package com.bcxin.oa.old.entity.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>
 * 人员社保缴费明细
 * </p>
 *
 * @author 罗鹏
 * @since 2017-12-22
 */
@TableName("per_social_ins_pay_detail")
@Data
public class PerSocialInsPayDetail extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 社保缴费明细ID
     */
	private Long insPayDetailId;
    /**
     * 社保险种
     */
	private String socialInsType;
    /**
     * 缴费基数
     */
	private BigDecimal socialInsBase;
    /**
     * 费款所属期
     */
	private String payPeriod;
    /**
     * 公司缴纳比例
     */
	private BigDecimal comPayProp;
    /**
     * 人员缴纳比例
     */
	private BigDecimal perPayProp;
    /**
     * 公司缴纳金额
     */
	private BigDecimal comPayAmount;
    /**
     * 人员缴纳金额
     */
	private BigDecimal perPayAmount;
    /**
     * 人员ID
     */
	private Long perId;
    /**
     * 企业ID
     */
	private Long comId;

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getInsPayDetailId() {
        return insPayDetailId;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getComId() {
        return comId;
    }
}
