package com.bcxin.oa.old.entity.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 人员当前位置
 */
@TableName("per_current_location")
@Data
public class PerCurrentLocation {
    /**
     * 人员ID
     */
    @ApiModelProperty(value = "人员ID")
    @NotNull(message = "人员ID不能为空")
    private Long perId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime = new Date(); // 更新时间
    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private String longitude;
    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private String latitude;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

}
