package com.bcxin.oa.old.entity.salary;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业薪资模板对应人员
 * 
 * @author llc
 * @date 2018-12-28
 */
@Data
@TableName("com_salary_temp_per")
public class ComSalaryTempPer{

	/** 企业薪资模板ID */
	@ApiModelProperty(value = "企业薪资模板ID")
	private Long comSalaryTempId;

	/** 创建者 */
	@ApiModelProperty(value = "创建者")
	private Long createBy;

	/** 创建日期 */
	@ApiModelProperty(value = "创建日期")
	private Date createTime;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComSalaryTempId() {
		return comSalaryTempId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getCreateBy() {
		return createBy;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

}