package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.common.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 基础参数的DTO，允许拓展，用String类型
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/2
 */
@Data
public class ParamDTO extends BaseEntity {

	private String id;

	/**
	 * 任务id
	 */
	private Long comTaskId;

	/**
	 * 查询关键词
	 */
	private String key;

	/**
	 * 月份
	 */
	private String month;

	/**
	 * 用户id
	 */
	private Long perId;

	/**
	 * 用户id，多人
	 */
	private String perIds;

	/**
	 * 日期
	 */
	private String date;

	/**
	 * 开始日期
	 */
	private String startDate;

	/**
	 * 结束日期
	 */
	private String endDate;

	/**
	 * 类型
	 */
	private String type;

	/**
	 * 状态
	 */
	private String status;

	/**
	 * 当天排班 or 周期排班 [ 1 or 2]
	 */
	private String taskShiftType;

	/**
	 * 排班方式 [ 1 or 2]
	 * "1" 周期排班
	 * "2" 手动排班
	 */
	private String attendSubType;

	/**
	 * 班次 or 周期 ids
	 */
	private String ids;

	/**
	 * 任务详细信息
	 */
	private String taskDetail;

	/**
	 * 详细信息
	 */
	private String detail;

	/**
	 * 集合
	 */
	private List<String> list;
}
