package com.bcxin.oa.old.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ComDepartTreeResultDto {

	/**
	 * 公司ID
	 */
	@ApiModelProperty(value = "公司ID")
	protected Long comId;

	/**
	 * 部门ID
	 */
	@ApiModelProperty(value = "部门ID")
	private Long departId;

	/**
	 * 部门名称
	 */
	@ApiModelProperty(value = "部门名称")
	private String departName;

	/**
	 * 上级部门ID
	 */
	@ApiModelProperty(value = "上级部门ID")
	private Long parentDepartId;

	/**
	 * 公司的下级部门
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<ComDepartTreeResultDto> children;

}
