
package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.dto.ComTaskFixedDTO;
import com.bcxin.oa.old.dto.ComTaskFixedTempDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskFixedService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Title：任务固定班制管理
 * @Package：com.bcx.platform.controller @Description：
 * @author：zhongjianhui
 */
@RestController
@RequestMapping("/task/groupfixed")
@Api(tags = { "" }, description = "任务固定班制管理")
public class ComTaskFixedController extends BaseController {

	@Resource
	private ComTaskFixedService comTaskFixedService;

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务固定班制管理", title = "任务固定班制详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-detail")
	@ApiOperation(value = "任务固定班制详情", httpMethod = "GET", notes = "任务固定班制详情", response = ComTaskFixedDTO.class)
	public Result getDetail(ComTaskFixedDTO comTaskFixedDTO) throws BusinessException {
		return comTaskFixedService.getDetail(comTaskFixedDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务固定班制管理", title = "保存", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "保存任务固定班制", httpMethod = "POST", notes = "保存任务固定班制", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "save")
	public Result save(ComTaskFixedTempDTO comTaskFixedTempDTO) throws BusinessException {
		return comTaskFixedService.save(comTaskFixedTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务固定班制管理", title = "修改任务固定班制", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "update")
	@ApiOperation(value = "修改任务固定班制", httpMethod = "POST", notes = "修改任务固定班制", response = ComTaskFixedTempDTO.class)
	public Result update(ComTaskFixedTempDTO comTaskFixedTempDTO) throws BusinessException {
		return comTaskFixedService.update(comTaskFixedTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务固定班制管理", title = "获取周一到周日模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-add-temp")
	@ApiOperation(value = "获取周一到周日模板", httpMethod = "GET", notes = "获取周一到周日模板", response = ComTaskFixedDTO.class)
	public Result getAddTemp(ComTaskFixedDTO comTaskFixedDTO) throws BusinessException {
		return comTaskFixedService.getAddTemp(comTaskFixedDTO).setBack(getRequest());
	}
}
