package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskAttendAddressService;
import com.bcxin.oa.old.service.task.ComTaskImplementService;
import com.bcxin.oa.old.service.task.ComTaskInsidePushService;
import com.bcxin.oa.old.service.task.ComTaskService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @description：任务管理
 * @author：zhangjianhua @date：2018/03/02
 */
@RestController
@RequestMapping("/task")
@Api(tags = { "" }, description = "任务管理")
public class ComTaskController extends BaseController {

	@Resource
	private ComTaskService taskService;

	@Resource
	private ComTaskInsidePushService comTaskInsidePushService;

	@Resource
	private ComTaskImplementService comTaskImplementService;

	@Resource
	private ComTaskAttendAddressService comTaskAttendAddressService;


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取所有大小任务类型树形", title = "获取所有大小任务类型树形", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "tree-tasktype")
	@ApiOperation(value = "获取所有大小任务类型树形", httpMethod = "GET", notes = "获取所有大小任务类型树形", response = ComTaskFixedDTO.class)
	public Result getTreeTaskType(ComTaskDto comTaskDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.treeForTaskType(comTaskDto).setBack(getRequest());
	}

	/**
	 * ---------------------------整合任务接口-zhongjianhui----------------------------------------------------------------
	 **/
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务第一步详情", title = "获取任务第一步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-step-one-detail")
	@ApiOperation(value = "获取任务第一步详情", httpMethod = "GET", notes = "获取任务第一步详情", response = ComTaskFixedDTO.class)
	public Result getStepOneDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
		return taskService.getStepOneDetail(comTaskTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "保存任务第一步详情", title = "保存任务第一步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "save-step-one-detail")
	@ApiOperation(value = "保存任务第一步详情", httpMethod = "POST", notes = "保存任务第一步详情", response = ComTaskFixedDTO.class)
	public Result saveStepOneDetail(ComTaskDto comTaskDto) throws BusinessException {
		return taskService.saveStepOneDetail(comTaskDto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务第二步详情", title = "获取任务第二步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-step-two-detail")
	@ApiOperation(value = "获取任务第二步详情", httpMethod = "GET", notes = "获取任务第二步详情", response = ComTaskFixedDTO.class)
	public Result getStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
		return taskService.getStepTwoDetail(comTaskTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "保存任务第二步详情", title = "保存任务第二步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "save-step-two-detail")
	@ApiOperation(value = "保存任务第二步详情", httpMethod = "POST", notes = "保存任务第二步详情", response = ComTaskFixedDTO.class)
	public Result saveStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
		return taskService.saveStepTwoDetail(comTaskTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "保存任务第三步详情", title = "保存任务第三步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "save-step-three-detail")
	@ApiOperation(value = "保存任务第三步详情", httpMethod = "POST", notes = "保存任务第三步详情", response = ComTaskFixedDTO.class)
	public Result saveStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		return taskService.saveStepThreeDetail(comTaskThreeDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务第三步详情", title = "获取任务第三步详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-step-three-detail")
	@ApiOperation(value = "获取任务第三步详情", httpMethod = "GET", notes = "获取任务第三步详情", response = ComTaskThreeDTO.class)
	public Result getStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		return taskService.getStepThreeDetail(comTaskThreeDTO).setBack(getRequest());
	}

	/**
	 * 根据id获取任务
	 *
	 * @param request
	 * @param comTaskId
	 * @return Result
	 * @throws BusinessException
	 * @author liyongqiang
	 */
	@PostMapping(value = "/get-task-by-id")
	@Log(modle = "根据id获取任务", title = "根据id获取任务", operation = Log.OPERA_TYPE_SELECT, systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "根据id获取任务", notes = "根据id获取任务")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "comTaskId", value = "任务id", required = true, dataType = "long", paramType = "query") })
	public Result getTaskById(HttpServletRequest request, @RequestParam Long comTaskId) throws BusinessException {

		return taskService.getTaskById(comTaskId).setBack(getRequest());

	}


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务未进行投保人员列", title = "获取任务未进行投保人员列", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-task-un-ins-per-info-list")
	@ApiOperation(value = "获取任务未进行投保人员列", httpMethod = "POST", notes = "获取任务未进行投保人员列", response = ComTaskThreeDTO.class)
	public Result getTaskUnInsPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		return taskService.getTaskUnInsPerInfoList(comTaskThreeDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务冲突投保人员列", title = "获取任务冲突投保人员列", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-task-conflict-per-info-list")
	@ApiOperation(value = "获取任务冲突投保人员列", httpMethod = "POST", notes = "获取任务冲突投保人员列", response = ComTaskThreeDTO.class)
	public Result getTaskConflictPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		return taskService.getTaskConflictPerInfoList(comTaskThreeDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务人员", title = "获取任务人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-task-per")
	@ApiOperation(value = "获取任务人员", httpMethod = "GET", notes = "获取任务人员", response = ComTaskThreeDTO.class)
	public Result getTaskPer(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.getTaskPer(comTaskThreeDTO).setBack(getRequest());
	}

	/**
	 * 导出任务人员
	 * @param dto
	 * @author llc
	 * @date 2019-11-29
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出任务人员", title = "导出任务人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-task-per")
	@ApiOperation(value = "导出任务人员", httpMethod = "GET", notes = "导出任务人员", response = ComTaskThreeDTO.class)
	public Result exportTaskPer(ComTaskThreeDTO dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.exportTaskPer(dto,getResponse()).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务负责人", title = "获取任务负责人", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-task-charge-per")
	@ApiOperation(value = "获取任务负责人", httpMethod = "GET", notes = "获取任务负责人", response = ComTaskThreeDTO.class)
	public Result getTaskChargePer(ComTask comTask) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.getTaskChargePer(comTask).setBack(getRequest());
	}


	/***
	 * 修改任务负责人
	 * @param comTask
	 * @author llc
	 * @date 2019-11-29
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "修改任务负责人", title = "修改任务负责人", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "update-task-charge-per")
	@ApiOperation(value = "修改任务负责人", httpMethod = "POST", notes = "修改任务负责人", response = ComTask.class)
	public Result updateTaskChargePer(ComTask comTask) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.updateTaskChargePer(comTask).setBack(getRequest());
	}


	/***
	 * 移除任务人员
	 * @param dto
	 * @author llc
	 * @date 2019-11-29
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "移除任务人员", title = "移除任务人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "remove-task-per")
	@ApiOperation(value = "移除任务人员", httpMethod = "POST", notes = "移除任务人员", response = ComTask.class)
	public Result removeTaskPer(ComTaskPerDTO dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.removeTaskPer(dto).setBack(getRequest());
	}


	/***
	 * 新增任务人员
	 * @param dto
	 * @author llc
	 * @date 2019-11-29
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "新增任务人员", title = "新增任务人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "add-task-per")
	@ApiOperation(value = "新增任务人员", httpMethod = "POST", notes = "新增任务人员", response = ComTask.class)
	public Result addTaskPer(ComTaskPerDTO dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.addTaskPer(dto).setBack(getRequest());
	}

	/**
	 * 定时器生成任务执行情况
	 *
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/13
	 */
	@PostMapping(value = "/run-task-implement")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "定时器生成任务执行情况", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "定时器生成任务执行情况", notes = "定时器生成任务执行情况")
	public Result runTaskImplement() throws BusinessException {
		return comTaskImplementService.runTaskImplement().setBack(getRequest());
	}

	/**
	 * 任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）
	 *
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/26
	 */
	@PostMapping(value = "/check-per-implement")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）", notes = "任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）")
	public Map<String, String> checkPerImplement(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		return comTaskImplementService.checkPerImplement(comTaskThreeDTO);
	}


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "删除任务考勤地址", title = "删除任务考勤地址", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "delete-address")
	@ApiOperation(value = "删除任务考勤地址", httpMethod = "POST", notes = "删除任务考勤地址", response = ComTaskAttendAddressDTO.class)
	public Result deleteComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskAttendAddressService.deleteComTaskAttendAddress(comTaskAttendAddress).setBack(getRequest());
	}


	/** ---------------------------创建任务-zhangjianhua---------------------------------------------------------------- **/

	/**
	 * 任务-出勤设置-出勤地点-新增
	 *
	 * @param comTaskAttendAddress
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/02
	 */
	@PostMapping(value = "/add-com-task-attend-address")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "任务-出勤设置-出勤地点-新增", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "任务-出勤设置-出勤地点-新增", notes = "任务-出勤设置-出勤地点-新增")
	public Result addComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskAttendAddressService.addComTaskAttendAddress(comTaskAttendAddress).setBack(getRequest());
	}

	/**
	 * 任务-出勤设置-出勤地点-修改
	 *
	 * @param comTaskAttendAddress
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/02
	 */
	@PostMapping(value = "/update-com-task-attend-address")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "任务-出勤设置-出勤地点-修改", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "任务-出勤设置-出勤地点-修改", notes = "任务-出勤设置-出勤地点-修改")
	public Result updateComTaskAttendAddress(ComTaskAttendAddress comTaskAttendAddress) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskAttendAddressService.updateComTaskAttendAddress(comTaskAttendAddress).setBack(getRequest());
	}

	/**
	 * 任务-出勤设置-出勤地点-列表
	 *
	 * @param comTaskAttendAddressDTO
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/02
	 */
	@GetMapping(value = "/list-com-task-attend-address")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务-出勤设置-出勤地点-列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "任务-出勤设置-出勤地点-列表", notes = "任务-出勤设置-出勤地点-列表")
	public Result listComTaskAttendAddress(ComTaskAttendAddressDTO comTaskAttendAddressDTO) {
		return comTaskAttendAddressService.listComTaskAttendAddress(comTaskAttendAddressDTO.getComTaskId())
				.setBack(getRequest());
	}



	/**
	 * 删除未生效任务
	 *
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/04/09
	 * @update by llc 2020-04-08
	 */
	@PostMapping(value = "/delete-task")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "删除未生效任务", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除未生效任务", notes = "删除未生效任务")
	public Result deleteTask(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.deleteTask(comTaskThreeDTO);
	}


	/**
	 * 延长任务
	 * @param comTask
	 * @author llc
	 * @date 2020-04-09
	 */
	@PostMapping(value = "/extent-task")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "延长任务", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "延长任务", notes = "延长任务")
	public Result extendTask(ComTask comTask) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.extendTask(comTask);
	}


	/**
	 * 结束任务
	 * @param comTask
	 * @author llc
	 * @date 2020-04-09
	 */
	@PostMapping(value = "/end-task")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "结束任务", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "结束任务", notes = "结束任务")
	public Result endTask(ComTask comTask) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.endTask(comTask);
	}

	/**
	 *
	 * 定时器修改任务状态
	 * 
	 * @param
	 * @return
	 * @throws BusinessException
	 * @author zhongjianhui
	 * @date 2018/04/17
	 */
	@PostMapping(value = "/change-task-status")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "定时修改任务状态", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = " 定时修改任务状态", notes = " 定时修改任务状态")
	public Result changeTaskStatus() throws BusinessException {
		return taskService.changeTaskStatus();
	}

	/**
	 * 查询任务列表
	 *
	 * @param comTaskDto
	 * @Title: selectTasksList
	 * @Description:
	 * @return: Result
	 * @author liyongqiang
	 * @date: 2017年12月22日
	 */
	@ApiOperation(value = "查询任务列表")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "查询任务列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "page-task-list")
	public Result pageTaskList(ComTaskDto comTaskDto) {
		Result result = taskService.pageTaskList(comTaskDto).setBack(getRequest());
		return result;
	}


	/**
	 * 导出任务列表
	 * @param dto
	 * @author llc
	 * @date 2019-11-29
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出任务列表", title = "导出任务列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-task-list")
	@ApiOperation(value = "导出任务列表", httpMethod = "GET", notes = "导出任务列表", response = ComTaskThreeDTO.class)
	public Result exportTaskList(ComTaskDto dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return taskService.exportTaskList(dto,getResponse()).setBack(getRequest());
	}


	/**
	 * 检测合同是否关联了任务
	 * @param dto
	 * @author llc
	 * @date 2019-05-15
	 */
	@PostMapping(value = "/check-relate-task-by-contract-id")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "检测合同是否关联了任务", title = "检测合同是否关联了任务", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = " 检测合同是否关联了任务", notes = " 检测合同是否关联了任务")
	public Result checkRelateTaskByContractId(ComTaskDto dto) throws BusinessException {
		return taskService.checkRelateTaskByContractId(dto);
	}

	/**
	 * 获取所属行业类型列表
	 *
	 * @return
	 */
	@PostMapping("/get-industries-list")
	@Log(modle = "获取所属行业类型列表", title = "获取所属行业类型列表", operation = Log.OPERA_TYPE_SELECT, systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取所属行业类型列表", notes = "")
	public Result getIndustriesList(ComTaskDto comTaskDto) {
		// 根据行业和机构类型 taskType
		return taskService.getIndustriesList(comTaskDto);
	}

	/**
	 * 获取服务类型
	 *
	 * @return
	 */
	@PostMapping("/get-server-type-list")
	@Log(modle = "获取服务类型", title = "获取服务类型", operation = Log.OPERA_TYPE_SELECT, systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取服务类型", notes = "")
	public Result getServerTypeList(ComTaskDto comTaskDto) {
		// 根据行业和机构类型 + serviceType
		return taskService.getServerTypeList(comTaskDto);
	}

	/**
	 * 外勤打卡提醒定时器
	 *
	 * @return
	 * @author llc
	 * @date 2019/01/12
	 */
	@PostMapping(value = "/task-card-remind")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "外勤打卡提醒", title = "外勤打卡提醒", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "外勤打卡提醒", notes = "外勤打卡提醒")
	public Result taskCardRemindJob() throws BusinessException {
		return taskService.taskCardRemindJob();
	}

	/**
	 * 驻勤到期提醒定时器
	 * @param
	 * @author llc
	 * @date 2020-04-24
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/task-expire-remind")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "驻勤到期提醒", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = " 驻勤到期提醒", notes = " 驻勤到期提醒")
	public Result taskExpireRemind() throws BusinessException {
		return taskService.taskExpireRemind();
	}

	/**
	 * 获取公司任务驻勤点类型
	 *
	 * @param comTask
	 * @Title: getComTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2019-11-01
	 */
	@ApiOperation(value = "获取公司任务驻勤点类型")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "获取公司任务驻勤点类型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-com-task-station-type")
	public Result getComtaskStationType(ComTask comTask) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.getComtaskStationType(comTask).setBack(getRequest());
		return result;
	}

	/**
	 * 防控指挥获取任务列表
	 *
	 * @param comTask
	 * @Title: getComTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2019-11-01
	 */
	@ApiOperation(value = "防控指挥获取任务列表")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "防控指挥获取任务列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-com-task-list")
	public Result getComTaskList(ComTask comTask) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.getComTaskList(comTask).setBack(getRequest());
		return result;
	}

	/**
	 * 防控指挥获取任务人员位置
	 *
	 * @param comTask
	 * @Title: getComTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2019-11-01
	 */
	@ApiOperation(value = "防控指挥获取任务人员位置")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "防控指挥获取任务人员位置", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-com-task-per-location")
	public Result getComTaskPerLocation(ComTask comTask) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.getComTaskPerLocation(comTask).setBack(getRequest());
		return result;
	}


	/***
	 * 获取任务成员历史记录
	 * @param dto
	 * @author llc
	 * @date 2020-04-08
	 *
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取任务成员历史记录", title = "获取任务成员历史记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-task-per-record")
	@ApiOperation(value = "获取任务成员历史记录", httpMethod = "POST", notes = "获取任务成员历史记录", response = Result.class)
	public Result getTaskPerRecord(ComTaskDto dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskInsidePushService.getTaskPerRecord(dto).setBack(getRequest());
	}

	/**
	 * 导出任务人员历史记录
	 * @param dto
	 * @author llc
	 * @date 2020-04-08
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "导出任务人员历史记录", title = "导出任务人员历史记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-task-per-record")
	@ApiOperation(value = "导出任务人员历史记录", httpMethod = "GET", notes = "导出任务人员历史记录", response = ComTaskThreeDTO.class)
	public Result exportTaskPerRecord(ComTaskDto dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskInsidePushService.exportTaskPerRecord(dto,getResponse()).setBack(getRequest());
	}

	/**
	 * 批量删除驻勤点
	 * @author wangjianjun
	 * @date 2020/5/7
	 */
	@PostMapping(value = "delete-task-batch")
	public Result deleteBatchComTask(ComTaskDto dto) {
		return taskService.deleteBatchComTask(dto);
	}


	/**
	 * 通过合同ID查找驻勤点
	 *
	 * @param comTask
	 * @return: Result
	 * @author llc
	 * @date: 2020-06-10
	 */
	@ApiOperation(value = "通过合同ID查找驻勤点")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "通过合同ID查找驻勤点", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-task-list-by-contractId")
	public Result getTaskListByContractId(ComTask comTask) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.getTaskListByContractId(comTask).setBack(getRequest());
		return result;
	}


	/**
	 * 公安获取任务驻勤点类型
	 *
	 * @param comTask
	 * @Title: policeGetTaskStationType
	 * @return: Result
	 * @author llc
	 * @date: 2020-07-02
	 */
	@ApiOperation(value = "公安获取任务驻勤点类型")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "公安获取任务驻勤点类型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "police-get-task-station-type")
	public Result policeGetTaskStationType(ComTask comTask) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.policeGetTaskStationType(comTask).setBack(getRequest());
		return result;
	}

	/**
	 * 公安防控指挥获取任务列表
	 *
	 * @param dto
	 * @Title: policeGetTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2020-07-02
	 */
	@ApiOperation(value = "公安防控指挥获取任务列表")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "公安防控指挥获取任务列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "police-get-task-list")
	public Result policeGetTaskList(ComTaskDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.policeGetTaskList(dto).setBack(getRequest());
		return result;
	}


	/**
	 * 公安防控指挥获取任务位置列表
	 *
	 * @param dto
	 * @Title: policeGetTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2020-07-09
	 */
	@ApiOperation(value = "公安防控指挥获取任务位置列表")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "公安防控指挥获取任务位置列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "police-get-task-location-list")
	public Result policeGetTaskLocationList(ComTaskDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.policeGetTaskLocationList(dto).setBack(getRequest());
		return result;
	}

	/**
	 * 公安防控指挥获取任务信息
	 *
	 * @param dto
	 * @Title: policeGetTaskList
	 * @return: Result
	 * @author llc
	 * @date: 2020-07-09
	 */
	@ApiOperation(value = "公安防控指挥获取任务信息")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "公安防控指挥获取任务信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "police-get-task-by-id")
	public Result policeGetTaskById(ComTaskDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = taskService.policeGetTaskById(dto).setBack(getRequest());
		return result;
	}


}
