package com.bcxin.oa.old.controller.common;

import cn.hutool.json.JSONUtil;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.entity.task.ConfigIndustryDict;
import com.bcxin.oa.old.service.common.CommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 文件上传
 */
@Slf4j
@RestController
@RequestMapping("/public/common/dict")
@Api(description = "字典查询") // tag中文会影响路径
public class DictController extends BaseController {


	@Autowired
	private CommonService commonService;

	@PostMapping("/get-dict-by-code-types")
	@ApiOperation(value="传入字典类型字符串数组", notes="economicType经济类型,comType公司类型,institutionType机构类型,industryType行业类型,fieldType字段类型")
	public Result getConfigDictById(String codeTypes) {
		return commonService.getConfigDictById(codeTypes).setBack(getRequest());
	}

	@PostMapping("/get-institution-type-by-industry-type")
	@ApiOperation(value="从机构类型字典表获取", notes="根据行业类型获取机构")
	public Result getInstitutionTypeByIndustryType(String industryType) {
		log.info(">>>>>>>>获得参数"+ JSONUtil.toJsonStr(industryType));
		return commonService.getInstitutionTypeByIndustryType(industryType).setBack(getRequest());
	}

	@PostMapping("/get-industry-dict-by-code-types")
	@ApiOperation(value="从业字典获取", notes="通过参数codeType获取从业相关类型")
	public Result getConfigIndustryDictByComId(ConfigIndustryDict cid) {
		return commonService.getConfigIndustryDictByComId(cid).setBack(getRequest());
	}

	@PostMapping("/clear/{key}")
	@ApiOperation(value="清理redis缓存", notes="清理redis缓存")
	public Result clearByKey(@PathVariable("key") String key) {
		return commonService.deleteRedisByKey(key).setBack(getRequest());
	}

}
