package com.bcxin.oa.old.controller.app.task;

import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.dto.ComTaskAdjustApproveDto;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.app.AppComTaskDTO;
import com.bcxin.oa.old.dto.app.AppComTaskImplementDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.app.AppComTaskService;
import com.bcxin.oa.old.service.task.app.PerTaskCardRecordService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 任务管理
 *
 * @author zhangye
 */
@RestController
@RequestMapping("/task/app/task")
@Api(tags = { "" }, description = "APP任务")
public class AppComTaskController extends BaseController {
	@Autowired
	private AppComTaskService appComTaskService;

	@Autowired
	private PerTaskCardRecordService perTaskCardRecordService;

	/**
	 * 任务列表查询
	 *
	 * @param appComTaskDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/page-for-task")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务列表查询", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务列表查询", notes = "任务列表查询")
	public Result pageForGroup(AppComTaskDTO appComTaskDTO) throws BusinessException {
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		CurrentUser currentUser = new CurrentUser(getRequest());
		appComTaskDTOParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.pageTask(appComTaskDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}


	/**
	 * 任务列表查询
	 *
	 * @param dto
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/get-per-task-list")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务列表查询", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务列表查询", notes = "任务列表查询")
	public Result getPerTaskList(ComTaskDto dto) throws BusinessException {
		ComTaskDto comTaskDtoParam = Result.getDecodeData(dto.getAppData(), ComTaskDto.class);
		ObjectUtils.appCopyProperties(comTaskDtoParam, dto);
		CurrentUser currentUser = new CurrentUser(getRequest());
		comTaskDtoParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getPerTaskList(comTaskDtoParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}


	/**
	 * 任务详情查询
	 *
	 * @param appComTaskDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/get-task-details")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务列表查询", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务详情查询", notes = "任务详情查询")
	public Result getTaskDetails(AppComTaskDTO appComTaskDTO) throws BusinessException {
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		CurrentUser currentUser = new CurrentUser(getRequest());
		appComTaskDTOParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getTaskDetails(appComTaskDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * 获取APP用户正在执行任务
	 *
	 * @param appComTaskDTO
	 * @throws BusinessException
	 * @Title: getRuningTaskRound
	 * @Description:
	 * @return: Result
	 * @author zhangye
	 * @date: 2018年03月07日
	 */
	@ApiOperation(value = "查询是否有正在执行的任务接口")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "查询任务列表", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/get-runing-taskround")
	public Result getRuningTaskRound(AppComTaskDTO appComTaskDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		appComTaskDTOParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getRuningTaskRound(appComTaskDTOParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * 校验APP用户是否有正在执行任务
	 *
	 * @param appComTaskDTO
	 * @throws BusinessException
	 * @Title: getRuningTaskRound
	 * @Description:
	 * @return: Result
	 * @author zhangye
	 * @date: 2018年03月07日
	 */
	@ApiOperation(value = "校验是否有正在执行的任务接口")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "查询任务列表", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/check-runing-taskround")
	public Result checkRuningTaskRound(AppComTaskDTO appComTaskDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		appComTaskDTOParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getRuningTaskRound(appComTaskDTOParam).setBack(getRequest());
		if (result.getData() != null) {
			result.setRetType(Result.ERROR);
			result.setMsg("当前已有任务正在执行，请先签退执行中的任务。");
		} else {
			result.setData(Result.setEncodeData(result.getData()));
		}
		return result;
	}

	/**
	 * 获取任务成员列表
	 *
	 * @param appComTaskDTO
	 * @throws BusinessException
	 * @Title: getRuningTaskRound
	 * @Description:
	 * @return: Result
	 * @author zhangye
	 * @date: 2018年03月07日
	 */
	@ApiOperation(value = "获取任务成员列表")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "获取任务成员列表", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/get-task-person")
	public Result getTaskPerson(AppComTaskDTO appComTaskDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		appComTaskDTOParam.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getTaskPerson(appComTaskDTOParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * 班次执行情况查询
	 *
	 * @param appComTaskImplementDto
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/get-task-shift-implement")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "班次执行情况查询", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "班次执行情况查询", notes = "班次执行情况查询")
	public Result getTaskShiftImplement(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		AppComTaskImplementDto appComTaskImplementDtoParam = Result.getDecodeData(appComTaskImplementDto.getAppData(),
				AppComTaskImplementDto.class);
		ObjectUtils.appCopyProperties(appComTaskImplementDtoParam, appComTaskImplementDto);
		/*** 因为存在查询其他人执行情况，这里如果未传人员ID则默认为自己 ***/
		if(appComTaskImplementDtoParam.getPerId() == null ) {
			CurrentUser currentUser = new CurrentUser(getRequest());
			appComTaskImplementDtoParam.setPerId(currentUser.getPerId());
		}
		Result result = appComTaskService.getTaskShiftImplement(appComTaskImplementDtoParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * 任务状态查询
	 *
	 * @param appComTaskDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/get-task-status")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务状态查询", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务状态查询", notes = "任务状态查询")
	public Result getTaskStatus(AppComTaskDTO appComTaskDTO) throws BusinessException {
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		Result result = appComTaskService.getTaskStatus(appComTaskDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * 获取某人某天某任务的排班班次
	 *
	 * @param comTaskSchedul
	 * @return
	 * @author llc
	 * @date 2019-02-21
	 */
	@ApiOperation(value = "获取某人某天某任务的排班班次")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "获取某人某天某任务的排班班次", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/get-per-date-task-shift")
	public Result getPerDateTaskShift(ComTaskSchedul comTaskSchedul) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		ComTaskSchedul param = Result.getDecodeData(comTaskSchedul.getAppData(), ComTaskSchedul.class);
		ObjectUtils.appCopyProperties(param, comTaskSchedul);
		param.setPerId(currentUser.getPerId());
		Result result = appComTaskService.getPerDateTaskShift(param).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * 外勤代班审批通过业务实现
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-02-21
	 * 作为服务提供者,接收参数必须用 @RequestBody，否则会接收不到参数
	 */
	@ApiOperation(value = "外勤代班审批通过业务实现")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "外勤代班审批通过业务实现", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/complete-task-adjust-approve")
	public Result completeTaskAdjustApprove(@RequestBody ComTaskAdjustApproveDto dto) throws BusinessException {
		Result result = appComTaskService.completeTaskAdjustApprove(dto).setBack(getRequest());
		return result;
	}

	/**
	 * 查询个人的外勤详情
	 * （基于get-task-details接口整改）
	 * @param appComTaskDTO
	 * @author llc
	 * @date 2019-02-25
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/get-task-details-by-perId")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "查询个人的外勤详情", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "查询个人的外勤详情", notes = "查询个人的外勤详情")
	public Result getTaskDetailsByPerId(AppComTaskDTO appComTaskDTO) throws BusinessException {
		AppComTaskDTO appComTaskDTOParam = Result.getDecodeData(appComTaskDTO.getAppData(), AppComTaskDTO.class);
		ObjectUtils.appCopyProperties(appComTaskDTOParam, appComTaskDTO);
		Result result = appComTaskService.getTaskDetailsByPerId(appComTaskDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

}
