package com.bcxin.oa.old.controller.app.attend;

import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.dto.app.AppComAttendDTO;
import com.bcxin.oa.old.dto.app.AppPerAttendCardRecordDTO;
import com.bcxin.oa.old.dto.user.CurrentUser;
import com.bcxin.oa.old.service.attend.app.ComAttendService;
import com.bcxin.oa.old.service.attend.app.PerAttendCardRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App接口-考勤管理
 * 
 * @author zhangye
 * @version 1.0
 */
@RestController
@RequestMapping("/task/app/com/attend")
@Api(tags = { "" }, description = "APP-考勤管理")
public class AppComAttendController extends BaseController {

	@Autowired
	private ComAttendService comAttendService;

	@Autowired
	private PerAttendCardRecordService perAttendCardRecordService;

	/**
	 * 考勤列表查询
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "考勤管理", title = "考勤列表查询", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/list-for-attendance")
	@ApiOperation(value = "考勤列表查询", httpMethod = "POST", notes = "考勤列表查询")
	public Result pageForGroup(AppComAttendDTO appComAttendDTO) throws BusinessException {
		AppComAttendDTO appComAttendDTOParam = Result.getDecodeData(appComAttendDTO.getAppData(),
				AppComAttendDTO.class);
		if (appComAttendDTOParam == null) {
			appComAttendDTOParam = new AppComAttendDTO();
		}
		ObjectUtils.appCopyProperties(appComAttendDTOParam, appComAttendDTO);
		CurrentUser currentUser = new CurrentUser(getRequest());
		appComAttendDTOParam.setPerId(currentUser.getPerId());
		Result result = comAttendService.listComAttend(appComAttendDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * APP-按月查询考勤统计情况
	 *
	 * @param perAttendCardRecordDTO
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/22
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "APP-按月查询考勤统计情况", title = "按月查询考勤统计情况", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-按月查询考勤统计情况", httpMethod = "POST", notes = "按月查询考勤统计情况", response = AppPerAttendCardRecordDTO.class)
	@PostMapping(value = "count-attend-card-record")
	public Result countAttendCardRecord(AppPerAttendCardRecordDTO perAttendCardRecordDTO) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerAttendCardRecordDTO perAttendCardRecordDTOParam = Result.getDecodeData(perAttendCardRecordDTO.getAppData(), AppPerAttendCardRecordDTO.class);
		ObjectUtils.appCopyProperties(perAttendCardRecordDTOParam, perAttendCardRecordDTO);
		perAttendCardRecordDTOParam.setPerId(currentUser.getPerId());
		Result result = perAttendCardRecordService.countAttendCardRecord(perAttendCardRecordDTOParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

}
