package com.bcxin.oa.old.common.utils.file;

import cn.hutool.core.lang.Console;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import com.google.common.io.Files;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@Slf4j
public class BcxinStringUtils {

	/**
	 * 产生随机1-10 的 随机数
	 * @return String
	 */
	public static String random(int length){
		StringBuilder sb = new StringBuilder(length);
		for ( int i=0;i<length;i++ ) {
			sb.append(ThreadLocalRandom.current().nextInt(10));
		}
		return sb.toString();
	}


	/**
	 * 按字母顺序排序
	 *
	 * @param source
	 * @return
	 */
	public static String AbcSort(String source) {
		char[] c = source.toCharArray();// 将字符串转换成char数组
		Arrays.sort(c);// 对数组进行排序
		return String.valueOf(c);//
	}

	private static RowHandler createRowHandler() {
		return new RowHandler() {
			@Override
			public void handle(int sheetIndex, long rowIndex, List<Object> rowlist) {
				Console.log("[{}] [{}] {}", sheetIndex, rowIndex, rowlist);
			}
		};
	}

}
