package com.bcxin.oa.old.common.utils.file;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import com.bcxin.oa.old.common.Constants;
import com.bcxin.oa.old.common.utils.file.obs.OBSUtil;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

@Slf4j
public class BcxinFileUtils {

    /**
     * 默认文件上传路径
     */
    private final static String DEFAULT_UPLOAD_DIR = "upload";

    private final static String DEFAULT_UPLOAD_LINUX = "/data/upload/saas/";

    private final static String DEFAULT_TEMP_DIR = "temp";

    private final static String QRCODE_DIR = "qrcode";

    /**
     * <b>Function </b> 本地文件存储
     *
     * @return
     * @author 罗鹏
     * @date 2017年1月3日 下午8:34:36
     * @注意事项 </b>
     * <b>
     */
    public static Map<String, String> saveFile(String uploadPath, MultipartFile multipartFile) {
        if (multipartFile != null) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + BcxinStringUtils.random(5) + "."; // 20100101123123.
                String fileType = Files.getFileExtension(multipartFile.getOriginalFilename()); // jpg
                materialFileName = materialFileName + fileType; // 20100101123123.jpg
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "public/common/file/get-resource?path=" + dirDate + "/" + materialFileName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("执行本地文件上传..." + targetFile);
                multipartFile.transferTo(targetFile);
                Map<String, String> map = Maps.newHashMap();
                map.put("url", url);
                map.put("key", "local_" + now.getTime());
                if (map == null || map.size() < 2) {
                    log.info("本地文件上传失败！");
                } else {
                    log.info("本地文件上传成功!");
                }
                return map;
            } catch (Exception e) {
                e.printStackTrace();
                log.error("saveFile:"+e.getMessage(), e);
                return null;
            }
        }
        return null;
    }

    /**
     * 华为OBS文件上传存储（同步）
     *
     * @return
     */
    public static String huaweiOBSFileUpload(MultipartFile xFile, String envi) {
		/* 获得文件后缀名 jpg*/
        String fileType = Files.getFileExtension(xFile.getOriginalFilename());
		/* 生成随机文件名 12345*/
        String randomNumber = DateUtil.current() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
        String fileName = randomNumber + Constants.DOT + fileType;
		/* 生成目录 */
        String directoryName = DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = xFile.getInputStream()) {
            return obsUtil.put(directoryName, ossKey, inputStream);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("huaweiOBSFileUpload:"+e.getMessage(), e);
        }
        return "";
    }

    public static String thumb_huaweiOBSFileUpload(MultipartFile xFile,String readPath, String envi) {
        readPath = readPath.replace("%2F","/");
        String floot = readPath.split(DEFAULT_UPLOAD_DIR + "/")[1];
        String fileType = Files.getFileExtension(floot);
		/* 生成目录 */
        String directoryName = DEFAULT_UPLOAD_DIR + "/" + floot.split("/")[0] + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + "/" + floot.replace(Constants.DOT + fileType,"_THUMB" + Constants.DOT + fileType);
        OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = xFile.getInputStream()) {
            String thumb = DEFAULT_UPLOAD_LINUX+ UUID.randomUUID().toString()+ Constants.DOT + fileType;
            imageOp(inputStream,thumb,100,100);
            return obsUtil.put(directoryName, ossKey, new FileInputStream(new File(thumb)));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("thumb_huaweiOBSFileUpload:"+e.getMessage(), e);
        }
        return "";
    }


    /**
     * <b>  </b>
     *  图片原路径 /data/upload/blb/report/1575615964667.jpg
     * @author ZXF
     * @create 2020/06/15 0015 17:35
     * @version
     * @注意事项 </b>
     */
    public static void imageOp(InputStream inputStream,String outPath, int width, int height){
        Image image = null;
        try {
            image = ImageIO.read(inputStream);
        } catch (IOException e) {
            System.out.println("file path error...");
        }

        int originalImageWidth = image.getWidth(null);
        int originalImageHeight = image.getHeight(null);

        BufferedImage originalImage = new BufferedImage(
                originalImageWidth,
                originalImageHeight,
                BufferedImage.TYPE_3BYTE_BGR);
        Graphics2D g2d = originalImage.createGraphics();
        g2d.drawImage(image, 0, 0, null);

        BufferedImage changedImage =
                new BufferedImage(
                        width,
                        height,
                        BufferedImage.TYPE_3BYTE_BGR);

        double widthBo = (double)width/originalImageWidth;
        double heightBo = (double)width/originalImageHeight;

        AffineTransform transform = new AffineTransform();
        transform.setToScale(widthBo, heightBo);

        AffineTransformOp ato = new AffineTransformOp(transform, null);
        ato.filter(originalImage, changedImage);
        FileOutputStream smallImage = null;
        try {
            smallImage = new FileOutputStream(outPath);
            ImageIO.write(changedImage, "jpeg",smallImage);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (smallImage != null) {
                try {
                    smallImage.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 华为OBS文件上传存储（同步）
     *
     * @return
     */
    public static String huaweiOBSFileUploadForBlob(MultipartFile xFile, String envi) {
		/* 获得文件后缀名 jpg*/
        String fileType = Files.getFileExtension(xFile.getOriginalFilename());
        if(StringUtils.isEmpty(fileType)){
            fileType = xFile.getOriginalFilename();
        }
        //如果是blob文件强制换成MP3后缀
        if(Constants.BLOB.equals(fileType)){
            fileType = Constants.MP3;
        }
		/* 生成随机文件名 12345*/
        String randomNumber = DateUtil.current() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
        String fileName = randomNumber + Constants.DOT + fileType;
		/* 生成目录 */
        String directoryName = DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/blob/";
        String ossKey = directoryName + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = xFile.getInputStream()) {
            return obsUtil.put(directoryName, ossKey, inputStream);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("huaweiOBSFileUploadForBlob:"+e.getMessage(), e);
        }
        return "";
    }

    /**
     * 华为OBS文件上传存储（同步）
     *
     * @return
     */
    public static String huaweiOBSFileUpload(File file, String envi, String fileType) {

		/* 生成随机文件名 12345*/
        String randomNumber = DateUtil.current() + RandomUtil.randomNumbers(6);
		/* 组装成随机文件名称 12345.jpg */
        String fileName = randomNumber + Constants.DOT + fileType;
		/* 生成目录 */
        String directoryName = DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = FileUtil.getInputStream(file)) {
            return obsUtil.put(directoryName, ossKey, inputStream);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("huaweiOBSFileUpload(envi:"+envi+",fileType:"+fileType+",obsUtil:"+(obsUtil==null?"null":"not null")+"):"+e.getMessage(), e);
        }
        return "";
    }


    /**
     * 华为OBS文件上传存储（本地文件上传到华为公共云）
     *
     * @return
     */
    public static String huaweiLocalFileUpload(File file, String date, String envi) {
		/* 生成目录 */
        String directoryName = DEFAULT_UPLOAD_DIR + "/" + date + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + "/" + date + "/" + file.getName();
        OBSUtil obsUtil = new OBSUtil(envi);
		/* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = FileUtil.getInputStream(file)) {
            return obsUtil.put(directoryName, ossKey, inputStream);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("huaweiLocalFileUpload:"+e.getMessage(), e);
        }
        return "";
    }


    /**
     * 通过文件url生成base64字符串
     *
     * @param imgURL
     * @return
     * @auth llc
     * @date 2019-04-17
     */
    public static String getInputStreamByUrl(String imgURL) {
        ByteArrayOutputStream outPut = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            // 创建URL
            URL url = new URL(imgURL);
            // 创建链接
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10 * 1000);

            if (conn.getResponseCode() != HttpURLConnection.HTTP_OK) {
                //连接失败/链接失效/图片不存在
                return "fail";
            }
			/* jdk7自动关闭流 */
            try (InputStream inStream = conn.getInputStream();) {
                int len = -1;
                while ((len = inStream.read(data)) != -1) {
                    outPut.write(data, 0, len);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(outPut.toByteArray());
    }

    public static void downloadBase64(HttpServletResponse response, String base64Code) throws IOException {
        try (ServletOutputStream out = response.getOutputStream()) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + DateUtil.current() + ".pdf");
            byte[] bytes = new BASE64Decoder().decodeBuffer(base64Code);
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes)) {
                byte[] buffer = new byte[1024];
                int byteRead = 0;
                while ((byteRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, byteRead);
                }
                out.flush();
            }
        }
    }
        /**
         * MultipartFile 转 File
         * @param file
         * @throws Exception
         */

    public static File multipartFileToFile(MultipartFile file) throws Exception {

        File toFile = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            if (file.equals("") || file.getSize() <= 0) {
                return null;
            } else {
                is = file.getInputStream();
                toFile = new File(file.getOriginalFilename());
                os = new FileOutputStream(toFile);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            if (is != null) {
                try {
                    is.close(); // 输入流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return toFile;
    }


    public static void deleteFolder(File file) {
        if(file.exists()) {
            if(file.isDirectory()) {
                for(File f : file.listFiles()) {
                    deleteFolder(f);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

}
