package com.bcxin.oa.current.common.exception;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * 远程错误，表示远程调研错误。
 */
public class RemoteException extends AbstractRuntimeException {

    /**
     * 具有明细错误消息的异常
     *
     * @param detailMessage 错误消息明细
     */
    private RemoteException(String detailMessage) {
        super(detailMessage);
    }

    /**
     * 具有引发异常堆栈的异常
     *
     * @param e 引发异常
     */
    private RemoteException(Throwable e) {
        super(e);
    }

    /**
     * 具有明细消息和引发异常堆栈的异常
     *
     * @param detailMessage 错误消息明细
     * @param e
     */
    private RemoteException(String detailMessage, Throwable e) {
        super(detailMessage, e);
    }

    /**
     * 具有消息格式化功能的异常 消息格式化的规则请参阅{@link String#format(String, Object...)}
     *
     * @param detailMessageFormat 消息格式化模板
     * @param args
     */
    private RemoteException(String detailMessageFormat, Object... args) {
        super(detailMessageFormat, args);
    }

    /**
     * 具有明细消息和引发异常堆栈的异常，具有消息格式化功能 消息格式化的规则请参阅{@link String#format(String, Object...)}
     *
     * @param e 引发异常
     * @param detailMessageFormat 消息格式化模板
     * @param args
     */
    private RemoteException(Throwable e, String detailMessageFormat, Object... args) {
        super(e, detailMessageFormat, args);
    }

    /**
     * 具有引发异常堆栈的异常
     *
     * @param e 引发异常
     */
    public static RemoteException exception(Throwable e) {
        return new RemoteException(e);
    }

    /**
     * 具有明细消息和引发异常堆栈的异常
     *
     * @param detailMessage 错误消息明细
     * @param e
     */
    public static RemoteException exception(String detailMessage, Throwable e) {
        return new RemoteException(detailMessage, e);
    }

    /**
     * 具有消息格式化功能的异常 消息格式化的规则请参阅{@link String#format(String, Object...)}
     * 格式化参数如果小于需要格式化的个数那么无法进行格式化，如果大于则没有影响
     *
     * @param detailMessageFormat 消息格式化模板
     * @param args
     */
    public static RemoteException exception(String detailMessageFormat, Object... args) {
        if (StringUtils.isBlank(detailMessageFormat)) {
            return exception("未知异常");
        }
        if (ArrayUtils.isEmpty(args)) {
            return exception(detailMessageFormat);
        }
        Object lastArg = args[args.length - 1];
        if (isSubClass(lastArg, Throwable.class)) {
            return new RemoteException((Throwable) lastArg, detailMessageFormat, ArrayUtils.subarray(args, 0, (args.length - 1)));
        }
        return new RemoteException(detailMessageFormat, args);
    }

    /**
     * 具有明细错误消息的异常
     *
     * @param detailMessage 错误消息明细
     */
    public static RemoteException exception(String detailMessage) {
        return new RemoteException(detailMessage);
    }
}
