package com.bcxin.oa.old.service.system;


import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.dto.ComDepartDto;
import com.bcxin.oa.old.entity.system.PerOrgRelation;

import java.util.Map;

/**
 * 人员组织架构
 *
 * @author llc
 * @date 2019-07-10
 */

public interface PerOrgRelationService {

    PerOrgRelation getByTlkId(String tlkId);

    /**
     * 获取组织的下一级部门列表
     * @param comDepart
     * @return
     * @author llc
     * @date 2019-07-10
     */
    Result getChildDepartList(ComDepartDto comDepart);

    /**
     * web通过姓名/手机号码/身份证搜索人员信息
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-07-11
     */
    Result getWebPerListByKeyword(ComDepartDto comDepartDto);

    /**
     * 关键字查询公共选人的接口
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-08-28
     */
    Result getCommonPerListByKeyword(ComDepartDto comDepartDto);


    /**
     * 驻勤模块选人的接口
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2020-04-16
     */
    Result getTaskPerListByKeyword(ComDepartDto comDepartDto);


    Map<String, Object> getDataAuthOrgList(Long comId, Long perId);

    /**
     * 获取组织的人员列表
     * @param comDepart
     * @return
     * @author llc
     * @date 2019-07-10
     */
    Result getOrgPerSonList(ComDepartDto comDepart);


    /**
     * 获取选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    Result getDepartPerSonList(ComDepartDto comDepart);


    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    Result getTaskDepartPerSonList(ComDepartDto comDepart);


    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    Result getHuaweiDepartPerSonList(ComDepartDto comDepart);


    /**
     * 华为会议选人的接口(关键字查询)
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-12-12
     */
    Result getHuaweiPerListByKeyword(ComDepartDto comDepartDto);



}
