package com.bcxin.oa.old.mapper.salary;

import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业薪酬模板对应人员
 *
 * @author llc
 * @date 2018-12-28
 */
public interface ComSalaryTempPerMapper {

	/**
	 * 校验模板人员是否存在其他模板
	 * @param comId
	 * @param startYears
	 * @param endYears
	 * @param comSalaryTempId
	 * @param list
	 * @return
	 * @author llc
	 * @date 2019-01-03
	 */
	List<String> checkSalaryTempPer(@Param("comId") Long comId,
									@Param("comSalaryTempId") Long comSalaryTempId,
									@Param("startYears") String startYears,
									@Param("endYears") String endYears,
									@Param("list") List<String> list);


	/**
	 * 插入企业薪酬对应人员
	 * @param comId
	 * @param comSalaryTempId
	 * @param createBy
	 * @param startYears
	 * @param endYears
	 * @param list
	 * @return
	 * @author llc
	 * @date 2018-12-28
	 */
	int batchInsertSalaryTempPer(@Param("comId") Long comId,
								 @Param("comSalaryTempId") Long comSalaryTempId,
								 @Param("createBy") Long createBy,
								 @Param("startYears") String startYears,
								 @Param("endYears") String endYears,
								 @Param("list")  List<String> list);

	/**
	 * 删除企业薪酬对应人员
	 * 
	 * @param comSalaryTempId
	 * @return
	 * @author llc
	 * @date 2018-12-29
	 */
	int deleteSalaryTempPer(@Param("comSalaryTempId") Long comSalaryTempId);


	/**
	 * 查询企业薪资模板对应人员
	 *
	 * @param comSalaryTempId
	 * @return
	 * @author llc
	 * @date 2019-01-03
	 */
	List<String> getComSalaryTempPerList(@Param("comSalaryTempId") Long comSalaryTempId);

}