package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.entity.task.TempTaskSchedulCheck;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @Classname ComAttendTaskImportMapper
 * @Description 任务排班导入
 * @Date 2019/9/26 16:21
 * @Created by jianjun.wang
 */
public interface ComAttendTaskImportMapper {
    /**
     * 1.把导入任务排班批量插入到临时表
     * @param taskSchedulList
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    Integer insertTempBatchTaskSchedulImport(@Param("taskSchedulList") List<Map<String, String>> taskSchedulList,
                                             @Param("importBatchId") Long importBatchId);


    /**
     * 2.批量任务排班导入-校验导入的人员ID是否有效
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    Integer checkPerId(@Param("importBatchId") Long importBatchId, @Param("comTaskId") Long comTaskId);


    /**
     * 3.批量任务排班导入-校验导入的人员ID是否存在重复
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    Integer checkPerIdNoRepeat(@Param("importBatchId") Long importBatchId);

    /**
     * 3.1 获取（人员有效性）校验成功的日期排班
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    List<Map<String, Object>> getPerDateSchedulList(@Param("importBatchId") Long importBatchId);


    /**
     * 4.批量任务排班导入-插入任务排班校验表
     * @param importBatchId
     * @param list
     * @date 2019-09-27
     * @auth llc
     */
    Integer insertTempTaskSchedulCheck(@Param("importBatchId") Long importBatchId,@Param("list") List<TempTaskSchedulCheck> list);


    /**
     * 5.批量任务排班导入-校验此人员排班是否和其他任务存在冲突
     * @param importBatchId
     * @param comId
     * @param comTaskId
     * @date 2019-10-09
     * @auth llc
     */
    Integer checkPerSchedulConflict(@Param("importBatchId") Long importBatchId,
                                    @Param("comId") Long comId,
                                    @Param("comTaskId") Long comTaskId);




    /**
     * 6.批量任务排班导入-清除旧的排班记录
     * @param importBatchId
     * @param comId
     * @param comTaskId
     * @date 2019-10-09
     * @auth llc
     */
    Integer deleteOldTaskSchedul(@Param("importBatchId") Long importBatchId,
                                 @Param("comId") Long comId,
                                 @Param("comTaskId") Long comTaskId);



    /**
     * 7.批量任务排班导入-清除旧的任务执行情况
     * @param importBatchId
     * @param comId
     * @param comTaskId
     * @date 2019-10-09
     * @auth llc
     */
    Integer deleteOldTaskImplement(@Param("importBatchId") Long importBatchId,
                                   @Param("comId") Long comId,
                                   @Param("comTaskId") Long comTaskId);



    /**
     * 8.批量任务排班导入-插入新的排班记录
     * @param importBatchId
     * @param comId
     * @param comTaskId
     * @date 2019-10-09
     * @auth llc
     */
    Integer insertNewTaskSchedul(@Param("importBatchId") Long importBatchId,
                                 @Param("comId") Long comId,
                                 @Param("comTaskId") Long comTaskId,
                                 @Param("createBy") Long createBy);

    /**
     * 9.批量任务排班导入-获取本次导入任务执行情况
     * @param importBatchId
     * @param comId
     * @date 2019-10-09
     * @auth llc
     */
    List<ComTaskImplement> getNewTaskImplementList(@Param("importBatchId") Long importBatchId,
                                                   @Param("comId") Long comId);


    /**
     * 10.批量任务排班导入-插入新的任务执行情况
     * @param createBy
     * @param list
     * @date 2019-10-09
     * @auth llc
     */
    Integer insertNewTaskImplement(@Param("createBy") Long createBy,@Param("list") List<ComTaskImplement> list);


    /**
     * 11.批量任务排班导入-获取排班校验表失败记录
     * @param importBatchId
     * @date 2019-10-15
     * @auth llc
     */
    List<TempTaskSchedulCheck> getTempTaskSchedulCheckFailList(@Param("importBatchId") Long importBatchId);


    /**
     * 12.批量任务排班导入- 更新排班导入临时表的校验失败信息
     * @param importBatchId
     * @param perCheckFailList
     * @date 2019-10-15
     * @auth llc
     */
     Integer updateTempBatchTaskImport(@Param("importBatchId") Long importBatchId,@Param("list") List<Map<String,Object>> perCheckFailList);

    /**
     * 13.批量任务排班导入- 获取导入的任务排班信息
     *
     * @param importBatchId by llc 2019-09-27
     */
    List<Map<String, String>> getTempImportTaskSchedulList(@Param("importBatchId") Long importBatchId);

    /**
     * 14.批量任务排班导入- 删除导入校验数据
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    Integer deleteTempTaskSchedulCheck(@Param("importBatchId") Long importBatchId);


    /**
     * 15.批量任务排班导入- 删除临时表的导入数据
     * @param importBatchId
     * @date 2019-09-27
     * @auth llc
     */
    Integer deleteTempBatchTaskSchedulImport(@Param("importBatchId") Long importBatchId);


}
