package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 批量任务排班导入校验
 * 
 * @author llc
 * @date 2019-09-30
 */
@Data
@TableName("temp_task_schedul_check")
public class TempTaskSchedulCheck{

	/** 任务排班ID */
	@ApiModelProperty(value = "任务排班ID")
	private Long taskSchedulId;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 日期 */
	@ApiModelProperty(value = "日期")
	private Date dates;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	/** 导入批次ID */
	@ApiModelProperty(value = "导入批次ID")
	private Long importBatchId;

	/** 成功标志 */
	@ApiModelProperty(value = "成功标志")
	private String isSuccess;

	/** 错误信息 */
	@ApiModelProperty(value = "错误信息")
	private String errorMsg;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getImportBatchId() {
		return importBatchId;
	}

}