package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 内勤打卡提醒
 * 
 * @author llc
 * @since 2019-01-10
 */
@TableName("attend_card_remind")
@Data
public class AttendCardRemind extends BaseEntity<AttendCardRemind> {

	/** 内勤打卡提醒ID */
	@ApiModelProperty(value = "内勤打卡提醒ID")
	private Long attendCardRemindId;

	/** 星期几 */
	@ApiModelProperty(value = "weekDay")
	private int weekDay;

	/** 提醒时间 */
	@ApiModelProperty(value = "提醒时间")
	private Date remindTime;

	/** 考勤时间 */
	@ApiModelProperty(value = "考勤时间")
	private Date attendTime;

	/** 开始日期 */
	@ApiModelProperty(value = "开始日期")
	private Date startDate;

	/** 结束日期 */
	@ApiModelProperty(value = "结束日期")
	private Date endDate;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendCardRemindId() {
		return attendCardRemindId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

}