package com.bcxin.oa.old.entity.count;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 人员考勤日统计
 * 
 * @author llc
 * @date 2018-12-03
 */
@Data
@TableName("count_per_attend_date")
public class CountPerAttendDate extends BaseEntity<CountPerAttendDate> {
	private static final long serialVersionUID = 1972770399L;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 考勤日期 */
	@ApiModelProperty(value = "考勤日期")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date attendDate;

	/** 正常考勤次数 */
	@ApiModelProperty(value = "正常考勤次数")
	private int normalAttendTimes;

	/** 是否休息 */
	@ApiModelProperty(value = "是否休息")
	private String isRest;

	/** 是否缺勤 */
	@ApiModelProperty(value = "是否缺勤")
	private String isAbsenteeism;

	/** 缺勤时长(时) */
	@ApiModelProperty(value = "缺勤时长(时)")
	private BigDecimal absenceTime;

	/** 迟到次数 */
	@ApiModelProperty(value = "迟到次数")
	private int lateTimes;


	/** 总迟到时间(分钟) */
	@ApiModelProperty(value = "总迟到时间(分钟)")
	private int totalLateTime;

	/** 早退次数 */
	@ApiModelProperty(value = "早退次数")
	private int leaveEarlyTimes;


	/** 总早退时间(分钟) */
	@ApiModelProperty(value = "总早退时间(分钟)")
	private int totalLeaveEarlyTime;

	/** 缺卡次数 */
	@ApiModelProperty(value = "缺卡次数")
	private int missCardTimes;

	/** 总工时(时) */
	@ApiModelProperty(value = "总工时(时)")
	private BigDecimal workHours;

	/** 第一轮上班打卡结果 */
	@ApiModelProperty(value = "第一轮上班打卡结果")
	private String firstRoundOnWork;

	/** 第一轮上班打卡结果 */
	@ApiModelProperty(value = "第一轮下班打卡结果")
	private String firstRoundOffWork;

	/** 第二轮上班打卡结果 */
	@ApiModelProperty(value = "第二轮上班打卡结果")
	private String secondRoundOnWork;

	/** 第二轮上班打卡结果 */
	@ApiModelProperty(value = "第二轮上班打卡结果")
	private String secondRoundOffWork;

	/** 第三轮上班打卡结果 */
	@ApiModelProperty(value = "第三轮上班打卡结果")
	private String thirdRoundOnWork;

	/** 第三轮下班打卡结果 */
	@ApiModelProperty(value = "第三轮下班打卡结果")
	private String thirdRoundOffWork;

	/** 第四轮上班打卡结果 */
	@ApiModelProperty(value = "第四轮上班打卡结果")
	private String fourthRoundOnWork;

	/** 第四轮下班打卡结果 */
	@ApiModelProperty(value = "第四轮下班打卡结果")
	private String fourthRoundOffWork;

	/** 第五轮上班打卡结果 */
	@ApiModelProperty(value = "第五轮上班打卡结果")
	private String fifthRoundOnWork;

	/** 第五轮下班打卡结果 */
	@ApiModelProperty(value = "第五轮下班打卡结果")
	private String fifthRoundOffWork;


	/** 部门ID */
	@ApiModelProperty(value = "部门ID")
	private Long departId;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getDepartId() {
		return departId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

}