package com.bcxin.oa.old.dto;


import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.Date;

/**
 * 员工批量导入Excel
 *
 * @author zhangye
 * @version 1.0
 */
public class PerInfoExcelBean implements Serializable {

    private static final long serialVersionUID = -3531925993852171266L;

    private String departName;

    @Pattern(regexp = "^[a-zA-Z\\u4e00-\\u9fa5]{1,16}$", message = "姓名只能是中文或英文，且在16个字符以内")
    private String name;

    @Pattern(regexp = "^身份证$", message = "证件类型必须是身份证")
    private String idCardType;

    private String idCardNo;

    @Pattern(regexp = "^1[0-9]{10}$", message = "手机格式不正确")
    private String mobilePhone;

    private String roleName;

    private Date entryDate;

    private String isAppActive;

    private String isAppAuth;

    /**
     * 导入的错误信息
     */
    private String errorMsg;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(String idCardType) {
        this.idCardType = idCardType;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getDepartName() {
        return departName;
    }

    public void setDepartName(String departName) {
        this.departName = departName;
    }

    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public String getErrorMsg() {
        if (StringUtils.isNotEmpty(errorMsg)) {
            return errorMsg;
        } else {
            return "";
        }
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getIsAppActive() {
        return isAppActive;
    }

    public void setIsAppActive(String isAppActive) {
        this.isAppActive = isAppActive;
    }

    public String getIsAppAuth() {
        return isAppAuth;
    }

    public void setIsAppAuth(String isAppAuth) {
        this.isAppAuth = isAppAuth;
    }
}