
package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.entity.task.ComTaskShift;
import com.bcxin.oa.old.dto.ComTaskFixedDTO;
import com.bcxin.oa.old.dto.ComTaskFixedTempDTO;
import com.bcxin.oa.old.dto.ComTaskShiftDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskShiftService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Title：任务班次范围
 * @author：llc
 * @date 2020-05-06
 */
@RestController
@RequestMapping("/task/shift")
@Api(tags = { "" }, description = "任务班次范围")
public class ComTaskShiftController extends BaseController {

	@Resource
	private ComTaskShiftService comTaskShiftService;

	/**
	 * 获取未排班班次列表
	 * @param ComTaskShift
	 * @author llc
	 * @date 2020-05-06
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务班次范围", title = "获取未排班班次列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-no-schedul-shift-list")
	@ApiOperation(value = "获取未排班班次列表", httpMethod = "GET", notes = "获取未排班班次列表", response = ComTaskFixedDTO.class)
	public Result getNoSchedulShiftList(ComTaskShift ComTaskShift) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskShiftService.getNoSchedulShiftList(ComTaskShift).setBack(getRequest());
	}

	/**
	 * 删除驻勤班次关联
	 * @param dto
	 * @author llc
	 * @date 2020-05-06
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务班次范围", title = "删除驻勤班次关联", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除驻勤班次关联", httpMethod = "POST", notes = "删除驻勤班次关联", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "delete-task-shift")
	public Result deleteTaskShift(ComTaskShiftDto dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskShiftService.deleteTaskShift(dto).setBack(getRequest());
	}


	/**
	 * 获取未设置班次列表
	 * @param ComTaskShift
	 * @author llc
	 * @date 2020-05-09
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务班次范围", title = "获取未设置班次列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-no-set-shift-list")
	@ApiOperation(value = "获取未设置班次列表", httpMethod = "GET", notes = "获取未设置班次列表", response = ComTaskFixedDTO.class)
	public Result getNoSetShiftList(ComTaskShift ComTaskShift) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskShiftService.getNoSetShiftList(ComTaskShift).setBack(getRequest());
	}


	/**
	 * 新增驻勤班次关联
	 * @param dto
	 * @author llc
	 * @date 2020-05-09
	 * @return
	 * @throws BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务班次范围", title = "新增驻勤班次关联", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "新增驻勤班次关联", httpMethod = "POST", notes = "新增驻勤班次关联", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "add-task-shift")
	public Result addTaskShift(ComTaskShiftDto dto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comTaskShiftService.addTaskShift(dto).setBack(getRequest());
	}

}
