package com.bcxin.oa.old.controller.system;

import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.dto.PerBaseInfoDto;
import com.bcxin.oa.old.dto.PerInfoQueryDto;
import com.bcxin.oa.old.dto.PerOrgRelationDto;
import com.bcxin.oa.old.dto.PerTaskInfoDto;
import com.bcxin.oa.old.dto.user.CurrentUser;
import com.bcxin.oa.old.entity.system.PerBaseInfo;
import com.bcxin.oa.old.service.system.PerBaseInfoService;
import com.bcxin.oa.old.service.system.PerOrgRelationService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author：wangcy @date：2017/12/20 0020 10:31
 * @description：perBaseInfo的controller层
 */
@RestController
@RequestMapping("/system/per-base-info")
public class PerBaseInfoController extends BaseController {

	@Resource
	private PerBaseInfoService perBaseInfoService;

	@Resource
	private PerOrgRelationService perOrgRelationService;


	/**
	 * @Author: wangcy
	 * @Description:查看用户基础信息
	 * @Date: 2017/12/26 0026 19:48
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "用户管理", title = "查看用户基础信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-per-base-info")
	@ApiOperation(value = "查看用户", httpMethod = "POST", notes = "查看用户基础信息", response = PerBaseInfoDto.class)
	public Result getPerBaseInfo(Long perId) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perBaseInfoService.getPerBaseInfo(perId).setBack(getRequest());
	}

	/**
	 * @Author: luopeng
	 * @Description:查看用户基础信息
	 * @Date: 2021/07/30
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "查看用户入职信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-per-work-info")
	@ApiOperation(value = "查看用户", httpMethod = "POST", notes = "查看用户入职信息", response = PerBaseInfoDto.class)
	public Result getPerWorkInfo(PerBaseInfo perBaseInfo) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perBaseInfoService.getPerWorkInfo(perBaseInfo).setBack(getRequest());
	}


	/**
	 * 通过人员ID列表查询人员基础信息
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2020-04-15
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "通过人员ID列表查询人员基础信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "/get-per-base-info-list-by-perids")
	@ApiOperation(value = "通过人员ID列表查询人员基础信息", httpMethod = "POST", notes = "通过人员ID列表查询人员基础信息", response = PerBaseInfoDto.class)
	public Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perBaseInfoService.getPerBaseInfoListByPerIds(dto).setBack(getRequest());
	}

	/**
	 * 查看用户基础信息
	 * 【百课堂在调用，勿加权限校验】
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户基本信息管理", title = "获取用户精简基本信息", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-simple-per-base-info")
	@ApiOperation(value = "获取用户精简基本信息", httpMethod = "POST", notes = "获取用户精简基本信息", response = PerBaseInfoDto.class)
	public Result getSimplePerBaseInfo(Long perId) {
	    /* 【百课堂在调用，勿加权限校验】 */
		Result result = perBaseInfoService.getSimplePerBaseInfo(perId);
		return result.setBack(getRequest());
	}
	/**
	 * 获取用户定位信息
	 * 【百课堂在调用，勿加权限校验】
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户基本信息管理", title = "获取用户定位信息", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-per-localtion")
	@ApiOperation(value = "获取用户定位信息", httpMethod = "POST", notes = "获取用户定位信息", response = PerBaseInfoDto.class)
	public Result getPerLocation(Long perId) {
	    /* 【百课堂在调用，勿加权限校验】 */
		Result result = perBaseInfoService.getPerLocation(perId);
		return result.setBack(getRequest());
	}
	/**
	 * 获取用户入职信息
	 * 【百课堂在调用，勿加权限校验】
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户基本信息管理", title = "获取用户入职信息", systemType = Log.OPERA_TYPE_SELECT)
	@PostMapping(value = "get-per-work")
	@ApiOperation(value = "获取用户定位信息", httpMethod = "POST", notes = "获取用户定位信息", response = PerBaseInfoDto.class)
	public Result getPerWork(Long perId) {
	    /* 【百课堂在调用，勿加权限校验】 */
		Result result = perBaseInfoService.getPerWork(perId);
		return result.setBack(getRequest());
	}

	/**
	 * 查看用户基础信息
	 * 【百课堂在调用，勿加权限校验】
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户基本信息管理", title = "获取用户精简基本信息", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-simple-per-base-info-by-idCardNo")
	@ApiOperation(value = "获取用户精简基本信息", httpMethod = "POST", notes = "获取用户精简基本信息", response = PerBaseInfoDto.class)
	public Result getSimplePerBaseInfoByIdCardNo(String idCardNo) {
	    /* 【百课堂在调用，勿加权限校验】 */
		Result result = perBaseInfoService.getSimplePerBaseInfo(idCardNo);
		return result.setBack(getRequest());
	}

	/**
	 * 查看用户基础信息
	 *【百课堂在调用，勿加权限校验】
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户基本信息管理", title = "获取用户部门信息", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-per-depart-info")
	@ApiOperation(value = "获取用户部门信息", httpMethod = "POST", notes = "获取用户部门信息", response = PerBaseInfoDto.class)
	public Result getPerDepartInfoByIdList(HttpServletRequest request) {
		/* 【百课堂在调用，勿加权限校验】 */
		String perIdListStr = request.getParameter("perIdList");
		List<Long> list = JSON.parseArray(perIdListStr,Long.class);
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("departName" , request.getParameter("departName"));
		paramMap.put("comId" , request.getParameter("comId"));
		paramMap.put("perIdList" , list);
		Result result = perBaseInfoService.getPerDepartInfoByIdList(paramMap);
		return result.setBack(getRequest());
	}

	/**
	 * @Author: zhongjianhui
	 * @Description:查询离职用户列表
	 * @Date: 2017/12/29 19:48
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "查询离职用户列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "page/leave-per")
	@ApiOperation(value = "查询离职用户列表", httpMethod = "POST", notes = "查询离职用户列表", response = PerBaseInfoDto.class)
	public Result pageForLeavePer(PerOrgRelationDto perOrgRelationDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perBaseInfoService.pageForLeavePer(perOrgRelationDto).setBack(getRequest());
	}

	/**
	 * 保安人员信息分页查询
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-05-17
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "人员信息分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "/page-for-per-info")
	@ApiOperation(value = "人员信息分页查询", httpMethod = "POST", notes = "人员信息分页查询", response = PerBaseInfoDto.class)
	public Result pageForPerInfo(PerInfoQueryDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		dto.setPerId(currentUser.getPerId());
		return perBaseInfoService.pageForPerInfo(dto).setBack(getRequest());
	}

	/**
	 * 导出保安人员信息
	 * @param dto
	 * @author llc
	 * @date 2019-06-03
	 */
	@GetMapping(value = "/export-security-staff-info")
	@ApiOperation(value = "导出保安人员信息", httpMethod = "GET", notes = "无", response = PerBaseInfoDto.class)
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "导出保安人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result exportSecurityStaffInfo(PerInfoQueryDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		dto.setPerId(currentUser.getPerId());
		Result result = perBaseInfoService.exportSecurityStaffInfo(dto,getResponse()).setBack(getRequest());
		return result;
	}

	/**
	 * 保安人员驻勤点信息分页查询
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2020-04-22
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "保安人员驻勤点信息分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "/page-per-task-info")
	@ApiOperation(value = "保安人员驻勤点信息分页查询", httpMethod = "POST", notes = "保安人员驻勤点信息分页查询", response = PerBaseInfoDto.class)
	public Result pagePerTaskInfo(PerTaskInfoDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perBaseInfoService.pagePerTaskInfo(dto).setBack(getRequest());
	}

	/**
	 * 导出人员驻勤点信息
	 * @param dto
	 * @author llc
	 * @date 2020-04-23
	 */
	@GetMapping(value = "/export-per-task-info")
	@ApiOperation(value = "导出人员驻勤点信息", httpMethod = "GET", notes = "无", response = PerBaseInfoDto.class)
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "导出人员驻勤点信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	public Result exportPerTaskInfo(PerTaskInfoDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = perBaseInfoService.exportPerTaskInfo(dto,getResponse()).setBack(getRequest());
		return result;
	}

	/**
	 * 批量查询用户是否存在
	 * @author hzh
	 * @date 2020-10-29
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "批量查询用户是否存在", title = "批量查询用户是否存在", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "batch-check-person")
	@ApiOperation(value = "批量查询用户是否存在", httpMethod = "POST", notes = "批量查询用户是否存在", response = Result.class)
	public Result batchCheckPerson(HttpServletRequest request) {
		String idCardNoStr = request.getParameter("idCardNoList");
		List<String> list = JSON.parseArray(idCardNoStr,String.class);
		if (list == null) {
			return Result.fail("查询list不能为空").setBack(getRequest());
		}
		Result result = perBaseInfoService.batchCheckPerson(list);
		return result;
	}
}
