package com.bcxin.oa.old.controller.system;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.MedicalSocialRecDTO;
import com.bcxin.oa.old.service.system.MedicalSocialRecService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Cleanup;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 企业基础信息表 前端控制器
 * </p>
 *
 * @author ctj
 * @since 2017-12-11
 */
@RestController
@RequestMapping("/enterprise/ins/medical-social-rec")
@Api(tags = { "" }, description = "医社保记录") // tag中文会影响路径
public class MedicalSocialRecController extends BaseController {

	@Resource
	private MedicalSocialRecService medicalSocialRecService;

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保记录", title = "查询人员缴交情况分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-his-rec-list-page")
	@ApiOperation(value = "查询人员缴交情况分页")
	public Result getHisRecListPage(MedicalSocialRecDTO dto) throws BusinessException {
		return medicalSocialRecService.getHisRecListPage(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保记录", title = "导出excel", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/export-his-rec-list")
	@ApiOperation(value = "医社保记录，导出excel")
	public void exportHisRecList(MedicalSocialRecDTO dto) throws Exception {;
		if (dto.getComId() == null) {
			throw new Exception("参数comId不能为空");
		}
		if (dto.getPayPeriod() == null) {
			throw new Exception("参数payPeriod不能为空");
		}
		List<Map<String, Object>> list = medicalSocialRecService.getHisRecListPageExport(dto);
		exportHisRec(getResponse(), list, "医社保记录查询" + dto.getPayPeriod());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保记录", title = "统计某个月，应缴交总计、企业缴交总金额、个人缴交总金额", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/stat-his-rec-list")
	@ApiOperation(value = "统计某个月，应缴交总计、企业缴交总金额、个人缴交总金额")
	public Result statHisRecList(MedicalSocialRecDTO dto) throws BusinessException {
		return medicalSocialRecService.statHisRecList(dto).setBack(getRequest());
	}

	private void exportHisRec(HttpServletResponse response, List<Map<String, Object>> list, String rename) throws Exception {
		List<Map<String, Object>> rows = Lists.newArrayList();
		for (Map<String, Object> map : list) {
			map.remove("payPeriod");
			rows.add(map);
		}
		// 通过工具类创建writer
		ExcelWriter writer = ExcelUtil.getWriter();

		writer.addHeaderAlias("name","名称");
		writer.addHeaderAlias("idCardNo","身份证号");
		writer.addHeaderAlias("pensionComPayAmount","养老保险（企业）");
		writer.addHeaderAlias("unemploymentComPayAmount","失业保险（企业）");
		writer.addHeaderAlias("medicalComPayAmount","医疗保险（企业）");
		writer.addHeaderAlias("injuryComPayAmount","工伤保险（企业）");
		writer.addHeaderAlias("birthComPayAmount","生育保险（企业）");
		writer.addHeaderAlias("fundComPayAmount","公积金（企业）");

		writer.addHeaderAlias("pensionPerPayAmount","养老保险（个人）");
		writer.addHeaderAlias("unemploymentPerPayAmount","失业保险（个人）");
		writer.addHeaderAlias("medicalPerPayAmount","医疗保险（个人）");
		writer.addHeaderAlias("injuryPerPayAmount","工伤保险（个人）");
		writer.addHeaderAlias("birthPerPayAmount","生育保险（个人）");
		writer.addHeaderAlias("fundPerPayAmount","公积金（个人）");
		writer.addHeaderAlias("totalPayAmount","合计");

		// 一次性写出内容，使用默认样式
		writer.write(rows);

		/* 设置列宽度 */
		writer.setColumnWidth(0,16);
		writer.setColumnWidth(1,20);
		writer.setColumnWidth(2,16);
		writer.setColumnWidth(3,16);
		writer.setColumnWidth(4,16);
		writer.setColumnWidth(5,16);
		writer.setColumnWidth(6,16);
		writer.setColumnWidth(7,16);
		writer.setColumnWidth(8,16);
		writer.setColumnWidth(9,16);
		writer.setColumnWidth(10,16);
		writer.setColumnWidth(11,16);
		writer.setColumnWidth(12,16);
		writer.setColumnWidth(13,16);

		response.setContentType("application/vnd.ms-excel;charset=utf-8");
		//test.xls是弹出下载对话框的文件名，不能为中文，中文请自行编码
		response.setHeader("Content-Disposition","attachment;filename=" + URLEncoder.encode(rename)+ ".xls");
		@Cleanup
		ServletOutputStream out = response.getOutputStream();

		writer.flush(out);
		// 关闭writer，释放内存
		writer.close();

	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保记录", title = "定时任务默认执行当月，可传入2018-10具体月份和公司则会缩小范围", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/task-generate-his-rec")
	@ApiOperation(value = "定时任务，默认执行当月，可传入2018-10具体月份和公司则会缩小范围")
	public Result taskGenerateHisRec() throws Exception {
		return medicalSocialRecService.taskGenerateHisRec(getParams());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保记录", title = "提示用户去完成方案的设置", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/prompt-user-to-set-scheme")
	@ApiOperation(value = "提示用户去完成方案的设置")
	public Result promptUserToSetScheme(MedicalSocialRecDTO dto) throws Exception {
		return medicalSocialRecService.promptUserToSetScheme(dto);
	}

	public static void main(String[] args) {

		List<String> errorList = Lists.newArrayList();
		errorList.add("请导入薪酬数据，未检测到数据");
		errorList.add("excel列不符，请重新下载导入模板");
		errorList.add("第1行，未匹配到公司员工【李明明】，请检查");
		errorList.add("第2行，未匹配到公司员工【李明明】，请检查");
		errorList.add("第3行，未匹配到公司员工【李明、】，请检查");

		// 通过工具类创建writer
		ExcelWriter writer = ExcelUtil.getWriter("d:/writeMapTest2.xls");
		//writer.merge(errorList.size() - 1, "测试标题");

		writer.setColumnWidth(0,80);
		// 一次性写出内容，使用默认样式
		writer.write(errorList);
		// 关闭writer，释放内存
		writer.close();
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "定时任务医社保定期生成社保数据", title = "可选参数payPeriod，comId，默认计算所有企业上个月的", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/medical-social-rec-quartz")
	@ApiOperation(value = "定时任务医社保定期生成社保数据")
	public Result findCompnayAndPersonByUserid() throws BusinessException {
		return medicalSocialRecService.taskGenerateHisRec(getParams()).setBack(getRequest());
	}
}
