package com.bcxin.oa.old.controller.htmlfive.salary;

import com.bcxin.oa.old.entity.salary.PerSalaryGrant;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.service.salary.app.HtmlPerSalaryGrantService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * APP-薪酬管理的controller层
 * by llc 2019-01-01
 */
@RestController
@RequestMapping("/task/html/com/salary")
@Api(tags = { "" }, description = "APP-薪酬管理")
public class HtmlPerSalaryController extends BaseController {


	@Autowired
	private HtmlPerSalaryGrantService htmlPerSalaryGrantService;


	/**
	 * 个人工资单列表
	 * @return
	 * @author llc
	 * @date 2019-01-01
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "个人工资单列表", title = "个人工资单列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "个人工资单列表", httpMethod = "POST", notes = "个人工资单列表", response = Map.class)
	@PostMapping(value = "per-salary-list")
	public Result perSalaryList(ParamDTO paramDTO,HttpServletRequest request) {
		return htmlPerSalaryGrantService.perSalaryList(paramDTO).setBack(request);
	}


	/**
	 * 个人工资单详情
	 * @return
	 * @author llc
	 * @date 2019-01-01
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "个人工资单详情", title = "个人工资单详情", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "个人工资单详情", httpMethod = "POST", notes = "个人工资单详情", response = Map.class)
	@PostMapping(value = "per-salary-detail")
	public Result perSalaryDetail(ParamDTO paramDTO) {
		Result result = htmlPerSalaryGrantService.perSalaryDetail(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 个人工资单确认
	 * @return
	 * @author llc
	 * @date 2019-01-01
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "个人工资单确认", title = "个人工资单确认", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "个人工资单确认", httpMethod = "POST", notes = "个人工资单确认", response = PerSalaryGrant.class)
	@PostMapping(value = "confirm-salary")
	public Result confirmSalary(ParamDTO paramDTO) {
		Result result = htmlPerSalaryGrantService.perSalaryConfirm(paramDTO);
		return result.setBack(getRequest());
	}

}
