package com.bcxin.oa.old.controller.app.attend;

import com.bcxin.oa.old.dto.app.AppPerAttendCardRecordDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.user.CurrentUser;
import com.bcxin.oa.old.service.attend.app.PerAttendCardRecordService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App接口-考勤打卡记录管理
 *
 * @author wangjianchi
 * @version 1.0
 */
@RestController
@RequestMapping("/task/app/per/attend/cardrecord")
@Api(tags = { "" }, description = "APP-考勤打卡记录")
public class AppPerAttendCardRecordController extends BaseController {

	@Autowired
	private PerAttendCardRecordService perAttendCardRecordService;

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-考勤打卡记录", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-考勤上班打卡记录", httpMethod = "POST", notes = "保存考勤上班打卡记录", response = AppPerAttendCardRecordDTO.class)
	@PostMapping(value = "save-signin")
	public Result saveSignIn(AppPerAttendCardRecordDTO appPerAttendCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerAttendCardRecordDTO appPerCerBaseInfoDtoParam = Result
				.getDecodeData(appPerAttendCardRecordDto.getAppData(), AppPerAttendCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerCerBaseInfoDtoParam, appPerAttendCardRecordDto);
		appPerCerBaseInfoDtoParam.setPerId(currentUser.getPerId());
		appPerCerBaseInfoDtoParam.setClockInType(DictConst.CLOCKINTYPE_SBDK);
		return perAttendCardRecordService.saveSignIn(appPerCerBaseInfoDtoParam).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-考勤打卡记录", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-考勤下班打卡记录", httpMethod = "POST", notes = "保存考勤下班打卡记录", response = AppPerAttendCardRecordDTO.class)
	@PostMapping(value = "save-signout")
	public Result saveSignOut(AppPerAttendCardRecordDTO appPerAttendCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerAttendCardRecordDTO appPerCerBaseInfoDtoParam = Result
				.getDecodeData(appPerAttendCardRecordDto.getAppData(), AppPerAttendCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerCerBaseInfoDtoParam, appPerAttendCardRecordDto);
		appPerCerBaseInfoDtoParam.setPerId(currentUser.getPerId());
		appPerCerBaseInfoDtoParam.setClockInType(DictConst.CLOCKINTYPE_XBDK);
		return perAttendCardRecordService.saveSignOut(appPerCerBaseInfoDtoParam).setBack(getRequest());
	}


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "APP-查询考勤状态", title = "查询考勤状态", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-查询考勤状态", httpMethod = "POST", notes = "查询考勤状态", response = AppPerAttendCardRecordDTO.class)
	@PostMapping(value = "get-attend-state")
	public Result getAttendState(AppPerAttendCardRecordDTO appPerAttendCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerAttendCardRecordDTO appPerCerBaseInfoDtoParam = Result
				.getDecodeData(appPerAttendCardRecordDto.getAppData(), AppPerAttendCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerCerBaseInfoDtoParam, appPerAttendCardRecordDto);
		appPerCerBaseInfoDtoParam.setPerId(currentUser.getPerId());
		Result result = perAttendCardRecordService.getAttendState(appPerCerBaseInfoDtoParam).setBack(getRequest());
		return result;
	}
}
