package com.bcxin.oa;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@SpringBootApplication
@EnableScheduling
@EnableWebMvc
@EnableTransactionManagement
@EnableAsync
@EnableRetry
@MapperScan({"com.bcxin.oa.old.mapper", "com.bcxin.oa.current.mapper"})
public class PersonnelOaApplication {
	public static void main(String[] args) {
		SpringApplication.run(PersonnelOaApplication.class, args);
	}
}
