package com.bcxin.oa.old.service.task.bbd;

import com.bcxin.oa.old.entity.task.ComShiftRule;
import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.app.AppPerTaskCardRecordDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import java.util.List;

/**
 * 百保盾联调
 *
 * @author zhongjianhui
 * @since 2018-03-22 10:04:46
 */
public interface BbdTestService {

	/**
	 * 新增或更新任务 重载同步任务，这个是调task/save.json
	 *
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateTask @date：2019/10/24 10:01 @params： * @param object
	 */
	void bbdSaveOrUpdateTask(ComTaskDto comTaskThreeDTO);

	/**
	 * 删除任务
	 *
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method testTask @date：2018/3/23 10:01 @params： * @param object
	 */
	void bbdDeleteTask(ComTaskDto comTaskDto);


	/**
	 * 新增任务人员
	 * @param comTaskDto
	 * @param perIdList
	 * @auth llc
	 * @date 2020-04-17
	 */
	void bbdAddTaskPer(ComTaskDto comTaskDto,List<String> perIdList);


	/**
	 * 删除任务人员
	 * @param comTaskDto
	 * @auth llc
	 * @date 2020-03-26
	 */
	void bbdRemoveTaskPer(ComTaskDto comTaskDto,List<String> perIdList);


	/**
	 * 保存企业驻勤点班次
	 * @param comShiftDto
	 * @param ruleList
	 * @auth llc
	 * @date 2020-03-26
	 */
	void bbdSaveComTaskShift(ComShiftDto comShiftDto, List<ComShiftRule> ruleList);

	/**
	 * 删除企业驻勤点班次
	 * @param comShiftDto
	 * @auth llc
	 * @date 2020-03-26
	 */
	void bbdDeleteComTaskShift(ComShiftDto comShiftDto);


	/**
	 * 同步驻勤排班信息
	 * @param list
	 * @param dto
	 * @author llc
	 * @date 2020-03-24
	 */
	void bbdSyncTaskSchedul(List<ComTaskSchedul> list, ParamDTO dto);

	/**
	 * 批量同步驻勤排班信息
	 * @param perIdList
	 * @param dto
	 * @author llc
	 * @date 2020-03-24
	 */
	void bbdBatchSyncTaskSchedul(List<String> perIdList, ParamDTO dto);


	/**
	 * 同步任务打卡记录
	 * @param dto
	 * @author llc
	 * @date 2020-03-26
	 */
	void bbdSyncPerTaskCardRecord(AppPerTaskCardRecordDTO dto);

	/**
	 * 删除驻勤点
	 * @param comTaskDto
	 * @auth wangjianjun
	 * @date 2020-05-07
	 */
	void bbdDeleteTaskBatch(ComTaskDto comTaskDto,List<Long> perIdList) throws BusinessException;

	/**
	 * <b> 校验人员是否有人口库照片接口 </b>
	 * @author ZXF
	 * @create 2020/09/09 0009 14:20
	 * @version
	 * @注意事项 </b>
	 */
	Result bbdCheckPersonBaseHeadImg(Integer province, String idCardNo) throws BusinessException;

	/**
	 * <b> 联名卡申请前向百保盾发起资格证推送状态变更 </b>
	 * @author ZXF
	 * @create 2020/09/15 0015 13:30
	 * @version
	 * @注意事项 </b>
	 */
	Result bbdApplyBeforeSend(Integer province, String idCardNo) throws BusinessException;

}