package com.bcxin.oa.old.service.system;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.dto.ComDepartDto;
import com.bcxin.oa.old.entity.system.PerOrgRelation;
import com.bcxin.oa.old.mapper.ComDepartMapper;
import com.bcxin.oa.old.mapper.PerOrgRelationMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class PerOrgRelationServiceImpl implements PerOrgRelationService {


    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;


    @Resource
    private ComDepartMapper comDepartMapper;


    @Override
    public PerOrgRelation getByTlkId(String tlkId) {
        return perOrgRelationMapper.findByTlkId(tlkId);
    }


    /**
     * 获取组织的下一级部门列表
     *
     * @param comDepart
     * @return
     * @author llc
     * @date 2019-07-10
     */
    @Override
    public Result getChildDepartList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPerID() == null) {
            return Result.fail("人员ID不能为空");
        }
        /*** 如果部门ID为空则代表传入的是企业 ***/
        if (comDepart.getDepartId() == null) {
            comDepart.setDepartId(-1L); // 如果没传部门ID，则查询企业的下一级部门
        }

        /*** 子部门列表 ***/
        List<Map<String, Object>> childDepartList = comDepartMapper.getChildDepart(comDepart.getComId(), comDepart.getDepartId(), null);

        /*** 存在子部门才需要判断数据权限 ***/
        if (childDepartList.size() > 0) {
            /*** 获取人员的通讯录数据权限涉及部门 ***/
            Map<String, Object> map = getDataAuthOrgList(comDepart.getComId(), comDepart.getPerID());
            if (ObjectUtil.equal(map.get("dataAuthType").toString(), DictConst.DATAAUTHTYPE_QGS)) {
                for (Map<String, Object> m : childDepartList) {
                    m.put("isExistsDataAuth", CommonConst.Y);
                }
            } else {
                /*** 如果不是全公司的权限只需判断权限涉及部门是否包含此部门即可***/
                ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");
                /*** 如果人员的数据权限涉及部门为空 ***/
                if (orgIdList.size() == 0) {

                } else {
                    /*** 匹配到数据权限部门则置为存在数据权限 ***/
                    for (Map<String, Object> m : childDepartList) {
                        for (Long orgId : orgIdList) {
                            if (orgId.equals(Long.parseLong(m.get("departId").toString()))) {
                                m.put("isExistsDataAuth", CommonConst.Y);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return Result.success(Result.SUCCESS_MSG, childDepartList);
    }



    /**
     * web通过姓名/手机号码/身份证搜索人员信息(包含数据权限)
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-07-17
     */
    @Override
    public Result getWebPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(comDepartDto.getKeyword())) {
            return Result.fail("关键字不能为空");
        }
        /*** 获取人员的通讯录数据权限涉及部门 ***/
        Map<String, Object> map = getDataAuthOrgList(comDepartDto.getComId(), comDepartDto.getPerID());

        String dataAuthType = map.get("dataAuthType").toString();
        ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");
        /*** 如果人员的权限不是全公司且数据权限涉及部门为空 ***/
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());
        if(!ObjectUtil.equal(dataAuthType, DictConst.DATAAUTHTYPE_QGS) && orgIdList.size() == 0){
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }

        List<Map<String, String>> perList = perOrgRelationMapper.getWebPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword(),dataAuthType,orgIdList);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    /**
     * 公共选人的接口(关键字查询)
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-08-28
     */
    @Override
    public Result getCommonPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(comDepartDto.getKeyword())) {
            return Result.fail("关键字不能为空");
        }
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());
        List<Map<String, String>> perList = perOrgRelationMapper.getCommonPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword());
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }


    /**
     * 驻勤模块选人的接口
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2020-04-16
     */
    @Override
    public Result getTaskPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(comDepartDto.getKeyword())) {
            return Result.fail("关键字不能为空");
        }
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());

        /*** 2020-07-20 因产品需求添加数据权限 ***/
        /*** 获取人员的通讯录数据权限涉及部门 ***/
        Map<String, Object> map = getDataAuthOrgList(comDepartDto.getComId(), comDepartDto.getPerID());

        String dataAuthType = map.get("dataAuthType").toString();
        ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");
        /*** 如果人员的权限不是全公司且数据权限涉及部门为空 ***/
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());
        if(!ObjectUtil.equal(dataAuthType, DictConst.DATAAUTHTYPE_QGS) && orgIdList.size() == 0){
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        List<Map<String, String>> perList = perOrgRelationMapper.getTaskPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword(),dataAuthType,orgIdList);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    @Override
    public Map<String, Object> getDataAuthOrgList(Long comId, Long perId) {
        Map<String, Object> map = new HashMap<>();
        String dataAuthType = CommonConst.N; // 数据权限初始设置为0
        List<Long> orgIdList = new ArrayList<>();
        map.put("dataAuthType", dataAuthType);
        map.put("orgIdList", orgIdList);
        return map;
    }

    /**
     * 获取组织的人员列表
     *
     * @param comDepart
     * @return
     * @author llc
     * @date 2019-07-10
     */
    @Override
    public Result getOrgPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null && comDepart.getPerID() == null ){
            return Result.fail("部门ID和人员ID不能同时为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setPerId(comDepart.getPerID());
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getWebPerListByOrg(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }



    /**
     * 获取选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @Override
    public Result getDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }


    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    @Override
    public Result getTaskDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getTaskDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }


    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    @Override
    public Result getHuaweiDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail("请传企业ID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if(comDepart.getDepartId() == null){
            return Result.fail("部门ID为空");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();

        /*** 如果部门ID为空或者-1则代表传入的是企业 ***/

        if(comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage(comDepart.getPageNumber(), comDepart.getPageSize());
        List<Map<String, Object>> perList = perOrgRelationMapper.getHuaweiDepartPerSonList(perOrgRelation);

        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

    /**
     * 华为会议选人的接口(关键字查询)
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-12-12
     */
    @Override
    public Result getHuaweiPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(comDepartDto.getKeyword())) {
            return Result.fail("关键字不能为空");
        }
        PageHelper.startPage(comDepartDto.getPageNumber(), comDepartDto.getPageSize());
        List<Map<String, String>> perList = perOrgRelationMapper.getHuaweiPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword());
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(perList));
    }

}
