package com.bcxin.oa.old.service.attend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.dto.AttendCardRemindDTO;
import com.bcxin.oa.old.dto.ComAttendAddressDTO;
import com.bcxin.oa.old.dto.ComAttendGroupDTO;
import com.bcxin.oa.old.dto.ComAttendGroupFixedDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.DictMessageTypeConst;
import com.bcxin.oa.old.common.MsgConst;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 企业考勤组
 *
 * @author llc
 * @since 2018-03-25
 */
@Service
@Transactional
public class ComAttendGroupServiceImpl implements ComAttendGroupService {
    @Resource
    private ComAttendGroupMapper comAttendGroupMapper;

    @Resource
    private ComAttendPerMapper comAttendPerMapper;

    @Resource
    private ComAttendResponsPerMapper comAttendResponsPerMapper;

    @Resource
    private ComAttendAddressMapper comAttendAddressMapper;

    @Resource
    private ComAttendGroupFixedMapper comAttendGroupFixedMapper;

    @Resource
    private ComAttendGroupFreeMapper comAttendGroupFreeMapper;

    @Resource
    private ComAttendGroupSchedulMapper comAttendGroupSchedulMapper;

    @Resource
    private MidAttendGroupMapper midAttendGroupMapper;

    @Resource
    private MidAttendGroupDetailMapper midAttendGroupDetailMapper;

    @Resource
    private CommonService commonService;

    @Resource
    private AttendCardRemindMapper attendCardRemindMapper;

    @Resource
    private ComShiftRuleMapper comShiftRuleMapper;

    @Resource
    private IdWorker idWorker;
    /**
     * 考勤组列表
     *
     * @param comAttendGroupDTO
     * @throws BusinessException by llc 2018-04-02
     */

    @Override
    public Result pageForGroup(ComAttendGroupDTO comAttendGroupDTO) {
        PageHelper.startPage(comAttendGroupDTO.getPageNumber(), comAttendGroupDTO.getPageSize());
        List<Map<String, String>> comAttendGroupList = comAttendGroupMapper.pageForGroup(comAttendGroupDTO);
        for (Map<String, String> map : comAttendGroupList) {
            if (StringUtils.isNotEmpty(map.get("shiftDetail"))) {
                String shiftDetail = map.get("shiftDetail").replace("*br/*", "<br/>");
                map.put("shiftDetail", shiftDetail);
            }
        }
        PageInfoUtils pageInfo = new PageInfoUtils(comAttendGroupList);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 进入考勤设置第一步页面
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
    @Override
    public Result inFirstStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {

        /********* 新增或者修改第二步跳转到第一步 *********/

        Map<String, Object> resultMap = new HashMap<>();

        String midAttendGroupId = "";

        if (dto.getMidAttendGroupId() != null && dto.getMidAttendGroupId().toString() != "") {
            MidAttendGroupDetail detail = new MidAttendGroupDetail();
            detail.setMidAttendGroupId(dto.getMidAttendGroupId());
            detail.setStage(1);
            detail = midAttendGroupDetailMapper.getDetailByStep(detail);
            resultMap = JSON.parseObject(detail.getContent());
            midAttendGroupId = dto.getMidAttendGroupId().toString();
        } else { // 从考勤列表进入或者新增

            if (dto.getAttendGroupId() != null && dto.getAttendGroupId().toString() != "") { // 如果是列表界面进来修改

                if (dto.getIsFormal() == null || dto.getIsFormal() == "") { // 校验是否是正式考勤组
                    throw new BusinessException(Result.BUSINESS_ERROR, "是否正式考勤组标志必须录入");
                }

                if (dto.getIsFormal().equalsIgnoreCase(CommonConst.Y)) { // 如果是正式考勤修改

                    ComAttendGroup comAttendGroup = comAttendGroupMapper.getByPrimaryKey(dto.getAttendGroupId());

                    if (comAttendGroup == null) {
                        throw new BusinessException(Result.BUSINESS_ERROR, "考勤组ID无效");
                    }

                    ComAttendGroupFixed comAttendGroupFixed = new ComAttendGroupFixed();
                    comAttendGroupFixed.setComId(dto.getComId());
                    comAttendGroupFixed.setAttendGroupId(dto.getAttendGroupId());

                    resultMap.put("attendGroupName", comAttendGroup.getAttendGroupName());
                    resultMap.put("attendType", comAttendGroup.getAttendType());
                    resultMap.put("isFollowLegalHoliday", comAttendGroup.getIsFollowLegalHoliday());
                    if (comAttendGroup.getAttendType().equalsIgnoreCase(DictConst.ATTENDTYPE_GDBZ)) {
                        List<Map<String, String>> fixedList = comAttendGroupFixedMapper.getFixedDetailList(comAttendGroupFixed);
                        resultMap.put("comAttendGroupFixeds", JSON.toJSON(fixedList).toString());
                    }
                    /************* 这里是预留排班制、自由工时扩展 ****************/

                } else { // 如果是暂存考勤组完善
                    MidAttendGroupDetail detail = new MidAttendGroupDetail();
                    detail.setMidAttendGroupId(dto.getAttendGroupId());
                    detail.setStage(1);
                    detail = midAttendGroupDetailMapper.getDetailByStep(detail);
                    resultMap = JSON.parseObject(detail.getContent());
                    midAttendGroupId = dto.getAttendGroupId().toString(); // 把考勤组ID设为中间表ID
                }
            }
        }
        resultMap.put("midAttendGroupId", midAttendGroupId);
        resultMap.put("attendGroupId",
                dto.getAttendGroupId() == null ? dto.getAttendGroupId() : dto.getAttendGroupId().toString());
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 进入考勤设置第二步页面
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
    @Override
    public Result inSecondStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {

        /********* 新增或者修改进入第二步 *********/

        if (dto.getMidAttendGroupId() == null || dto.getMidAttendGroupId().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组中间表ID不能为空");
        }

        Map<String, Object> resultMap = new HashMap<>();

        MidAttendGroupDetail detail = new MidAttendGroupDetail();
        detail.setMidAttendGroupId(dto.getMidAttendGroupId());
        detail.setStage(2);
        detail = midAttendGroupDetailMapper.getDetailByStep(detail);

        if (detail != null) {
            resultMap = JSON.parseObject(detail.getContent());
        } else { // 查询正式的考勤地址
            ComAttendAddress address = new ComAttendAddress();
            address.setComId(dto.getComId());
            address.setAttendGroupId(dto.getAttendGroupId());
            List<Map<String, Object>> addressList = comAttendAddressMapper.getAttendGroupAddress(address);
            if (addressList.size() >= 1) {
                resultMap.put("addressRange", addressList.get(0).get("addressRange"));
            } else {
                resultMap.put("addressRange", null);
            }
            resultMap.put("comAttendAddressJson", JSON.toJSON(addressList).toString());
        }
        resultMap.put("midAttendGroupId",
                dto.getMidAttendGroupId() == null ? dto.getMidAttendGroupId() : dto.getMidAttendGroupId().toString());
        resultMap.put("attendGroupId",
                dto.getAttendGroupId() == null ? dto.getAttendGroupId() : dto.getAttendGroupId().toString());

        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 进入考勤设置第三步页面
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-30
     */
    @Override
    public Result inThirdStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {

        if (dto.getMidAttendGroupId() == null || dto.getMidAttendGroupId().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组中间表ID不能为空");
        }

        /********* 第三步不存在暂存概念 *********/

        Map<String, Object> resultMap = new HashMap<>();

        if (dto.getAttendGroupId() != null) {
            // 查询正式的考勤人员和考勤负责人
            List<Map<String, Object>> perList = comAttendPerMapper.getAttendPerList(dto.getCreateTime(),
                    dto.getAttendGroupId()); // 获取考勤人员列表
            List<Map<String, Object>> chargePerList = comAttendResponsPerMapper
                    .getAttendResponsPerList(dto.getAttendGroupId());// 获取考勤负责人员
            resultMap.put("perList", JSON.toJSON(perList));
            resultMap.put("chargePerList", JSON.toJSON(chargePerList));
        }
        resultMap.put("midAttendGroupId", dto.getMidAttendGroupId().toString());
        resultMap.put("attendGroupId",
                dto.getAttendGroupId() == null ? dto.getAttendGroupId() : dto.getAttendGroupId().toString());
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 考勤设置暂存第一步 (设置考勤类型和工作安排)
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-27
     */
    @Override
    public Result saveFirstStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {

        if (dto.getAttendGroupName() == null || dto.getAttendGroupName() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组名称不能为空");
        }
        if (dto.getAttendType() == null || dto.getAttendType() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤类型不能为空");
        }
        if (dto.getComAttendGroupFixeds() == null || dto.getComAttendGroupFixeds().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "工作安排不能为空");
        }

        // 校验公司是否已经存在同名的考勤组

        int attendGroupCount = comAttendGroupMapper.getExistsSameAttendGroupNameCount(dto);
        if (attendGroupCount > 0) {
            throw new BusinessException(Result.BUSINESS_ERROR, "已存在同名的考勤组，请设置其他名称");
        }
        // 把工作安排json串转成
        Map<String, Object> map = new HashMap();
        map.put("attendGroupName", dto.getAttendGroupName());
        map.put("attendType", dto.getAttendType());
        map.put("isFollowLegalHoliday", dto.getIsFollowLegalHoliday());
        map.put("comAttendGroupFixeds", dto.getComAttendGroupFixeds());
        String shiftIds = "";
        String shiftDetails = "";
        List<String> shiftIdList = new ArrayList<>();
        List<String> shiftDetailList = new ArrayList<>();
        List<ComAttendGroupFixedDTO> attendGroupFixedList = JSON.parseArray(dto.getComAttendGroupFixeds(),
                ComAttendGroupFixedDTO.class);
        for (ComAttendGroupFixedDTO fixedDto : attendGroupFixedList) {
            if (fixedDto.getShiftId() != null && !shiftIdList.contains(fixedDto.getShiftId().toString())) { // 去除重复shiftId
                shiftIdList.add(fixedDto.getShiftId().toString());
                shiftDetailList.add(fixedDto.getDetail());
            }
        }
        for (String shiftId : shiftIdList) {
            shiftIds = shiftIds + shiftId + ",";
        }
        for (String shiftDetail : shiftDetailList) {
            shiftDetails = shiftDetails + shiftDetail + "<br/>";
        }
        map.put("shiftIds", shiftIds.substring(0, shiftIds.length() - 1)); // 此考勤组所选的班次ID集合
        map.put("shiftDetails", shiftDetails.substring(0, shiftDetails.length() - 5)); // 此考勤组所选的班次详情

        String content = JSON.toJSON(map).toString();

        Long midAttendGroupIdId;
        // 第二步或者第三步返回到第一步修改
        if (dto.getMidAttendGroupId() != null && dto.getMidAttendGroupId().toString() != "") {
            midAttendGroupIdId = dto.getMidAttendGroupId();
            MidAttendGroupDetail detail = new MidAttendGroupDetail();
            detail.setStage(1);
            detail.setContent(content);
            detail.setMidAttendGroupId(midAttendGroupIdId);
            int detailCount = midAttendGroupDetailMapper.updateMidAttendGroupDetail(detail);
            if (detailCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "更新考勤组中间表明细失败");
            }
        } else { // 如果是第一步新增
            midAttendGroupIdId = idWorker.nextId();

            /********* 考勤组中间表 *********/
            MidAttendGroup midAttendGroup = new MidAttendGroup();
            midAttendGroup.setMidAttendGroupId(midAttendGroupIdId);
            midAttendGroup.setCreateTime(dto.getCreateTime());
            midAttendGroup.setCreateBy(dto.getCreateBy());
            midAttendGroup.setComId(dto.getComId());
            midAttendGroup.setPerId(dto.getCreateBy());
            // 做这步是怕经办人员做完第一步后面又不做导致脏数据很多，通过判断中间标存在考勤组ID用定时器清理
            midAttendGroup.setAttendGroupId(dto.getAttendGroupId());
            int midAttendGroupCount = midAttendGroupMapper.insertMidAttendGroup(midAttendGroup);
            if (midAttendGroupCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤组中间表失败");
            }
            /********* 考勤组中间表明细 *********/
            MidAttendGroupDetail detail = new MidAttendGroupDetail();
            detail.setMidAttendDetailId(idWorker.nextId());
            detail.setCreateTime(dto.getCreateTime());
            detail.setCreateBy(dto.getCreateBy());
            detail.setComId(dto.getComId());
            detail.setStage(1);
            detail.setContent(content);
            detail.setMidAttendGroupId(midAttendGroupIdId);

            int detailCount = midAttendGroupDetailMapper.insertMidAttendlGroupDetai(detail);
            if (detailCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤组中间表明细失败");
            }
        }
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("midAttendGroupId", midAttendGroupIdId.toString());
        resultMap.put("attendGroupId",
                dto.getAttendGroupId() == null ? dto.getAttendGroupId() : dto.getAttendGroupId().toString());
        return Result.success("", resultMap);
    }

    /**
     * 考勤设置暂存第二步 (设置考勤方式)
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-28
     */
    @Override
    public Result saveSecondStepAttendGroup(ComAttendAddressDTO dto) throws BusinessException {

        if (dto.getMidAttendGroupId() == null || dto.getMidAttendGroupId().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组中间表ID不能为空");
        }
        if (StringUtils.isEmpty(dto.getComAttendAddressJson())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤地址不能为空");
        }

        if (dto.getAddressRange() == null || dto.getAddressRange().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤范围不能为空");
        }

        MidAttendGroup midAttendGroup = midAttendGroupMapper.getByPrimaryKey(dto.getMidAttendGroupId());
        if (midAttendGroup == null) {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组中间表ID无效");
        }

        Map<String, Object> map = new HashMap();
        map.put("addressRange", dto.getAddressRange());
        map.put("comAttendAddressJson", dto.getComAttendAddressJson());
        String content = JSON.toJSON(map).toString();

        /******* 给对象赋值 ******/
        MidAttendGroupDetail detail = new MidAttendGroupDetail();
        detail.setComId(dto.getComId());
        detail.setStage(2);
        detail.setContent(content);
        detail.setMidAttendGroupId(dto.getMidAttendGroupId());
        MidAttendGroupDetail detailOld = midAttendGroupDetailMapper.getDetailByStep(detail);
        if (detailOld != null) { // 如果存在则更新
            detail.setMidAttendDetailId(detailOld.getMidAttendDetailId());
            detail.setUpdateTime(dto.getUpdateTime());
            detail.setUpdateBy(dto.getUpdateBy());
            int updateDetailCount = midAttendGroupDetailMapper.updateMidAttendGroupDetail(detail);
            if (updateDetailCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "设置考勤方式失败");
            }
        } else { // 如果不存在则插入
            detail.setMidAttendDetailId(idWorker.nextId());
            detail.setCreateTime(dto.getCreateTime());
            detail.setCreateBy(dto.getCreateBy());
            int insertDetailCount = midAttendGroupDetailMapper.insertMidAttendlGroupDetai(detail);
            if (insertDetailCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "设置考勤方式失败");
            }
        }
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("midAttendGroupId", dto.getMidAttendGroupId().toString());
        resultMap.put("attendGroupId",
                dto.getAttendGroupId() == null ? dto.getAttendGroupId() : dto.getAttendGroupId().toString());
        return Result.success("", resultMap);
    }

    /**
     * 校验考勤组人员
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-29
     */
    @Override
    @Transactional
    public Result checkAttendPer(ComAttendGroupDTO dto) throws BusinessException {

        if (dto.getMidAttendGroupId() == null || dto.getMidAttendGroupId().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤中间表ID不能为空");
        }
        MidAttendGroup midAttendGroup = midAttendGroupMapper.getByPrimaryKey(dto.getMidAttendGroupId());
        if (midAttendGroup == null) {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组中间表ID无效");
        }

        /***** 考勤组考勤人员 ****/
        List<Map<String, Object>> validatePerList = new ArrayList<>();
        if (!StringUtils.isNotEmpty(dto.getPerIdStr())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "请选择考勤人员");
        } else {
            String[] perIdStrArray = dto.getPerIdStr().split(",");
            for (String perId : perIdStrArray) {
                Map<String, Object> map = new HashMap();
                map.put("perId", perId);
                map.put("midAttendGroupId", dto.getMidAttendGroupId());
                validatePerList.add(map);
            }
        }
        // 插入之前先删除考勤人员校验表

        comAttendPerMapper.deleteValidateAttendPer(dto.getMidAttendGroupId()); // 删除考勤人员校验表

        int c = comAttendPerMapper.insertValidateAttendPer(validatePerList); // 插入考勤人员校验表
        if (c == 0) {
            throw new BusinessException(Result.BUSINESS_ERROR, "校验考勤组人员失败");
        }

        Map<String, Object> paramMap = new HashMap();
        paramMap.put("midAttendGroupId", dto.getMidAttendGroupId());
        ;
        paramMap.put("comId", dto.getComId());
        paramMap.put("createTime", dto.getCreateTime());
        paramMap.put("oldAttendGroupId", dto.getAttendGroupId()); // 修改情况无需校验本身考勤组人员

        comAttendPerMapper.validateAttendPer(paramMap); // 校验考勤组人员

        if (dto.getAttendGroupId() != null) {
            comAttendPerMapper.validateThisAttendPer(paramMap); // 校验考勤组人员是否已经存在本考勤组明日生效
        }

        paramMap.put("validateFlag", CommonConst.N); // 查询出已经存在其他考勤组的人员
        List<Map<String, String>> existsPerList = comAttendPerMapper.getExistsAttendPerList(paramMap);

        if (existsPerList.size() > 0) {
            return Result.success("", JSON.toJSON(existsPerList).toString());
        } else {
            return Result.success("");
        }

    }

    /**
     * 考勤设置第三步 (设置考勤人员，正式保存)
     *
     * @param dto
     * @return
     * @author llc
     * @since 2018-03-29
     */
    @Override
    public Result saveThirdStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {

        if (dto.getMidAttendGroupId() == null || dto.getMidAttendGroupId().toString() == "") {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤中间表ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getIsAdjust())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "是否调整考勤组人员参数不能为空");
        }

        if (StringUtil.isEmpty(dto.getEffectRule())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "生效规则参数不能为空");
        }

        /***** 考勤组负责人 ****/
        List<String> chargePerIdList = new ArrayList();
        if (!StringUtils.isNotEmpty(dto.getChargePerIdStr())) {
            throw new BusinessException(Result.BUSINESS_ERROR, "请选择考勤组负责人员");
        } else {
            String[] chargePerIdStrArray = dto.getChargePerIdStr().split(",");
            if (chargePerIdStrArray.length > 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "考勤组负责人不能超过1人");
            }
            for (String chargePerId : chargePerIdStrArray) {
                chargePerIdList.add(chargePerId);
            }
        }
        List<MidAttendGroupDetail> detailsList = midAttendGroupDetailMapper.getDetailList(dto.getMidAttendGroupId());

        if (detailsList.size() != 2) {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤组前两步暂存数据出错");
        }
        /**************** 取出前两步暂存的数据 *******************/
        MidAttendGroupDetail detailStepOne = detailsList.get(0);

        MidAttendGroupDetail detailStepTwo = detailsList.get(1);

        /************* 转换json *************/
        JSONObject jsonBackOne = JSONObject.parseObject(detailStepOne.getContent());
        Map<String, String> detailStepOneMap = new HashMap<>();
        for (String key : jsonBackOne.keySet()) {
            if (jsonBackOne.get(key) != null) {
                String value = (String) jsonBackOne.get(key);
                detailStepOneMap.put(key, value);
            }
        }
        JSONObject jsonBackTwo = JSONObject.parseObject(detailStepTwo.getContent());
        Map<String, String> detailStepTwoMap = new HashMap<>();
        detailStepTwoMap.put("addressRange", jsonBackTwo.get("addressRange").toString());
        detailStepTwoMap.put("comAttendAddressJson", jsonBackTwo.get("comAttendAddressJson").toString());

        Date effectStartTime; // 生效时间

        if (dto.getEffectRule().equals(DictConst.EFFECTRULE_JRSX)) { // 及时生效(改成今日生效)
//            effectStartTime = dto.getCreateTime();
            effectStartTime = new Date(
                    System.currentTimeMillis() / 86400000 * 86400000 - (23 - Calendar.ZONE_OFFSET) * 3600000);
        } else { // 明日生效 取生效时间为第二天的 00:00:00
            Date date = new Date(
                    System.currentTimeMillis() / 86400000 * 86400000 - (23 - Calendar.ZONE_OFFSET) * 3600000);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(Calendar.DAY_OF_MONTH, 1);
            effectStartTime = c.getTime();
        }

        /************* 如果修改考勤组，处理旧的考勤组 *********/
        if (dto.getAttendGroupId() != null && !dto.getMidAttendGroupId().equals(dto.getAttendGroupId())) {

            /*** 更新考勤组信息 ***/
            ComAttendGroup comAttendGroup = new ComAttendGroup();
            comAttendGroup.setAttendGroupId(dto.getAttendGroupId());
            comAttendGroup.setUpdateTime(dto.getCreateTime());
            comAttendGroup.setUpdateBy(dto.getCreateBy());
            comAttendGroup.setAttendGroupName(detailStepOneMap.get("attendGroupName"));
            comAttendGroup.setEffectRule(dto.getEffectRule());
            comAttendGroup.setAttendType(detailStepOneMap.get("attendType"));
            comAttendGroup.setIsFollowLegalHoliday(detailStepOneMap.get("isFollowLegalHoliday"));
            comAttendGroup.setShiftIds(detailStepOneMap.get("shiftIds"));
            comAttendGroup.setShiftDetails(detailStepOneMap.get("shiftDetails"));
            comAttendGroup.setComId(dto.getComId());
            comAttendGroupMapper.updateAttendGroup(comAttendGroup);

            /*** 目前固定排班不支持变更考勤规则 ***/

//            /*** 判断考勤组设定的排版规则是否有变化，有变化则处理 ***/
//            List<ComAttendGroupFixed> comAttendGroupFixedList = JSON.parseArray(detailStepOneMap.get("comAttendGroupFixeds"), ComAttendGroupFixed.class);
//
//            List<ComAttendGroupFixed> oldComAttendGroupFixedList = comAttendGroupFixedMapper.getComAttendGroupFixedList(dto.getAttendGroupId(),dto.getCreateTime());
//
//            for (ComAttendGroupFixed comAttendGroupFixed : comAttendGroupFixedList) {
//                for (ComAttendGroupFixed oldComAttendGroupFixed : oldComAttendGroupFixedList) {
//
//                    /** 如果设置的规则都一样 **/
//                    if (oldComAttendGroupFixed.getWeekDay() == comAttendGroupFixed.getWeekDay()) {
//                        if (oldComAttendGroupFixed.getIsRest().equalsIgnoreCase(comAttendGroupFixed.getIsRest())
//                                && ((oldComAttendGroupFixed.getShiftId() == null && comAttendGroupFixed.getShiftId() == null)
//                                    || (oldComAttendGroupFixed.getShiftId() != null && comAttendGroupFixed.getShiftId() != null &&
//                                        oldComAttendGroupFixed.getShiftId().equals(comAttendGroupFixed.getShiftId())))) {
//                        } else {
//                            /*** 设置新的考勤组规则 ***/
//                            comAttendGroupFixed.setAttendGroupFixedId(idWorker.nextId());
//                            comAttendGroupFixed.setCreateTime(dto.getCreateTime());
//                            comAttendGroupFixed.setCreateBy(dto.getCreateBy());
//                            comAttendGroupFixed.setComId(dto.getComId());
//                            comAttendGroupFixed.setAttendGroupId(dto.getAttendGroupId());
//                            comAttendGroupFixed.setEffectStartTime(effectStartTime);
//                            /*** 设置旧的考勤组规则 ***/
//                            oldComAttendGroupFixed.setEffectEndTime(effectStartTime);
//                        }
//                        break;
//                    }
//                }
//            }
//           /*** 插入新的考勤规则 ***/
//            List<ComAttendGroupFixed> newComAttendGroupFixedList = new ArrayList<ComAttendGroupFixed>();
//            for(ComAttendGroupFixed comAttendGroupFixed : comAttendGroupFixedList){
//                if(comAttendGroupFixed.getEffectStartTime() != null){
//                    newComAttendGroupFixedList.add(comAttendGroupFixed);
//                }
//            }
//            if(newComAttendGroupFixedList.size() >0 ) {
//                comAttendGroupFixedMapper.insertComAttendGroupFixed(newComAttendGroupFixedList);
//            }
//
//           /*** 更新旧的考勤规则为失效 ***/
//
//            List<ComAttendGroupFixed> invalidAttendGroupFixedList = new ArrayList<ComAttendGroupFixed>();
//            for(ComAttendGroupFixed comAttendGroupFixed : oldComAttendGroupFixedList){
//                if(comAttendGroupFixed.getEffectEndTime() != null){
//                    invalidAttendGroupFixedList.add(comAttendGroupFixed);
//                }
//            }
//            if(invalidAttendGroupFixedList.size()>0) {
//                comAttendGroupFixedMapper.invalidComAttendGroupFixed(invalidAttendGroupFixedList, dto.getUpdateBy(), effectStartTime);
//            }


            /************* 企业考勤地址 ***************/

            /************* 1.删除旧的考勤地址 ***************/

            ComAttendAddress address = new ComAttendAddress();
            address.setAttendGroupId(dto.getAttendGroupId());
            address.setUpdateBy(dto.getCreateBy());
            address.setUpdateTime(dto.getCreateTime());
            comAttendAddressMapper.deleteBeforeAddress(address);

            /************* 2.插入新的考勤地址 ***************/

            List<ComAttendAddress> attendAddressList = new ArrayList<>();
            List<ComAttendAddress> addressList = JSON.parseArray(detailStepTwoMap.get("comAttendAddressJson"),
                    ComAttendAddress.class);
            for (ComAttendAddress attendAddress : addressList) {
                attendAddress.setAttendAddressId(idWorker.nextId());
                attendAddress.setCreateTime(dto.getCreateTime());
                attendAddress.setCreateBy(dto.getCreateBy());
                attendAddress.setComId(dto.getComId());
                attendAddress.setAddressRange(Long.parseLong(detailStepTwoMap.get("addressRange")));
                attendAddress.setAttendGroupId(dto.getAttendGroupId());
                attendAddressList.add(attendAddress);
            }
            if (comAttendAddressMapper.insertAttendGroupAddress(attendAddressList) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤地址失败");
            }

            /************* 企业考勤组负责人员 ***************/

            /************* 1.删除旧的考勤组负责人员 ***************/
            comAttendResponsPerMapper.deleteByAttendGroupId(dto.getAttendGroupId());

            /************* 2.插入新的考勤组负责人员 ***************/
            List<ComAttendResponsPer> comAttendResponsPerList = new ArrayList<>();
            for (String perId : chargePerIdList) {
                ComAttendResponsPer comAttendResponsPer = new ComAttendResponsPer();
                comAttendResponsPer.setCreateTime(dto.getCreateTime());
                comAttendResponsPer.setCreateBy(dto.getCreateBy());
                comAttendResponsPer.setComId(dto.getComId());
                comAttendResponsPer.setAttendGroupId(dto.getAttendGroupId());
                comAttendResponsPer.setPerId(Long.parseLong(perId));
                comAttendResponsPerList.add(comAttendResponsPer);
            }
            if (comAttendResponsPerMapper.insertComAttendResponsPer(comAttendResponsPerList) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤组负责人员失败");
            }


            /************* 企业考勤组考勤人员 ***************/

            /***** 修改考勤组的人员需要考虑几种情况
             1.本次减少的考勤人员做失效处理
             2.本次新增的考勤人员做插入处理
             2.1 本次新增的人员存在其他考勤组且调整到本考勤组
             2.2 如果本次新增的人员存在其他考勤组且保留在原考勤组 *****/


            /*************  1.本次减少的考勤人员做失效处理 ***************/
            Map<String, Object> map = new HashMap();
            map.put("attendGroupId", dto.getAttendGroupId());
            map.put("comId", dto.getComId());
            map.put("effectStartTime", effectStartTime);
            map.put("updateTime", dto.getUpdateTime());
            map.put("updateBy", dto.getUpdateBy());
            map.put("midAttendGroupId", dto.getMidAttendGroupId());

            comAttendPerMapper.updateOldAttendLessPer(map);

            /*************  2.本次新增的考勤人员做插入处理 ***************/

            List<Map<String, String>> addAttendPerIdList = comAttendPerMapper.getAddAttendPerList(dto.getAttendGroupId(), dto.getMidAttendGroupId(), dto.getUpdateTime());
            List<ComAttendPer> addAttendPerList = new ArrayList<>();
            if (addAttendPerIdList.size() > 0) {

                /*** 2.1 如果本次新增的人员存在其他考勤组且调整到本考勤组 ***/
                if (dto.getIsAdjust().equalsIgnoreCase(CommonConst.Y)) {

                    comAttendPerMapper.updateAttendPer(map); // 处理其他考勤组移出的人员变成失效

                    /*** 如果人员即时调整了考勤组，且当天在旧的考勤组有打卡记录,清除当天的打卡记录 ***/
                    if (dto.getEffectRule().equals(DictConst.EFFECTRULE_JRSX)) { // 及时生效
                        List<Long> perIdList = comAttendPerMapper.getCheckFailAttendPerList(dto.getMidAttendGroupId());
                        /*** 删除打卡记录 ***/
                        if (perIdList.size() > 0) {
                            comAttendPerMapper.deleteAttendCardRecord(perIdList, DateUtils.formatDate(effectStartTime), dto.getComId());
                        }
                    }

                    for (Map<String, String> perMap : addAttendPerIdList) {
                        ComAttendPer comAttendPer = new ComAttendPer();
                        comAttendPer.setComAttendPerId(idWorker.nextId());
                        comAttendPer.setCreateTime(dto.getCreateTime());
                        comAttendPer.setCreateBy(dto.getCreateBy());
                        comAttendPer.setComId(dto.getComId());
                        comAttendPer.setAttendGroupId(dto.getAttendGroupId());
                        comAttendPer.setPerId(Long.parseLong(perMap.get("perId")));
                        comAttendPer.setEffectStartTime(effectStartTime);
                        addAttendPerList.add(comAttendPer);
                    }

                } else {
                    for (Map<String, String> perMap : addAttendPerIdList) {
                        /*** 2.2 如果本次新增的人员存在其他考勤组且保留在原考勤组 ***/
                        if (perMap.get("validateFlag").equalsIgnoreCase(CommonConst.Y)) {
                            ComAttendPer comAttendPer = new ComAttendPer();
                            comAttendPer.setComAttendPerId(idWorker.nextId());
                            comAttendPer.setCreateTime(dto.getCreateTime());
                            comAttendPer.setCreateBy(dto.getCreateBy());
                            comAttendPer.setComId(dto.getComId());
                            comAttendPer.setAttendGroupId(dto.getAttendGroupId());
                            comAttendPer.setPerId(Long.parseLong(perMap.get("perId")));
                            comAttendPer.setEffectStartTime(effectStartTime);
                            addAttendPerList.add(comAttendPer);
                        }
                    }
                }

                if (addAttendPerList.size() > 0) {
                    int insertAttendPerCount = comAttendPerMapper.insertAttendPer(addAttendPerList);
                    if (insertAttendPerCount != addAttendPerList.size()) {
                        throw new BusinessException(Result.BUSINESS_ERROR, "设置考勤人员失败");
                    }
                }
            }

        } else {  /**** 新增的考勤组  ****/

            Long attendGroupId = dto.getMidAttendGroupId(); // 取考群组中间表ID作为考勤组ID

            /************* 企业考勤组 ***************/
            ComAttendGroup comAttendGroup = new ComAttendGroup();
            comAttendGroup.setAttendGroupId(attendGroupId);
            comAttendGroup.setCreateTime(dto.getCreateTime());
            comAttendGroup.setCreateBy(dto.getCreateBy());
            comAttendGroup.setAttendGroupName(detailStepOneMap.get("attendGroupName"));
            comAttendGroup.setEffectRule(dto.getEffectRule());

            comAttendGroup.setAttendType(detailStepOneMap.get("attendType"));
            comAttendGroup.setIsFollowLegalHoliday(detailStepOneMap.get("isFollowLegalHoliday"));
            comAttendGroup.setShiftIds(detailStepOneMap.get("shiftIds"));
            comAttendGroup.setShiftDetails(detailStepOneMap.get("shiftDetails"));
            comAttendGroup.setComId(dto.getComId());
            int addAttendGroupCount = comAttendGroupMapper.addAttendGroup(comAttendGroup);
            if (addAttendGroupCount != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤组失败");
            }
            /************* 企业考勤地址 ***************/
            List<ComAttendAddress> attendAddressList = new ArrayList<>();
            List<ComAttendAddress> addressList = JSON.parseArray(detailStepTwoMap.get("comAttendAddressJson"),
                    ComAttendAddress.class);
            for (ComAttendAddress attendAddress : addressList) {
                attendAddress.setAttendAddressId(idWorker.nextId());
                attendAddress.setCreateTime(dto.getCreateTime());
                attendAddress.setCreateBy(dto.getCreateBy());
                attendAddress.setComId(dto.getComId());
                attendAddress.setAddressRange(Long.parseLong(detailStepTwoMap.get("addressRange")));
                attendAddress.setAttendGroupId(attendGroupId);
                attendAddressList.add(attendAddress);
            }
            if (comAttendAddressMapper.insertAttendGroupAddress(attendAddressList) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤地址失败");
            }

            /************* 企业考勤组固定班制明细 ***************/

            List<ComAttendGroupFixed> attendGroupFixedList = new ArrayList<>();
            List<ComAttendGroupFixed> comAttendGroupFixedList = JSON
                    .parseArray(detailStepOneMap.get("comAttendGroupFixeds"), ComAttendGroupFixed.class);
            for (ComAttendGroupFixed attendGroupFixed : comAttendGroupFixedList) {
                attendGroupFixed.setAttendGroupFixedId(idWorker.nextId());
                attendGroupFixed.setCreateTime(dto.getCreateTime());
                attendGroupFixed.setCreateBy(dto.getCreateBy());
                attendGroupFixed.setComId(dto.getComId());
                attendGroupFixed.setAttendGroupId(attendGroupId);
                attendGroupFixedList.add(attendGroupFixed);
            }
            if (comAttendGroupFixedMapper.insertComAttendGroupFixed(attendGroupFixedList) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增固定排班失败");
            }

            /*** 考勤打卡提醒 ***/

            if (StringUtils.isNotEmpty(comAttendGroup.getShiftIds())) {
                List<String> shiftIdList = Arrays.asList(comAttendGroup.getShiftIds().split(","));
                List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getshiftRuleList(dto.getComId(), shiftIdList);
                List<AttendCardRemind> attendCardRemindList = new ArrayList<>();

                for (ComAttendGroupFixed attendGroupFixed : comAttendGroupFixedList) {

                    /*** 休息不提醒 ***/
                    if (attendGroupFixed.getShiftId() == null) {
                        continue;
                    }

                    for (ComShiftRule comShiftRule : shiftRuleList) {
                        if (comShiftRule.getShiftId().equals(attendGroupFixed.getShiftId())) {
                            AttendCardRemind attendCardRemind = new AttendCardRemind();
                            attendCardRemind.setAttendCardRemindId(idWorker.nextId());
                            attendCardRemind.setComId(dto.getComId());
                            attendCardRemind.setCreateBy(dto.getCreateBy());
                            attendCardRemind.setCreateTime(dto.getCreateTime());
                            attendCardRemind.setAttendGroupId(comAttendGroup.getAttendGroupId());
                            attendCardRemind.setWeekDay(attendGroupFixed.getWeekDay());
                            attendCardRemind.setAttendTime(comShiftRule.getStartWorkTime());
                            attendCardRemind.setRemindTime(DateUtil.offsetMinute(comShiftRule.getStartWorkTime(), -5)); // 提醒时间推前5分钟
                            attendCardRemind.setStartDate(DateUtils.parseDate(DateUtils.formatDate(dto.getCreateTime(), "yyyy-MM-dd")));
                            attendCardRemindList.add(attendCardRemind);
                        }
                    }
                }

                if(attendCardRemindList.size()>0){
                    attendCardRemindMapper.batchInsertAttendCardRemind(attendCardRemindList);
                }

            }


            /************* 企业考勤组负责人员 ***************/
            List<ComAttendResponsPer> comAttendResponsPerList = new ArrayList<>();
            for (String perId : chargePerIdList) {
                ComAttendResponsPer comAttendResponsPer = new ComAttendResponsPer();
                comAttendResponsPer.setCreateTime(dto.getCreateTime());
                comAttendResponsPer.setCreateBy(dto.getCreateBy());
                comAttendResponsPer.setComId(dto.getComId());
                comAttendResponsPer.setAttendGroupId(attendGroupId);
                comAttendResponsPer.setPerId(Long.parseLong(perId));
                comAttendResponsPerList.add(comAttendResponsPer);
            }
            if (comAttendResponsPerMapper.insertComAttendResponsPer(comAttendResponsPerList) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤组负责人员失败");
            }

            /************* 企业考勤组考勤人员 ***************/

            List<Map<String, String>> attendPerList = new ArrayList<>();

            Map<String, Object> paramMap = new HashMap();
            paramMap.put("midAttendGroupId", dto.getMidAttendGroupId());
            ;
            paramMap.put("comId", dto.getComId());
            if (dto.getIsAdjust().equalsIgnoreCase(CommonConst.Y)) { // 调整考勤组人员
                attendPerList = comAttendPerMapper.getValAttendPerList(paramMap); // 查询出本次所有考勤人员

                paramMap.put("effectStartTime", effectStartTime);
                paramMap.put("updateBy", dto.getCreateBy());
                paramMap.put("updateTime", dto.getUpdateTime());

                comAttendPerMapper.updateAttendPer(paramMap); // 处理其他考勤组移出的人员

                /*** 如果人员即时调整了考勤组，且当天在旧的考勤组有打卡记录,清除当天的打卡记录 ***/
                if (dto.getEffectRule().equals(DictConst.EFFECTRULE_JRSX)) { // 及时生效
                    List<Long> perIdList = comAttendPerMapper.getCheckFailAttendPerList(dto.getMidAttendGroupId());
                    /*** 删除打卡记录 ***/
                    if (perIdList.size() > 0) {
                        comAttendPerMapper.deleteAttendCardRecord(perIdList, DateUtils.formatDate(effectStartTime), dto.getComId());
                    }
                }

            } else { // 保留在之前考勤组
                paramMap.put("validateFlag", CommonConst.Y); // 查询出此次设置不在其他考勤组的人员
                attendPerList = comAttendPerMapper.getValAttendPerList(paramMap);
            }
            List<ComAttendPer> comAttendPerList = new ArrayList<ComAttendPer>();
            for (Map<String, String> map : attendPerList) {
                ComAttendPer comAttendPer = new ComAttendPer();
                comAttendPer.setComAttendPerId(idWorker.nextId());
                comAttendPer.setCreateTime(dto.getCreateTime());
                comAttendPer.setCreateBy(dto.getCreateBy());
                comAttendPer.setComId(dto.getComId());
                comAttendPer.setAttendGroupId(attendGroupId);
                comAttendPer.setPerId(Long.parseLong(map.get("perId")));
                comAttendPer.setEffectStartTime(effectStartTime);
                comAttendPerList.add(comAttendPer);
            }

            if (comAttendPerList.size() >= 1) {
                int insertAttendPerCount = comAttendPerMapper.insertAttendPer(comAttendPerList);
                if (insertAttendPerCount != comAttendPerList.size()) {
                    throw new BusinessException(Result.BUSINESS_ERROR, "设置考勤人员失败");
                }
            }
        }

        /*************** 删除考勤组中间表、考勤组人员校验表 ******************/

        deleteMidAttendGroup(dto.getMidAttendGroupId());
        return Result.success("保存成功");
    }

    /**
     * 删除考勤组中间表、考勤组人员校验表
     *
     * @param midAttendGroupId
     * @return
     * @author llc
     * @since 2018-03-29
     */
    private void deleteMidAttendGroup(Long midAttendGroupId) {

        midAttendGroupDetailMapper.deleteMidAttendGroupDetail(midAttendGroupId);

        comAttendPerMapper.deleteValidateAttendPer(midAttendGroupId);

        midAttendGroupMapper.deleteMidAttendGroup(midAttendGroupId);
    }

    /**
     * 定时器删除正式考勤组修改的考勤组中间表、考勤组人员校验表（最后一步未提交）
     *
     * @param
     * @return
     * @author llc
     * @since 2018-04-02
     */
    @Override
    public Result deleteMidAttendByTask() {

        midAttendGroupDetailMapper.deleteMidAttendGroupDetailBytask();

        comAttendPerMapper.deleteValidateAttendPerBytask();

        midAttendGroupMapper.deleteMidAttendGroupBytask();

        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    @Override
    public Result delete(ComAttendGroupDTO dto) throws BusinessException {
        Long attendGroupId = dto.getAttendGroupId();
        if (dto.getIsFormal() == null || dto.getIsFormal() == "") { // 校验是否是正式考勤组
            throw new BusinessException(Result.BUSINESS_ERROR, "是否正式考勤组标志必须录入");
        }
        if (dto.getIsFormal().equalsIgnoreCase(CommonConst.N)) { // 暂存考勤组
            // 在查询列表返回的时候把考勤组中间表ID赋值给attendGroupId
            if (midAttendGroupDetailMapper.deleteMidAttendGroupDetail(attendGroupId) == 0) {
                throw new BusinessException(Result.BUSINESS_ERROR, "删除考勤组失败");
            }
            if (midAttendGroupMapper.deleteMidAttendGroup(attendGroupId) != 1) {
                throw new BusinessException(Result.BUSINESS_ERROR, "删除考勤组失败");
            }
        } else { // 正式考勤组

            /*** 删除考勤组前需判断是否存在人员 ***/

            List<Long> perIdList = comAttendPerMapper.getAttendPerIdList(attendGroupId, dto.getUpdateTime());
            if (perIdList != null && perIdList.size()>0) {

                /*** 删除考勤组人员当天的打卡记录 ***/
                comAttendPerMapper.deleteAttendCardRecord(perIdList, DateUtils.formatDate(dto.getUpdateTime()), dto.getComId());
            }

            /*** 删除考勤组人员 ***/
            comAttendPerMapper.deleteAttendGroupPerById(attendGroupId, dto.getUpdateBy(), dto.getUpdateTime());


            /*** 删除考勤组 ***/
            comAttendGroupMapper.deleteAttendGroupById(attendGroupId, dto.getUpdateBy(), dto.getUpdateTime());

            /*** 删除考勤提醒记录 ***/

            attendCardRemindMapper.delAttendCardRemind(attendGroupId);
        }
        return Result.success(Result.SUCCESS_MSG, "删除成功");
    }


    /**
     * 内勤打卡提醒定时器
     *
     * @return
     * @author llc
     * @date 2019-01-10
     */
    @Override
    public Result attendCardRemindJob() throws BusinessException {

        String currentDate = DateUtil.today();
        String currentTime = DateUtils.formatDate(new Date(), "HH:mm") + ":00";

        List<AttendCardRemindDTO> attendCardRemindList = attendCardRemindMapper.getAttendCardRemindList(currentDate, currentTime);
        if (CollectionUtil.isEmpty(attendCardRemindList)) {
            return Result.success(Result.SUCCESS_QUERY_MSG);
        }

        /*** 如果有需要提醒的人员，再去查询设置的人员 ***/
        List<Map<String, String>> perList = attendCardRemindMapper.getAttendCardRemindPerList(currentDate, currentTime, attendCardRemindList);
        for (AttendCardRemindDTO dto : attendCardRemindList) {
            Iterator<Map<String, String>> iter = perList.iterator();
            StringBuilder builder = new StringBuilder();
            while (iter.hasNext()) {
                Map<String, String> map = iter.next();
                if (map.get("attendGroupId").equals(dto.getAttendGroupId())) {
                    builder.append(map.get("perId")).append(",");
                    iter.remove();
                }
            }
            dto.setPerIdStr(builder.toString());
        }

        List<AttendCardRemindDTO> remindList = new ArrayList<>();
        /*** 排除没人的考勤组 ***/
        for (AttendCardRemindDTO dto : attendCardRemindList) {
            if (StringUtil.isEmpty(dto.getPerIdStr())) {
                continue;
            }
            remindList.add(dto);
        }
        /* 通知 */
        for (AttendCardRemindDTO dto : remindList) {
            String content = MsgConst.TYPE_030003_ATTEND_CLOCK_REMIND_CONTENT;
            content = content.replace("{clockTime}", dto.getAttendTime());
            commonService.sendMessageToApp(MsgConst.TYPE_030003_ATTEND_CLOCK_REMIND_TITLE, content,
                    DictMessageTypeConst.MESSAGETYPE_030003, dto.getPerIdStr(),
                    Long.parseLong(dto.getComId()), null);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

}