package com.bcxin.oa.old.service.attend;

import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.dto.ComAttendAddressDTO;
import com.bcxin.oa.old.entity.task.ComAttendAddress;
import com.bcxin.oa.old.entity.task.ComAttendGroup;
import com.bcxin.oa.old.mapper.ComAttendAddressMapper;
import com.bcxin.oa.old.mapper.ComAttendGroupMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 企业考勤地址
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
@Service
@Transactional
public class ComAttendAddressServiceImpl implements ComAttendAddressService {
	@Resource
	private ComAttendAddressMapper comAttendAddressMapper;

	@Resource
	private ComAttendGroupMapper comAttendGroupMapper;

	@Resource
	private IdWorker idWorker;

	/**
	 * 设置考勤方式（考勤地点）
	 *
	 * @param comAttendAddressDTO
	 * @return
	 */
	@Override
	public Result addAttendGroupAddress(ComAttendAddressDTO comAttendAddressDTO) throws BusinessException {

		if (StringUtils.isNotEmpty(comAttendAddressDTO.getComAttendAddressJson())) {

			List<ComAttendAddress> list = JSON.parseArray(comAttendAddressDTO.getComAttendAddressJson(),
					ComAttendAddress.class);

			if (list != null && list.size() > 0) {

				for (ComAttendAddress attendAddress : list) {
					// 添加考勤地点信息
					ComAttendAddress comAttendAddress = new ComAttendAddress();
					// 拷贝
					ObjectUtils.copyProperties(comAttendAddress, comAttendAddressDTO);
					comAttendAddress.setAttendAddressId(idWorker.nextId());
					comAttendAddress.setAddress(attendAddress.getAddress());
					comAttendAddress.setAddressLongitude(attendAddress.getAddressLongitude());
					comAttendAddress.setAddressLatitude(attendAddress.getAddressLatitude());

					int status = comAttendAddressMapper.addAttendGroupAddress(comAttendAddress);
					if (status <= 0) {
						throw new BusinessException(Result.BUSINESS_ERROR, "新增考勤地址失败，请重试");
					}
				}
			}
		} else {
			throw new BusinessException(Result.BUSINESS_ERROR, "考勤地址不能为空");
		}

		// 查询考勤组信息
		ComAttendGroup comAttendGroup = comAttendGroupMapper.getByPrimaryKey(comAttendAddressDTO.getAttendGroupId());
		// 今日生效
		if (DictConst.EFFECTRULE_JRSX.equals(comAttendAddressDTO.getEffectRule())) {
			comAttendGroup.setEffectStartTime(new Date());
		}
		// 明日生效
		if (DictConst.EFFECTRULE_MRSX.equals(comAttendAddressDTO.getEffectRule())) {
			Date date = new Date(
					System.currentTimeMillis() / 86400000 * 86400000 - (23 - Calendar.ZONE_OFFSET) * 3600000);
			Calendar c = Calendar.getInstance();
			c.setTime(date);
			c.add(Calendar.DAY_OF_MONTH, 1);
			comAttendGroup.setEffectStartTime(c.getTime());
		}
		comAttendGroupMapper.updateAttendGroup(comAttendGroup);

		// TODO
		// 业务日志
		/*
		 * BusinessLog businessLog = new BusinessLog();
		 * businessLog.setBusinessType("CA0005");
		 * businessLog.setCurrentApprovalLevel(0);
		 * businessLog.setPartyType(DictConst.PARTYTYPE_QY);
		 * businessLog.setPartyId(Long.parseLong("394804217337872384"));
		 * businessLog.setComId(comAttendAddressDTO.getComId());
		 * businessLog.setBusinessHandlStatus(DictConst.BUSINESSHANDLSTATUS_SHTG
		 * ); businessLog.setHandlePerId(1L);
		 * commonService.BunissLogDemo(businessLog);
		 */

		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * 修改考勤方式（考勤地点）
	 *
	 * @param dto
	 * @return
	 */
	@Override
	public Result updateAttendGroupAddress(ComAttendAddressDTO dto) throws BusinessException {

		// 删除以前的地址

		ComAttendAddress address =  new ComAttendAddress();
		address.setAttendGroupId(dto.getAttendGroupId());
		address.setUpdateBy(dto.getCreateBy());
		address.setUpdateTime(dto.getCreateTime());
		comAttendAddressMapper.deleteBeforeAddress(address);
		// 添加新的地址，更新考勤组信息
		return addAttendGroupAddress(dto);
	}

	/**
	 * 查看考勤方式（考勤地点）
	 *
	 * @param attendGroupId
	 * @return
	 */
	@Override
	public Result listAttendGroupAddress(Long attendGroupId) {

		if (attendGroupId == null || attendGroupId.toString() == "") {
			return Result.fail("attendGroupId不能为空");
		}

		List<ComAttendAddress> list = comAttendAddressMapper.listAttendGroupAddress(attendGroupId);

		return Result.success("", list);
	}
}