package com.bcxin.oa.old.mapper.task;


import com.bcxin.oa.old.entity.count.CountPerTaskDate;
import com.bcxin.oa.old.dto.ExportPerAttendMonthDTO;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.count.AppPerTaskCountResultDTO;
import com.bcxin.oa.old.dto.count.CountPerTaskDTO;
import com.bcxin.oa.old.dto.count.ExportPerTaskMonthDTO;
import com.bcxin.oa.old.dto.count.PerTaskDateDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员外勤日统计
 *
 * @author llc
 * @date 2019-01-15
 */
public interface CountPerTaskDateMapper extends CrudDao<CountPerTaskDate> {


    /**
     * 生成统计外勤数据
     * @author llc
     * @date 2019-01-15
     * @param paramMap
     * @return
     */
    Map<String, String> prc_createTaskCountReport(Map<String, Object> paramMap);


    /**
     * 获取人员外勤日统计情况
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    List<Map<String,Object>> getPerTaskDateCountList(CountPerTaskDTO dto) ;


    /**
     * 获取人员外勤月统计情况
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    List<ExportPerTaskMonthDTO> getPerTaskMonthCountList(CountPerTaskDTO dto) ;

    /**
     * 获得个人月统计数据
     * @param dto
     * @return
     */
    ExportPerAttendMonthDTO getPerTaskAttendMonthCount(ParamDTO dto);



    /**
     * 查询人员某日外勤打卡详情
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    List<Map<String,Object>> getTaskRecodeList(PerTaskDateDTO dto) ;


    /**
     * 插入管理员修改的打卡记录
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    int insertPerTaskRecord(PerTaskDateDTO dto) ;


    /**
     * 更新管理员修改的打卡记录
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    int updatePerTaskRecord(PerTaskDateDTO dto) ;


    /**
     * 查询修改后的人员每日打卡情况
     * @author llc
     * @date 2019-01-15
     * @param dto
     * @return
     */
    List<PerTaskDateDTO> getTaskRecodeAgain(PerTaskDateDTO dto) ;

    /**
     * 更新人员日外勤统计
     * @author llc
     * @date 2019-01-15
     * @param countPerTaskDate
     * @return
     */

    int updateCountPerTaskDate(CountPerTaskDate countPerTaskDate) ;


    /**
     * 查询外勤统计记录
     * @author llc
     * @date 2019-01-24
     * @param perId
     * @param comId
     * @return
     */
    AppPerTaskCountResultDTO getOutAttendCount(@Param("perId") Long perId, @Param("comId") Long comId, @Param("startDate")String startDate, @Param("endDate")String endDate) ;


    /**
     * 查询异常考勤信息
     * @author llc
     * @date 2019-01-04
     * @param perId
     * @param comId
     * @return
     */
    List<PerTaskDateDTO> getAbnormalAttendInfo(@Param("perId") Long perId,@Param("comId") Long comId,@Param("startDate")String startDate,@Param("endDate")String endDate) ;


    /**
     * 查询异常打卡记录
     * @author llc
     * @date 2019-01-04
     * @param perId
     * @param comId
     * @param list
     * @return
     */
    List<Map<String,String>> getAbnormalAttendRecord(@Param("perId") Long perId,@Param("comId") Long comId,@Param("list")List<PerTaskDateDTO> list) ;


    /**
     * 查询缺卡记录
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @param list
     * @return
     */
    List<Map<String,String>> getMissCardRecord(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate,
                                               @Param("list")List<PerTaskDateDTO> list) ;


    /**
     * 查询统计区间内的请假、加班情况
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @return
     */
    Map<String,Object> getLeaveAndOverTimeInfo(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate) ;


    /**
     * 查询统计区间内的外勤请假记录
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @return
     */
    List<Map<String,Object>> getTaskLeaveList(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate) ;


    /**
     * 获取外勤月度统计列表
     * @author llc
     * @date 2019-02-22
     * @param comTaskId
     * @param comId
     * @param month
     * @return
     */
    List<Map<String,String>> getTaskMonthStatisList(@Param("comTaskId") Long comTaskId,
                                                    @Param("comId") Long comId,
                                                    @Param("month")String month) ;


    /**
     * 获取某天任务出勤人员
     * @author llc
     * @date 2019-02-25
     * @param comTaskId
     * @param comId
     * @param date
     * @return
     */
    List<Map<String,String>> getTaskAttendPerDate(@Param("comTaskId") Long comTaskId,
                                                  @Param("comId") Long comId,
                                                  @Param("date")String date) ;

}