package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.system.ComSocialInsSchemeDetail;
import com.bcxin.oa.old.entity.system.PerSocialInsPayDetail;
import com.bcxin.oa.old.entity.system.PerSocialInsSchemeRela;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/23
 * @Description: 
 * @Modified By: 
 */
@Component
public interface MedicalSocialRecMapper {

    /**
     * 根据日期或者企业id去判断是否生成了数据
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/27 16:39
     */
    List<Map> getRecByPeriod(@Param("comId") Long comId, @Param("payPeriod") String payPeriod);

    /**
     * 根据企业ID进行后台计算，得到计算后的数据，缺少主键ID和payPeriod
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/27 14:37
     */
    List<PerSocialInsPayDetail> getHisPerRecByComId(@Param("comId")Long comId, @Param("payPeriod") String payPeriod);

    /**
     * 获得医社保缴费记录查询
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 16:32
     */
    List<Map<String, Object>> getHisRecListPage(Map dto);


    /**
     * 人员选择列表分页，根据企业ID和缴交方案ID查询出本公司的所有人员
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 16:32
     */
    List<Map> multiselPersonPage(@Param("comId") Long comId , @Param("paySchemeId") Long paySchemeId);

    /**
     * 批量插入人员关系
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 16:36
     */
    int batchInsert(List<PerSocialInsSchemeRela> record);

    /**
     * 医社保历史缴费记录 缴费记录统计按月
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 16:40
     */
    Map statHisRecList(@Param("comId") Long comId, @Param("payPeriod") String payPeriod);

    /**
     * 缴交设置分页查询
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 16:47
     */
    List<Map> getPaymentSettingPage(Map dto);


    /**
     * 根据方案ID和社会保险险种
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/23 18:06
     */
    Map checkRepeatSchemeDetail (@Param("socialInsType") String socialInsType, @Param("paySchemeId") Long paySchemeId );


    /**
     * 根据方案ID，查询出对应的5险信息
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/24 19:33
     */
    List<ComSocialInsSchemeDetail> selectSocialInsDetail(@Param("paySchemeId") Long paySchemeId);


    /**
     *  某个方案已选的人员列表信息，分页
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/25 9:53
     */
    List<Map> getSelectedPersonPage(@Param("paySchemeId") Long paySchemeId);


    /**
     * 根据方案ID，统计该方案的人数
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/26 10:11
     */
    Map<String, Long> statPerCntBySchemeId(@Param("paySchemeIds") String paySchemeIds);
}
