package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskShift;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 任务人员排班相关
 */
public interface ComTaskShiftMapper extends CrudDao<ComTaskShift> {

    List<MultiDataDTO> getShiftByTask(@Param("comTaskId") Long comTaskId);

    List<ComTaskShift> getShiftListByTask(@Param("comTaskId") Long comTaskId);

    List<MultiDataDTO> getCurrentPerByTask(@Param("comTaskId") Long comTaskId);

    //重载getCurrentPerByTask方法
    List<MultiDataDTO> getCurrentPerByTaskExport(@Param("comTaskId") Long comTaskId,@Param("comId")Long comId);

    /**
     * 查询出勤班次
     *
     * @param comTaskId
     * @return
     */
    List<ComShiftDto> selectComTaskShiftByTaskId(Long comTaskId);


    List<MultiDataDTO> getPerShiftByPerList(@Param("comTaskId") Long comTaskId,@Param("comId") Long comId, @Param("perList") List<MultiDataDTO> perList,
                                            @Param("startDate") String startDate,@Param("endDate") String endDate);


    /**
     * 获得人员当天的排班情况
     *
     * @param ydate     昨天
     * @param cdate     今天
     * @param perId     人员id
     * @param comTaskId 任务id，需要排除当前任务的排班情况
     * @return
     */
    List<MultiDataDTO> getPerShiftCurrentDate(@Param("ydate") String ydate,
                                              @Param("cdate") String cdate,
                                              @Param("perId") Long perId,
                                              @Param("comTaskId") Long comTaskId);


    /**
     * 获得人员固定排班模拟当天的排班情况
     *
     * @param yesterdayOfWeek  昨天是星期几
     * @param currentDayOfWeek 今天是星期几
     * @param perId            人员id
     * @return
     */
    List<MultiDataDTO> getMockShiftCurrentDate(@Param("appointedDate") String appointedDate,
                                               @Param("yesterdayOfWeek") int yesterdayOfWeek,
                                               @Param("currentDayOfWeek") int currentDayOfWeek,
                                               @Param("perId") Long perId,
                                               @Param("noShiftFixList")List<String> noShiftFixList);


    /**
     * 获得固定排班中模拟日期当天白天排班的情况
     *
     * @param dayOfWeek  指定日期是星期几
     * @param perId            人员id
     * @return
     */
    List<MultiDataDTO> getMockShiftAppointedNextDate(@Param("appointedDate") String appointedDate,
                                               @Param("dayOfWeek") int dayOfWeek,
                                               @Param("perId") Long perId,
                                               @Param("noShiftFixList")List<String> noShiftFixList);
    /**
     * 批量插入添加默认班次信息
     *
     * @param listComTaskShift
     * @return
     */
    int batchInsertComTaskShift(List<ComTaskShift> listComTaskShift);

    /**
     * 固定班制获取班次
     *
     * @param comTaskId
     * @return
     */
    List<MultiDataDTO> getShiftByFixedTask(@Param("comTaskId") Long comTaskId);

    /**
     * 获得人员存在多少个固定班次中
     * @param appointedDate
     * @param perId
     * @return
     */
    List<String> selectPerShiftFixTask(@Param("appointedDate") String appointedDate, @Param("perId")Long perId);

    /**
     * 获得固定班次中是否已经有排班信息
     *
     * @param appointedDate
     * @return
     */
    List<String> existsPerShiftTask(@Param("appointedDate") String appointedDate, @Param("perId")Long perId);


    /**
     * 获取任务人员列表
     * @param comTaskId
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    List<Map<String,String>> getTaskPerListByTaskId(@Param("comTaskId") Long comTaskId);


    /**
     * 获取未排班班次列表
     *
     * @param comTaskShift
     * @author llc
     * @date 2020-05-06
     */
    List<Map<String,String>> getNoSchedulShiftList(ComTaskShift comTaskShift);


    /**
     * 删除驻勤班次关联
     *
     * @param comTaskId
     * @param shiftIdList
     * @author llc
     * @date 2020-05-06
     */
    int deleteTaskShift(@Param("comTaskId") Long comTaskId,@Param("list") List<Long> shiftIdList);


    /**
     * 获取未设置班次列表
     *
     * @param comTaskShift
     * @author llc
     * @date 2020-05-06
     */
    List<Map<String,String>> getNoSetShiftList(ComTaskShift comTaskShift);


}