package com.bcxin.oa.old.mapper;


import com.bcxin.oa.old.entity.task.ComShiftRule;
import com.bcxin.oa.old.entity.task.ComTaskShift;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 企业班次规则
* @author zhangye
* @since 2018-02-26 14:14:14
*/
public interface ComShiftRuleMapper extends CrudDao<ComShiftRule>{

    List<ComShiftRule> getShiftRuleByShiftId(@Param("shiftId") Long shiftId);

    List<ComShiftRule> getShiftRuleByShiftIdList(@Param("shiftList") List<ComTaskShift> shiftList);

    ComShiftRule getShiftRuleByRuleId(@Param("shiftRuleId") Long shiftRuleId);

    int hasNextDay(@Param("idList") List<String> idList);

    void deleteByShiftId(@Param("shiftId") Long shiftId);

    List<MultiDataDTO> getTimeNodeByShiftIdList(@Param("idList") List<String> idList);

    List<MultiDataDTO> getTimeNodeByShiftId(@Param("shiftId") Long shiftId);

    List<MultiDataDTO> getNextDayTimeNodeByShiftId(@Param("idList") List<String> idList);



    /**
     * 通过考勤组安排的班次集合查询班次详情
     *
     * @param comId
     * @param shiftIdList
     * @return
     */
    List<ComShiftRule> getshiftRuleList(@Param("comId") Long comId,@Param("list") List<String> shiftIdList);
}