package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComAttendAddress;
import com.bcxin.oa.old.common.CrudDao;

import java.util.List;
import java.util.Map;

/**
 * 企业考勤地址
 *
 * @author zhangjianhua
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendAddressMapper extends CrudDao<ComAttendAddress> {

    /**
     * 设置考勤方式（考勤地点）
     *
     * @param comAttendAddress
     * @return
     */
    int addAttendGroupAddress(ComAttendAddress comAttendAddress);

    /**
     * 删除以前的地址
     *
     * @param address
     * @return
     */
    int deleteBeforeAddress(ComAttendAddress address);

    /**
     * 查看考勤方式（考勤地点）
     *
     * @param attendGroupId
     * @return
     */
    List<ComAttendAddress> listAttendGroupAddress(Long attendGroupId);


    /**
     * 批量插入考勤地址
     *
     * @param attendAddressList
     * @return
     */
    int insertAttendGroupAddress(List<ComAttendAddress> attendAddressList);

    /**
     * 查询考勤地址
     *
     * @param address
     * @return
     */
    List<Map<String,Object>> getAttendGroupAddress(ComAttendAddress address);


}