package com.bcxin.oa.old.entity.task.tempTask;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 临保任务考勤地址
 *
 * @author llc
 * @date 2020-02-21
 */
@Data
@TableName("com_temp_task_attend_address")
public class ComTempTaskAttendAddress extends BaseEntity<ComTempTaskAttendAddress> {

	/** 任务考勤地址ID */
	@ApiModelProperty(value = "任务考勤地址ID")
	private Long taskAttendAddressId;

	/** 考勤地址 */
	@ApiModelProperty(value = "考勤地址")
	private String address;

	/** 考勤地址经度 */
	@ApiModelProperty(value = "考勤地址经度")
	private String addressLongitude;

	/** 考勤地址纬度 */
	@ApiModelProperty(value = "考勤地址纬度")
	private String addressLatitude;

	/** 考勤范围（米为单位） */
	@ApiModelProperty(value = "考勤范围（米为单位）")
	private Long addressRange;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTempTaskId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getTaskAttendAddressId() {
		return taskAttendAddressId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTempTaskId() {
		return comTempTaskId;
	}
}