package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务签到提醒
 * @author 罗鹏
 */
@TableName("task_card_remind")
@Data
public class TaskCardRemind extends BaseEntity<TaskCardRemind> {
	private static final long serialVersionUID = 685361896L;

	/** 外勤打卡提醒ID */
	@ApiModelProperty(value = "外勤打卡提醒ID")
	private Long taskCardRemindId;

	/**
	 * 提醒时间
	 */
	private Date remindTime;

	/**
	 * 考勤时间
	 */
	private Date attendTime;

	/**
	 * 开始日期
	 */
	private Date startDate;

	/**
	 * 结束日期
	 */
	private Date endDate;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 班次规则ID */
	@ApiModelProperty(value = "班次规则ID")
	private Long shiftRuleId;


	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskCardRemindId() {
		return taskCardRemindId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftRuleId() {
		return shiftRuleId;
	}


}