package com.bcxin.oa.old.dto.count;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;

/**
 * 人员每日外勤详情dto
 *
 * @author llc
 * @date 2019-01-14
 */
@Data
public class PerTaskDateDTO extends BaseEntity<PerTaskDateDTO> {

    /** 人员Id */
    private Long perId;

    /** 任务Id */
    private Long comTaskId;

    /** 考勤日期 */
    private String taskName;

    /** 考勤日期 */
    private String attendDate;

    /** 第几轮 */
    private int commutRound;

    /** 打卡类型 */
    private String clockInType;

    /** 外勤状态 */
    private String attendStatus;

    /** 修改的时间 */
    private int minute;

    /** 打卡记录ID */
    private Long taskCardRecordId;


    /** 外勤时间 */
    private Date attendTime;

    /** 打卡时间 */
    private Date clockInTime;

    /** 备注 */
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComTaskId() {
        return comTaskId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getTaskCardRecordId() {
        return taskCardRecordId;
    }

}
