package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 *
 * APP任务
 *
 * @author zhangye
 * @since 2018-03-15 16:24:22
 */
@Data
public class AppComTaskRoundDTO extends BaseEntity<AppComTaskRoundDTO> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 49195933494526696L;
	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long taskId;
	/** 任务执行情况ID */
	@ApiModelProperty(value = "任务执行情况ID")
	private Long smallShiftId;

	/** 轮次签到时间 */
	@ApiModelProperty(value = "轮次签到时间")
	private String signInTime;

	/** 上班打卡日期 */
	@ApiModelProperty(value = "上班打卡日期")
	private String clockInDate;

	/** 下班打卡日期 */
	@ApiModelProperty(value = "下班打卡日期 ")
	private String clockOutDate;

	/** 轮次下班时间 */
	@ApiModelProperty(value = "轮次下班时间 ")
	private String signOutTime;

	/** 轮次上班日期 */
	@ApiModelProperty(value = "轮次上班日期")
	private Date startDate;

	/** 可上班打卡日期 */
	@ApiModelProperty(value = "可上班打卡日期")
	private Date canSignInDate;

	/** 下班最迟打卡日期 */
	@ApiModelProperty(value = "下班最迟打卡日期")
	private Date canSignOutDate;

	/** 上班出勤状态 */
	@ApiModelProperty(value = "上班出勤状态")
	private String signInStatus;

	/** 下班出勤状态 */
	@ApiModelProperty(value = "下班出勤状态")
	private String signOutStatus;

	/** 出勤类型 */
	@ApiModelProperty(value = "出勤类型")
	private String attendType;
	/** 日期详情 */
	@ApiModelProperty(value = "日期详情")
	private String taskDateInfo;
	/** 打卡时限开关 */
	@ApiModelProperty(value = "打卡时限开关")
	private String clockLimitSwitch;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskId() {
		return taskId;
	}

}
