
package com.bcxin.oa.old.controller.system;

import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.ComDepartDto;
import com.bcxin.oa.old.dto.user.CurrentUser;
import com.bcxin.oa.old.entity.system.ComDepart;
import com.bcxin.oa.old.service.system.ComDepartService;
import com.bcxin.oa.old.service.system.PerOrgRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Title：部门管理
 * @Package：com.bcx.platform.controller @Description：
 * @author：钟剑辉
 * @date：2017年11月16日 下午8:38:11 @version：V1.0
 */
@RestController
@RequestMapping("/system/com-depart")
@Api(tags = { "" }, description = "部门管理")
public class ComDepartController extends BaseController {

	@Resource
	private ComDepartService comDepartService;

	@Resource
	private PerOrgRelationService perOrgRelationService;

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "列表查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "list")
	@ApiOperation(value = "获取部门列表", httpMethod = "GET", notes = "获取部门列表", response = ComDepart.class)
	public Result list(ComDepartDto comDepart) {
		return comDepartService.selecteByParentDepartId(comDepart).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "树形查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "tree-com-depart")
	@ApiOperation(value = "获取公司及下级部门", httpMethod = "GET", notes = "获取公司及下级部门", response = ComDepart.class)
	public Result treecomdepart(ComDepartDto comDepart) {
		return comDepartService.selecteComAndDepartByParentDepartId(comDepart).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "公司详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get")
	@ApiOperation(value = "获取部门信息", httpMethod = "GET", notes = "获取部门信息", response = ComDepart.class)
	public Result queryComDepartList(ComDepartDto comDepart) {
		return comDepartService.getByPrimaryKey(comDepart).setBack(getRequest());
	}

	/**
	 * 所有选择组织架构人员接口
	 * @param comDepart
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门人员树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-treeper-bydepart")
	public Result getTreePerByDepart(ComDepartDto comDepart) {
		return comDepartService.getTreePerByDepart(comDepart).setBack(getRequest());
	}

	/**
	 * 人事模块-组织架构部门树（新）
	 * @param comDepart
	 * @auth llc
	 * @date 2019-07-16
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门人员树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-depart-tree")
	public Result getDepartTree(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		comDepart.setPerID(currentUser.getPerId());
		return comDepartService.getDepartTree(comDepart).setBack(getRequest());
	}



	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "企业人员Map列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-treeper-bydepart-map")
	public Result getTreePerByDepartMap(ComDepartDto comDepart) {
		return comDepartService.getTreePerByDepartMap(comDepart).setBack(getRequest());
	}

	/**
	 * 选人公共部门树接口
	 * @param comDepart
	 * @auth llc
	 * @date 2019-08-28
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-tree-depart")
	public Result getTreeDepart(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comDepartService.getTreeDepart(comDepart).setBack(getRequest());
	}

	/**
	 * 获取选人公共部门树的人员列表
	 * @param comDepart
	 * @auth llc
	 * @date 2019-08-28
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取组织机构右边的人员列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-depart-person-list")
	public Result getDepartPerSonList(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perOrgRelationService.getDepartPerSonList(comDepart).setBack(getRequest());
	}


	/**
	 * 获取驻勤模块公共部门树的人员列表
	 * @param comDepart
	 * @auth llc
	 * @date 2020-04-16
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取驻勤模块公共部门树的人员列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-task-depart-person-list")
	public Result getTaskDepartPerSonList(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perOrgRelationService.getTaskDepartPerSonList(comDepart).setBack(getRequest());
	}

	/**
	 * 公共选人的接口(关键字查询)
	 * @param comDepartDto
	 * @return
	 * @author llc
	 * @date 2019-08-28
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "公共选人的接口(关键字查询)", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-common-per-list-by-keyword")
	@ApiOperation(value = "公共选人的接口(关键字查询)", httpMethod = "POST", notes = "公共选人的接口(关键字查询)")
	public Result getCommonPerListByKeyword(ComDepartDto comDepartDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = perOrgRelationService.getCommonPerListByKeyword(comDepartDto);
		return result;
	}


	/**
	 * 驻勤模块选人的接口(关键字查询)(涉及数据权限)
	 * @param comDepartDto
	 * @return
	 * @author llc
	 * @date 2020-04-16
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "驻勤模块选人的接口(关键字查询)(涉及数据权限)", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-task-per-list-by-keyword")
	@ApiOperation(value = "驻勤模块选人的接口(关键字查询)(涉及数据权限)", httpMethod = "POST", notes = "驻勤模块选人的接口(关键字查询)(涉及数据权限)")
	public Result getTaskPerListByKeyword(ComDepartDto comDepartDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		comDepartDto.setPerID(currentUser.getPerId());
		Result result = perOrgRelationService.getTaskPerListByKeyword(comDepartDto);
		return result;
	}



	/**
	 * 获取华为会议选人公共部门树的人员列表
	 * @param comDepart
	 * @auth llc
	 * @date 2019-12-12
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取组织机构右边的人员列表（华为会议选人）", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-huawei-depart-person-list")
	public Result getHuaweiDepartPerSonList(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perOrgRelationService.getHuaweiDepartPerSonList(comDepart).setBack(getRequest());
	}

	/**
	 * 华为会议选人的接口(关键字查询)
	 * @param comDepartDto
	 * @return
	 * @author llc
	 * @date 2019-12-12
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "华为会议选人的接口(关键字查询)", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-huawei-per-list-by-keyword")
	@ApiOperation(value = "华为会议选人的接口(关键字查询)", httpMethod = "POST", notes = "华为会议选人的接口(关键字查询)")
	public Result getHuaweiPerListByKeyword(ComDepartDto comDepartDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = perOrgRelationService.getHuaweiPerListByKeyword(comDepartDto);
		return result;
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "导出组织架构Excel模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-depart-temp")
	public Result exportDepartTemp(String comId) throws BusinessException {
		return comDepartService.exportDepartTemp(comId, getResponse()).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "导出组织架构Excel", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "导出组织架构Excel", httpMethod = "GET", notes = "导出组织架构Excel", response = ComDepartDto.class)
	@GetMapping(value = "export-depart")
	public Result exportDepart(ComDepartDto comDepart) throws BusinessException {
		return comDepartService.exportDepart(getResponse(), comDepart).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-tree-depart-not-data-auth")
	public Result getTreeDepartNotDataAuth(ComDepartDto comDepart) {
		return comDepartService.getTreeDepartNotDataAuth(comDepart).setBack(getRequest());
	}

	/**
	 * 获取子部门列表(包含数据权限)
	 *
	 * @param comDepart
	 * @return
	 * @author llc
	 * @date 2019-07-15
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取子部门列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-child-depart-list")
	@ApiOperation(value = "获取子部门列表", httpMethod = "GET", notes = "获取子部门列表", response = ComDepartDto.class)
	public Result getChildDepartList(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		comDepart.setPerID(currentUser.getPerId());
		return perOrgRelationService.getChildDepartList(comDepart).setBack(getRequest());
	}

	/**
	 * web通过姓名/手机号码/身份证搜索人员信息(组织架构涉及权限)
	 * @param comDepartDto
	 * @return
	 * @author llc
	 * @date 2019-07-17
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "web通过姓名/手机号码/身份证搜索人员信息", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "get-web-per-list-by-keyword")
	@ApiOperation(value = "web通过姓名/手机号码/身份证搜索人员信息", httpMethod = "POST", notes = "web通过姓名/手机号码/身份证搜索人员信息")
	public Result getWebPerListByKeyword(ComDepartDto comDepartDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		comDepartDto.setPerID(currentUser.getPerId());
		Result result = perOrgRelationService.getWebPerListByKeyword(comDepartDto);
		return result;
	}

	/**
	 * 获取组织机构右边的人员列表（新）
	 * @param comDepart
	 * @auth llc
	 * @date 2019-07-16
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取组织机构右边的人员列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-org-person-list")
	public Result getOrgPerSonList(ComDepartDto comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return perOrgRelationService.getOrgPerSonList(comDepart).setBack(getRequest());
	}

	/**
	 * 获取部门app通讯录权限设置信息
	 * @param comDepart
	 * @auth llc
	 * @date 2019-07-26
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取部门app通讯录权限设置信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "get-depart-app-auth-info")
	public Result getDepartAppAuthInfo(ComDepart comDepart) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comDepartService.getDepartAppAuthInfo(comDepart).setBack(getRequest());
	}

}
