package com.bcxin.oa.old.controller.app.task;

import com.bcxin.oa.old.dto.ComTaskFixedTempDTO;
import com.bcxin.oa.old.dto.app.AppPerTaskCardRecordDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.app.PerTaskCardRecordService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App接口-任务考勤打卡记录管理
 *
 * @author wangjianchi
 * @version 1.0
 */
@RestController
@RequestMapping("/task/app/per/task/card/record")
@Api(tags = { "" }, description = "APP-任务考勤打卡记录")
public class AppPerTaskCardRecordController extends BaseController {

	@Autowired
	private PerTaskCardRecordService perTaskCardRecordService;

	/**
	 * APP-任务考勤打卡记录-上班
	 *
	 * @param appPerTaskCardRecordDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/15
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = " APP-任务考勤打卡记录-上班", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = " APP-任务考勤打卡记录-上班", httpMethod = "POST", notes = " APP-任务考勤打卡记录-上班", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "save-task-sign-in")
	public Result saveTaskSignIn(AppPerTaskCardRecordDTO appPerTaskCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerTaskCardRecordDTO appPerTaskCardRecordDTOParam = Result
				.getDecodeData(appPerTaskCardRecordDto.getAppData(), AppPerTaskCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerTaskCardRecordDTOParam, appPerTaskCardRecordDto);
		appPerTaskCardRecordDTOParam.setPerId(currentUser.getPerId());
		appPerTaskCardRecordDTOParam.setClockInType(DictConst.CLOCKINTYPE_SBDK);
		Result result = perTaskCardRecordService.saveTaskSign(appPerTaskCardRecordDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * APP-任务考勤打卡记录-下班
	 *
	 * @param appPerTaskCardRecordDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/15
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = " APP-任务考勤打卡记录-下班", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = " APP-任务考勤打卡记录-下班", httpMethod = "POST", notes = " APP-任务考勤打卡记录-下班", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "save-task-sign-out")
	public Result saveTaskSignOut(AppPerTaskCardRecordDTO appPerTaskCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerTaskCardRecordDTO appPerTaskCardRecordDTOParam = Result
				.getDecodeData(appPerTaskCardRecordDto.getAppData(), AppPerTaskCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerTaskCardRecordDTOParam, appPerTaskCardRecordDto);
		appPerTaskCardRecordDTOParam.setPerId(currentUser.getPerId());
		appPerTaskCardRecordDTOParam.setFeedbackPerId(currentUser.getPerId());
		appPerTaskCardRecordDTOParam.setClockInType(DictConst.CLOCKINTYPE_XBDK);
		Result result = perTaskCardRecordService.saveTaskOut(appPerTaskCardRecordDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}

	/**
	 * APP-任务考勤打卡记录-下班（查询状态）
	 *
	 * @param appPerTaskCardRecordDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/23
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = " APP-任务考勤打卡记录-下班（查询状态）", title = "下班（查询状态）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = " APP-任务考勤打卡记录-下班（查询状态）", httpMethod = "POST", notes = " APP-任务考勤打卡记录-下班（查询状态）", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "select-task-sign-out")
	public Result selectTaskSignOut(AppPerTaskCardRecordDTO appPerTaskCardRecordDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppPerTaskCardRecordDTO appPerTaskCardRecordDTOParam = Result
				.getDecodeData(appPerTaskCardRecordDto.getAppData(), AppPerTaskCardRecordDTO.class);
		ObjectUtils.appCopyProperties(appPerTaskCardRecordDTOParam, appPerTaskCardRecordDto);
		appPerTaskCardRecordDTOParam.setPerId(currentUser.getPerId());
		appPerTaskCardRecordDTOParam.setClockInType(DictConst.CLOCKINTYPE_XBDK);
		Result result = perTaskCardRecordService.selectTaskSignOut(appPerTaskCardRecordDTOParam);
		result.setData(Result.setEncodeData(result.getData()));
		return result.setBack(getRequest());
	}






}
