package com.bcxin.oa.old.common.utils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

/**
 * @version V1.0
 * @desc AES 加密工具类
 */
public class AESUtil {

	public final static String ENCODING = "UTF-8";
	// 密钥
	public static final String AES_KEY = "2E9316AAB412DFAED10EFF5E03A1EF72";

	/**
	 * AES 加密
	 *
	 * @param text
	 *            待加密的字符串
	 * @return 加密后的byte[] 数组
	 * @throws Exception
	 */
	public static String encode(String text) throws Exception {
		try {
			String base64Key = AES_KEY;
			byte[] key = parseHexStr2Byte(base64Key);
			SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
			Cipher cipher = Cipher.getInstance("AES");
			cipher.init(Cipher.ENCRYPT_MODE, sKeySpec);
			byte[] bjiamihou = cipher.doFinal(text.getBytes(ENCODING));
			String result = parseByte2HexStr(bjiamihou);
			return result;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * AES解密
	 *
	 * @param text
	 *            待解密的字符串
	 * @return 解密后的字符串
	 * @throws Exception
	 */
	public static String decode(String text) throws Exception {
		String base64Key = AES_KEY;
		byte[] key = parseHexStr2Byte(base64Key);
		SecretKeySpec sKeySpec = new SecretKeySpec(key, "AES");
		Cipher cipher = Cipher.getInstance("AES");
		cipher.init(Cipher.DECRYPT_MODE, sKeySpec);
		byte[] bjiemihou = cipher.doFinal(parseHexStr2Byte(text));
		String result = new String(bjiemihou, "UTF-8");
		return result;
	}

	/**
	 * 生成密钥 自动生成base64 编码后的AES128位密钥
	 *
	 * @throws NoSuchAlgorithmException
	 * @throws Exception
	 */
	public static String getAESKey() throws Exception {
		KeyGenerator kg = KeyGenerator.getInstance("AES");
		kg.init(128);// 要生成多少位，只需要修改这里即可128, 192或256
		SecretKey sk = kg.generateKey();
		byte[] b = sk.getEncoded();
		return parseByte2HexStr(b);
	}

	/**
	 * 将16进制转换为二进制
	 *
	 * @param hexStr
	 * @return
	 */
	public static byte[] parseHexStr2Byte(String hexStr) {
		if (hexStr.length() < 1)
			return null;
		byte[] result = new byte[hexStr.length() / 2];
		for (int i = 0; i < hexStr.length() / 2; i++) {
			int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
			int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
			result[i] = (byte) (high * 16 + low);
		}
		return result;
	}

	/**
	 * 将二进制转换成16进制
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStr(byte buf[]) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < buf.length; i++) {
			String hex = Integer.toHexString(buf[i] & 0xFF);
			if (hex.length() == 1) {
				hex = '0' + hex;
			}
			sb.append(hex.toUpperCase());
		}
		return sb.toString();
	}

	public static byte[] AES_CBC_Decrypt(byte[] data, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = getCipher(Cipher.DECRYPT_MODE, key, iv);
		return cipher.doFinal(data);
	}

	private static Cipher getCipher(int mode, byte[] key, byte[] iv) throws Exception {
		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");

		// 因为AES的加密块大小是128bit(16byte), 所以key是128、192、256bit无关
		// System.out.println("cipher.getBlockSize()： " +
		// cipher.getBlockSize());

		SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
		cipher.init(mode, secretKeySpec, new IvParameterSpec(iv));

		return cipher;
	}

	public static void main(String[] args) throws Exception {
//		String content = "事实上就是";
//		String encodeStr = AESUtil.encode(content);
//		System.out.println(encodeStr);
//		System.out.println(Integer.parseInt("2231244".substring(0,6)));
//		ResultJson resultJson = new ResultJson();
//		if(resultJson.isSuccessful()){
//			System.out.println("123");
//		}else{
//			System.out.println("123456778".substring(0,6));
//		}

//		List<Map> list =  new ArrayList<>();
//		Map m1 = new HashMap();
//		m1.put("a","11");
//		m1.put("b","2");
//		m1.put("c","2");
//		list.add(m1);
//
//		Map m = new HashMap();
//		m.put("a","11");
//		m.put("b","2");
//		m.put("c","2");
//
//		if(list.contains(m)){
//			System.out.println("1232");
//		}

//		String encodeStr = "F4D296BF31C2717DF9794B272260B83E549FB47C87B37B40E8EF5BC5335B46681BFA20391FCD2F937C90267FA6048D97F75FCE1B9EB52ED0521578013E2DBEE5";
//		byte[] bytes = publicKey.getBytes();
//
//		byte[] data = Hex.decodeHex(passWord.toCharArray());
//		byte[] s = AESUtil.AES_CBC_Decrypt(data, bytes, bytes);
//		passWord = new String(s);

		System.out.println(AESUtil.decode("427D441F3D7AD8D526B3495AD02738D66E49EBC24B2CE32B751F870F438D1C06FBE55EA6738A50394E2262D79109E692416C206CB5EDD9BCE44846AE1532E3683D4DFBEE74002BFBC2B5C0D1C694F314"));

        String sessionId = "";
		StringBuilder sb = new StringBuilder();
		sb.append(1234).append("|");
		sb.append("zhangsan").append("|");
		sb.append(DateUtils.formatDate(DateUtils.addHours(new Date(), 2), "yyyy-MM-dd HH:mm:ss"));
		sessionId = sb.toString();
		System.out.println(sessionId);
		System.out.println(AESUtil.encode(sessionId));
//		List<String> list = new ArrayList<>();
//		list.add("12345");
//		list.add("123452");
//		JSON.toJSONString(list);
//		System.out.println("350781198601104425".substring(0,"350781198601104425".length()-1));
//		System.out.println(null + "123");

	}


}