/*
 Navicat Premium Data Transfer

 Source Server         : 测试数据库-企业
 Source Server Type    : MySQL
 Source Server Version : 50741 (5.7.41-230700-log)
 Source Host           : 49.4.21.141:45611
 Source Schema         : personnel_oa_copy

 Target Server Type    : MySQL
 Target Server Version : 50741 (5.7.41-230700-log)
 File Encoding         : 65001

 Date: 22/01/2024 11:07:16
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for attend_card_remind
-- ----------------------------
DROP TABLE IF EXISTS `attend_card_remind`;
CREATE TABLE `attend_card_remind` (
  `attendCardRemindId` bigint(20) NOT NULL COMMENT '内勤打卡提醒ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `remindTime` time DEFAULT NULL COMMENT '提醒时间',
  `attendTime` time DEFAULT NULL COMMENT '考勤时间',
  `startDate` date DEFAULT NULL COMMENT '开始日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`attendCardRemindId`),
  KEY `index_attend_card_remind_comId` (`comId`),
  KEY `index_attend_card_remind_attendGroupId` (`attendGroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内勤打卡提醒';

-- ----------------------------
-- Records of attend_card_remind
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_address
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_address`;
CREATE TABLE `com_attend_address` (
  `attendAddressId` bigint(20) NOT NULL COMMENT '考勤地址ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `address` varchar(100) DEFAULT NULL COMMENT '考勤地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '考勤地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '考勤地址纬度',
  `addressRange` bigint(20) DEFAULT NULL COMMENT '考勤范围（米为单位）',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  PRIMARY KEY (`attendAddressId`),
  KEY `index_com_attend_address_comId` (`comId`),
  KEY `index_com_attend_address_attendGroupId` (`attendGroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤地址';

-- ----------------------------
-- Records of com_attend_address
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_cycle_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_cycle_shift`;
CREATE TABLE `com_attend_cycle_shift` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `whatDay` int(1) NOT NULL COMMENT '第几天',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `attendSchedulCycleId` bigint(20) NOT NULL COMMENT '考勤组排班周期ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`attendSchedulCycleId`,`whatDay`),
  KEY `index_com_attend_cycle_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组排班周期所选班次';

-- ----------------------------
-- Records of com_attend_cycle_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_group
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_group`;
CREATE TABLE `com_attend_group` (
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `attendGroupName` varchar(30) DEFAULT NULL COMMENT '考勤组名称',
  `effectRule` varchar(6) DEFAULT NULL COMMENT '生效规则',
  `effectStartTime` datetime DEFAULT NULL COMMENT '生效开始时间',
  `effectEndTime` datetime DEFAULT NULL COMMENT '生效截止时间',
  `attendType` varchar(6) DEFAULT NULL COMMENT '考勤类型',
  `shiftIds` varchar(600) DEFAULT NULL COMMENT '考勤组所选班次ID组合(冗余字段，以逗号分隔)',
  `shiftDetails` varchar(2000) DEFAULT NULL COMMENT '考勤组所选班次详情组合',
  `isFollowLegalHoliday` varchar(1) DEFAULT NULL COMMENT '是否遵循法定假日',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`attendGroupId`),
  KEY `index_com_attend_group_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组';

-- ----------------------------
-- Records of com_attend_group
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_group_fixed
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_group_fixed`;
CREATE TABLE `com_attend_group_fixed` (
  `attendGroupFixedId` bigint(20) NOT NULL COMMENT '考勤组固定班制ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`attendGroupFixedId`),
  KEY `index_com_attend_group_fixed_comId` (`comId`),
  KEY `index_attend_group_fixed_attendGroupId` (`attendGroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组固定班制明细';

-- ----------------------------
-- Records of com_attend_group_fixed
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_group_free
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_group_free`;
CREATE TABLE `com_attend_group_free` (
  `attendGroupFreeId` bigint(20) NOT NULL COMMENT '考勤组自由工时ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `startTime` time DEFAULT NULL COMMENT '考勤时间起点',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  PRIMARY KEY (`attendGroupFreeId`),
  KEY `index_com_attend_group_free_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组自由工时明细';

-- ----------------------------
-- Records of com_attend_group_free
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_group_schedul
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_group_schedul`;
CREATE TABLE `com_attend_group_schedul` (
  `attendGroupSchedulId` bigint(20) NOT NULL COMMENT '考勤组排班制ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `schedulDate` date DEFAULT NULL COMMENT '排班日期',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `perId` bigint(20) NOT NULL COMMENT '考勤人员ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`attendGroupSchedulId`),
  KEY `index_com_attend_group_schedul_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组排班制明细';

-- ----------------------------
-- Records of com_attend_group_schedul
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_group_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_group_shift`;
CREATE TABLE `com_attend_group_shift` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  PRIMARY KEY (`attendGroupId`,`shiftId`),
  KEY `index_com_attend_group_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组班次范围';

-- ----------------------------
-- Records of com_attend_group_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_per
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_per`;
CREATE TABLE `com_attend_per` (
  `comAttendPerId` bigint(20) NOT NULL COMMENT '考勤人员ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `effectStartTime` datetime DEFAULT NULL COMMENT '生效开始时间',
  `effectEndTime` datetime DEFAULT NULL COMMENT '生效截止时间',
  PRIMARY KEY (`comAttendPerId`),
  KEY `index_com_attend_per_comId` (`comId`),
  KEY `index_com_attend_per` (`attendGroupId`,`perId`),
  KEY `index_com_attend_per_effectStartTime` (`effectStartTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组考勤人员';

-- ----------------------------
-- Records of com_attend_per
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_respons_per
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_respons_per`;
CREATE TABLE `com_attend_respons_per` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`attendGroupId`,`perId`),
  KEY `index_com_attend_respons_per_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组负责人员';

-- ----------------------------
-- Records of com_attend_respons_per
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_schedul_cycle
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_schedul_cycle`;
CREATE TABLE `com_attend_schedul_cycle` (
  `attendSchedulCycleId` bigint(20) NOT NULL COMMENT '考勤组排班周期ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `cycleName` varchar(20) DEFAULT NULL COMMENT '周期名称',
  `cycleDays` int(3) DEFAULT NULL COMMENT '周期天数',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  PRIMARY KEY (`attendSchedulCycleId`),
  KEY `index_com_attend_schedul_cycle_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤组排班周期';

-- ----------------------------
-- Records of com_attend_schedul_cycle
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_attend_wifi
-- ----------------------------
DROP TABLE IF EXISTS `com_attend_wifi`;
CREATE TABLE `com_attend_wifi` (
  `attendWifiId` bigint(20) NOT NULL COMMENT '考勤WIFIID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `wifiName` varchar(20) DEFAULT NULL COMMENT 'WIFI名称',
  `macAddress` varchar(50) DEFAULT NULL COMMENT 'MAC地址',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  PRIMARY KEY (`attendWifiId`),
  KEY `index_com_attend_wifi_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业考勤WIFI';

-- ----------------------------
-- Records of com_attend_wifi
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_base_info
-- ----------------------------
DROP TABLE IF EXISTS `com_base_info`;
CREATE TABLE `com_base_info` (
  `comId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '企业ID',
  `tlkId` varchar(200) NOT NULL COMMENT 'V5的ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `isInit` varchar(1) DEFAULT '0' COMMENT '是否初始化',
  `authType` varchar(6) DEFAULT NULL COMMENT '认证类型',
  `authStatus` varchar(6) DEFAULT NULL COMMENT '认证状态',
  `authRemark` varchar(255) DEFAULT NULL COMMENT '认证说明',
  `firstAuthTime` datetime DEFAULT NULL COMMENT '首次认证通过时间',
  `comName` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `logoUrl` varchar(500) DEFAULT NULL COMMENT '企业LOGOurl',
  `telePhone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `fax` varchar(20) DEFAULT NULL COMMENT '传真',
  `regProvince` int(6) DEFAULT NULL COMMENT '注册地所在省份',
  `regCity` int(6) DEFAULT NULL COMMENT '注册地所在城市',
  `regArea` int(6) DEFAULT NULL COMMENT '注册地所在区/县',
  `regAddress` varchar(100) DEFAULT NULL COMMENT '注册具体地址',
  `workProvince` int(6) DEFAULT NULL COMMENT '办公地所在省份',
  `workCity` int(6) DEFAULT NULL COMMENT '办公地所在城市',
  `workArea` int(6) DEFAULT NULL COMMENT '办公地所在区/县',
  `workAddress` varchar(100) DEFAULT NULL COMMENT '办公地址',
  `regDetailAddress` varchar(100) DEFAULT NULL COMMENT '注册完整地址到门牌号',
  `economicType` varchar(6) DEFAULT NULL COMMENT '经济类型',
  `industryType` varchar(6) DEFAULT NULL COMMENT '行业类型',
  `comType` varchar(6) DEFAULT NULL COMMENT '公司类型',
  `institutionType` varchar(6) DEFAULT NULL COMMENT '机构类型',
  `isBranchCom` varchar(1) DEFAULT NULL COMMENT '是否分公司',
  `parentComName` varchar(100) DEFAULT NULL COMMENT '总公司名称',
  `parentComCerNo` varchar(50) DEFAULT NULL COMMENT '总公司营业执照号',
  `parentComRep` varchar(50) DEFAULT NULL COMMENT '总公司法人',
  `parentComTel` varchar(20) DEFAULT NULL COMMENT '总公司联系电话',
  `legalRepName` varchar(50) DEFAULT NULL COMMENT '法定代表人姓名',
  `nationality` varchar(6) DEFAULT NULL COMMENT '法定代表人国籍/地区',
  `legalRepPhone` varchar(20) DEFAULT NULL COMMENT '法定代表人手机号',
  `idCardType` varchar(1) DEFAULT NULL COMMENT '法定代表人证件类型',
  `idCardNo` varchar(20) DEFAULT NULL COMMENT '法定代表人证件号码',
  `regAmount` decimal(14,4) DEFAULT NULL COMMENT '注册资金（万元）',
  `fixedAssets` decimal(14,4) DEFAULT NULL COMMENT '固定资产（万元）',
  `annualTurnover` decimal(14,4) DEFAULT NULL COMMENT '年营业额（万元）',
  `annualProfitTax` decimal(14,4) DEFAULT NULL COMMENT '年利税（万元）',
  `comCerType` varchar(6) DEFAULT NULL COMMENT '企业证件类型',
  `comCerNo` varchar(50) DEFAULT NULL COMMENT '企业证件号码',
  `comCerUrl` varchar(500) DEFAULT NULL COMMENT '企业证件url',
  `comTreeCode` varchar(200) DEFAULT NULL COMMENT '企业树代码',
  `comSource` varchar(6) DEFAULT NULL COMMENT '企业来源',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `parentComId` bigint(20) DEFAULT NULL COMMENT '上级企业ID',
  `comRegId` bigint(20) DEFAULT NULL COMMENT '企业注册ID',
  `orgAddEventId` bigint(20) DEFAULT NULL COMMENT '组织新增事件ID',
  `zipCode` varchar(10) DEFAULT NULL COMMENT '注册完整地址所在地邮编',
  `tlkDomainId` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`comId`),
  UNIQUE KEY `index_com_base_info_tlkId` (`tlkId`) USING BTREE,
  KEY `index_com_base_info_comTreeCode` (`comTreeCode`),
  KEY `index_com_base_info_parentComId` (`parentComId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业基础信息';

-- ----------------------------
-- Records of com_base_info
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_depart
-- ----------------------------
DROP TABLE IF EXISTS `com_depart`;
CREATE TABLE `com_depart` (
  `departId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门ID',
  `tlkId` varchar(200) NOT NULL COMMENT 'V5的ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `departName` varchar(30) NOT NULL COMMENT '部门名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否有效',
  `seq` int(6) DEFAULT NULL COMMENT '排序',
  `departTreeCode` varchar(200) DEFAULT NULL COMMENT '部门树查询代码',
  `orgAddEventId` bigint(20) DEFAULT NULL COMMENT '组织新增事件ID',
  `parentDepartId` bigint(20) DEFAULT NULL COMMENT '上级部门ID',
  `limitSeeAppSwitch` varchar(1) DEFAULT NULL COMMENT '限制本部门人员查看App通讯录开关',
  `limitSeeAppType` varchar(6) DEFAULT NULL COMMENT '限制查看App通讯录类型',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `tlkDepartId` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`departId`),
  UNIQUE KEY `index_com_depart_tlkId` (`tlkId`) USING BTREE,
  KEY `index_com_depart_comId` (`comId`),
  KEY `index_com_depart_departTreeCode` (`departTreeCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='部门';

-- ----------------------------
-- Records of com_depart
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_industry_info
-- ----------------------------
DROP TABLE IF EXISTS `com_industry_info`;
CREATE TABLE `com_industry_info` (
  `comIndFieldId` bigint(20) NOT NULL COMMENT '企业行业字段ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `fieldCode` varchar(100) DEFAULT NULL COMMENT '字段编码',
  `fieldValue` varchar(1000) DEFAULT NULL COMMENT '字段值',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comIndFieldId`),
  KEY `index_com_industry_info_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业行业信息';

-- ----------------------------
-- Records of com_industry_info
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_salary_record
-- ----------------------------
DROP TABLE IF EXISTS `com_salary_record`;
CREATE TABLE `com_salary_record` (
  `comSalaryRecordId` bigint(20) NOT NULL COMMENT '企业薪资记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `grantYears` varchar(7) DEFAULT NULL COMMENT '发放年月',
  `isCreateData` varchar(1) DEFAULT NULL COMMENT '是否生成发放数据',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comSalaryRecordId`),
  KEY `index_com_salary_record_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业薪资记录';

-- ----------------------------
-- Records of com_salary_record
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_salary_temp
-- ----------------------------
DROP TABLE IF EXISTS `com_salary_temp`;
CREATE TABLE `com_salary_temp` (
  `comSalaryTempId` bigint(20) NOT NULL COMMENT '企业薪资模板ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `name` varchar(50) DEFAULT NULL COMMENT '模板名称',
  `startYears` varchar(7) DEFAULT NULL COMMENT '开始年月',
  `endYears` varchar(7) DEFAULT NULL COMMENT '结束年月',
  `isActive` varchar(1) DEFAULT '1' COMMENT '是否启用',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comSalaryTempId`),
  KEY `index_com_salary_temp_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业薪资模板';

-- ----------------------------
-- Records of com_salary_temp
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_salary_temp_per
-- ----------------------------
DROP TABLE IF EXISTS `com_salary_temp_per`;
CREATE TABLE `com_salary_temp_per` (
  `comSalaryTempId` bigint(20) NOT NULL COMMENT '企业薪资模板ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`comSalaryTempId`,`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业薪资模板对应人员';

-- ----------------------------
-- Records of com_salary_temp_per
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_salary_temp_project
-- ----------------------------
DROP TABLE IF EXISTS `com_salary_temp_project`;
CREATE TABLE `com_salary_temp_project` (
  `comSalaryTempId` bigint(20) NOT NULL COMMENT '企业薪资模板ID',
  `salaryType` varchar(6) NOT NULL COMMENT '薪资类型',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `setAmount` int(6) NOT NULL DEFAULT '0' COMMENT '设置的金额',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注(工资条提醒项目)',
  PRIMARY KEY (`comSalaryTempId`,`salaryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业薪资模板对应项目';

-- ----------------------------
-- Records of com_salary_temp_project
-- ----------------------------
BEGIN;
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1101', '2024-01-15 11:28:51', NULL, 1111, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1102', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1201', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1202', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1203', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1204', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1209', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1301', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1302', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1303', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1304', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1305', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1306', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1307', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1308', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1309', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1401', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1402', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1403', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1404', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1405', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '1406', '2024-01-15 11:28:51', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '3001', '2024-01-15 11:28:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '3002', '2024-01-15 11:28:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '3003', '2024-01-15 11:28:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '3008', '2024-01-15 11:28:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1196415700851216384, '3101', '2024-01-15 11:28:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1101', '2024-01-18 15:29:51', NULL, 6000, 'q');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1102', '2024-01-18 15:29:51', NULL, 1000, 'w');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1201', '2024-01-18 15:29:51', NULL, 200, 'e');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1202', '2024-01-18 15:29:51', NULL, 200, 'e');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1203', '2024-01-18 15:29:51', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1204', '2024-01-18 15:29:51', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1209', '2024-01-18 15:29:51', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1301', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1302', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1303', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1304', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1305', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1306', '2024-01-18 15:29:51', NULL, 60, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1307', '2024-01-18 15:29:51', NULL, 60, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1308', '2024-01-18 15:29:51', NULL, 60, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1309', '2024-01-18 15:29:51', NULL, 10, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1401', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1402', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1403', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1404', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1405', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '1406', '2024-01-18 15:29:51', NULL, 40, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '3001', '2024-01-18 15:29:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '3002', '2024-01-18 15:29:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '3003', '2024-01-18 15:29:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '3008', '2024-01-18 15:29:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197129634538725376, '3101', '2024-01-18 15:29:51', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1101', '2024-01-18 15:30:15', NULL, 30000, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1102', '2024-01-18 15:30:15', NULL, 3000, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1201', '2024-01-18 15:30:15', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1202', '2024-01-18 15:30:15', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1203', '2024-01-18 15:30:15', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1204', '2024-01-18 15:30:15', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1209', '2024-01-18 15:30:15', NULL, 200, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1301', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1302', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1303', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1304', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1305', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1306', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1307', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1308', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1309', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1401', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1402', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1403', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1404', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1405', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '1406', '2024-01-18 15:30:15', NULL, 0, '');
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '3001', '2024-01-18 15:30:15', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '3002', '2024-01-18 15:30:15', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '3003', '2024-01-18 15:30:15', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '3008', '2024-01-18 15:30:15', NULL, 0, NULL);
INSERT INTO `com_salary_temp_project` (`comSalaryTempId`, `salaryType`, `createTime`, `createBy`, `setAmount`, `remark`) VALUES (1197560817821630464, '3101', '2024-01-18 15:30:15', NULL, 0, NULL);
COMMIT;

-- ----------------------------
-- Table structure for com_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_shift`;
CREATE TABLE `com_shift` (
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `shiftName` varchar(20) DEFAULT NULL COMMENT '班次名称',
  `shiftRuleDetail` varchar(500) DEFAULT NULL COMMENT '班次规则详情',
  `shiftType` varchar(6) DEFAULT NULL COMMENT '班次类型',
  `effectRule` varchar(6) DEFAULT NULL COMMENT '生效规则',
  `effectStartTime` datetime DEFAULT NULL COMMENT '生效开始时间',
  `effectEndTime` datetime DEFAULT NULL COMMENT '生效截止时间',
  `commutTimes` int(3) DEFAULT NULL COMMENT '每天上下班次数',
  `permitLateUp` int(3) DEFAULT NULL COMMENT '允许迟到时间上限',
  `seriousLateLow` int(3) DEFAULT NULL COMMENT '严重迟到时间下限',
  `absentLow` int(3) DEFAULT NULL COMMENT '旷工时间下限',
  `clockWorkLimit` int(3) DEFAULT NULL COMMENT '打卡时限上限',
  `permitLateSwitch` varchar(1) DEFAULT NULL COMMENT '允许迟到校验开关',
  `seriousLateSwitch` varchar(1) DEFAULT NULL COMMENT '严重迟到校验开关',
  `absentSwitch` varchar(1) DEFAULT NULL COMMENT '旷工校验开关',
  `clockLimitSwitch` varchar(1) DEFAULT NULL COMMENT '打卡时限开关',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`shiftId`),
  KEY `index_com_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业班次';

-- ----------------------------
-- Records of com_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_shift_rule
-- ----------------------------
DROP TABLE IF EXISTS `com_shift_rule`;
CREATE TABLE `com_shift_rule` (
  `shiftRuleId` bigint(20) NOT NULL COMMENT '班次规则ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `commutRound` int(3) DEFAULT NULL COMMENT '上下班第几轮',
  `startWorkTime` time DEFAULT NULL COMMENT '上班时间',
  `endWorkTime` time DEFAULT NULL COMMENT '下班时间',
  `isStartNextDay` varchar(1) DEFAULT '0' COMMENT '上班时间是否是次日',
  `isEndNextDay` varchar(1) DEFAULT '0' COMMENT '下班时间是否是次日',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  PRIMARY KEY (`shiftRuleId`),
  KEY `index_com_shift_rule_shiftId` (`shiftId`),
  KEY `index_com_shift_rule_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业班次规则';

-- ----------------------------
-- Records of com_shift_rule
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_social_ins_scheme
-- ----------------------------
DROP TABLE IF EXISTS `com_social_ins_scheme`;
CREATE TABLE `com_social_ins_scheme` (
  `paySchemeId` bigint(20) NOT NULL COMMENT '缴费方案ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `schemeName` varchar(20) DEFAULT NULL COMMENT '方案名称',
  `isEffect` varchar(1) DEFAULT NULL COMMENT '是否生效（废弃）',
  `startYears` varchar(7) DEFAULT NULL COMMENT '开始年月',
  `endYears` varchar(7) DEFAULT NULL COMMENT '结束年月',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`paySchemeId`),
  KEY `index_com_social_ins_scheme_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业医社保缴费方案';

-- ----------------------------
-- Records of com_social_ins_scheme
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_social_ins_scheme_detail
-- ----------------------------
DROP TABLE IF EXISTS `com_social_ins_scheme_detail`;
CREATE TABLE `com_social_ins_scheme_detail` (
  `paySchemeDetailId` bigint(20) NOT NULL COMMENT '缴费方案明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `socialInsType` varchar(6) DEFAULT NULL COMMENT '社保险种',
  `socialInsBase` decimal(10,2) DEFAULT NULL COMMENT '缴费基数',
  `comPayProp` decimal(5,4) DEFAULT NULL COMMENT '公司缴纳比例',
  `perPayProp` decimal(5,4) DEFAULT NULL COMMENT '人员缴纳比例',
  `paySchemeId` bigint(20) NOT NULL COMMENT '缴费方案ID',
  PRIMARY KEY (`paySchemeDetailId`),
  KEY `index_com_social_ins_scheme_detail_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业医社保缴费方案明细';

-- ----------------------------
-- Records of com_social_ins_scheme_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task
-- ----------------------------
DROP TABLE IF EXISTS `com_task`;
CREATE TABLE `com_task` (
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `taskAssign` varchar(6) DEFAULT NULL COMMENT '任务归属',
  `taskName` varchar(50) DEFAULT NULL COMMENT '任务名称',
  `taskType` varchar(8) DEFAULT NULL COMMENT '任务类型',
  `taskStationType` varchar(6) DEFAULT NULL COMMENT '驻勤点类型',
  `serviceObject` varchar(100) DEFAULT NULL COMMENT '服务对象',
  `serviceObjectType` varchar(6) DEFAULT NULL COMMENT '服务对象类型',
  `serviceObjectSySituation` varchar(6) DEFAULT NULL COMMENT '服务对象涉外情况',
  `isSecurityImportantUnit` varchar(1) DEFAULT '0' COMMENT '是否治安保卫重点单位',
  `taskLevel` varchar(6) DEFAULT NULL COMMENT '任务等级',
  `attendType` varchar(6) DEFAULT NULL COMMENT '任务考勤类型',
  `attendSubType` varchar(6) DEFAULT NULL COMMENT '外勤排班方式子类型',
  `serviceType` varchar(100) DEFAULT NULL COMMENT '服务类型(以逗号隔开)',
  `taskNature` varchar(6) DEFAULT NULL COMMENT '任务性质',
  `urgentLevel` varchar(6) DEFAULT NULL COMMENT '紧急程度',
  `taskContent` varchar(1000) DEFAULT NULL COMMENT '任务内容',
  `province` int(6) DEFAULT NULL COMMENT '任务地址所在省份',
  `city` int(6) DEFAULT NULL COMMENT '任务地址所在城市',
  `area` int(6) DEFAULT NULL COMMENT '任务地址所在区县',
  `taskAddress` varchar(100) DEFAULT NULL COMMENT '任务地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '任务地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '任务地址纬度',
  `taskExactAddress` varchar(100) DEFAULT NULL COMMENT '任务精确地址',
  `execRange` bigint(20) DEFAULT NULL COMMENT '执行范围（单位:米）',
  `taskStatus` varchar(6) DEFAULT NULL COMMENT '任务状态',
  `startDate` date DEFAULT NULL COMMENT '任务开始日期',
  `endDate` date DEFAULT NULL COMMENT '任务截止日期',
  `taskTimeDimension` varchar(6) DEFAULT NULL COMMENT '任务时间维度',
  `perNum` bigint(20) DEFAULT NULL COMMENT '所需人数',
  `comContractId` bigint(20) DEFAULT NULL COMMENT '合同ID',
  `projectLevel` varchar(1) DEFAULT NULL COMMENT '所属项目级别',
  `taskPerInsMode` varchar(6) DEFAULT NULL COMMENT '任务人员投保方式',
  `taskInsSign` varchar(6) DEFAULT NULL COMMENT '任务人员投保标记',
  `pushRange` varchar(6) DEFAULT NULL COMMENT '推送范围(情况以，隔开)',
  `realNameAuthSwitch` varchar(1) DEFAULT NULL COMMENT '任务实名认证开关(1:开,0:关)',
  `perReportSwitch` varchar(1) DEFAULT NULL COMMENT '参与人员上报开关',
  `locusReportSwitch` varchar(1) DEFAULT NULL COMMENT '任务轨迹上报开关',
  `recordAttendSwitch` varchar(1) DEFAULT NULL COMMENT '任务记录考勤开关',
  `recordStepSwitch` varchar(1) DEFAULT NULL COMMENT '任务步数记录开关',
  `chargePerId` bigint(20) DEFAULT NULL COMMENT '任务负责人ID',
  `belogProjectId` bigint(20) DEFAULT NULL COMMENT '所属项目ID',
  `comProjectId` bigint(20) DEFAULT NULL COMMENT '项目ID',
  `cityOrgId` bigint(10) DEFAULT NULL COMMENT '所属市公安机构id',
  `districtOrgId` bigint(10) DEFAULT NULL COMMENT '所属县（区）机构id',
  `policeStationId` bigint(10) DEFAULT NULL COMMENT '所属派出所id',
  `bbdId` bigint(10) DEFAULT NULL COMMENT '百保盾ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comTaskId`),
  KEY `index_com_task_comId` (`comId`),
  KEY `index_com_task_startDate` (`startDate`),
  KEY `index_com_task_comContractId` (`comContractId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务';

-- ----------------------------
-- Records of com_task
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_approve
-- ----------------------------
DROP TABLE IF EXISTS `com_task_approve`;
CREATE TABLE `com_task_approve` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `approveTempId` bigint(20) NOT NULL COMMENT '企业审批模板ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`comTaskId`,`approveTempId`),
  KEY `index_com_task_approve_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务审批关联表';

-- ----------------------------
-- Records of com_task_approve
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_attend_address
-- ----------------------------
DROP TABLE IF EXISTS `com_task_attend_address`;
CREATE TABLE `com_task_attend_address` (
  `taskAttendAddressId` bigint(20) NOT NULL COMMENT '任务考勤地址ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `address` varchar(100) DEFAULT NULL COMMENT '考勤地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '考勤地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '考勤地址纬度',
  `addressRange` bigint(20) DEFAULT NULL COMMENT '考勤范围（米为单位）',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskAttendAddressId`),
  KEY `index_com_task_attend_address_comId` (`comId`),
  KEY `index_com_task_attend_address_comTaskId` (`comTaskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务考勤地址';

-- ----------------------------
-- Records of com_task_attend_address
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_attend_wifi
-- ----------------------------
DROP TABLE IF EXISTS `com_task_attend_wifi`;
CREATE TABLE `com_task_attend_wifi` (
  `taskAttendWifiId` bigint(20) NOT NULL COMMENT '考勤WIFIID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `wifiName` varchar(20) DEFAULT NULL COMMENT 'WIFI名称',
  `macAddress` varchar(50) DEFAULT NULL COMMENT 'MAC地址',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskAttendWifiId`),
  KEY `index_com_task_attend_wifi_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务考勤WIFI';

-- ----------------------------
-- Records of com_task_attend_wifi
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_behalf
-- ----------------------------
DROP TABLE IF EXISTS `com_task_behalf`;
CREATE TABLE `com_task_behalf` (
  `taskBehalfId` bigint(20) NOT NULL COMMENT '任务代班记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `behalfDate` date DEFAULT NULL COMMENT '代班日期',
  `behalfPerId` bigint(20) NOT NULL COMMENT '代班人员ID',
  `beBehalfPerId` bigint(20) NOT NULL COMMENT '被代班人员ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  `approveApplyId` bigint(20) DEFAULT NULL COMMENT '审批ID',
  PRIMARY KEY (`taskBehalfId`),
  KEY `index_com_task_behalf_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务代班记录';

-- ----------------------------
-- Records of com_task_behalf
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_charge_record
-- ----------------------------
DROP TABLE IF EXISTS `com_task_charge_record`;
CREATE TABLE `com_task_charge_record` (
  `comTaskChargeRecordId` bigint(20) NOT NULL COMMENT '任务负责人记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `startTime` datetime DEFAULT NULL COMMENT '负责开始时间',
  `endTime` datetime DEFAULT NULL COMMENT '负责结束时间',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `chargePerId` bigint(20) NOT NULL COMMENT '任务负责人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comTaskChargeRecordId`),
  KEY `index_com_task_charge_record_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务负责人记录';

-- ----------------------------
-- Records of com_task_charge_record
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_cycle_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_task_cycle_shift`;
CREATE TABLE `com_task_cycle_shift` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `whatDay` int(1) NOT NULL COMMENT '第几天',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `taskSchedulCycleId` bigint(20) NOT NULL COMMENT '任务排班周期ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`taskSchedulCycleId`,`whatDay`),
  KEY `index_com_task_cycle_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务排班周期所选班次';

-- ----------------------------
-- Records of com_task_cycle_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_feedback
-- ----------------------------
DROP TABLE IF EXISTS `com_task_feedback`;
CREATE TABLE `com_task_feedback` (
  `taskFeedbackId` bigint(20) NOT NULL COMMENT '任务反馈记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `feedbackDates` date DEFAULT NULL COMMENT '反馈日期',
  `feedbackContent` longtext COMMENT '任务反馈内容',
  `imageUrl` varchar(500) DEFAULT NULL COMMENT '反馈图片url',
  `feedbackPerId` bigint(20) NOT NULL COMMENT '反馈人员ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `taskImplementId` bigint(20) NOT NULL COMMENT '任务执行情况ID',
  `dutyState` varchar(6) DEFAULT NULL COMMENT '值班状态（1正常2离岗）',
  `leaveType` varchar(6) DEFAULT NULL COMMENT '离岗原因类别（1执行紧急任务2提前完成任务3请假4其他）',
  `leaveComment` varchar(1000) DEFAULT NULL COMMENT '离岗原因',
  PRIMARY KEY (`taskFeedbackId`),
  KEY `index_com_task_feedback_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务反馈记录';

-- ----------------------------
-- Records of com_task_feedback
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_fixed
-- ----------------------------
DROP TABLE IF EXISTS `com_task_fixed`;
CREATE TABLE `com_task_fixed` (
  `taskFixedId` bigint(20) NOT NULL COMMENT '任务固定班制ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`taskFixedId`),
  KEY `index_com_task_fixed_comTaskId` (`comTaskId`),
  KEY `index_com_task_fixed_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务固定班制明细';

-- ----------------------------
-- Records of com_task_fixed
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_free
-- ----------------------------
DROP TABLE IF EXISTS `com_task_free`;
CREATE TABLE `com_task_free` (
  `taskFreeId` bigint(20) NOT NULL COMMENT '任务固定班制ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `startTime` time DEFAULT NULL COMMENT '考勤时间起点',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskFreeId`),
  KEY `index_com_task_free_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务自由工时明细';

-- ----------------------------
-- Records of com_task_free
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_implement
-- ----------------------------
DROP TABLE IF EXISTS `com_task_implement`;
CREATE TABLE `com_task_implement` (
  `taskImplementId` bigint(20) NOT NULL COMMENT '任务执行情况ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `dates` date DEFAULT NULL COMMENT '日期',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `attendStatus` varchar(6) DEFAULT NULL COMMENT '上班出勤状态',
  `onClockInTime` datetime DEFAULT NULL COMMENT '上班打卡时间',
  `offAttendStatus` varchar(6) DEFAULT NULL COMMENT '下班出勤状态',
  `offClockInTime` datetime DEFAULT NULL COMMENT '下班打卡时间',
  `attendType` varchar(6) DEFAULT NULL COMMENT '出勤类型',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  PRIMARY KEY (`taskImplementId`),
  KEY `index_com_task_implement` (`comTaskId`,`perId`,`dates`,`shiftId`,`shiftRuleId`),
  KEY `index_com_task_implement_comId` (`comId`),
  KEY `index_com_task_implement_cols2` (`perId`,`dates`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务执行情况表';

-- ----------------------------
-- Records of com_task_implement
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_inside_push
-- ----------------------------
DROP TABLE IF EXISTS `com_task_inside_push`;
CREATE TABLE `com_task_inside_push` (
  `insidePushId` bigint(20) NOT NULL COMMENT '内部推送ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `startDate` date DEFAULT NULL COMMENT '开始日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `pushPerType` varchar(6) DEFAULT NULL COMMENT '内部推送人员类别',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`insidePushId`),
  KEY `index_com_task_inside_push_comId` (`comId`),
  KEY `index_com_task_inside_push_comTaskId` (`comTaskId`),
  KEY `index_com_task_inside_push_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务内部推送';

-- ----------------------------
-- Records of com_task_inside_push
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_mid_control
-- ----------------------------
DROP TABLE IF EXISTS `com_task_mid_control`;
CREATE TABLE `com_task_mid_control` (
  `comTaskMidControlId` bigint(20) NOT NULL COMMENT '任务班次选择校验中间表ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `dates` date DEFAULT NULL COMMENT '日期',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`comTaskMidControlId`),
  KEY `index_com_task_mid_control_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务班次选择校验中间表';

-- ----------------------------
-- Records of com_task_mid_control
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_oper_process
-- ----------------------------
DROP TABLE IF EXISTS `com_task_oper_process`;
CREATE TABLE `com_task_oper_process` (
  `taskOperProcessId` bigint(20) NOT NULL COMMENT '任务操作流程ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `taskOperObject` varchar(6) DEFAULT NULL COMMENT '任务操作对象',
  `taskOperResult` varchar(6) DEFAULT NULL COMMENT '任务操作结果',
  `perId` bigint(20) NOT NULL COMMENT '操作人员ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskOperProcessId`),
  KEY `index_com_task_oper_process_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务操作流程';

-- ----------------------------
-- Records of com_task_oper_process
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_reinforce
-- ----------------------------
DROP TABLE IF EXISTS `com_task_reinforce`;
CREATE TABLE `com_task_reinforce` (
  `taskReinforceId` bigint(20) NOT NULL COMMENT '任务增援记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `reinforceDate` date DEFAULT NULL COMMENT '增援日期',
  `reinforcePerId` bigint(20) NOT NULL COMMENT '增援人员ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  `businessLogId` bigint(20) NOT NULL COMMENT '业务日志ID',
  PRIMARY KEY (`taskReinforceId`),
  KEY `index_com_task_reinforce_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务增援记录';

-- ----------------------------
-- Records of com_task_reinforce
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_schedul
-- ----------------------------
DROP TABLE IF EXISTS `com_task_schedul`;
CREATE TABLE `com_task_schedul` (
  `taskSchedulId` bigint(20) NOT NULL COMMENT '任务排班制ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `schedulDate` date DEFAULT NULL COMMENT '排班日期',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `perId` bigint(20) NOT NULL COMMENT '排班人员ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`taskSchedulId`),
  KEY `index_com_task_schedul_comTaskId` (`comTaskId`),
  KEY `index_com_task_schedul_comId` (`comId`),
  KEY `index_com_task_schedul` (`perId`,`schedulDate`,`shiftId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务排班制明细';

-- ----------------------------
-- Records of com_task_schedul
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_schedul_cycle
-- ----------------------------
DROP TABLE IF EXISTS `com_task_schedul_cycle`;
CREATE TABLE `com_task_schedul_cycle` (
  `taskSchedulCycleId` bigint(20) NOT NULL COMMENT '任务排班周期ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `cycleName` varchar(20) DEFAULT NULL COMMENT '周期名称',
  `startDate` date DEFAULT NULL COMMENT '开始日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `perIds` text COMMENT '人员ID集合',
  `cycleDays` int(3) DEFAULT NULL COMMENT '周期天数',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskSchedulCycleId`),
  KEY `index_com_task_schedul_cycle_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务排班周期';

-- ----------------------------
-- Records of com_task_schedul_cycle
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_task_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_task_shift`;
CREATE TABLE `com_task_shift` (
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  PRIMARY KEY (`comTaskId`,`shiftId`),
  KEY `index_com_task_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务班次范围（排班）';

-- ----------------------------
-- Records of com_task_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task`;
CREATE TABLE `com_temp_task` (
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `taskName` varchar(50) DEFAULT NULL COMMENT '任务名称',
  `taskType` varchar(8) DEFAULT NULL COMMENT '任务类型',
  `taskStationType` varchar(6) DEFAULT NULL COMMENT '驻勤点类型',
  `serviceObject` varchar(100) DEFAULT NULL COMMENT '服务对象',
  `serviceObjectType` varchar(6) DEFAULT NULL COMMENT '服务对象类型',
  `serviceObjectSySituation` varchar(6) DEFAULT NULL COMMENT '服务对象涉外情况',
  `isSecurityImportantUnit` varchar(1) DEFAULT '0' COMMENT '是否治安保卫重点单位',
  `taskContent` varchar(1000) DEFAULT NULL COMMENT '任务内容',
  `province` int(6) DEFAULT NULL COMMENT '任务地址所在省份',
  `city` int(6) DEFAULT NULL COMMENT '任务地址所在城市',
  `area` int(6) DEFAULT NULL COMMENT '任务地址所在区县',
  `taskAddress` varchar(100) DEFAULT NULL COMMENT '任务地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '任务地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '任务地址纬度',
  `execRange` bigint(20) DEFAULT NULL COMMENT '执行范围（单位:米）',
  `taskStatus` varchar(6) DEFAULT NULL COMMENT '任务状态',
  `startDate` date DEFAULT NULL COMMENT '任务开始日期',
  `endDate` date DEFAULT NULL COMMENT '任务截止日期',
  `chargePerId` bigint(20) DEFAULT NULL COMMENT '任务负责人ID',
  `comContractId` bigint(20) NOT NULL COMMENT '企业合同ID',
  `isRelationActivity` varchar(1) DEFAULT NULL COMMENT '是否关联活动',
  `activityNo` varchar(50) DEFAULT NULL COMMENT '活动编号',
  `activityName` varchar(50) DEFAULT NULL COMMENT '活动名称',
  `activityCom` varchar(50) DEFAULT NULL COMMENT '活动企业',
  `isShareTask` varchar(1) DEFAULT NULL COMMENT '是否共享任务',
  `cityOrgId` bigint(10) DEFAULT NULL COMMENT '所属市公安机构id',
  `districtOrgId` bigint(10) DEFAULT NULL COMMENT '所属县（区）机构id',
  `policeStationId` bigint(10) DEFAULT NULL COMMENT '所属派出所id',
  `bbdId` bigint(10) DEFAULT NULL COMMENT '百保盾ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`comTempTaskId`),
  KEY `index_com_temp_task_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务';

-- ----------------------------
-- Records of com_temp_task
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task_attend_address
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task_attend_address`;
CREATE TABLE `com_temp_task_attend_address` (
  `taskAttendAddressId` bigint(20) NOT NULL COMMENT '临保任务考勤地址ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `address` varchar(100) DEFAULT NULL COMMENT '考勤地址',
  `addressLongitude` varchar(50) DEFAULT NULL COMMENT '考勤地址经度',
  `addressLatitude` varchar(50) DEFAULT NULL COMMENT '考勤地址纬度',
  `addressRange` bigint(20) DEFAULT NULL COMMENT '考勤范围（米为单位）',
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  PRIMARY KEY (`taskAttendAddressId`),
  KEY `index_com_temp_task_attend_address_comId` (`comId`),
  KEY `index_com_temp_task_attend_address_comTempTaskId` (`comTempTaskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务考勤地址';

-- ----------------------------
-- Records of com_temp_task_attend_address
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task_per
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task_per`;
CREATE TABLE `com_temp_task_per` (
  `comTempTaskPerId` bigint(20) NOT NULL COMMENT '临保任务人员ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '人员所在企业ID',
  `startDate` date DEFAULT NULL COMMENT '开始日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`comTempTaskPerId`),
  KEY `index_com_temp_task_per_comId` (`comId`),
  KEY `index_com_temp_task_per_comTaskId` (`comTempTaskId`),
  KEY `index_com_temp_task_per_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务人员';

-- ----------------------------
-- Records of com_temp_task_per
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task_share
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task_share`;
CREATE TABLE `com_temp_task_share` (
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  `shareComId` bigint(20) NOT NULL COMMENT '共享企业ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  PRIMARY KEY (`comTempTaskId`,`shareComId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='临保任务共享企业';

-- ----------------------------
-- Records of com_temp_task_share
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task_shift
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task_shift`;
CREATE TABLE `com_temp_task_shift` (
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `shiftName` varchar(20) DEFAULT NULL COMMENT '班次名称',
  `shiftRuleDetail` varchar(500) DEFAULT NULL COMMENT '班次规则详情',
  `effectRule` varchar(6) DEFAULT NULL COMMENT '生效规则',
  `effectStartTime` datetime DEFAULT NULL COMMENT '生效开始时间',
  `effectEndTime` datetime DEFAULT NULL COMMENT '生效截止时间',
  `commutTimes` int(3) DEFAULT NULL COMMENT '每天上下班次数',
  `permitLateUp` int(3) DEFAULT NULL COMMENT '允许迟到时间上限',
  `seriousLateLow` int(3) DEFAULT NULL COMMENT '严重迟到时间下限',
  `absentLow` int(3) DEFAULT NULL COMMENT '旷工时间下限',
  `clockWorkLimit` int(3) DEFAULT NULL COMMENT '打卡时限上限',
  `permitLateSwitch` varchar(1) DEFAULT NULL COMMENT '允许迟到校验开关',
  `seriousLateSwitch` varchar(1) DEFAULT NULL COMMENT '严重迟到校验开关',
  `absentSwitch` varchar(1) DEFAULT NULL COMMENT '旷工校验开关',
  `clockLimitSwitch` varchar(1) DEFAULT NULL COMMENT '打卡时限开关',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `comTempTaskId` bigint(20) NOT NULL COMMENT '临保任务ID',
  PRIMARY KEY (`shiftId`),
  KEY `index_com_temp_task_shift_comId` (`comId`),
  KEY `index_com_temp_task_shift_comTempTaskId` (`comTempTaskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业临保任务班次';

-- ----------------------------
-- Records of com_temp_task_shift
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for com_temp_task_shift_rule
-- ----------------------------
DROP TABLE IF EXISTS `com_temp_task_shift_rule`;
CREATE TABLE `com_temp_task_shift_rule` (
  `shiftRuleId` bigint(20) NOT NULL COMMENT '班次规则ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `commutRound` int(3) DEFAULT NULL COMMENT '上下班第几轮',
  `startWorkTime` time DEFAULT NULL COMMENT '上班时间',
  `endWorkTime` time DEFAULT NULL COMMENT '下班时间',
  `isStartNextDay` varchar(1) DEFAULT '0' COMMENT '上班时间是否是次日',
  `isEndNextDay` varchar(1) DEFAULT '0' COMMENT '下班时间是否是次日',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  PRIMARY KEY (`shiftRuleId`),
  KEY `index_com_temp_task_shift_rule_shiftId` (`shiftId`),
  KEY `index_com_temp_task_shift_rule_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业临保任务班次规则';

-- ----------------------------
-- Records of com_temp_task_shift_rule
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for config_calendar
-- ----------------------------
DROP TABLE IF EXISTS `config_calendar`;
CREATE TABLE `config_calendar` (
  `years` int(4) DEFAULT NULL COMMENT '年度',
  `dates` date NOT NULL COMMENT '日期',
  `weekDay` int(1) DEFAULT NULL COMMENT '星期几',
  `whatWeek` int(1) DEFAULT NULL COMMENT '第几周',
  `isLegalHoliday` varchar(1) DEFAULT NULL COMMENT '是否法定假日',
  `holidayName` varchar(6) DEFAULT NULL COMMENT '节假日名称',
  PRIMARY KEY (`dates`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日历';

-- ----------------------------
-- Records of config_calendar
-- ----------------------------
BEGIN;
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-01', 1, 1, '1', '元旦');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-02', 2, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-03', 3, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-04', 4, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-05', 5, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-06', 6, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-07', 7, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-08', 1, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-09', 2, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-10', 3, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-11', 4, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-12', 5, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-13', 6, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-14', 7, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-15', 1, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-16', 2, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-17', 3, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-18', 4, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-19', 5, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-20', 6, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-21', 7, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-22', 1, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-23', 2, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-24', 3, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-25', 4, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-26', 5, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-27', 6, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-28', 7, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-29', 1, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-30', 2, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-01-31', 3, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-01', 4, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-02', 5, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-03', 6, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-04', 7, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-05', 1, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-06', 2, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-07', 3, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-08', 4, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-09', 5, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-10', 6, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-11', 7, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-12', 1, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-13', 2, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-14', 3, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-15', 4, 7, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-16', 5, 7, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-17', 6, 7, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-18', 7, 7, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-19', 1, 8, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-20', 2, 8, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-21', 3, 8, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-22', 4, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-23', 5, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-24', 6, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-25', 7, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-26', 1, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-27', 2, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-02-28', 3, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-01', 4, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-02', 5, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-03', 6, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-04', 7, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-05', 1, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-06', 2, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-07', 3, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-08', 4, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-09', 5, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-10', 6, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-11', 7, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-12', 1, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-13', 2, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-14', 3, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-15', 4, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-16', 5, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-17', 6, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-18', 7, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-19', 1, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-20', 2, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-21', 3, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-22', 4, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-23', 5, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-24', 6, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-25', 7, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-26', 1, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-27', 2, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-28', 3, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-29', 4, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-30', 5, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-03-31', 6, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-01', 7, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-02', 1, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-03', 2, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-04', 3, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-05', 4, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-06', 5, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-07', 6, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-08', 7, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-09', 1, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-10', 2, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-11', 3, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-12', 4, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-13', 5, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-14', 6, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-15', 7, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-16', 1, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-17', 2, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-18', 3, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-19', 4, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-20', 5, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-21', 6, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-22', 7, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-23', 1, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-24', 2, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-25', 3, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-26', 4, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-27', 5, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-28', 6, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-29', 7, 17, '1', '五一劳动节 ');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-04-30', 1, 18, '1', '五一劳动节 ');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-01', 2, 18, '1', '五一劳动节 ');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-02', 3, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-03', 4, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-04', 5, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-05', 6, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-06', 7, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-07', 1, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-08', 2, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-09', 3, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-10', 4, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-11', 5, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-12', 6, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-13', 7, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-14', 1, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-15', 2, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-16', 3, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-17', 4, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-18', 5, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-19', 6, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-20', 7, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-21', 1, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-22', 2, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-23', 3, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-24', 4, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-25', 5, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-26', 6, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-27', 7, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-28', 1, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-29', 2, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-30', 3, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-05-31', 4, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-01', 5, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-02', 6, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-03', 7, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-04', 1, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-05', 2, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-06', 3, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-07', 4, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-08', 5, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-09', 6, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-10', 7, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-11', 1, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-12', 2, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-13', 3, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-14', 4, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-15', 5, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-16', 6, 24, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-17', 7, 24, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-18', 1, 25, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-19', 2, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-20', 3, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-21', 4, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-22', 5, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-23', 6, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-24', 7, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-25', 1, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-26', 2, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-27', 3, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-28', 4, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-29', 5, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-06-30', 6, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-01', 7, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-02', 1, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-03', 2, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-04', 3, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-05', 4, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-06', 5, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-07', 6, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-08', 7, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-09', 1, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-10', 2, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-11', 3, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-12', 4, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-13', 5, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-14', 6, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-15', 7, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-16', 1, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-17', 2, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-18', 3, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-19', 4, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-20', 5, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-21', 6, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-22', 7, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-23', 1, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-24', 2, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-25', 3, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-26', 4, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-27', 5, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-28', 6, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-29', 7, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-30', 1, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-07-31', 2, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-01', 3, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-02', 4, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-03', 5, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-04', 6, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-05', 7, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-06', 1, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-07', 2, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-08', 3, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-09', 4, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-10', 5, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-11', 6, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-12', 7, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-13', 1, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-14', 2, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-15', 3, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-16', 4, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-17', 5, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-18', 6, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-19', 7, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-20', 1, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-21', 2, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-22', 3, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-23', 4, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-24', 5, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-25', 6, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-26', 7, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-27', 1, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-28', 2, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-29', 3, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-30', 4, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-08-31', 5, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-01', 6, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-02', 7, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-03', 1, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-04', 2, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-05', 3, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-06', 4, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-07', 5, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-08', 6, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-09', 7, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-10', 1, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-11', 2, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-12', 3, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-13', 4, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-14', 5, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-15', 6, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-16', 7, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-17', 1, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-18', 2, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-19', 3, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-20', 4, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-21', 5, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-22', 6, 38, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-23', 7, 38, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-24', 1, 39, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-25', 2, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-26', 3, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-27', 4, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-28', 5, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-29', 6, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-09-30', 7, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-01', 1, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-02', 2, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-03', 3, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-04', 4, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-05', 5, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-06', 6, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-07', 7, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-08', 1, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-09', 2, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-10', 3, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-11', 4, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-12', 5, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-13', 6, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-14', 7, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-15', 1, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-16', 2, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-17', 3, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-18', 4, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-19', 5, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-20', 6, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-21', 7, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-22', 1, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-23', 2, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-24', 3, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-25', 4, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-26', 5, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-27', 6, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-28', 7, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-29', 1, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-30', 2, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-10-31', 3, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-01', 4, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-02', 5, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-03', 6, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-04', 7, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-05', 1, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-06', 2, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-07', 3, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-08', 4, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-09', 5, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-10', 6, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-11', 7, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-12', 1, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-13', 2, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-14', 3, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-15', 4, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-16', 5, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-17', 6, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-18', 7, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-19', 1, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-20', 2, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-21', 3, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-22', 4, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-23', 5, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-24', 6, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-25', 7, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-26', 1, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-27', 2, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-28', 3, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-29', 4, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-11-30', 5, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-01', 6, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-02', 7, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-03', 1, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-04', 2, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-05', 3, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-06', 4, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-07', 5, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-08', 6, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-09', 7, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-10', 1, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-11', 2, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-12', 3, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-13', 4, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-14', 5, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-15', 6, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-16', 7, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-17', 1, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-18', 2, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-19', 3, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-20', 4, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-21', 5, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-22', 6, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-23', 7, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-24', 1, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-25', 2, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-26', 3, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-27', 4, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-28', 5, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-29', 6, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-30', 7, 52, '1', '元旦');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2018, '2018-12-31', 1, 1, '1', '元旦');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-01', 2, 1, '1', '元旦');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-02', 3, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-03', 4, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-04', 5, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-05', 6, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-06', 7, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-07', 1, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-08', 2, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-09', 3, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-10', 4, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-11', 5, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-12', 6, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-13', 7, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-14', 1, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-15', 2, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-16', 3, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-17', 4, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-18', 5, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-19', 6, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-20', 7, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-21', 1, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-22', 2, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-23', 3, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-24', 4, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-25', 5, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-26', 6, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-27', 7, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-28', 1, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-29', 2, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-30', 3, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-01-31', 4, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-01', 5, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-02', 6, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-03', 7, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-04', 1, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-05', 2, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-06', 3, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-07', 4, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-08', 5, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-09', 6, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-10', 7, 6, '1', '春节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-11', 1, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-12', 2, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-13', 3, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-14', 4, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-15', 5, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-16', 6, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-17', 7, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-18', 1, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-19', 2, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-20', 3, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-21', 4, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-22', 5, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-23', 6, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-24', 7, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-25', 1, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-26', 2, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-27', 3, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-02-28', 4, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-01', 5, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-02', 6, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-03', 7, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-04', 1, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-05', 2, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-06', 3, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-07', 4, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-08', 5, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-09', 6, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-10', 7, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-11', 1, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-12', 2, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-13', 3, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-14', 4, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-15', 5, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-16', 6, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-17', 7, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-18', 1, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-19', 2, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-20', 3, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-21', 4, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-22', 5, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-23', 6, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-24', 7, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-25', 1, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-26', 2, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-27', 3, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-28', 4, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-29', 5, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-30', 6, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-03-31', 7, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-01', 1, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-02', 2, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-03', 3, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-04', 4, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-05', 5, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-06', 6, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-07', 7, 14, '1', '清明节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-08', 1, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-09', 2, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-10', 3, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-11', 4, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-12', 5, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-13', 6, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-14', 7, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-15', 1, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-16', 2, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-17', 3, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-18', 4, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-19', 5, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-20', 6, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-21', 7, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-22', 1, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-23', 2, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-24', 3, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-25', 4, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-26', 5, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-27', 6, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-28', 7, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-29', 1, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-04-30', 2, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-01', 3, 18, '1', '劳动节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-02', 4, 18, '1', '劳动节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-03', 5, 18, '1', '劳动节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-04', 6, 18, '1', '劳动节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-05', 7, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-06', 1, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-07', 2, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-08', 3, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-09', 4, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-10', 5, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-11', 6, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-12', 7, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-13', 1, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-14', 2, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-15', 3, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-16', 4, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-17', 5, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-18', 6, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-19', 7, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-20', 1, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-21', 2, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-22', 3, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-23', 4, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-24', 5, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-25', 6, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-26', 7, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-27', 1, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-28', 2, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-29', 3, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-30', 4, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-05-31', 5, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-01', 6, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-02', 7, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-03', 1, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-04', 2, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-05', 3, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-06', 4, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-07', 5, 23, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-08', 6, 23, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-09', 7, 23, '1', '端午节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-10', 1, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-11', 2, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-12', 3, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-13', 4, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-14', 5, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-15', 6, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-16', 7, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-17', 1, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-18', 2, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-19', 3, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-20', 4, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-21', 5, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-22', 6, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-23', 7, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-24', 1, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-25', 2, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-26', 3, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-27', 4, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-28', 5, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-29', 6, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-06-30', 7, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-01', 1, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-02', 2, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-03', 3, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-04', 4, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-05', 5, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-06', 6, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-07', 7, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-08', 1, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-09', 2, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-10', 3, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-11', 4, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-12', 5, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-13', 6, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-14', 7, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-15', 1, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-16', 2, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-17', 3, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-18', 4, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-19', 5, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-20', 6, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-21', 7, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-22', 1, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-23', 2, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-24', 3, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-25', 4, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-26', 5, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-27', 6, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-28', 7, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-29', 1, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-30', 2, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-07-31', 3, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-01', 4, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-02', 5, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-03', 6, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-04', 7, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-05', 1, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-06', 2, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-07', 3, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-08', 4, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-09', 5, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-10', 6, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-11', 7, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-12', 1, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-13', 2, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-14', 3, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-15', 4, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-16', 5, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-17', 6, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-18', 7, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-19', 1, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-20', 2, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-21', 3, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-22', 4, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-23', 5, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-24', 6, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-25', 7, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-26', 1, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-27', 2, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-28', 3, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-29', 4, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-30', 5, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-08-31', 6, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-01', 7, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-02', 1, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-03', 2, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-04', 3, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-05', 4, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-06', 5, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-07', 6, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-08', 7, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-09', 1, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-10', 2, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-11', 3, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-12', 4, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-13', 5, 37, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-14', 6, 37, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-15', 7, 37, '1', '中秋节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-16', 1, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-17', 2, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-18', 3, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-19', 4, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-20', 5, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-21', 6, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-22', 7, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-23', 1, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-24', 2, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-25', 3, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-26', 4, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-27', 5, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-28', 6, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-29', 7, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-09-30', 1, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-01', 2, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-02', 3, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-03', 4, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-04', 5, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-05', 6, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-06', 7, 40, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-07', 1, 41, '1', '国庆节');
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-08', 2, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-09', 3, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-10', 4, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-11', 5, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-12', 6, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-13', 7, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-14', 1, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-15', 2, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-16', 3, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-17', 4, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-18', 5, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-19', 6, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-20', 7, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-21', 1, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-22', 2, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-23', 3, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-24', 4, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-25', 5, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-26', 6, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-27', 7, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-28', 1, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-29', 2, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-30', 3, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-10-31', 4, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-01', 5, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-02', 6, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-03', 7, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-04', 1, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-05', 2, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-06', 3, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-07', 4, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-08', 5, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-09', 6, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-10', 7, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-11', 1, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-12', 2, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-13', 3, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-14', 4, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-15', 5, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-16', 6, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-17', 7, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-18', 1, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-19', 2, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-20', 3, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-21', 4, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-22', 5, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-23', 6, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-24', 7, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-25', 1, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-26', 2, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-27', 3, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-28', 4, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-29', 5, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-11-30', 6, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-01', 7, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-02', 1, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-03', 2, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-04', 3, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-05', 4, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-06', 5, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-07', 6, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-08', 7, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-09', 1, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-10', 2, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-11', 3, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-12', 4, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-13', 5, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-14', 6, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-15', 7, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-16', 1, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-17', 2, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-18', 3, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-19', 4, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-20', 5, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-21', 6, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-22', 7, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-23', 1, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-24', 2, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-25', 3, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-26', 4, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-27', 5, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-28', 6, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-29', 7, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-30', 1, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2019, '2019-12-31', 2, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-01', 3, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-02', 4, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-03', 5, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-04', 6, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-05', 7, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-06', 1, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-07', 2, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-08', 3, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-09', 4, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-10', 5, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-11', 6, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-12', 7, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-13', 1, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-14', 2, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-15', 3, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-16', 4, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-17', 5, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-18', 6, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-19', 7, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-20', 1, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-21', 2, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-22', 3, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-23', 4, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-24', 5, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-25', 6, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-26', 7, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-27', 1, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-28', 2, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-29', 3, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-30', 4, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-01-31', 5, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-01', 6, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-02', 7, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-03', 1, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-04', 2, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-05', 3, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-06', 4, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-07', 5, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-08', 6, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-09', 7, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-10', 1, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-11', 2, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-12', 3, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-13', 4, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-14', 5, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-15', 6, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-16', 7, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-17', 1, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-18', 2, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-19', 3, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-20', 4, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-21', 5, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-22', 6, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-23', 7, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-24', 1, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-25', 2, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-26', 3, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-27', 4, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-28', 5, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-02-29', 6, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-01', 7, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-02', 1, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-03', 2, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-04', 3, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-05', 4, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-06', 5, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-07', 6, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-08', 7, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-09', 1, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-10', 2, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-11', 3, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-12', 4, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-13', 5, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-14', 6, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-15', 7, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-16', 1, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-17', 2, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-18', 3, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-19', 4, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-20', 5, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-21', 6, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-22', 7, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-23', 1, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-24', 2, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-25', 3, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-26', 4, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-27', 5, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-28', 6, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-29', 7, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-30', 1, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-03-31', 2, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-01', 3, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-02', 4, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-03', 5, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-04', 6, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-05', 7, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-06', 1, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-07', 2, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-08', 3, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-09', 4, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-10', 5, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-11', 6, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-12', 7, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-13', 1, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-14', 2, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-15', 3, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-16', 4, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-17', 5, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-18', 6, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-19', 7, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-20', 1, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-21', 2, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-22', 3, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-23', 4, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-24', 5, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-25', 6, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-26', 7, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-27', 1, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-28', 2, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-29', 3, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-04-30', 4, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-01', 5, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-02', 6, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-03', 7, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-04', 1, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-05', 2, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-06', 3, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-07', 4, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-08', 5, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-09', 6, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-10', 7, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-11', 1, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-12', 2, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-13', 3, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-14', 4, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-15', 5, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-16', 6, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-17', 7, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-18', 1, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-19', 2, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-20', 3, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-21', 4, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-22', 5, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-23', 6, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-24', 7, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-25', 1, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-26', 2, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-27', 3, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-28', 4, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-29', 5, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-30', 6, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-05-31', 7, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-01', 1, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-02', 2, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-03', 3, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-04', 4, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-05', 5, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-06', 6, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-07', 7, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-08', 1, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-09', 2, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-10', 3, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-11', 4, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-12', 5, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-13', 6, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-14', 7, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-15', 1, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-16', 2, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-17', 3, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-18', 4, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-19', 5, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-20', 6, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-21', 7, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-22', 1, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-23', 2, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-24', 3, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-25', 4, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-26', 5, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-27', 6, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-28', 7, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-29', 1, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-06-30', 2, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-01', 3, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-02', 4, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-03', 5, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-04', 6, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-05', 7, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-06', 1, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-07', 2, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-08', 3, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-09', 4, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-10', 5, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-11', 6, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-12', 7, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-13', 1, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-14', 2, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-15', 3, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-16', 4, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-17', 5, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-18', 6, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-19', 7, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-20', 1, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-21', 2, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-22', 3, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-23', 4, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-24', 5, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-25', 6, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-26', 7, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-27', 1, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-28', 2, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-29', 3, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-30', 4, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-07-31', 5, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-01', 6, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-02', 7, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-03', 1, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-04', 2, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-05', 3, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-06', 4, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-07', 5, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-08', 6, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-09', 7, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-10', 1, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-11', 2, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-12', 3, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-13', 4, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-14', 5, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-15', 6, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-16', 7, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-17', 1, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-18', 2, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-19', 3, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-20', 4, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-21', 5, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-22', 6, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-23', 7, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-24', 1, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-25', 2, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-26', 3, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-27', 4, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-28', 5, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-29', 6, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-30', 7, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-08-31', 1, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-01', 2, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-02', 3, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-03', 4, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-04', 5, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-05', 6, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-06', 7, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-07', 1, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-08', 2, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-09', 3, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-10', 4, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-11', 5, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-12', 6, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-13', 7, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-14', 1, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-15', 2, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-16', 3, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-17', 4, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-18', 5, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-19', 6, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-20', 7, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-21', 1, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-22', 2, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-23', 3, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-24', 4, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-25', 5, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-26', 6, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-27', 7, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-28', 1, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-29', 2, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-09-30', 3, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-01', 4, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-02', 5, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-03', 6, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-04', 7, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-05', 1, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-06', 2, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-07', 3, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-08', 4, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-09', 5, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-10', 6, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-11', 7, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-12', 1, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-13', 2, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-14', 3, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-15', 4, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-16', 5, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-17', 6, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-18', 7, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-19', 1, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-20', 2, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-21', 3, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-22', 4, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-23', 5, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-24', 6, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-25', 7, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-26', 1, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-27', 2, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-28', 3, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-29', 4, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-30', 5, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-10-31', 6, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-01', 7, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-02', 1, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-03', 2, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-04', 3, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-05', 4, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-06', 5, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-07', 6, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-08', 7, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-09', 1, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-10', 2, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-11', 3, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-12', 4, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-13', 5, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-14', 6, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-15', 7, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-16', 1, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-17', 2, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-18', 3, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-19', 4, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-20', 5, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-21', 6, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-22', 7, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-23', 1, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-24', 2, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-25', 3, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-26', 4, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-27', 5, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-28', 6, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-29', 7, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-11-30', 1, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-01', 2, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-02', 3, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-03', 4, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-04', 5, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-05', 6, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-06', 7, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-07', 1, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-08', 2, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-09', 3, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-10', 4, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-11', 5, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-12', 6, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-13', 7, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-14', 1, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-15', 2, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-16', 3, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-17', 4, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-18', 5, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-19', 6, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-20', 7, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-21', 1, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-22', 2, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-23', 3, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-24', 4, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-25', 5, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-26', 6, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-27', 7, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-28', 1, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-29', 2, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-30', 3, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2020, '2020-12-31', 4, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-01', 5, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-02', 6, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-03', 7, 53, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-04', 1, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-05', 2, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-06', 3, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-07', 4, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-08', 5, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-09', 6, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-10', 7, 1, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-11', 1, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-12', 2, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-13', 3, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-14', 4, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-15', 5, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-16', 6, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-17', 7, 2, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-18', 1, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-19', 2, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-20', 3, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-21', 4, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-22', 5, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-23', 6, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-24', 7, 3, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-25', 1, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-26', 2, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-27', 3, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-28', 4, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-29', 5, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-30', 6, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-01-31', 7, 4, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-01', 1, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-02', 2, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-03', 3, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-04', 4, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-05', 5, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-06', 6, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-07', 7, 5, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-08', 1, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-09', 2, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-10', 3, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-11', 4, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-12', 5, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-13', 6, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-14', 7, 6, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-15', 1, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-16', 2, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-17', 3, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-18', 4, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-19', 5, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-20', 6, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-21', 7, 7, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-22', 1, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-23', 2, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-24', 3, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-25', 4, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-26', 5, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-27', 6, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-02-28', 7, 8, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-01', 1, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-02', 2, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-03', 3, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-04', 4, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-05', 5, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-06', 6, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-07', 7, 9, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-08', 1, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-09', 2, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-10', 3, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-11', 4, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-12', 5, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-13', 6, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-14', 7, 10, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-15', 1, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-16', 2, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-17', 3, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-18', 4, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-19', 5, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-20', 6, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-21', 7, 11, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-22', 1, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-23', 2, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-24', 3, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-25', 4, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-26', 5, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-27', 6, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-28', 7, 12, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-29', 1, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-30', 2, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-03-31', 3, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-01', 4, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-02', 5, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-03', 6, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-04', 7, 13, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-05', 1, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-06', 2, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-07', 3, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-08', 4, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-09', 5, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-10', 6, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-11', 7, 14, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-12', 1, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-13', 2, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-14', 3, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-15', 4, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-16', 5, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-17', 6, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-18', 7, 15, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-19', 1, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-20', 2, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-21', 3, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-22', 4, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-23', 5, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-24', 6, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-25', 7, 16, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-26', 1, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-27', 2, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-28', 3, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-29', 4, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-04-30', 5, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-01', 6, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-02', 7, 17, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-03', 1, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-04', 2, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-05', 3, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-06', 4, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-07', 5, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-08', 6, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-09', 7, 18, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-10', 1, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-11', 2, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-12', 3, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-13', 4, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-14', 5, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-15', 6, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-16', 7, 19, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-17', 1, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-18', 2, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-19', 3, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-20', 4, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-21', 5, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-22', 6, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-23', 7, 20, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-24', 1, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-25', 2, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-26', 3, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-27', 4, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-28', 5, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-29', 6, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-30', 7, 21, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-05-31', 1, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-01', 2, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-02', 3, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-03', 4, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-04', 5, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-05', 6, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-06', 7, 22, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-07', 1, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-08', 2, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-09', 3, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-10', 4, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-11', 5, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-12', 6, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-13', 7, 23, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-14', 1, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-15', 2, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-16', 3, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-17', 4, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-18', 5, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-19', 6, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-20', 7, 24, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-21', 1, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-22', 2, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-23', 3, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-24', 4, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-25', 5, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-26', 6, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-27', 7, 25, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-28', 1, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-29', 2, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-06-30', 3, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-01', 4, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-02', 5, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-03', 6, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-04', 7, 26, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-05', 1, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-06', 2, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-07', 3, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-08', 4, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-09', 5, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-10', 6, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-11', 7, 27, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-12', 1, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-13', 2, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-14', 3, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-15', 4, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-16', 5, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-17', 6, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-18', 7, 28, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-19', 1, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-20', 2, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-21', 3, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-22', 4, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-23', 5, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-24', 6, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-25', 7, 29, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-26', 1, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-27', 2, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-28', 3, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-29', 4, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-30', 5, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-07-31', 6, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-01', 7, 30, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-02', 1, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-03', 2, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-04', 3, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-05', 4, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-06', 5, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-07', 6, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-08', 7, 31, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-09', 1, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-10', 2, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-11', 3, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-12', 4, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-13', 5, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-14', 6, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-15', 7, 32, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-16', 1, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-17', 2, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-18', 3, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-19', 4, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-20', 5, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-21', 6, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-22', 7, 33, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-23', 1, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-24', 2, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-25', 3, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-26', 4, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-27', 5, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-28', 6, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-29', 7, 34, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-30', 1, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-08-31', 2, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-01', 3, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-02', 4, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-03', 5, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-04', 6, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-05', 7, 35, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-06', 1, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-07', 2, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-08', 3, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-09', 4, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-10', 5, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-11', 6, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-12', 7, 36, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-13', 1, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-14', 2, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-15', 3, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-16', 4, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-17', 5, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-18', 6, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-19', 7, 37, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-20', 1, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-21', 2, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-22', 3, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-23', 4, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-24', 5, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-25', 6, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-26', 7, 38, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-27', 1, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-28', 2, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-29', 3, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-09-30', 4, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-01', 5, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-02', 6, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-03', 7, 39, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-04', 1, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-05', 2, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-06', 3, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-07', 4, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-08', 5, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-09', 6, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-10', 7, 40, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-11', 1, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-12', 2, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-13', 3, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-14', 4, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-15', 5, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-16', 6, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-17', 7, 41, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-18', 1, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-19', 2, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-20', 3, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-21', 4, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-22', 5, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-23', 6, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-24', 7, 42, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-25', 1, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-26', 2, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-27', 3, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-28', 4, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-29', 5, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-30', 6, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-10-31', 7, 43, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-01', 1, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-02', 2, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-03', 3, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-04', 4, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-05', 5, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-06', 6, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-07', 7, 44, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-08', 1, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-09', 2, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-10', 3, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-11', 4, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-12', 5, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-13', 6, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-14', 7, 45, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-15', 1, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-16', 2, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-17', 3, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-18', 4, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-19', 5, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-20', 6, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-21', 7, 46, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-22', 1, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-23', 2, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-24', 3, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-25', 4, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-26', 5, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-27', 6, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-28', 7, 47, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-29', 1, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-11-30', 2, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-01', 3, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-02', 4, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-03', 5, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-04', 6, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-05', 7, 48, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-06', 1, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-07', 2, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-08', 3, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-09', 4, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-10', 5, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-11', 6, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-12', 7, 49, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-13', 1, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-14', 2, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-15', 3, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-16', 4, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-17', 5, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-18', 6, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-19', 7, 50, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-20', 1, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-21', 2, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-22', 3, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-23', 4, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-24', 5, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-25', 6, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-26', 7, 51, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-27', 1, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-28', 2, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-29', 3, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-30', 4, 52, '0', NULL);
INSERT INTO `config_calendar` (`years`, `dates`, `weekDay`, `whatWeek`, `isLegalHoliday`, `holidayName`) VALUES (2021, '2021-12-31', 5, 52, '0', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_com_branch
-- ----------------------------
DROP TABLE IF EXISTS `config_com_branch`;
CREATE TABLE `config_com_branch` (
  `provinceId` int(6) NOT NULL COMMENT '省份ID',
  `provinceName` varchar(20) DEFAULT NULL COMMENT '省份名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否启用',
  `seq` int(3) DEFAULT NULL COMMENT '排序',
  `isNeedPoliceRecord` varchar(1) DEFAULT NULL COMMENT '是否需要公安备案',
  PRIMARY KEY (`provinceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分公司备案配置';

-- ----------------------------
-- Records of config_com_branch
-- ----------------------------
BEGIN;
INSERT INTO `config_com_branch` (`provinceId`, `provinceName`, `isActive`, `seq`, `isNeedPoliceRecord`) VALUES (110000, '北京市', '1', 1, '1');
INSERT INTO `config_com_branch` (`provinceId`, `provinceName`, `isActive`, `seq`, `isNeedPoliceRecord`) VALUES (450000, '广西壮族自治区', '1', 2, '1');
INSERT INTO `config_com_branch` (`provinceId`, `provinceName`, `isActive`, `seq`, `isNeedPoliceRecord`) VALUES (610000, '陕西省', '1', 3, '0');
INSERT INTO `config_com_branch` (`provinceId`, `provinceName`, `isActive`, `seq`, `isNeedPoliceRecord`) VALUES (640000, '宁夏回族自治区', '1', 4, '1');
INSERT INTO `config_com_branch` (`provinceId`, `provinceName`, `isActive`, `seq`, `isNeedPoliceRecord`) VALUES (650000, '新疆', '1', 5, '1');
COMMIT;

-- ----------------------------
-- Table structure for config_com_industry
-- ----------------------------
DROP TABLE IF EXISTS `config_com_industry`;
CREATE TABLE `config_com_industry` (
  `industryType` varchar(6) NOT NULL COMMENT '行业类别',
  `institutionType` varchar(6) NOT NULL COMMENT '机构类型',
  `fieldCode` varchar(40) NOT NULL COMMENT '字段编码',
  `fieldName` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `isRequired` varchar(1) DEFAULT NULL COMMENT '是否必录',
  `isEdit` varchar(1) DEFAULT NULL COMMENT '是否可编辑',
  `isHidden` varchar(1) DEFAULT NULL COMMENT '是否隐藏',
  `seq` int(4) DEFAULT NULL COMMENT '顺序',
  `fieldType` varchar(2) DEFAULT NULL COMMENT '字段类型',
  `tips` varchar(100) DEFAULT NULL COMMENT '提示',
  `fieldOptions` varchar(500) DEFAULT NULL,
  `maxLength` varchar(4) DEFAULT NULL COMMENT '最大长度',
  `scriptEvent` varchar(200) DEFAULT NULL COMMENT '脚本事件',
  `scriptFunction` varchar(4000) DEFAULT NULL COMMENT '脚本方法',
  PRIMARY KEY (`institutionType`,`fieldCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业行业信息配置';

-- ----------------------------
-- Records of config_com_industry
-- ----------------------------
BEGIN;
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_activityArea', '活动区域', '1', '1', '0', 8, '1', NULL, NULL, '50', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_businessOrg', '业务主管单位', '1', '1', '0', 9, '1', NULL, NULL, '20', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_businessScope', '业务范围', '1', '1', '0', 1, '10', NULL, NULL, '500', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_effectEndDate', '生效结束日期', '1', '1', '0', 6, '9', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_effectStartDate', '生效开始日期', '1', '1', '0', 5, '9', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_legalRepName', '法定代表人', '1', '1', '0', 7, '1', NULL, NULL, '20', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_licenceDate', '发证日期', '1', '1', '0', 4, '3', NULL, NULL, NULL, NULL, '(rule, value, callback) => {\r\n                if (!value) {\r\n                  return callback();\r\n                }\r\n                const selectDate = value[\'_d\'] && moment(value[\'_d\']).format(\'YYYY-MM-DD\');\r\n                const currentDate = moment().format(\'YYYY-MM-DD\');\r\n                if (selectDate > currentDate) {\r\n                  callback(\"所选日期不能大于当前日期！\");\r\n                }\r\n                callback();\r\n              }');
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_licenceOrg', '发证机关名称', '1', '1', '0', 3, '1', NULL, NULL, '50', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_registrationNum', '统一社会信用代码', '1', '1', '0', 2, '1', NULL, NULL, '20', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'conf_socialOrgCerUrl', '社会团体法人登记证书', '1', '1', '0', 10, '8', '支持JPEG、JPG、PNG、BMP格式', NULL, NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_armedLevel', '武装押运守护评定等级', '1', '1', '0', 4, '4', NULL, '0:无,1:一级,2:二级,3:三级', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_association', '所属行业保安协会', '1', '1', '0', 1, '5', NULL, '0:无,1:中国保安协会,2:省保安协会,3:市保安协会', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_licenceDate', '发证日期', '1', '1', '0', 10, '3', NULL, NULL, NULL, NULL, '(rule, value, callback) => {\r\n                if (!value) {\r\n                  return callback();\r\n                }\r\n                const selectDate = value[\'_d\'] && moment(value[\'_d\']).format(\'YYYY-MM-DD\');\r\n                const currentDate = moment().format(\'YYYY-MM-DD\');\r\n                if (selectDate > currentDate) {\r\n                  callback(\"所选日期不能大于当前日期！\");\r\n                }\r\n                callback();\r\n              }');
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_licenceOrg', '发证机关名称', '1', '1', '0', 9, '1', NULL, NULL, '50', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_manpowerLevel', '人力防范评定等级', '1', '1', '0', 3, '4', NULL, '0:无,1:一级,2:二级,3:三级,4:准三级', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_riskLevel', '是否有风险评估资质', '1', '1', '0', 6, '4', NULL, '0:否,1:是', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_safeRange', '经营范围', '1', '1', '0', 2, '5', NULL, '1:门卫,2:巡逻,3:守护,4:随身护卫,6:武装押运,7:安全检查,8:安全风险评估,9:安全技术防范,10:区域秩序维护', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_safeTechLevel', '安全技术防范评定等级', '1', '1', '0', 5, '4', NULL, '0:无,1:一级,2:二级,3:三级', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_securityLicenseNum', '保安服务许可证号', '1', '1', '0', 7, '1', NULL, NULL, '20', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_securityLicenseUrl', '保安服务许可证', '1', '1', '0', 8, '8', '支持JPEG、JPG、PNG、BMP格式', '', NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_securityPerNum', '保安员人数', '1', '1', '0', 12, '2', NULL, NULL, '6', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'conf_totalPerNum', '企业总人数', '1', '1', '0', 11, '2', NULL, NULL, '6', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'conf_licenceDate', '发证日期', '1', '1', '0', 5, '3', NULL, NULL, NULL, NULL, '(rule, value, callback) => {\r\n                if (!value) {\r\n                  return callback();\r\n                }\r\n                const selectDate = value[\'_d\'] && moment(value[\'_d\']).format(\'YYYY-MM-DD\');\r\n                const currentDate = moment().format(\'YYYY-MM-DD\');\r\n                if (selectDate > currentDate) {\r\n                  callback(\"所选日期不能大于当前日期！\");\r\n                }\r\n                callback();\r\n              }');
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'conf_licenceOrg', '发证机关名称', '1', '1', '0', 4, '1', NULL, NULL, '50', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'conf_securityTrainLicenseNum', '保安培训许可证号', '1', '1', '0', 2, '1', NULL, NULL, '20', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'conf_securityTrainLicenseUrl', '保安培训许可证', '1', '1', '0', 3, '8', '支持JPEG、JPG、PNG、BMP格式', NULL, NULL, NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'conf_trainContent', '培训内容', '1', '1', '0', 1, '10', NULL, NULL, '500', NULL, NULL);
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'conf_securityPerNum', '保安员人数', '1', '1', '0', 2, '2', '', '', '6', '', '');
INSERT INTO `config_com_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isEdit`, `isHidden`, `seq`, `fieldType`, `tips`, `fieldOptions`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'conf_totalPerNum', '企业总人数', '0', '1', '0', 1, '2', '', '', '6', '', '');
COMMIT;

-- ----------------------------
-- Table structure for config_dict
-- ----------------------------
DROP TABLE IF EXISTS `config_dict`;
CREATE TABLE `config_dict` (
  `configDictId` int(20) NOT NULL AUTO_INCREMENT COMMENT '代码条目ID',
  `isActive` varchar(1) DEFAULT '1' COMMENT '是否有效',
  `codeType` varchar(30) DEFAULT NULL COMMENT '代码类型',
  `description` varchar(255) DEFAULT NULL COMMENT '代码中文描述',
  `codeValue` varchar(20) DEFAULT NULL COMMENT '代码值',
  `label` varchar(100) DEFAULT NULL COMMENT '代码值中文描述',
  `seq` int(2) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`configDictId`),
  KEY `index_codeType_codeValue` (`codeType`,`codeValue`)
) ENGINE=InnoDB AUTO_INCREMENT=2118 DEFAULT CHARSET=utf8 COMMENT='字典表';

-- ----------------------------
-- Records of config_dict
-- ----------------------------
BEGIN;
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1, '1', 'partyType', '当事人类型', '1', '企业', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2, '1', 'partyType', '当事人类型', '2', '人员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (3, '1', 'lastApprovalFlag', '最后一次审核动作', '1', '审批通过', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (4, '1', 'lastApprovalFlag', '最后一次审核动作', '2', '审核不通过', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (5, '1', 'lastApprovalFlag', '最后一次审核动作', '0', '打回', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (6, '1', 'businessHandlStatus', '业务办理状态', '1', '审核通过', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (7, '1', 'businessHandlStatus', '业务办理状态', '2', '审核不通过', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (8, '1', 'businessHandlStatus', '业务办理状态', '0', '打回', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (9, '1', 'bloodType', '血型', 'A', 'A', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (10, '1', 'bloodType', '血型', 'B', 'B', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (11, '1', 'bloodType', '血型', 'O', 'O', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (12, '1', 'bloodType', '血型', 'AB', 'AB', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (13, '1', 'politicalStatus', '政治面貌', '01', '中共党员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (14, '1', 'politicalStatus', '政治面貌', '02', '中共预备党员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (15, '1', 'politicalStatus', '政治面貌', '03', '共青团员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (16, '1', 'politicalStatus', '政治面貌', '04', '民革会员', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (17, '1', 'politicalStatus', '政治面貌', '05', '民盟盟员', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (18, '1', 'politicalStatus', '政治面貌', '06', '民建会员', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (19, '1', 'politicalStatus', '政治面貌', '07', '民进会员', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (20, '1', 'politicalStatus', '政治面貌', '08', '农工党党员', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (21, '1', 'politicalStatus', '政治面貌', '09', '致公党党员', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (22, '1', 'politicalStatus', '政治面貌', '10', '九三学社社员', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (23, '1', 'politicalStatus', '政治面貌', '11', '台盟盟员', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (24, '1', 'politicalStatus', '政治面貌', '12', '无党派民主人士', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (25, '1', 'politicalStatus', '政治面貌', '13', '群众', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (26, '1', 'maritalStatus', '婚姻状况', '1', '未婚', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (27, '1', 'maritalStatus', '婚姻状况', '2', '已婚', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (28, '1', 'maritalStatus', '婚姻状况', '3', '丧偶', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (29, '1', 'maritalStatus', '婚姻状况', '4', '离婚', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (30, '1', 'maritalStatus', '婚姻状况', '9', '其他', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (31, '1', 'communicatePreStatus', '沟通前状态', '1', '无人接听', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (32, '1', 'communicatePreStatus', '沟通前状态', '2', '停机', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (33, '1', 'communicateStatus', '沟通中状态', '1', '对方态度很好', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (34, '1', 'communicateStatus', '沟通中状态', '2', '对方态度恶劣', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (35, '1', 'communicateAfterStatus', '沟通后状态', '1', '对方考虑', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (36, '1', 'communicateAfterStatus', '沟通后状态', '2', '面试时间冲突', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (37, '1', 'communicateAfterStatus', '沟通后状态', '3', '对方已找到工作', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (38, '1', 'communicateAfterStatus', '沟通后状态', '4', '对方同意面试', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (39, '1', 'agreeInterviewStatus', '同意面试后状态', '1', '没来参加面试', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (40, '1', 'agreeInterviewStatus', '同意面试后状态', '2', '不适合', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (41, '1', 'agreeInterviewStatus', '同意面试后状态', '3', '选定', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (42, '1', 'agreeInterviewStatus', '同意面试后状态', '4', '已面试', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (43, '1', 'experienceType', '经历类别', '01', '教育经历', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (44, '1', 'experienceType', '经历类别', '02', '培训经历', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (45, '1', 'experienceType', '经历类别', '03', '工作经历', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (46, '1', 'experienceType', '经历类别', '04', '实习经历', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (47, '1', 'comSource', '企业来源', '1', '公安导入', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (48, '1', 'comSource', '企业来源', '2', '自主注册', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (49, '1', 'comSource', '企业来源', '3', '邀请码推荐', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (50, '1', 'comSource', '企业来源', '9', '其他', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (51, '1', 'newsScope', '消息范围', '1', '公安消息', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (52, '1', 'newsScope', '消息范围', '2', '平台消息', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (53, '1', 'newsScope', '消息范围', '3', '企业消息', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (54, '1', 'perCerlevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (55, '1', 'perCerlevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (56, '1', 'perCerlevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (57, '1', 'perCerlevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (58, '1', 'perCerlevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (59, '1', 'attendType', '考勤类型', '1', '固定班制', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (60, '1', 'attendType', '考勤类型', '2', '排班制', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (61, '1', 'attendType', '考勤类型', '3', '自由工时', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (62, '1', 'taskNature', '任务性质', '1', '固定', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (63, '1', 'taskNature', '任务性质', '2', '临时', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (64, '1', 'urgentLevel', '紧急程度', '1', '普通', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (65, '1', 'urgentLevel', '紧急程度', '2', '紧急', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (66, '1', 'taskStatus', '任务状态', '0', '未开始', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (67, '1', 'taskStatus', '任务状态', '1', '进行中', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (68, '1', 'taskStatus', '任务状态', '2', '已完成', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (69, '1', 'taskStatus', '任务状态', '3', '已延期', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (70, '1', 'taskStatus', '任务状态', '4', '已取消', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (71, '1', 'taskStatus', '任务状态', '5', '已暂停', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (72, '1', 'taskStatus', '任务状态', '6', '未发布', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (73, '1', 'taskStatus', '任务状态', '7', '已结束', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (74, '1', 'taskLevel', '任务等级', '1', '企业级', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (75, '1', 'taskLevel', '任务等级', '2', '社区级', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (76, '1', 'taskLevel', '任务等级', '3', '区县级', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (77, '1', 'taskLevel', '任务等级', '4', '市级', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (78, '1', 'taskLevel', '任务等级', '5', '省级', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (79, '1', 'taskLevel', '任务等级', '6', '国家级', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (80, '1', 'taskLevel', '任务等级', '7', '国际级', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (81, '1', 'taskTimeDimension', '任务时间维度', '1', '一个月', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (82, '1', 'taskTimeDimension', '任务时间维度', '2', '三个月', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (83, '1', 'taskTimeDimension', '任务时间维度', '3', '半年', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (84, '1', 'taskTimeDimension', '任务时间维度', '4', '一年', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (85, '1', 'taskTimeDimension', '任务时间维度', '5', '永久', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (86, '1', 'pushRange', '推送范围', '1', '内部推送', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (87, '1', 'pushRange', '推送范围', '2', '全网推送', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (88, '1', 'pushPerType', '内部推送人员类别', '1', '参与人员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (89, '1', 'pushPerType', '内部推送人员类别', '2', '抄送人员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (90, '1', 'taskPerInsMode', '任务人员投保方式', '1', '个人购买', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (91, '1', 'taskPerInsMode', '任务人员投保方式', '2', '企业赠送保险', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (92, '1', 'taskPerInsMode', '任务人员投保方式', '9', '无需投保', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (93, '1', 'taskOperObject', '任务操作对象', '1', '任务', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (94, '1', 'taskOperObject', '任务操作对象', '2', '审批', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (95, '1', 'taskOperObject', '任务操作对象', '3', '申请', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (96, '1', 'taskOperObject', '任务操作对象', '4', '项目', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (97, '1', 'taskOperObject', '任务操作对象', '5', '合同', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (98, '1', 'taskOperResult', '任务操作结果', '10', '调整了人员排班', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (99, '1', 'taskOperResult', '任务操作结果', '20', '通过审批', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (100, '1', 'taskOperResult', '任务操作结果', '30', '提交了调班申请', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (101, '1', 'taskOperResult', '任务操作结果', '40', '预览了关联项目', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (102, '1', 'taskOperResult', '任务操作结果', '50', '查阅了关联合同', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (103, '1', 'taskOperResult', '任务操作结果', '60', '查阅了任务', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (104, '1', 'taskOperResult', '任务操作结果', '70', '创建并发布了任务', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (105, '1', 'reviewMark', '复核标志', '0', '未复核', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (106, '1', 'reviewMark', '复核标志', '1', '复核通过', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (107, '1', 'reviewMark', '复核标志', '2', '复核不通过', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (108, '1', 'buyMode', '购买方式', '1', '在线购买', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (109, '1', 'buyMode', '购买方式', '2', '线下购买', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (110, '1', 'tableType', '变更项目所在表类型', '1', '列表', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (111, '1', 'tableType', '变更项目所在表类型', '2', '行表', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (112, '1', 'socialInsType', '社保险种', '110', '养老保险', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (113, '1', 'socialInsType', '社保险种', '210', '失业保险', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (114, '1', 'socialInsType', '社保险种', '310', '医疗保险', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (115, '1', 'socialInsType', '社保险种', '410', '工伤保险', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (116, '1', 'socialInsType', '社保险种', '510', '生育保险', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (117, '1', 'taxPayerType', '增值税纳税人类别', '1', '增值税一般纳税人', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (118, '1', 'taxPayerType', '增值税纳税人类别', '2', '增值税小规模纳税人', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (119, '1', 'contractType', '合同类型', '01', '企业服务合同', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (120, '1', 'contractType', '合同类型', '02', '劳动/劳务合同', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (123, '1', 'comParty', '企业所在方', '1', '甲方', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (124, '1', 'comParty', '企业所在方', '2', '乙方', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (125, '1', 'distributionMode', '发放/结算方式', '1', '小时', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (126, '1', 'distributionMode', '发放/结算方式', '2', '日', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (127, '1', 'distributionMode', '发放/结算方式', '3', '周', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (128, '1', 'distributionMode', '发放/结算方式', '4', '月', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (129, '1', 'distributionMode', '发放/结算方式', '5', '年', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (130, '1', 'economicType', '经济类型', '1', '国有经济', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (131, '1', 'economicType', '经济类型', '2', '集体经济', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (132, '1', 'economicType', '经济类型', '3', '私营经济', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (133, '1', 'economicType', '经济类型', '4', '个体经济', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (134, '1', 'economicType', '经济类型', '5', '联营经济', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (135, '1', 'economicType', '经济类型', '6', '股份制', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (136, '1', 'economicType', '经济类型', '7', '外商投资', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (137, '1', 'economicType', '经济类型', '8', '港澳台投资与其他经济', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (138, '1', 'economicType', '经济类型', '9', '其他经济', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (139, '1', 'industryType', '行业类型', '01', '保安行业', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (140, '1', 'comType', '公司类型', '1', '合资', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (141, '1', 'comType', '公司类型', '2', '独资', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (142, '1', 'comType', '公司类型', '3', '国有', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (143, '1', 'comType', '公司类型', '4', '私营', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (144, '1', 'comType', '公司类型', '5', '全民所有制', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (145, '1', 'comType', '公司类型', '6', '集体所有制', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (146, '1', 'comType', '公司类型', '7', '股份制', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (147, '1', 'comType', '公司类型', '8', '有限责任', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (148, '1', 'comType', '公司类型', '9', '其他', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (149, '1', 'institutionType', '机构类型', '0101', '保安协会', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (150, '1', 'institutionType', '机构类型', '0102', '保安服务公司', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (151, '1', 'institutionType', '机构类型', '0103', '保安培训单位', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (152, '1', 'institutionType', '机构类型', '0104', '自行招用保安单位', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (154, '1', 'comCerType', '企业证件类型', '2', '统一社会信用代码证', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (155, '1', 'manageMode', '经营模式', '1', '合资', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (156, '1', 'manageMode', '经营模式', '2', '合作', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (157, '1', 'manageMode', '经营模式', '3', '独资', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (158, '1', 'idCardType', '身份证件类型', '1', '居民身份证（户口簿）', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (159, '1', 'idCardType_bak', '身份证件类型', '2', '中国人民解放军军官证', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (160, '1', 'idCardType_bak', '身份证件类型', '3', '中国人民武装警察警官证', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (161, '1', 'idCardType_bak', '身份证件类型', '4', '香港特区护照/身份证明', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (162, '1', 'idCardType_bak', '身份证件类型', '5', '澳门特区护照/身份证明', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (163, '1', 'idCardType_bak', '身份证件类型', '6', '台湾居民来往大陆通行证', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (164, '1', 'idCardType_bak', '身份证件类型', '8', '外国人护照', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (165, '1', 'education', '学历', '1', '小学', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (166, '1', 'education', '学历', '2', '初中', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (167, '1', 'education', '学历', '3', '高中', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (168, '1', 'education', '学历', '4', '中专', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (169, '1', 'education', '学历', '5', '大专', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (170, '1', 'education', '学历', '6', '本科', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (171, '1', 'education', '学历', '7', '硕士研究生', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (172, '1', 'education', '学历', '8', '博士', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (173, '1', 'education', '学历', '9', '博士后', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (174, '1', 'positionNature', '职位性质', '1', '全职', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (175, '1', 'positionNature', '职位性质', '2', '兼职', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (176, '1', 'positionNature', '职位性质', '3', '实习', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (177, '1', 'releaseStatus', '发布状态', '0', '未发布', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (178, '1', 'releaseStatus', '发布状态', '1', '开启', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (179, '1', 'releaseStatus', '发布状态', '2', '关闭', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (180, '1', 'salaryType', '薪资类型', '1', '固定薪资', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (181, '1', 'salaryType', '薪资类型', '2', '固定薪资+提成', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (182, '1', 'welfare', '福利', '1', '五险', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (183, '1', 'welfare', '福利', '2', '住房公积金', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (184, '1', 'welfare', '福利', '3', '包吃', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (185, '1', 'welfare', '福利', '4', '包住', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (186, '1', 'welfare', '福利', '5', '加班补助', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (187, '1', 'welfare', '福利', '6', '班车接送', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (188, '1', 'workTimeType', '每天工作时间类型', '0', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (189, '1', 'workTimeType', '每天工作时间类型', '1', '1小时', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (190, '1', 'workTimeType', '每天工作时间类型', '1.5', '1.5小时', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (191, '1', 'workTimeType', '每天工作时间类型', '2', '2小时', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (192, '1', 'workTimeType', '每天工作时间类型', '2.5', '2.5小时', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (193, '1', 'workTimeType', '每天工作时间类型', '3', '3小时', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (194, '1', 'workTimeType', '每天工作时间类型', '3.5', '3.5小时', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (195, '1', 'workTimeType', '每天工作时间类型', '4', '4小时', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (196, '1', 'workTimeType', '每天工作时间类型', '4.5', '4.5小时', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (197, '1', 'workTimeType', '每天工作时间类型', '5', '5小时', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (198, '1', 'workTimeType', '每天工作时间类型', '5.5', '5.5小时', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (199, '1', 'workTimeType', '每天工作时间类型', '6', '6小时', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (200, '1', 'workTimeType', '每天工作时间类型', '6.5', '6.5小时', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (201, '1', 'workTimeType', '每天工作时间类型', '7', '7小时', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (202, '1', 'workTimeType', '每天工作时间类型', '7.5', '7.5小时', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (203, '1', 'workTimeType', '每天工作时间类型', '8', '8小时', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (204, '1', 'workTimeType', '每天工作时间类型', '8.5', '8.5小时', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (205, '1', 'workTimeType', '每天工作时间类型', '9', '9小时', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (206, '1', 'workTimeType', '每天工作时间类型', '9.5', '9.5小时', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (207, '1', 'workTimeType', '每天工作时间类型', '10', '10小时', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (208, '1', 'workTimeType', '每天工作时间类型', '10.5', '10.5小时', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (209, '1', 'workTimeType', '每天工作时间类型', '11', '11小时', 22);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (210, '1', 'workTimeType', '每天工作时间类型', '11.5', '11.5小时', 23);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (211, '1', 'workTimeType', '每天工作时间类型', '12', '12小时', 24);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (212, '1', 'workDayType', '每周工作天数类型', '0', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (213, '1', 'workDayType', '每周工作天数类型', '1', '1天', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (214, '1', 'workDayType', '每周工作天数类型', '2', '2天', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (215, '1', 'workDayType', '每周工作天数类型', '3', '3天', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (216, '1', 'workDayType', '每周工作天数类型', '4', '4天', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (217, '1', 'workDayType', '每周工作天数类型', '5', '5天', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (218, '1', 'workDayType', '每周工作天数类型', '6', '6天', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (219, '1', 'workDayType', '每周工作天数类型', '7', '7天', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (220, '1', 'workLifeType', '工作年限类型', '11', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (221, '1', 'workLifeType', '工作年限类型', '0', '应届', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (222, '1', 'workLifeType', '工作年限类型', '1', '1年以上', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (223, '1', 'workLifeType', '工作年限类型', '2', '2年以上', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (224, '1', 'workLifeType', '工作年限类型', '3', '3年以上', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (225, '1', 'workLifeType', '工作年限类型', '4', '4年以上', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (226, '1', 'workLifeType', '工作年限类型', '5', '5年以上', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (227, '1', 'workLifeType', '工作年限类型', '6', '6年以上', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (228, '1', 'workLifeType', '工作年限类型', '7', '7年以上', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (229, '1', 'workLifeType', '工作年限类型', '8', '8年以上', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (230, '1', 'workLifeType', '工作年限类型', '9', '9年以上', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (231, '1', 'workLifeType', '工作年限类型', '10', '10年以上', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (232, '1', 'educationLow', '最低学历', '0', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (233, '1', 'educationLow', '最低学历', '1', '小学', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (234, '1', 'educationLow', '最低学历', '2', '初中', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (235, '1', 'educationLow', '最低学历', '3', '高中', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (236, '1', 'educationLow', '最低学历', '4', '中专', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (237, '1', 'educationLow', '最低学历', '5', '大专', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (238, '1', 'educationLow', '最低学历', '6', '本科', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (239, '1', 'educationLow', '最低学历', '7', '硕士研究生', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (240, '1', 'educationLow', '最低学历', '8', '博士', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (241, '1', 'educationLow', '最低学历', '9', '博士后', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (242, '1', 'sex', '性别', '1', '男', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (243, '1', 'sex', '性别', '2', '女', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (244, '1', 'sex', '性别', '9', '未说明性别', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (245, '1', 'sexRequire', '性别要求', '0', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (246, '1', 'sexRequire', '性别要求', '1', '男', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (247, '1', 'sexRequire', '性别要求', '2', '女', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (248, '1', 'shareholderType', '股东类别', '1', '自然人股东', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (249, '1', 'shareholderType', '股东类别', '2', '机构股东', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (250, '1', 'contributionMode', '出资方式', '1', '货币', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (251, '1', 'contributionMode', '出资方式', '2', '实物', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (252, '1', 'contributionMode', '出资方式', '3', '知识产权', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (253, '1', 'contributionMode', '出资方式', '4', '土地使用权', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (254, '1', 'stockChangeType', '股权变更类型', '1', '增资', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (255, '1', 'stockChangeType', '股权变更类型', '2', '减资', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (256, '1', 'stockChangeType', '股权变更类型', '3', '股权转让', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (257, '1', 'stockAdjustType', '股权调整类型', '1', '调整金额', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (258, '1', 'stockAdjustType', '股权调整类型', '2', '调整到固定金额', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (259, '1', 'stockAdjustType', '股权调整类型', '3', '调整比例', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (260, '1', 'reportType', '报表类型', '1', '普通报表', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (261, '1', 'reportType', '报表类型', '2', '月度报表', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (262, '1', 'inOutStockType', '出入库类型', '1', '设备出库', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (263, '1', 'inOutStockType', '出入库类型', '2', '设备归还', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (264, '1', 'inOutStockType', '出入库类型', '3', '库存新增', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (265, '1', 'inOutStockType', '出入库类型', '4', '库存损耗', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (266, '1', 'securityRange', '安保范围', '01', '门卫', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (267, '1', 'securityRange', '安保范围', '02', '巡逻', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (268, '1', 'securityRange', '安保范围', '03', '守护', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (269, '1', 'securityRange', '安保范围', '04', '押运', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (270, '1', 'securityRange', '安保范围', '05', '随身护卫', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (271, '1', 'securityRange', '安保范围', '06', '安全检查', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (272, '1', 'securityRange', '安保范围', '07', '区域秩序维护', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (273, '1', 'securityRange', '安保范围', '08', '安全风险评估', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (274, '1', 'securityRange', '安保范围', '09', '安全技术防范', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (275, '1', 'securityRange', '安保范围', '10', '其他', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (276, '1', 'penaltyType', '处罚类型', '01', '警告', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (277, '1', 'penaltyType', '处罚类型', '02', '罚款', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (278, '1', 'penaltyType', '处罚类型', '03', '吊销保安员证', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (279, '1', 'penaltyType', '处罚类型', '04', '受到治安管理处罚', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (280, '1', 'penaltyType', '处罚类型', '05', '没收非法所得', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (281, '1', 'penaltyType', '处罚类型', '06', '追究形式刑责', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (282, '1', 'penaltyType', '处罚类型', '07', '非法培训单位', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (283, '1', 'penaltyType', '处罚类型', '08', '违规培训', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (284, '1', 'penaltyType', '处罚类型', '09', '培训诈骗', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (285, '1', 'penaltyType', '处罚类型', '10', '其他', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (286, '1', 'awardType', '表彰类型', '01', '见义勇为', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (287, '1', 'awardType', '表彰类型', '02', '因公负伤', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (288, '1', 'awardType', '表彰类型', '03', '因公牺牲', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (289, '1', 'awardType', '表彰类型', '04', '先进集体-全国', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (290, '1', 'awardType', '表彰类型', '05', '先进集体-省级', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (291, '1', 'awardType', '表彰类型', '06', '先进个人-全国', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (292, '1', 'awardType', '表彰类型', '07', '先进个人-省级', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (293, '1', 'awardType', '表彰类型', '08', '供破案线索', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (294, '1', 'awardType', '表彰类型', '09', '抓获嫌疑人', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (295, '1', 'awardType', '表彰类型', '10', '预防灾害事故', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (296, '1', 'awardType', '表彰类型', '11', '其他', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (297, '1', 'dataAuthFlag', '数据权限标志', '1', '是', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (298, '1', 'dataAuthFlag', '数据权限标志', '0', '否', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (299, '1', 'regionLevel', '区域级别', '1', '省', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (300, '1', 'regionLevel', '区域级别', '2', '市', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (301, '1', 'regionLevel', '区域级别', '3', '区/县', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (302, '1', 'clientType', '客户端类型', 'web', 'web', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (303, '1', 'clientType', '客户端类型', 'android', 'android', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (304, '1', 'clientType', '客户端类型', 'ios', 'ios', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (305, '1', 'orgType', '组织类型', '1', '公司', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (306, '1', 'orgType', '组织类型', '2', '部门', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (307, '1', 'parentOrgType', '上级组织类型', '1', '公司', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (308, '1', 'parentOrgType', '上级组织类型', '2', '部门', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (309, '1', 'roleType', '角色类型', '1', '主管理员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (310, '1', 'roleType', '角色类型', '2', '子管理员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (311, '1', 'roleType', '角色类型', '3', '部门管理员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (312, '1', 'roleType', '角色类型', '4', '普通', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (313, '1', 'dataAuthType', '角色数据权限类型', '1', '全公司', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (314, '1', 'dataAuthType', '角色数据权限类型', '2', '所在部门', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (315, '1', 'dataAuthType', '角色数据权限类型', '3', '所在部门及下级部门', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (316, '1', 'dataAuthType', '角色数据权限类型', '4', '特定部门', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (317, '1', 'nation', '民族', '01', '汉族', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (318, '1', 'nation', '民族', '02', '蒙古族', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (319, '1', 'nation', '民族', '03', '回族', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (320, '1', 'nation', '民族', '04', '藏族', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (321, '1', 'nation', '民族', '05', '维吾尔族', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (322, '1', 'nation', '民族', '06', '苗族', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (323, '1', 'nation', '民族', '07', '彝族', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (324, '1', 'nation', '民族', '08', '壮族', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (325, '1', 'nation', '民族', '09', '布依族', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (326, '1', 'nation', '民族', '10', '朝鲜族', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (327, '1', 'nation', '民族', '11', '满族', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (328, '1', 'nation', '民族', '12', '侗族', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (329, '1', 'nation', '民族', '13', '瑶族', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (330, '1', 'nation', '民族', '14', '白族', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (331, '1', 'nation', '民族', '15', '土家族', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (332, '1', 'nation', '民族', '16', '哈尼族', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (333, '1', 'nation', '民族', '17', '哈萨克族', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (334, '1', 'nation', '民族', '18', '傣族', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (335, '1', 'nation', '民族', '19', '黎族', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (336, '1', 'nation', '民族', '20', '傈僳族', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (337, '1', 'nation', '民族', '21', '佤族', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (338, '1', 'nation', '民族', '22', '畲族', 22);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (339, '1', 'nation', '民族', '23', '高山族', 23);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (340, '1', 'nation', '民族', '24', '拉祜族', 24);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (341, '1', 'nation', '民族', '25', '水族', 25);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (342, '1', 'nation', '民族', '26', '东乡族', 26);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (343, '1', 'nation', '民族', '27', '纳西族', 27);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (344, '1', 'nation', '民族', '28', '景颇族', 28);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (345, '1', 'nation', '民族', '29', '柯尔克孜族', 29);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (346, '1', 'nation', '民族', '30', '土族', 30);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (347, '1', 'nation', '民族', '31', '达斡尔族', 31);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (348, '1', 'nation', '民族', '32', '仫佬族', 32);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (349, '1', 'nation', '民族', '33', '羌族', 33);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (350, '1', 'nation', '民族', '34', '布朗族', 34);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (351, '1', 'nation', '民族', '35', '撒拉族', 35);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (352, '1', 'nation', '民族', '36', '毛难族', 36);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (353, '1', 'nation', '民族', '37', '仡佬族', 37);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (354, '1', 'nation', '民族', '38', '锡伯族', 38);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (355, '1', 'nation', '民族', '39', '阿昌族', 39);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (356, '1', 'nation', '民族', '40', '普米族', 40);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (357, '1', 'nation', '民族', '41', '塔吉克族', 41);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (358, '1', 'nation', '民族', '42', '怒族', 42);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (359, '1', 'nation', '民族', '43', '乌孜别克族', 43);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (360, '1', 'nation', '民族', '44', '俄罗斯族', 44);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (361, '1', 'nation', '民族', '45', '鄂温克族', 45);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (362, '1', 'nation', '民族', '46', '崩龙族', 46);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (363, '1', 'nation', '民族', '47', '保安族', 47);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (364, '1', 'nation', '民族', '48', '裕固族', 48);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (365, '1', 'nation', '民族', '49', '京族', 49);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (366, '1', 'nation', '民族', '50', '塔塔尔族', 50);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (367, '1', 'nation', '民族', '51', '独龙族', 51);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (368, '1', 'nation', '民族', '52', '鄂伦春族', 52);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (369, '1', 'nation', '民族', '53', '赫哲族', 53);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (370, '1', 'nation', '民族', '54', '门巴族', 54);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (371, '1', 'nation', '民族', '55', '珞巴族', 55);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (372, '1', 'nation', '民族', '56', '基诺族', 56);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (373, '1', 'nation', '民族', '97', '其他', 57);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (374, '1', 'nation', '民族', '98', '外国血统中国籍人士', 58);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (375, '1', 'nationality', '国籍', 'ABW', '阿鲁巴', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (376, '1', 'nationality', '国籍', 'AFG', '阿富汗', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (377, '1', 'nationality', '国籍', 'AGO', '安哥拉', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (378, '1', 'nationality', '国籍', 'AIA', '安圭拉', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (379, '1', 'nationality', '国籍', 'ALB', '阿尔巴尼亚', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (380, '1', 'nationality', '国籍', 'AND', '安道尔', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (381, '1', 'nationality', '国籍', 'ANT', '荷属安的列斯', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (382, '1', 'nationality', '国籍', 'ARE', '阿联酋', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (383, '1', 'nationality', '国籍', 'ARG', '阿根廷', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (384, '1', 'nationality', '国籍', 'ARM', '亚美尼亚', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (385, '1', 'nationality', '国籍', 'ASM', '美属萨摩亚', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (386, '1', 'nationality', '国籍', 'ATA', '南极洲', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (387, '1', 'nationality', '国籍', 'ATF', '法属南部领土', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (388, '1', 'nationality', '国籍', 'ATG', '安提瓜和巴布达', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (389, '1', 'nationality', '国籍', 'AUS', '澳大利亚', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (390, '1', 'nationality', '国籍', 'AUT', '奥地利', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (391, '1', 'nationality', '国籍', 'AZE', '阿塞拜疆', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (392, '1', 'nationality', '国籍', 'BDI', '布隆迪', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (393, '1', 'nationality', '国籍', 'BEL', '比利时', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (394, '1', 'nationality', '国籍', 'BEN', '贝宁', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (395, '1', 'nationality', '国籍', 'BFA', '布基纳法索', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (396, '1', 'nationality', '国籍', 'BGD', '孟加拉国', 22);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (397, '1', 'nationality', '国籍', 'BGR', '保加利亚', 23);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (398, '1', 'nationality', '国籍', 'BHR', '巴林', 24);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (399, '1', 'nationality', '国籍', 'BHS', '巴哈马', 25);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (400, '1', 'nationality', '国籍', 'BIH', '波斯尼亚和黑塞哥维那', 26);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (401, '1', 'nationality', '国籍', 'BLR', '白俄罗斯', 27);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (402, '1', 'nationality', '国籍', 'BLZ', '伯利兹', 28);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (403, '1', 'nationality', '国籍', 'BMU', '百幕大', 29);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (404, '1', 'nationality', '国籍', 'BOL', '玻利维亚', 30);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (405, '1', 'nationality', '国籍', 'BRA', '巴西', 31);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (406, '1', 'nationality', '国籍', 'BRB', '巴巴多斯', 32);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (407, '1', 'nationality', '国籍', 'BRN', '文莱', 33);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (408, '1', 'nationality', '国籍', 'BTN', '不丹', 34);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (409, '1', 'nationality', '国籍', 'BVT', '布维岛', 35);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (410, '1', 'nationality', '国籍', 'BWA', '博茨瓦纳', 36);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (411, '1', 'nationality', '国籍', 'CAF', '中非', 37);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (412, '1', 'nationality', '国籍', 'CAN', '加拿大', 38);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (413, '1', 'nationality', '国籍', 'CCK', '科科斯群岛', 39);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (414, '1', 'nationality', '国籍', 'CHE', '瑞士', 40);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (415, '1', 'nationality', '国籍', 'CHL', '智利', 41);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (416, '1', 'nationality', '国籍', 'CHN', '中国', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (417, '1', 'nationality', '国籍', 'CIV', '科特迪瓦', 43);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (418, '1', 'nationality', '国籍', 'CMR', '喀麦隆', 44);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (419, '1', 'nationality', '国籍', 'COD', '刚果民主共和国', 45);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (420, '1', 'nationality', '国籍', 'COG', '刚果', 46);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (421, '1', 'nationality', '国籍', 'COK', '库克群岛', 47);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (422, '1', 'nationality', '国籍', 'COL', '哥伦比亚', 48);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (423, '1', 'nationality', '国籍', 'COM', '科摩罗', 49);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (424, '1', 'nationality', '国籍', 'CPV', '佛得角', 50);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (425, '1', 'nationality', '国籍', 'CRI', '哥斯达黎加', 51);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (426, '1', 'nationality', '国籍', 'CUB', '古巴', 52);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (427, '1', 'nationality', '国籍', 'CXR', '圣诞岛', 53);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (428, '1', 'nationality', '国籍', 'CYM', '开曼群岛', 54);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (429, '1', 'nationality', '国籍', 'CYP', '塞浦路斯', 55);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (430, '1', 'nationality', '国籍', 'CZE', '捷克', 56);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (431, '1', 'nationality', '国籍', 'DEU', '德国', 57);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (432, '1', 'nationality', '国籍', 'DJI', '吉布提', 58);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (433, '1', 'nationality', '国籍', 'DMA', '多米尼加', 59);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (434, '1', 'nationality', '国籍', 'DNK', '丹麦', 60);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (435, '1', 'nationality', '国籍', 'DOM', '多米尼家共和国', 61);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (436, '1', 'nationality', '国籍', 'DZA', '阿尔及利亚', 62);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (437, '1', 'nationality', '国籍', 'ECU', '厄瓜多尔', 63);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (438, '1', 'nationality', '国籍', 'EGY', '埃及', 64);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (439, '1', 'nationality', '国籍', 'ERI', '厄立特里亚', 65);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (440, '1', 'nationality', '国籍', 'ESH', '西撒哈拉', 66);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (441, '1', 'nationality', '国籍', 'ESP', '西班牙', 67);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (442, '1', 'nationality', '国籍', 'EST', '爱沙尼亚', 68);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (443, '1', 'nationality', '国籍', 'ETH', '埃塞俄比亚', 69);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (444, '1', 'nationality', '国籍', 'FIN', '芬兰', 70);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (445, '1', 'nationality', '国籍', 'FJI', '斐济', 71);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (446, '1', 'nationality', '国籍', 'FLK', '马尔维纳斯群岛', 72);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (447, '1', 'nationality', '国籍', 'FRA', '法国', 73);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (448, '1', 'nationality', '国籍', 'FRO', '法罗群岛', 74);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (449, '1', 'nationality', '国籍', 'FSM', '密克罗尼西亚', 75);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (450, '1', 'nationality', '国籍', 'GAB', '加蓬', 76);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (451, '1', 'nationality', '国籍', 'GBD', '英国（独立领土公民、出国不用）', 77);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (452, '1', 'nationality', '国籍', 'GBN', '英国（海外国民，出国不用）', 78);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (453, '1', 'nationality', '国籍', 'GBO', '英国（海外公民，出国不用）', 79);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (454, '1', 'nationality', '国籍', 'GBP', '英国（保护公民，出国不用）', 80);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (455, '1', 'nationality', '国籍', 'GBR', '英国', 81);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (456, '1', 'nationality', '国籍', 'GBS', '英国（隶属，出国不用）', 82);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (457, '1', 'nationality', '国籍', 'GEO', '格鲁吉亚', 83);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (458, '1', 'nationality', '国籍', 'GHA', '加纳', 84);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (459, '1', 'nationality', '国籍', 'GIB', '直布罗陀', 85);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (460, '1', 'nationality', '国籍', 'GIN', '几内亚', 86);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (461, '1', 'nationality', '国籍', 'GLP', '瓜德罗普', 87);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (462, '1', 'nationality', '国籍', 'GMB', '冈比亚', 88);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (463, '1', 'nationality', '国籍', 'GNB', '几内亚比绍', 89);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (464, '1', 'nationality', '国籍', 'GNQ', '赤道几内亚', 90);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (465, '1', 'nationality', '国籍', 'GRC', '希腊', 91);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (466, '1', 'nationality', '国籍', 'GRD', '格林纳达', 92);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (467, '1', 'nationality', '国籍', 'GRL', '格陵兰', 93);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (468, '1', 'nationality', '国籍', 'GTM', '危地马拉', 94);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (469, '1', 'nationality', '国籍', 'GUF', '法属圭亚那', 95);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (470, '1', 'nationality', '国籍', 'GUM', '关岛', 96);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (471, '1', 'nationality', '国籍', 'GUY', '圭亚那', 97);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (472, '1', 'nationality', '国籍', 'HKG', '中国香港', 98);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (473, '1', 'nationality', '国籍', 'HMD', '赫德岛和麦克唐纳岛', 99);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (474, '1', 'nationality', '国籍', 'HND', '洪都拉斯', 100);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (475, '1', 'nationality', '国籍', 'HRV', '克罗地亚', 101);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (476, '1', 'nationality', '国籍', 'HTI', '海地', 102);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (477, '1', 'nationality', '国籍', 'HUN', '匈牙利', 103);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (478, '1', 'nationality', '国籍', 'IDN', '印度尼西亚', 104);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (479, '1', 'nationality', '国籍', 'IND', '印度', 105);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (480, '1', 'nationality', '国籍', 'IOT', '英属印度洋领土', 106);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (481, '1', 'nationality', '国籍', 'IRL', '爱尔兰', 107);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (482, '1', 'nationality', '国籍', 'IRN', '伊朗', 108);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (483, '1', 'nationality', '国籍', 'IRQ', '伊拉克', 109);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (484, '1', 'nationality', '国籍', 'ISL', '冰岛', 110);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (485, '1', 'nationality', '国籍', 'ISR', '以色列', 111);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (486, '1', 'nationality', '国籍', 'ITA', '意大利', 112);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (487, '1', 'nationality', '国籍', 'JAM', '牙买加', 113);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (488, '1', 'nationality', '国籍', 'JOR', '约旦', 114);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (489, '1', 'nationality', '国籍', 'JPN', '日本', 115);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (490, '1', 'nationality', '国籍', 'JTN', '约翰斯顿岛', 116);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (491, '1', 'nationality', '国籍', 'KAZ', '哈萨克斯坦', 117);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (492, '1', 'nationality', '国籍', 'KEN', '肯尼亚', 118);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (493, '1', 'nationality', '国籍', 'KGZ', '吉尔吉斯斯坦', 119);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (494, '1', 'nationality', '国籍', 'KHM', '柬埔寨', 120);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (495, '1', 'nationality', '国籍', 'KIR', '基里巴斯', 121);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (496, '1', 'nationality', '国籍', 'KNA', '圣基茨和尼维斯', 122);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (497, '1', 'nationality', '国籍', 'KOR', '韩国（南朝鲜）', 123);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (498, '1', 'nationality', '国籍', 'KWT', '科威特', 124);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (499, '1', 'nationality', '国籍', 'LAO', '老挝', 125);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (500, '1', 'nationality', '国籍', 'LBN', '黎巴嫩', 126);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (501, '1', 'nationality', '国籍', 'LBR', '利比里亚', 127);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (502, '1', 'nationality', '国籍', 'LBY', '利比亚', 128);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (503, '1', 'nationality', '国籍', 'LCA', '圣卢西亚', 129);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (504, '1', 'nationality', '国籍', 'LIE', '列支敦土登', 130);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (505, '1', 'nationality', '国籍', 'LKA', '斯里兰卡', 131);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (506, '1', 'nationality', '国籍', 'LSO', '莱索托', 132);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (507, '1', 'nationality', '国籍', 'LTU', '立陶宛', 133);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (508, '1', 'nationality', '国籍', 'LUX', '卢森堡', 134);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (509, '1', 'nationality', '国籍', 'LVA', '拉脱维亚', 135);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (510, '1', 'nationality', '国籍', 'MAC', '中国澳门', 136);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (511, '1', 'nationality', '国籍', 'MAR', '摩洛哥', 137);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (512, '1', 'nationality', '国籍', 'MCO', '摩纳哥', 138);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (513, '1', 'nationality', '国籍', 'MDA', '摩尔多瓦', 139);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (514, '1', 'nationality', '国籍', 'MDG', '马达加斯加', 140);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (515, '1', 'nationality', '国籍', 'MDV', '马尔代夫', 141);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (516, '1', 'nationality', '国籍', 'MEX', '墨西哥', 142);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (517, '1', 'nationality', '国籍', 'MHL', '马绍尔群岛', 143);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (518, '1', 'nationality', '国籍', 'MID', '中途岛', 144);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (519, '1', 'nationality', '国籍', 'MKD', '马其顿', 145);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (520, '1', 'nationality', '国籍', 'MLI', '马里', 146);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (521, '1', 'nationality', '国籍', 'MLT', '马耳他', 147);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (522, '1', 'nationality', '国籍', 'MMR', '缅甸', 148);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (523, '1', 'nationality', '国籍', 'MNG', '蒙古', 149);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (524, '1', 'nationality', '国籍', 'MNP', '北马里亚纳', 150);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (525, '1', 'nationality', '国籍', 'MOZ', '莫桑比克', 151);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (526, '1', 'nationality', '国籍', 'MRT', '毛里塔尼亚', 152);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (527, '1', 'nationality', '国籍', 'MSR', '蒙特塞拉特', 153);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (528, '1', 'nationality', '国籍', 'MTQ', '马提尼克', 154);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (529, '1', 'nationality', '国籍', 'MUS', '毛里求斯', 155);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (530, '1', 'nationality', '国籍', 'MWI', '马拉维', 156);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (531, '1', 'nationality', '国籍', 'MYS', '马来西亚', 157);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (532, '1', 'nationality', '国籍', 'MYT', '马约特', 158);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (533, '1', 'nationality', '国籍', 'NAM', '纳米比亚', 159);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (534, '1', 'nationality', '国籍', 'NCL', '新喀里多尼亚', 160);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (535, '1', 'nationality', '国籍', 'NER', '尼日尔', 161);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (536, '1', 'nationality', '国籍', 'NFK', '诺福克岛', 162);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (537, '1', 'nationality', '国籍', 'NGA', '尼日利亚', 163);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (538, '1', 'nationality', '国籍', 'NIC', '尼加拉瓜', 164);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (539, '1', 'nationality', '国籍', 'NIU', '纽埃', 165);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (540, '1', 'nationality', '国籍', 'NLD', '荷兰', 166);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (541, '1', 'nationality', '国籍', 'NOR', '挪威', 167);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (542, '1', 'nationality', '国籍', 'NPL', '尼波尔', 168);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (543, '1', 'nationality', '国籍', 'NRU', '瑙鲁', 169);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (544, '1', 'nationality', '国籍', 'NTZ', '中间地带', 170);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (545, '1', 'nationality', '国籍', 'NZL', '新西兰', 171);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (546, '1', 'nationality', '国籍', 'OMN', '阿曼', 172);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (547, '1', 'nationality', '国籍', 'PAK', '巴基斯坦', 173);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (548, '1', 'nationality', '国籍', 'PAN', '巴拿马', 174);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (549, '1', 'nationality', '国籍', 'PCN', '皮特凯恩群岛', 175);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (550, '1', 'nationality', '国籍', 'PER', '秘鲁', 176);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (551, '1', 'nationality', '国籍', 'PHL', '菲律宾', 177);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (552, '1', 'nationality', '国籍', 'PLW', '贝劳', 178);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (553, '1', 'nationality', '国籍', 'PNG', '巴布亚新几内亚', 179);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (554, '1', 'nationality', '国籍', 'POL', '波兰', 180);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (555, '1', 'nationality', '国籍', 'PRI', '波多黎各', 181);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (556, '1', 'nationality', '国籍', 'PRK', '朝鲜', 182);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (557, '1', 'nationality', '国籍', 'PRT', '葡萄牙', 183);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (558, '1', 'nationality', '国籍', 'PRY', '巴拉圭', 184);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (559, '1', 'nationality', '国籍', 'PST', '巴勒斯坦', 185);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (560, '1', 'nationality', '国籍', 'PYF', '法属菠利尼西亚', 186);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (561, '1', 'nationality', '国籍', 'QAT', '卡塔尔', 187);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (562, '1', 'nationality', '国籍', 'REU', '留尼汪', 188);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (563, '1', 'nationality', '国籍', 'ROM', '罗马尼亚', 189);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (564, '1', 'nationality', '国籍', 'RUS', '俄罗斯', 190);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (565, '1', 'nationality', '国籍', 'RWA', '卢旺达', 191);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (566, '1', 'nationality', '国籍', 'SAU', '沙特阿拉伯', 192);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (567, '1', 'nationality', '国籍', 'SDN', '苏丹', 193);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (568, '1', 'nationality', '国籍', 'SEN', '塞内加尔', 194);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (569, '1', 'nationality', '国籍', 'SF', '塞尔维亚', 195);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (570, '1', 'nationality', '国籍', 'SGP', '新加坡', 196);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (571, '1', 'nationality', '国籍', 'SGS', '南乔治亚岛和南桑德韦奇岛', 197);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (572, '1', 'nationality', '国籍', 'SHN', '圣赫勒拿', 198);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (573, '1', 'nationality', '国籍', 'SJM', '斯瓦尔巴群岛', 199);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (574, '1', 'nationality', '国籍', 'SLB', '所罗门群岛', 200);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (575, '1', 'nationality', '国籍', 'SLE', '塞拉利昂', 201);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (576, '1', 'nationality', '国籍', 'SLV', '萨尔瓦多', 202);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (577, '1', 'nationality', '国籍', 'SMR', '圣马力诺', 203);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (578, '1', 'nationality', '国籍', 'SOM', '索马里', 204);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (579, '1', 'nationality', '国籍', 'SPM', '圣皮埃尔和密克隆', 205);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (580, '1', 'nationality', '国籍', 'SS', '塞班', 206);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (581, '1', 'nationality', '国籍', 'STP', '圣多美和普林西比', 207);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (582, '1', 'nationality', '国籍', 'SUR', '苏里南', 208);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (583, '1', 'nationality', '国籍', 'SVK', '斯洛伐克', 209);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (584, '1', 'nationality', '国籍', 'SVN', '斯洛文尼亚', 210);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (585, '1', 'nationality', '国籍', 'SWE', '瑞典', 211);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (586, '1', 'nationality', '国籍', 'SWZ', '斯威士兰', 212);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (587, '1', 'nationality', '国籍', 'SX', '锡金', 213);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (588, '1', 'nationality', '国籍', 'SYC', '塞舌尔', 214);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (589, '1', 'nationality', '国籍', 'SYR', '叙利亚', 215);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (590, '1', 'nationality', '国籍', 'TCA', '特克斯和凯科斯群岛', 216);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (591, '1', 'nationality', '国籍', 'TCD', '乍得', 217);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (592, '1', 'nationality', '国籍', 'TGO', '多哥', 218);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (593, '1', 'nationality', '国籍', 'THA', '泰国', 219);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (594, '1', 'nationality', '国籍', 'TJK', '塔吉克斯坦', 220);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (595, '1', 'nationality', '国籍', 'TKL', '托克劳', 221);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (596, '1', 'nationality', '国籍', 'TKM', '土库曼斯坦', 222);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (597, '1', 'nationality', '国籍', 'TMP', '东帝汶', 223);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (598, '1', 'nationality', '国籍', 'TON', '汤加', 224);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (599, '1', 'nationality', '国籍', 'TTO', '特立尼达和多巴哥', 225);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (600, '1', 'nationality', '国籍', 'TUN', '突尼斯', 226);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (601, '1', 'nationality', '国籍', 'TUR', '土耳其', 227);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (602, '1', 'nationality', '国籍', 'TUV', '图瓦卢', 228);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (603, '1', 'nationality', '国籍', 'TWN', '中国台湾', 229);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (604, '1', 'nationality', '国籍', 'TZA', '坦桑尼亚', 230);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (605, '1', 'nationality', '国籍', 'UGA', '乌干达', 231);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (606, '1', 'nationality', '国籍', 'UKR', '乌克兰', 232);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (607, '1', 'nationality', '国籍', 'UMI', '美属太平洋各群岛', 233);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (608, '1', 'nationality', '国籍', 'UN', '联合国', 234);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (611, '1', 'nationality', '国籍', 'URY', '乌拉圭', 237);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (612, '1', 'nationality', '国籍', 'USA', '美国', 238);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (613, '1', 'nationality', '国籍', 'UZB', '乌兹别克斯坦', 239);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (614, '1', 'nationality', '国籍', 'VAT', '梵蒂冈', 240);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (615, '1', 'nationality', '国籍', 'VCT', '圣文森特和格林纳丁斯', 241);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (616, '1', 'nationality', '国籍', 'VEN', '委内瑞拉', 242);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (617, '1', 'nationality', '国籍', 'VGB', '英属维尔京群岛', 243);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (618, '1', 'nationality', '国籍', 'VIR', '美属维尔京群岛', 244);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (619, '1', 'nationality', '国籍', 'VNM', '越南', 245);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (620, '1', 'nationality', '国籍', 'VUT', '瓦努阿图', 246);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (621, '1', 'nationality', '国籍', 'WAK', '威克岛', 247);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (622, '1', 'nationality', '国籍', 'WLF', '瓦利斯和富图纳群岛', 248);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (623, '1', 'nationality', '国籍', 'WSM', '西萨摩亚', 249);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (624, '1', 'nationality', '国籍', 'XXA', '无国籍（无国籍人）', 250);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (625, '1', 'nationality', '国籍', 'XXB', '无国籍（难民）', 251);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (626, '1', 'nationality', '国籍', 'XXX', '无国籍（未声明国籍）', 252);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (627, '1', 'nationality', '国籍', 'YEM', '也门', 253);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (628, '1', 'nationality', '国籍', 'YUG', '南斯拉夫', 254);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (629, '1', 'nationality', '国籍', 'ZAF', '南非', 255);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (630, '1', 'nationality', '国籍', 'ZAR', '扎伊尔', 256);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (631, '1', 'nationality', '国籍', 'ZMB', '赞比亚', 257);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (632, '1', 'nationality', '国籍', 'ZWE', '津巴布韦', 258);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (633, '1', 'nationality', '国籍', 'ZZZ', '国籍不详', 259);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (634, '1', 'shiftType', '班次类型', '1', '考勤班次', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (635, '1', 'shiftType', '班次类型', '2', '任务班次', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (636, '1', 'effectRule', '生效规则', '1', '今日生效', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (637, '1', 'effectRule', '生效规则', '2', '明日生效', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (638, '1', 'equipType', '设备类型', '1', '安防器械', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (639, '1', 'equipType', '设备类型', '2', '防护装备', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (640, '1', 'equipType', '设备类型', '3', '安检排爆', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (641, '1', 'equipType', '设备类型', '4', '通信设备', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (642, '1', 'equipType', '设备类型', '5', '消防救援', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (643, '1', 'equipType', '设备类型', '6', '道路管理', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (644, '1', 'equipType', '设备类型', '7', '监控设备', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (645, '1', 'equipType', '设备类型', '8', '交通工具', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (646, '1', 'equipType', '设备类型', '9', '其他设备', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (647, '1', 'fieldType', '字段类型', '1', '单文本输入框', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (648, '1', 'fieldType', '字段类型', '2', '数字框', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (649, '1', 'fieldType', '字段类型', '3', '日期', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (650, '1', 'fieldType', '字段类型', '4', '下拉框', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (651, '1', 'fieldType', '字段类型', '5', '多选框', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (652, '1', 'fieldType', '字段类型', '6', '单选框', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (653, '1', 'fieldType', '字段类型', '7', '文件', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (654, '1', 'fieldType', '字段类型', '8', '图片', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (655, '1', 'attendStatus', '出勤状态', '1', '正常', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (656, '1', 'attendStatus', '出勤状态', '2', '迟到', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (657, '1', 'attendStatus', '出勤状态', '3', '早退', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (658, '1', 'attendStatus', '出勤状态', '4', '缺岗', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (659, '1', 'attendStatus', '出勤状态', '5', '漏卡', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (660, '1', 'attendStatus', '出勤状态', '6', '加班', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (661, '1', 'attendStatus', '出勤状态', '7', '请假', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (662, '1', 'attendStatus', '出勤状态', '8', '休息', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (663, '1', 'authType', '认证类型', '1', '公安认证', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (664, '1', 'authType', '认证类型', '2', '工商认证', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (665, '1', 'authType', '认证类型', '3', '平台认证', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (666, '1', 'authStatus', '认证状态', '0', '未认证', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (667, '1', 'authStatus', '认证状态', '2', '认证中', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (668, '1', 'authStatus', '认证状态', '1', '认证通过', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (669, '1', 'authStatus', '认证状态', '3', '认证不通过', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (670, '1', 'shiftStatus', '班次状态', '0', '未开始', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (671, '1', 'shiftStatus', '班次状态', '1', '执行中', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (672, '1', 'shiftStatus', '班次状态', '2', '已完成', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (673, '1', 'shiftStatus', '班次状态', '3', '已暂停', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (674, '1', 'taskInsSign', '任务人员投保标记', '0', '无需投保', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (675, '1', 'taskInsSign', '任务人员投保标记', '1', '已投保', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (676, '1', 'taskInsSign', '任务人员投保标记', '2', '未投保', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (677, '1', 'perSource', '用户来源', '1', '公安导入', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (678, '1', 'perSource', '用户来源', '2', '企业导入', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (679, '1', 'perSource', '用户来源', '3', '自主注册', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (680, '1', 'perSource', '用户来源', '4', '邀请码推荐', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (681, '1', 'perSource', '用户来源', '9', '其他', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (682, '1', 'dataSource', '数据来源', '1', '系统产生', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (683, '1', 'dataSource', '数据来源', '2', '手工导入', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (684, '1', 'conf_armedLevel', '武装押运守护等级', '1', '一级', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (685, '1', 'conf_armedLevel', '武装押运守护等级', '2', '二级', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (686, '1', 'conf_association', '所属行业保安协会', '1', '中国保安协会', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (687, '1', 'conf_association', '所属行业保安协会', '2', '省保安协会', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (688, '1', 'conf_association', '所属行业保安协会', '3', '市保安协会', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (689, '1', 'conf_manpowerLevel', '人力防范等级', '1', '一级', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (690, '1', 'conf_manpowerLevel', '人力防范等级', '2', '二级', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (691, '1', 'conf_manpowerLevel', '人力防范等级', '3', '三级', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (692, '1', 'conf_riskLevel', '是否有风险评估资质', '0', '否', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (693, '1', 'conf_riskLevel', '是否有风险评估资质', '1', '是', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (694, '1', 'conf_safeRange', '安全范围', '1', '门卫', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (695, '1', 'conf_safeRange', '安全范围', '2', '巡逻', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (696, '1', 'conf_safeRange', '安全范围', '3', '守护', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (697, '1', 'conf_safeRange', '安全范围', '4', '随身护卫', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (699, '1', 'conf_safeRange', '安全范围', '6', '武装押运', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (700, '1', 'conf_safeRange', '安全范围', '7', '安全检查', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (701, '1', 'conf_safeRange', '安全范围', '8', '安全风险评估', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (702, '1', 'conf_safeRange', '安全范围', '9', '安全技术防范', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (703, '1', 'conf_safeTechLevel', '安全技术防范等级', '1', '一级', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (704, '1', 'conf_safeTechLevel', '安全技术防范等级', '2', '二级', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (705, '1', 'conf_safeTechLevel', '安全技术防范等级', '3', '三级', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (708, '1', 'roleGroupType', '角色组类型', '1', '默认角色组', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (709, '1', 'roleGroupType', '角色组类型', '2', '普通角色组', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (710, '1', 'controlType', '审批控件类型', 'text', '单行输入框', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (711, '1', 'controlType', '审批控件类型', 'textArea', '多行输入框', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (712, '1', 'controlType', '审批控件类型', 'digital', '数字输入框', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (713, '1', 'controlType', '审批控件类型', 'radio', '单选框', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (714, '1', 'controlType', '审批控件类型', 'checkBox', '多选框', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (715, '1', 'controlType', '审批控件类型', 'date', '日期', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (716, '1', 'controlType', '审批控件类型', 'dateSection', '日期区间', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (717, '1', 'controlType', '审批控件类型', 'img', '图片', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (718, '1', 'controlType', '审批控件类型', 'detail', '添加明细', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (719, '1', 'controlType', '审批控件类型', 'amount', '金额', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (720, '1', 'controlType', '审批控件类型', 'content', '说明文字', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (721, '1', 'controlType', '审批控件类型', 'upload', '上传附件', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (722, '1', 'controlType', '审批控件类型', 'contacts', '联系人', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (723, '1', 'controlType', '审批控件类型', 'address', '地点定位', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (724, '1', 'controlType', '审批控件类型', 'formula', '计算公式', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (725, '1', 'controlType', '审批控件类型', 'exterContacts', '外部联系人', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (726, '1', 'clockInOnwer', '打卡归属', '1', '考勤打卡', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (727, '1', 'clockInOnwer', '打卡归属', '2', '任务打卡', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (728, '1', 'clockInType', '打卡类别', '1', '上班打卡', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (729, '1', 'clockInType', '打卡类别', '2', '下班打卡', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (730, '1', 'clockInWay', '打卡方式', '1', 'wifi打卡', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (731, '1', 'clockInWay', '打卡方式', '2', '地点打卡', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (739, '1', 'visibleType', '可见类型', '1', '全部可见', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (740, '1', 'visibleType', '可见类型', '2', '部分可见', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (747, '1', 'distinctRule', '审批人去重规则', '1', '不进行审批人去重', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (748, '1', 'distinctRule', '审批人去重规则', '2', '审批人多次出现，仅保留第一次出现的审批环节', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (749, '1', 'distinctRule', '审批人去重规则', '3', '审批人多次出现，仅保留最后一次出现的审批环节', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (750, '1', 'distinctRule', '审批人去重规则', '4', '在审批人连续出现时进行去重处理，仅保留第一次出现的审批环节', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (751, '1', 'noticeCcRule', '通知抄送人规则', '1', '仅全部同意后通知', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (752, '1', 'noticeCcRule', '通知抄送人规则', '2', '仅发起时通知', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (753, '1', 'noticeCcRule', '通知抄送人规则', '3', '发起时和全部同意后均通知', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (754, '1', 'interfaceOperType', '接口操作类型', 'read', '读', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (755, '1', 'interfaceOperType', '接口操作类型', 'write', '写', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (756, '1', 'skillLevel', '职业技能等级', '1', '初级保安员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (757, '1', 'skillLevel', '职业技能等级', '2', '中级保安员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (758, '1', 'skillLevel', '职业技能等级', '3', '高级保安员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (759, '1', 'skillLevel', '职业技能等级', '4', '保安管理师', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (760, '1', 'skillLevel', '职业技能等级', '5', '高级保安管理师', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (761, '1', 'drivingLicenseLevel', '驾照等级', 'A1', 'A1', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (762, '1', 'drivingLicenseLevel', '驾照等级', 'A2', 'A2', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (763, '1', 'drivingLicenseLevel', '驾照等级', 'A3', 'A3', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (764, '1', 'drivingLicenseLevel', '驾照等级', 'B1', 'B1', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (765, '1', 'drivingLicenseLevel', '驾照等级', 'B2', 'B2', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (766, '1', 'drivingLicenseLevel', '驾照等级', 'C1', 'C1', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (767, '1', 'drivingLicenseLevel', '驾照等级', 'C2', 'C2', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (768, '1', 'drivingLicenseLevel', '驾照等级', 'C3', 'C3', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (769, '1', 'drivingLicenseLevel', '驾照等级', 'C4', 'C4', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (770, '1', 'perCerType', '证书类型', '010001', '保安员等级证', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (771, '1', 'perCerType', '证书类型', '010002', '保安员资格证', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (772, '1', 'perCerType', '证书类型', '010003', '持枪证', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (773, '1', 'fieldType', '字段类型', '9', '时间区间', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (782, '1', 'isAppAuth', '是否APP身份认证通过', '0', '未认证', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (783, '1', 'isAppAuth', '是否APP身份认证通过', '1', '已认证', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (784, '1', 'inRoleType', '角色类别', '1', '未知确定1', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (785, '1', 'inRoleType', '角色类别', '2', '未知确定2', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (790, '1', 'commonBoolean', '通用布尔', '1', '是', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (791, '1', 'commonBoolean', '通用布尔', '0', '否', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (792, '1', 'senderType', '发件人类型', '1', '全部', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (793, '1', 'senderType', '发件人类型', '2', '系统', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (794, '1', 'senderType', '发件人类型', '3', '公安', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (795, '1', 'senderType', '发件人类型', '4', '企业', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (796, '1', 'areaAuthType', '角色区域权限类型', '1', '全国', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (797, '1', 'areaAuthType', '角色区域权限类型', '2', '特定地区', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (798, '1', 'platType', '平台类型', 'saas', 'saas', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (799, '1', 'platType', '平台类型', 'bbd', '百保盾', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (800, '1', 'platType', '平台类型', 'pss', 'pss', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (801, '1', 'platType', '平台类型', 'blb', '百联保', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (802, '1', 'platType', '平台类型', 'bkt', '百课堂', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (803, '1', 'policeOrgType', '公安机构类型', '1', '省级', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (804, '1', 'policeOrgType', '公安机构类型', '2', '市级', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (805, '1', 'policeOrgType', '公安机构类型', '3', '区县级', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (806, '1', 'policeOrgType', '公安机构类型', '4', '派出所', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (807, '1', 'policyRequireType', '政策要求', '1', '必须购买保险', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (808, '1', 'policyRequireType', '政策要求', '2', '无要求', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (809, '1', 'insType', '保险种类', '1', '团体意外险', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (810, '1', 'sendCycleType', '发送周期类型', '1', '按次发送', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (811, '1', 'sendCycleType', '发送周期类型', '2', '按周发送', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (812, '1', 'terminalType', '终端类型', '1', 'pc端', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (813, '1', 'terminalType', '终端类型', '2', '移动端', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (814, '1', 'terminalType', '终端类型', '3', 'app端', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (815, '1', 'interfaceExecStatus', '接口执行状态', '0', '执行失败', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (816, '1', 'interfaceExecStatus', '接口执行状态', '1', '执行成功', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (817, '1', 'insBusinessType', '保险审核类型', 'CI0011', '企业线下保险新增', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (818, '1', 'insBusinessType', '保险审核类型', 'CI0012', '企业线下保险维护', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (819, '1', 'isReadStatus', '简历阅读状态', '0', '未读', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (820, '1', 'isReadStatus', '简历阅读状态', '1', '已读', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (822, '1', 'isIncumbency', '在职状态', '0', '待职', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (823, '1', 'isIncumbency', '在职状态', '1', '在职', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (824, '1', 'language', '语言要求', '0', '不限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (825, '1', 'language', '语言要求', '1', '普通语', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (826, '1', 'language', '语言要求', '2', '当地方言', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (827, '1', 'language', '语言要求', '3', '英语', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (828, '1', 'language', '语言要求', '4', '其他语言', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (829, '1', 'terminal', '终端', '0', '全部', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (830, '1', 'terminal', '终端', '1', 'APP', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (831, '1', 'terminal', '终端', '2', 'PC', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (832, '1', 'terminal', '终端', '3', '移动', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (833, '1', 'workYears', '从业年限-年', '1', '1年', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (834, '1', 'workYears', '从业年限-年', '2', '2年', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (835, '1', 'workYears', '从业年限-年', '3', '3年', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (836, '1', 'workYears', '从业年限-年', '4', '4年', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (837, '1', 'workYears', '从业年限-年', '5', '5年', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (838, '1', 'workYears', '从业年限-年', '6', '6年', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (839, '1', 'workYears', '从业年限-年', '7', '7年', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (840, '1', 'workYears', '从业年限-年', '8', '8年', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (841, '1', 'workYears', '从业年限-年', '9', '9年', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (842, '1', 'workYears', '从业年限-年', '10', '10年', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (843, '1', 'workYears', '从业年限-年', '11', '11年', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (844, '1', 'workYears', '从业年限-年', '12', '12年', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (845, '1', 'workYears', '从业年限-年', '13', '13年', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (846, '1', 'workYears', '从业年限-年', '14', '14年', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (847, '1', 'workYears', '从业年限-年', '15', '15年', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (848, '1', 'workYears', '从业年限-年', '16', '16年', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (849, '1', 'workYears', '从业年限-年', '17', '17年', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (850, '1', 'workYears', '从业年限-年', '18', '18年', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (851, '1', 'workYears', '从业年限-年', '19', '19年', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (852, '1', 'workYears', '从业年限-年', '20', '20年', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (853, '1', 'workMonths', '从业年限-月', '1', '1月', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (854, '1', 'workMonths', '从业年限-月', '2', '2月', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (855, '1', 'workMonths', '从业年限-月', '3', '3月', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (856, '1', 'workMonths', '从业年限-月', '4', '4月', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (857, '1', 'workMonths', '从业年限-月', '5', '5月', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (858, '1', 'workMonths', '从业年限-月', '6', '6月', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (859, '1', 'workMonths', '从业年限-月', '7', '7月', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (860, '1', 'workMonths', '从业年限-月', '8', '8月', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (861, '1', 'workMonths', '从业年限-月', '9', '9月', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (862, '1', 'workMonths', '从业年限-月', '10', '10月', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (863, '1', 'workMonths', '从业年限-月', '11', '11月', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (864, '1', 'workMonths', '从业年限-月', '12', '12月', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (865, '1', 'isVeteran', '是否退伍军人', '0', '否', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (866, '1', 'isVeteran', '是否退伍军人', '1', '是', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (867, '1', 'isActiveMarket', '是否激活市场', '0', '否', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (868, '1', 'isActiveMarket', '是否激活市场', '1', '是', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (869, '1', 'transmissionChannel', '发送渠道', '1', '短信', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (870, '1', 'transmissionChannel', '发送渠道', '2', '邮件', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (871, '1', 'transmissionChannel', '发送渠道', '3', '系统通知', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (872, '1', 'appLoginStep', '登陆步骤', '1', '重置密码', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (873, '1', 'appLoginStep', '登陆步骤', '2', '完善信息1', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (874, '1', 'appLoginStep', '登陆步骤', '3', '认证授权', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (875, '1', 'appLoginStep', '登陆步骤', '4', '完善信息2', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (876, '1', 'idCardType_bak', '身份证件类型', '1', '居民身份证（户口簿）', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (877, '1', 'menuType', '菜单类型', '2', '菜单文件夹', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (878, '1', 'menuType', '菜单类型', '0', '菜单', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (879, '1', 'menuType', '菜单类型', '1', '方法', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (880, '1', 'encryType', '加密类型', '1', 'saas加密', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (881, '1', 'encryType', '加密类型', '2', '百保盾加密', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (882, '1', 'education', '学历', '10', '其他', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (883, '1', 'contractStatus', '合同状态', '1', '已签订', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (884, '1', 'contractStatus', '合同状态', '2', '已完成', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (885, '1', 'contractStatus', '合同状态', '3', '已续签', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (886, '1', 'contractStatus', '合同状态', '9', '已终止', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (887, '1', 'drivingLicenseLevel', '驾照等级', '0', '无', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (888, '1', 'bloodType', '血型', 'S', '其它', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (889, '1', 'conf_safeRange', '安全范围', '10', '区域秩序维护', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (890, '1', 'fieldType', '字段类型', '10', '多文本输入框', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (891, '1', 'institutionType', '机构类型', '0105', '保安服务公司及培训单位', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (892, '1', 'approveStatus', '审批状态', '0', '审批中', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (893, '1', 'approveStatus', '审批状态', '1', '审批通过', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (894, '1', 'approveStatus', '审批状态', '2', '审批不通过', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (895, '1', 'approvalAction', '审批动作', '0', '撤销', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (896, '1', 'approvalAction', '审批动作', '1', '同意', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (897, '1', 'remedyMatter', '补卡事项', '1', '上班打卡', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (898, '1', 'remedyMatter', '补卡事项', '2', '下班打卡', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (899, '1', 'leaveType', '请假类型', '1', '事假', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (900, '1', 'leaveType', '请假类型', '2', '病假', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (901, '1', 'leaveType', '请假类型', '3', '年假', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (902, '1', 'leaveType', '请假类型', '4', '婚假', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (903, '1', 'leaveType', '请假类型', '5', '调休', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (904, '1', 'leaveType', '请假类型', '6', '产假', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (905, '1', 'leaveType', '请假类型', '7', '公假', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (906, '1', 'leaveType', '请假类型', '8', '主管假', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (907, '1', 'approvalAction', '审批动作', '2', '不同意', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (908, '1', 'approveStatus', '审批状态', '3', '已撤销', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (909, '1', 'overType', '加班类型', '1', '工作日加班', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (910, '1', 'overType', '加班类型', '2', '休息日加班', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (911, '1', 'overType', '加班类型', '3', '节假日加班', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (912, '1', 'workYears', '从业年限-年', '21', '21年', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (913, '1', 'workYears', '从业年限-年', '22', '22年', 22);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (914, '1', 'workYears', '从业年限-年', '23', '23年', 23);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (915, '1', 'workYears', '从业年限-年', '24', '24年', 24);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (916, '1', 'workYears', '从业年限-年', '25', '25年', 25);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (917, '1', 'workYears', '从业年限-年', '26', '26年', 26);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (918, '1', 'workYears', '从业年限-年', '27', '27年', 27);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (919, '1', 'workYears', '从业年限-年', '28', '28年', 28);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (920, '1', 'workYears', '从业年限-年', '29', '29年', 29);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (921, '1', 'workYears', '从业年限-年', '30', '30年', 30);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (922, '1', 'workYears', '从业年限-年', '31', '31年', 31);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (923, '1', 'workYears', '从业年限-年', '32', '32年', 32);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (924, '1', 'workYears', '从业年限-年', '33', '33年', 33);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (925, '1', 'workYears', '从业年限-年', '34', '34年', 34);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (926, '1', 'workYears', '从业年限-年', '35', '35年', 35);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (927, '1', 'workYears', '从业年限-年', '36', '36年', 36);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (928, '1', 'workYears', '从业年限-年', '37', '37年', 37);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (929, '1', 'workYears', '从业年限-年', '38', '38年', 38);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (930, '1', 'workYears', '从业年限-年', '39', '39年', 39);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (931, '1', 'workYears', '从业年限-年', '40', '40年', 40);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (932, '1', 'workYears', '从业年限-年', '0', '0年', 0);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (933, '1', 'taskAssign', '任务归属', '1', '外勤', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (934, '1', 'taskAssign', '任务归属', '2', '任务', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (935, '1', 'attendSubType', '外勤排班方式子类型', '1', '规律周期排班', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (936, '1', 'attendSubType', '外勤排班方式子类型', '2', '不规律手动排班', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (937, '1', 'appSerType', 'app服务类别', '1', '服务窗', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (938, '1', 'appSerType', 'app服务类别', '2', '服务', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (939, '1', 'perSource', '用户来源', '5', 'osp后台录入', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (940, '1', 'industryType', '行业类型', '02', '大型活动相关行业', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (941, '1', 'inRoleAuthType', '内部角色权限类型', '1', '全部权限', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (942, '1', 'inRoleAuthType', '内部角色权限类型', '2', '查看权限', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (943, '1', 'institutionType', '机构类型', '0201', '风评机构', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (944, '1', 'institutionType', '机构类型', '0202', '承办单位', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (945, '1', 'institutionType', '机构类型', '0203', '政府单位', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (946, '1', 'accountStatus', '核算状态', '0', '待核算', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (947, '1', 'accountStatus', '核算状态', '1', '已核算', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (948, '1', 'institutionType', '机构类型', '0204', '服务机构', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (949, '1', 'socialInsType', '社保险种', '810', '公积金', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (950, '1', 'encryType', '加密类型', '3', 'pss加密', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (951, '1', 'comSource', '企业来源', '4', 'pss迁移', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (952, '1', 'perSource', '用户来源', '6', 'pss迁移', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (953, '1', 'mobileDeviceType', '手机设备类型', '1', 'android', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (954, '1', 'mobileDeviceType', '手机设备类型', '2', 'IOS', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (955, '1', 'appMarketType', 'app市场类型', '1', '全国市场', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (956, '1', 'appMarketType', 'app市场类型', '2', '排除北京市场', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (957, '1', 'appMarketType', 'app市场类型', '3', '北京市场', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (958, '1', 'openAccountStepDesc', '钱包开户步骤描述', '1', '完成开户资料填写', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (960, '1', 'taskStationType', '驻勤点类型', '01', '党政机关', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (961, '1', 'taskStationType', '驻勤点类型', '02', '高等院校', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (962, '1', 'taskStationType', '驻勤点类型', '03', '公交安全', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (963, '1', 'taskStationType', '驻勤点类型', '04', '公园景点', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (964, '1', 'taskStationType', '驻勤点类型', '05', '轨道交通', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (965, '1', 'taskStationType', '驻勤点类型', '06', '金融', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (966, '1', 'taskStationType', '驻勤点类型', '07', '酒店餐饮', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (967, '1', 'taskStationType', '驻勤点类型', '08', '居民社区', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (968, '1', 'taskStationType', '驻勤点类型', '09', '企事业单位', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (969, '1', 'taskStationType', '驻勤点类型', '10', '商市场', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (970, '1', 'taskStationType', '驻勤点类型', '11', '医疗机构', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (971, '1', 'taskStationType', '驻勤点类型', '12', '娱乐场所', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (972, '1', 'taskStationType', '驻勤点类型', '13', '文化/体育/会展中心', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (973, '1', 'taskStationType', '驻勤点类型', '14', '园区', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (974, '1', 'taskStationType', '驻勤点类型', '15', '乡镇街道', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (975, '1', 'taskStationType', '驻勤点类型', '16', '中小学幼儿园', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (976, '1', 'tradeStatus', '交易状态', '0', '待交易', 0);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (977, '1', 'tradeStatus', '交易状态', '1', '交易成功', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (978, '1', 'tradeStatus', '交易状态', '2', '交易失败', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (979, '1', 'tradeType', '交易类型', '01', '企业账户充值', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (980, '1', 'tradeType', '交易类型', '02', '企业账户提现', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (981, '1', 'operGrantFuncType', '操作发放功能类型', '1', '新建发放信息', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (982, '1', 'operGrantFuncType', '操作发放功能类型', '2', '提醒人员开通', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (983, '1', 'operGrantFuncType', '操作发放功能类型', '3', '发放薪资', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (984, '1', 'operGrantFuncType', '操作发放功能类型', '4', '导出发放数据', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (985, '1', 'grantType', '发放类型', '1', '发放到钱包', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (986, '1', 'grantType', '发放类型', '2', '发放到银行卡', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (987, '1', 'grantDataSource', '发放数据来源', '1', '引用薪酬核算', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (988, '1', 'grantDataSource', '发放数据来源', '2', '导入线下数据', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (989, '1', 'allGrantStatus', '总体发放状态', '0', '待发放', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (990, '1', 'allGrantStatus', '总体发放状态', '1', '正在发放', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (991, '1', 'allGrantStatus', '总体发放状态', '2', '部分完成', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (992, '1', 'allGrantStatus', '总体发放状态', '3', '全部完成', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (993, '1', 'grantStatus', '发放状态', '0', '待发放', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (994, '1', 'grantStatus', '发放状态', '1', '发放成功', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (995, '1', 'grantStatus', '发放状态', '2', '发放失败', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (996, '1', 'tradeType', '交易类型', '11', '个人账户充值', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (997, '1', 'tradeType', '交易类型', '12', '企业账户提现', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (998, '1', 'authResultType', '认证结果类型', '01', '认证通过', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (999, '1', 'authResultType', '认证结果类型', '02', '身份证号和姓名不匹配', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1000, '1', 'authResultType', '认证结果类型', '03', '人口库无照片', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1001, '1', 'authResultType', '认证结果类型', '04', '身份证号不存在', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1002, '1', 'collectStatus', '采集状态', '0', '未采集', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1003, '1', 'collectStatus', '采集状态', '1', '已采集', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1004, '1', 'collectStatus', '采集状态', '2', '已推送', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1005, '1', 'limitSeeAppType', '限制查看App通讯录类型', '1', '只能看到自己', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1006, '1', 'limitSeeAppType', '限制查看App通讯录类型', '2', '只能看到所在部门人员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1007, '1', 'limitSeeAppType', '限制查看App通讯录类型', '3', '只能看到所在部门及以下部门人员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1008, '1', 'limitSeeAppType', '限制查看App通讯录类型', '4', '只能看到特定部门', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1009, '1', 'tradeType', '交易类型', '03', '企业账户支付', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1010, '1', 'tradeType', '交易类型', '04', '企业账户金额冻结', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1011, '1', 'tradeType', '交易类型', '05', '企业账户金额解冻', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1012, '1', 'tradeType', '交易类型', '13', '个人账户金额冻结', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1013, '1', 'tradeType', '交易类型', '14', '个人账户金额解冻', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1014, '1', 'appServiceType', 'app服务类型', '1', '原生', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1015, '1', 'appServiceType', 'app服务类型', '2', 'html', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1016, '1', 'appServiceType', 'app服务类型', '3', '外部链接', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1017, '1', 'comWalletChangeType', '企业钱包变更类型', '1', '修改银行卡', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1018, '1', 'bankTradeType', '银行交易类型', '1', '转入', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1019, '1', 'bankTradeType', '银行交易类型', '2', '用户提现', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1020, '1', 'bankTradeType', '银行交易类型', '3', '转出', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1021, '1', 'bankTradeType', '银行交易类型', '4', '代付', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1022, '1', 'bankTradeType', '银行交易类型', '5', '代扣', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1023, '1', 'bankTradeType', '银行交易类型', '6', '退款', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1024, '1', 'bankTradeType', '银行交易类型', '7', '查补', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1025, '1', 'bankTradeType', '银行交易类型', '8', '透传', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1026, '1', 'bankTradeType', '银行交易类型', '9', '消费', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1027, '1', 'bankTradeType', '银行交易类型', '10', '理财专用', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1028, '1', 'bankTradeType', '银行交易类型', '11', '借款', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1029, '1', 'bankTradeType', '银行交易类型', '12', '还款', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1030, '1', 'bankTradeType', '银行交易类型', '13', '存', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1031, '1', 'bankTradeType', '银行交易类型', '14', '取', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1032, '1', 'bankTradeType', '银行交易类型', '15', '主扫', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1033, '1', 'bankTradeType', '银行交易类型', '16', '被扫', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1034, '1', 'bankTradeType', '银行交易类型', '17', '活转定', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1035, '1', 'bankTradeType', '银行交易类型', '18', '定转活', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1036, '1', 'bankTradeType', '银行交易类型', '19', '清算专用', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1037, '1', 'bankTradeType', '银行交易类型', '20', '理财购买', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1038, '1', 'bankTradeType', '银行交易类型', '21', '理财支取', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1039, '1', 'bankTradeType', '银行交易类型', '22', '信用卡还款', 22);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1040, '1', 'bankTradeType', '银行交易类型', '23', '定期还款', 23);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1041, '1', 'bankTradeType', '银行交易类型', '25', '充值', 24);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1042, '1', 'bankTradeType', '银行交易类型', '26', '转账', 25);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1043, '1', 'bankTradeType', '银行交易类型', '27', '入账', 26);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1044, '1', 'bankTradeType', '银行交易类型', '28', '结算提现', 27);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1045, '1', 'bankTradeType', '银行交易类型', '29', '消费', 28);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1046, '1', 'bankTradeType', '银行交易类型', '30', '消费撤销', 29);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1047, '1', 'bankTradeType', '银行交易类型', '31', '冲正', 30);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1048, '1', 'bankTradeType', '银行交易类型', '32', '退款', 31);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1049, '1', 'bankTradeType', '银行交易类型', '33', '白条消费', 32);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1050, '1', 'bankTradeType', '银行交易类型', '34', '手续费消费', 33);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1051, '1', 'bankTradeType', '银行交易类型', '35', '担保交易', 34);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1052, '1', 'bankTradeType', '银行交易类型', '36', '手续费消费分账分润', 35);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1053, '1', 'bankTradeType', '银行交易类型', '37', '撤销', 36);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1054, '1', 'serviceObjectType', '服务对象类型', '01', '广播电台、电视台、通讯社等重要新闻单位', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1055, '1', 'serviceObjectType', '服务对象类型', '02', '机场、港口、大型车站等重要交通枢纽', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1056, '1', 'serviceObjectType', '服务对象类型', '03', '国防科技工业重要产品的研制、 生产单位', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1057, '1', 'serviceObjectType', '服务对象类型', '04', '电信单位、邮政、金融单位', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1058, '1', 'serviceObjectType', '服务对象类型', '05', '大型能源动力设施、水利设施和城市水、电、燃气、 热力供应设施或单位', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1059, '1', 'serviceObjectType', '服务对象类型', '06', '大型物资储备单位和大型商贸中心', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1060, '1', 'serviceObjectType', '服务对象类型', '07', '博物馆、档案馆和重点文物保护单位', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1061, '1', 'serviceObjectType', '服务对象类型', '08', '教育、科研、医疗单位和大型文化、体育场所', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1062, '1', 'serviceObjectType', '服务对象类型', '09', '研制、生产、销售、储存危险物品或者实验、保藏传染性菌种、毒种的单位', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1063, '1', 'serviceObjectType', '服务对象类型', '10', '国家重点建设工程单位', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1064, '1', 'serviceObjectType', '服务对象类型', '11', '宾馆、饭店', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1065, '1', 'serviceObjectType', '服务对象类型', '12', '大学', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1066, '1', 'serviceObjectType', '服务对象类型', '13', '中、小学和幼儿园', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1067, '1', 'serviceObjectType', '服务对象类型', '14', '公园、景区', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1068, '1', 'serviceObjectType', '服务对象类型', '15', '繁华场所和地区', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1069, '1', 'serviceObjectType', '服务对象类型', '16', '物业公司', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1070, '1', 'serviceObjectType', '服务对象类型', '17', '娱乐场所', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1071, '1', 'serviceObjectType', '服务对象类型', '18', '党政机关', 18);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1072, '1', 'serviceObjectType', '服务对象类型', '19', '国有企业', 19);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1073, '1', 'serviceObjectType', '服务对象类型', '20', '涉外机构', 20);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1074, '1', 'serviceObjectType', '服务对象类型', '99', '其他单位', 21);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1076, '1', 'serviceObjectSySituation', '服务对象涉外情况', '01', '中国企业', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1077, '1', 'serviceObjectSySituation', '服务对象涉外情况', '02', '涉日', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1078, '1', 'serviceObjectSySituation', '服务对象涉外情况', '03', '涉美', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1079, '1', 'serviceObjectSySituation', '服务对象涉外情况', '04', '涉韩', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1080, '1', 'serviceObjectSySituation', '服务对象涉外情况', '05', '涉欧', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1081, '1', 'serviceObjectSySituation', '服务对象涉外情况', '06', '涉东南亚', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1082, '1', 'serviceObjectSySituation', '服务对象涉外情况', '07', '涉非', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1083, '1', 'serviceObjectSySituation', '服务对象涉外情况', '08', '涉俄罗斯', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1084, '1', 'serviceObjectSySituation', '服务对象涉外情况', '99', '其他', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1085, '1', 'bizInvoiceType', '开票类型', '1', '我方应开', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1086, '1', 'bizInvoiceType', '开票类型', '2', '我方应收', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1087, '1', 'goodDeedsType', '好人好事类型', '01', '见义勇为', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1088, '1', 'goodDeedsType', '好人好事类型', '02', '尊老爱幼', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1089, '1', 'goodDeedsType', '好人好事类型', '03', '爱岗敬业', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1090, '1', 'goodDeedsType', '好人好事类型', '04', '孝顺爱亲', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1091, '1', 'goodDeedsType', '好人好事类型', '05', '拾金不昧', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1092, '1', 'goodDeedsType', '好人好事类型', '06', '爱国爱党', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1093, '1', 'goodDeedsType', '好人好事类型', '07', '保护环境', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1094, '1', 'goodDeedsType', '好人好事类型', '08', '勤俭节约', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1095, '1', 'goodDeedsType', '好人好事类型', '09', '助人为乐', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1096, '1', 'goodDeedsType', '好人好事类型', '99', '其他', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1097, '1', 'interfaceExecStatus', '接口执行状态', '2', '未执行', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1098, '1', 'bizInvoiceMakeType', '发票类型', '1', '纸质普票', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1099, '1', 'bizInvoiceMakeType', '发票类型', '2', '纸质专票', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1100, '1', 'bizInvoiceMakeType', '发票类型', '3', '电子发票', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1101, '1', 'bktTrackType', '百课堂课程类型', '3', '保安员等级证课程', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1102, '1', 'bktTrackType', '百课堂课程类型', '4', '岗前培训课程', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1103, '1', 'residentType', '户籍类型', '1', '农村', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1104, '1', 'residentType', '户籍类型', '2', '城镇', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1105, '1', 'residentPlaceType', '户籍所在地类型', '1', '本市', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1106, '1', 'residentPlaceType', '户籍所在地类型', '2', '外埠', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1107, '1', 'productBuyMode', '购买方式', '1', '按月计费', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1108, '1', 'productBuyMode', '购买方式', '2', '按年计费', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1109, '1', 'productBuyMode', '购买方式', '3', '一次性计费', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1110, '1', 'productStatus', '产品状态', '0', '下架', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1111, '1', 'productStatus', '产品状态', '1', '上架', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1112, '1', 'productServiceType', '产品服务类型', '1', '会议资源', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1113, '1', 'productServiceType', '产品服务类型', '2', '硬件设备', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1114, '1', 'productServiceType', '产品服务类型', '3', '增值服务', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1115, '1', 'orderStatus', '订单状态', '0', '未支付', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1116, '1', 'orderStatus', '订单状态', '1', '已支付', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1117, '1', 'orderDeployStatus', '订单配置状态', '0', '配置中', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1118, '1', 'orderDeployStatus', '订单配置状态', '1', '配置完成', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2002, '1', 'orderState', '百课堂订单支付状态', '2', '取消', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2003, '1', 'orderState', '百课堂订单支付状态', '3', '撤销', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2004, '1', 'orderState', '百课堂订单支付状态', '0', '未支付', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2005, '1', 'testState', '考试合格状态', '0', '不合格', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2006, '1', 'testState', '考试合格状态', '1', '合格', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2007, '1', 'testState', '考试合格状态', '2', '未考试', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2008, '1', 'testState', '考试合格状态', '3', '全部', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2009, '1', 'orderState', '百课堂订单支付状态', '1', '已支付', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2010, '1', 'refundState', '百课堂退款状态', '0', '申请中', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2011, '1', 'refundState', '百课堂退款状态', '1', '已退款', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2012, '1', 'refundState', '百课堂退款状态', '2', '已拒绝', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2013, '1', 'personType', '人员类型', '1', '外省市来京务工人员', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2014, '1', 'personType', '人员类型', '2', '本市登记失业人员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2015, '1', 'personType', '人员类型', '3', '本市农村转移就业劳动力', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2016, '1', 'personType', '人员类型', '4', '本市应届高校毕业生', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2017, '1', 'personType', '人员类型', '5', '本市复员转业军人-退役士兵', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2018, '1', 'personType', '人员类型', '6', '本市复员转业军人-复员干部', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2019, '1', 'personType', '人员类型', '7', '本市复员转业军人-转业干部', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2020, '1', 'grantDataSource', '发放数据来源', '3', '引用第三方薪酬服务', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2021, '1', 'skillLevel', '职业技能等级', '0', '无', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2022, '1', 'regulatorType', '监管类型', '1', '注册地监管', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2023, '1', 'regulatorType', '监管类型', '2', '办公地监管', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2024, '1', 'grantMode', '发放方式', '1', '银行转账', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2025, '1', 'grantMode', '发放方式', '2', '现金', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2026, '1', 'grantChannel', '发放渠道', '1', '在线发放', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2027, '1', 'grantChannel', '发放渠道', '2', '线下发放', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2028, '1', 'comParty', '企业所在方', '3', '丙方', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2031, '1', 'courseType', '课程产品类型', '1', '保安资格证课程', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2032, '1', 'courseType', '课程产品类型', '2', '继续再教育课程', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2033, '1', 'courseType', '课程产品类型', '3', '保安等级证课程', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2034, '1', 'courseType', '课程产品类型', '4', '岗前培训课程', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2035, '1', 'courseType', '课程产品类型', '9', '其他', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2038, '1', 'mediaType', '媒体形式', '1', '视频', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2039, '1', 'mediaType', '媒体形式', '2', '试题', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2040, '1', 'sellType', '售卖方式', '1', '赠送', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2041, '1', 'sellType', '售卖方式', '2', '购买', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2042, '1', 'conf_armedLevel', '武装押运守护等级', '0', '无', 0);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2043, '1', 'conf_association', '所属行业保安协会', '0', '无', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2044, '1', 'conf_manpowerLevel', '人力防范等级', '0', '无', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2045, '1', 'conf_safeTechLevel', '安全技术防范等级', '0', '无', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2046, '1', 'assignedOrgType', '分配组织类型', '1', '企业', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2047, '1', 'assignedOrgType', '分配组织类型', '2', '公安', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2048, '1', 'purchaseStatus', '资源采购', '0', '未下单', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2049, '1', 'purchaseStatus', '资源采购', '1', '未支付', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2050, '1', 'purchaseStatus', '资源采购', '2', '已支付', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2053, '1', 'industryType', '行业类型', '09', '其他行业', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2054, '1', 'institutionType', '机构类型', '0901', '服务机构', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2055, '1', 'industrytype', '行业类型', '08', '监管行业', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2056, '1', 'institutionType', '机构类型', '0801', '服务机构', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2057, '1', 'appServiceType', 'app服务类型', '4', '带token外部链接', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2058, '1', 'bankAccountStatus', '银行账户状态', '0', '注销', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2059, '1', 'bankAccountStatus', '银行账户状态', '1', '正常', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2060, '1', 'bankAccountType', '银行账户类型', '1', 'I类', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2061, '1', 'bankAccountType', '银行账户类型', '2', 'II类', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2062, '1', 'grantType', '发放类型', '3', '发放到保安员证联名卡', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2063, '1', 'operGrantFuncType', '操作发放功能类型', '5', '添加数据', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2064, '1', 'operGrantFuncType', '操作发放功能类型', '6', '提交发放申请', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2065, '1', 'fmComType', '富民企业类型', '201', '国有企业', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2066, '1', 'fmComType', '富民企业类型', '202', '集体企业', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2067, '1', 'fmComType', '富民企业类型', '203', '股份合作企业', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2068, '1', 'fmComType', '富民企业类型', '204', '联营企业', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2069, '1', 'fmComType', '富民企业类型', '205', '有限责任公司', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2070, '1', 'fmComType', '富民企业类型', '206', '股份有限公司', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2071, '1', 'fmComType', '富民企业类型', '207', '私营企业', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2072, '1', 'fmComType', '富民企业类型', '208', '港、澳、台投资企业', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2073, '1', 'fmComType', '富民企业类型', '209', '外商投资企业', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2074, '1', 'fmComType', '富民企业类型', '210', '个体经营', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2075, '1', 'fmComType', '富民企业类型', '211', '乡镇企业', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2076, '1', 'fmComType', '富民企业类型', '299', '其他', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2077, '1', 'perCerType', '证书类型', '010004', '保安员等级结业证', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2078, '1', 'subsidyType', '补贴类型', '1', '保安员资格证考务补贴', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2079, '1', 'subsidyType', '补贴类型', '2', '职业技能培训补贴', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2080, '1', 'grantType', '发放类型', '4', '发放到渤海银行卡', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2081, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '1', '总经理', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2082, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '2', '副总经理', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2083, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '3', '系统管理员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2084, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '4', '培训负责人', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2085, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '5', '财务负责人', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2086, '1', 'regulatorMeetChargeType', '监管会议负责人类型', '6', '视频会议负责人', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2087, '1', 'discountWay', '优惠方式', '1', '优惠固定金额', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2088, '1', 'discountWay', '优惠方式', '2', '优惠到固定金额', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2089, '1', 'discountWay', '优惠方式', '3', '优惠比例', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2090, '1', 'couponStatus', '优惠券状态', '0', '未使用', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2091, '1', 'couponStatus', '优惠券状态', '1', '已使用', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2092, '1', 'couponStatus', '优惠券状态', '2', '已过期', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2093, '1', 'personType', '人员类型', '8', '退役军人', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2100, '1', 'legalJobCode', '富民职业代码', '0', '国家机关、党群组织、企业、事业单位负责人', 1);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2101, '1', 'legalJobCode', '富民职业代码', '1', '专业技术人员', 2);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2102, '1', 'legalJobCode', '富民职业代码', '3', '政府、事业等公务办事人员', 3);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2103, '1', 'legalJobCode', '富民职业代码', '4', '社会生产服务和生活服务人员', 4);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2104, '1', 'legalJobCode', '富民职业代码', '5', '农、林、牧、渔、水利业生产人员', 5);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2105, '1', 'legalJobCode', '富民职业代码', '6', '生产、加工、制造以及设备操作人员', 6);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2106, '1', 'legalJobCode', '富民职业代码', 'B', '农业技术人员', 7);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2107, '1', 'legalJobCode', '富民职业代码', 'D', '个体业主', 8);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2108, '1', 'legalJobCode', '富民职业代码', 'G', '文化、体育、娱乐从业人员', 9);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2109, '1', 'legalJobCode', '富民职业代码', 'H', '会计师、审计师、评估师等经济专业人员', 10);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2110, '1', 'legalJobCode', '富民职业代码', 'I', '销售、采购、从业人员', 11);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2111, '1', 'legalJobCode', '富民职业代码', 'J', '医疗、卫生从业人员', 12);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2112, '1', 'legalJobCode', '富民职业代码', 'K', '金融从业人员', 13);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2113, '1', 'legalJobCode', '富民职业代码', 'L', '房地产、物业从业人员', 14);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2114, '1', 'legalJobCode', '富民职业代码', 'M', '士兵、军官', 15);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2115, '1', 'legalJobCode', '富民职业代码', 'N', '教育从业人员', 16);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2116, '1', 'legalJobCode', '富民职业代码', 'P', '学生', 17);
INSERT INTO `config_dict` (`configDictId`, `isActive`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2117, '1', 'legalJobCode', '富民职业代码', 'Q', '离、退休人', 18);
COMMIT;

-- ----------------------------
-- Table structure for config_gua_project_dict
-- ----------------------------
DROP TABLE IF EXISTS `config_gua_project_dict`;
CREATE TABLE `config_gua_project_dict` (
  `guaProjectId` int(20) NOT NULL AUTO_INCREMENT,
  `guaProjectName` varchar(60) DEFAULT NULL COMMENT '保障项目名称',
  `guaCategoryCode` varchar(40) DEFAULT NULL COMMENT '保障分类编码',
  `guaCategory` varchar(40) DEFAULT NULL COMMENT '保障项目分类名称',
  `unit` varchar(30) DEFAULT NULL COMMENT '单位',
  `isActive` int(11) DEFAULT '1',
  `guaProjectCode` varchar(60) DEFAULT NULL COMMENT '保障项目编码，预留字段',
  `seq` int(11) DEFAULT NULL COMMENT '顺序',
  PRIMARY KEY (`guaProjectId`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='企业保险-保障项目配置表';

-- ----------------------------
-- Records of config_gua_project_dict
-- ----------------------------
BEGIN;
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (1, '意外身故/伤残', 'YF-BASE', '基础保障', '万元', 1, 'YF-BASE-YWSG-SC', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (2, '意外医疗', 'YF-BASE', '基础保障', '万元', 1, 'YF-BASE-YWYL', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (3, '意外住院津贴', 'YF-BASE', '基础保障', '元/天', 1, 'YF-BASE-ZYJT', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (4, '营运汽车意外伤害', 'YF-TRIFFIC', '交通意外', '万元', 1, 'YF-TRIFFIC-YYQCYWSH', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (5, '轨道列车意外伤害', 'YF-TRIFFIC', '交通意外', '万元', 1, 'YF-TRIFFIC-GDLCYWSH', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (6, '飞机意外伤害', 'YF-TRIFFIC', '交通意外', '万元', 1, 'YF-TRIFFIC-FJYWSH', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (7, '轮船意外伤害', 'YF-TRIFFIC', '交通意外', '万元', 1, 'YF-TRIFFIC-LCYWSH', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (8, '重大疾病', 'YF-HEALTH', '健康险', '万元', 1, 'YF-HEALTH-ZDJB', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (9, '猝死', 'YF-HEALTH', '健康险', '万元', 1, 'YF-HEALTH-CS', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (10, '补充医疗-门急诊', 'YF-HEALTH', '健康险', '万元', 1, 'YF-HEALTH-BCYL-MJZ', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (11, '补充医疗-住院医疗（疾病医疗）', 'YF-HEALTH', '健康险', '万元', 1, 'YF-HEALTH-BCYL-ZYYL', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (12, '意外和疾病身故（定期寿险）', 'YF-OTHER', '其他保障', '万元', 1, 'YF-OTHER-YW-JBSG', NULL);
INSERT INTO `config_gua_project_dict` (`guaProjectId`, `guaProjectName`, `guaCategoryCode`, `guaCategory`, `unit`, `isActive`, `guaProjectCode`, `seq`) VALUES (13, '烈士褒扬金', 'YF-OTHER', '其他保障', '万元', 1, 'YF-OTHER-LSBYJ', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_industry_dict
-- ----------------------------
DROP TABLE IF EXISTS `config_industry_dict`;
CREATE TABLE `config_industry_dict` (
  `industryDictId` int(20) NOT NULL COMMENT '行业代码条目ID',
  `industryType` varchar(6) DEFAULT NULL COMMENT '行业类型',
  `institutionType` varchar(6) DEFAULT NULL COMMENT '机构类型',
  `codeType` varchar(30) DEFAULT NULL COMMENT '代码类型',
  `description` varchar(255) DEFAULT NULL COMMENT '代码中文描述',
  `codeValue` varchar(8) DEFAULT NULL COMMENT '代码值',
  `label` varchar(30) DEFAULT NULL COMMENT '代码值中文描述',
  `seq` int(2) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`industryDictId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='行业字典表';

-- ----------------------------
-- Records of config_industry_dict
-- ----------------------------
BEGIN;
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (1, '01', '0101', 'perType', '人员类型', '010001', '普通保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (2, '01', '0101', 'perType', '人员类型', '010002', '武装押运人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (3, '01', '0101', 'perType', '人员类型', '010003', '内勤人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (4, '01', '0102', 'perType', '人员类型', '010001', '普通保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (5, '01', '0102', 'perType', '人员类型', '010002', '武装押运人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (6, '01', '0102', 'perType', '人员类型', '010003', '内勤人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (7, '01', '0103', 'perType', '人员类型', '010001', '普通保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (8, '01', '0103', 'perType', '人员类型', '010002', '武装押运人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (9, '01', '0103', 'perType', '人员类型', '010003', '内勤人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (10, '01', '0104', 'perType', '人员类型', '010001', '普通保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (11, '01', '0104', 'perType', '人员类型', '010002', '武装押运人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (12, '01', '0104', 'perType', '人员类型', '010003', '内勤人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (13, '01', '0101', 'perCerType', '人员证书类型', '010001', '保安员等级证', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (14, '01', '0101', 'perCerType', '人员证书类型', '010002', '保安员资格证', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (15, '01', '0101', 'perCerType', '人员证书类型', '010003', '持枪证', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (16, '01', '0102', 'perCerType', '人员证书类型', '010001', '保安员等级证', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (17, '01', '0102', 'perCerType', '人员证书类型', '010002', '保安员资格证', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (18, '01', '0102', 'perCerType', '人员证书类型', '010003', '持枪证', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (19, '01', '0103', 'perCerType', '人员证书类型', '010001', '保安员等级证', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (20, '01', '0103', 'perCerType', '人员证书类型', '010002', '保安员资格证', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (21, '01', '0103', 'perCerType', '人员证书类型', '010003', '持枪证', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (22, '01', '0104', 'perCerType', '人员证书类型', '010001', '保安员等级证', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (23, '01', '0104', 'perCerType', '人员证书类型', '010002', '保安员资格证', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (24, '01', '0104', 'perCerType', '人员证书类型', '010003', '持枪证', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (25, '01', '0101', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (26, '01', '0101', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (27, '01', '0101', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (28, '01', '0101', 'jobSkillLevel', '职业技能等级', '010004', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (29, '01', '0101', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (30, '01', '0102', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (31, '01', '0102', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (32, '01', '0102', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (33, '01', '0102', 'jobSkillLevel', '职业技能等级', '010004', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (34, '01', '0102', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (35, '01', '0103', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (36, '01', '0103', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (37, '01', '0103', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (38, '01', '0103', 'jobSkillLevel', '职业技能等级', '010004', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (39, '01', '0103', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (40, '01', '0104', 'jobSkillLevel', '职业技能等级', '010001', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (41, '01', '0104', 'jobSkillLevel', '职业技能等级', '010002', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (42, '01', '0104', 'jobSkillLevel', '职业技能等级', '010003', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (43, '01', '0104', 'jobSkillLevel', '职业技能等级', '010004', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (44, '01', '0104', 'jobSkillLevel', '职业技能等级', '010005', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (65, '01', '0101', 'serviceType', '服务类型', '010001', '技防', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (66, '01', '0101', 'serviceType', '服务类型', '010002', '人防', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (67, '01', '0101', 'serviceType', '服务类型', '010003', '随身护卫', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (68, '01', '0101', 'serviceType', '服务类型', '010004', '安全检查', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (69, '01', '0101', 'serviceType', '服务类型', '010009', '其他', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (70, '01', '0102', 'serviceType', '服务类型', '010001', '技防', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (71, '01', '0102', 'serviceType', '服务类型', '010002', '人防', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (72, '01', '0102', 'serviceType', '服务类型', '010003', '随身护卫', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (73, '01', '0102', 'serviceType', '服务类型', '010004', '安全检查', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (74, '01', '0102', 'serviceType', '服务类型', '010009', '其他', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (75, '01', '0103', 'serviceType', '服务类型', '010001', '技防', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (76, '01', '0103', 'serviceType', '服务类型', '010002', '人防', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (77, '01', '0103', 'serviceType', '服务类型', '010003', '随身护卫', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (78, '01', '0103', 'serviceType', '服务类型', '010004', '安全检查', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (79, '01', '0103', 'serviceType', '服务类型', '010009', '其他', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (80, '01', '0104', 'serviceType', '服务类型', '010001', '技防', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (81, '01', '0104', 'serviceType', '服务类型', '010002', '人防', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (82, '01', '0104', 'serviceType', '服务类型', '010003', '随身护卫', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (83, '01', '0104', 'serviceType', '服务类型', '010004', '安全检查', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (84, '01', '0104', 'serviceType', '服务类型', '010009', '其他', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (85, '01', '0105', 'serviceType', '服务类型', '010001', '技防', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (86, '01', '0105', 'serviceType', '服务类型', '010002', '人防', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (87, '01', '0105', 'serviceType', '服务类型', '010003', '随身护卫', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (88, '01', '0105', 'serviceType', '服务类型', '010004', '安全检查', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (89, '01', '0105', 'serviceType', '服务类型', '010009', '其他', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (90, '01', '0105', 'perType', '人员类型', '010001', '普通保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (91, '01', '0105', 'perType', '人员类型', '010002', '武装押运人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (92, '01', '0105', 'perType', '人员类型', '010003', '内勤人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (93, '02', '0201', 'perType', '人员类型', '020001', '普通职员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (94, '02', '0201', 'perType', '人员类型', '020102', '结算人员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (95, '02', '0201', 'perType', '人员类型', '020103', '财务人员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (96, '02', '0201', 'perType', '人员类型', '020104', '勘查项目经理', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (97, '02', '0201', 'perType', '人员类型', '020105', '勘查区域经理', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (98, '02', '0201', 'perType', '人员类型', '020106', '报告编写人员', 6);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (99, '02', '0201', 'perType', '人员类型', '020107', '报告审核人员', 7);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (100, '02', '0201', 'perType', '人员类型', '020108', '撰写专家', 8);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (101, '02', '0201', 'perType', '人员类型', '020109', '评估组长', 9);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (102, '02', '0201', 'perType', '人员类型', '020110', '勘查人员', 10);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (103, '02', '0201', 'perType', '人员类型', '020111', '勘查专家', 11);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (104, '02', '0202', 'perType', '人员类型', '020001', '普通职员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (105, '02', '0203', 'perType', '人员类型', '020001', '普通职员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (107, '02', '0204', 'perType', '人员类型', '020001', '普通职员', NULL);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (108, '01', '0101', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (109, '01', '0101', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (110, '01', '0101', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (111, '01', '0101', 'perCerLevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (112, '01', '0101', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (113, '01', '0102', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (114, '01', '0102', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (115, '01', '0102', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (116, '01', '0102', 'perCerLevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (117, '01', '0102', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (118, '01', '0103', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (119, '01', '0103', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (120, '01', '0103', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (121, '01', '0103', 'perCerLevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (122, '01', '0103', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (123, '01', '0104', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (124, '01', '0104', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (125, '01', '0104', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (126, '01', '0104', 'perCerLevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (127, '01', '0104', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (128, '01', '0105', 'perCerLevel', '人员证书等级', '01000101', '初级保安员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (129, '01', '0105', 'perCerLevel', '人员证书等级', '01000102', '中级保安员', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (130, '01', '0105', 'perCerLevel', '人员证书等级', '01000103', '高级保安员', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (131, '01', '0105', 'perCerLevel', '人员证书等级', '01000104', '保安师', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (132, '01', '0105', 'perCerLevel', '人员证书等级', '01000105', '高级保安管理员', 5);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (133, '02', '0205', 'perType', '人员类型', '020501', '管理员', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (134, '01', '0101', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (135, '01', '0102', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (136, '01', '0103', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (137, '01', '0104', 'perCerType', '人员证书类型', '010004', '保安员等级结业证', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (138, '09', '0901', 'perType', '人员类型', '090001', '管理层', 1);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (139, '09', '0901', 'perType', '人员类型', '090002', '项目经理', 2);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (140, '09', '0901', 'perType', '人员类型', '090003', '区域经理', 3);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (141, '09', '0901', 'perType', '人员类型', '090004', '保洁主管', 4);
INSERT INTO `config_industry_dict` (`industryDictId`, `industryType`, `institutionType`, `codeType`, `description`, `codeValue`, `label`, `seq`) VALUES (142, '09', '0901', 'perType', '人员类型', '090005', '保洁员', 5);
COMMIT;

-- ----------------------------
-- Table structure for config_industrytype
-- ----------------------------
DROP TABLE IF EXISTS `config_industrytype`;
CREATE TABLE `config_industrytype` (
  `industryTypeId` bigint(20) NOT NULL COMMENT '行业类型ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `industryType` varchar(6) NOT NULL COMMENT '行业类型',
  `name` varchar(20) DEFAULT NULL COMMENT '行业类型名称',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`industryTypeId`),
  UNIQUE KEY `industryType` (`industryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='行业类型配置';

-- ----------------------------
-- Records of config_industrytype
-- ----------------------------
BEGIN;
INSERT INTO `config_industrytype` (`industryTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `industryType`, `name`, `seq`, `remark`) VALUES (1, '2018-03-13 15:21:24', NULL, NULL, NULL, '01', '保安行业', 1, NULL);
INSERT INTO `config_industrytype` (`industryTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `industryType`, `name`, `seq`, `remark`) VALUES (2, '2018-12-25 19:09:43', NULL, NULL, NULL, '02', '大型活动相关行业', 2, NULL);
INSERT INTO `config_industrytype` (`industryTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `industryType`, `name`, `seq`, `remark`) VALUES (3, '2020-07-02 14:38:02', NULL, '2020-07-02 14:38:04', NULL, '08', '监管行业', 8, NULL);
INSERT INTO `config_industrytype` (`industryTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `industryType`, `name`, `seq`, `remark`) VALUES (4, '2020-06-23 14:39:12', NULL, '2020-06-23 14:41:22', NULL, '09', '其他行业', 9, '');
COMMIT;

-- ----------------------------
-- Table structure for config_init_menu
-- ----------------------------
DROP TABLE IF EXISTS `config_init_menu`;
CREATE TABLE `config_init_menu` (
  `menuConfigId` bigint(20) NOT NULL COMMENT '初始化菜单配置ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `institutionType` varchar(6) DEFAULT NULL COMMENT '机构类型',
  `isAuth` varchar(1) DEFAULT NULL COMMENT '企业是否认证通过',
  `menuId` bigint(20) NOT NULL COMMENT '菜单ID',
  `regionId` bigint(20) DEFAULT NULL COMMENT '区域ID',
  PRIMARY KEY (`menuConfigId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='初始化菜单配置';

-- ----------------------------
-- Records of config_init_menu
-- ----------------------------
BEGIN;
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (1, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (4, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (5, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (6, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (7, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (8, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (9, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (10, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (11, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (12, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (15, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (16, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (17, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (18, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (19, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (20, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (21, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (22, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (23, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (24, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (29, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (30, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (31, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 40000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (36, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (37, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (38, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (39, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 40040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (41, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 60000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (42, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 60010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (43, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 60010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (64, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (67, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (68, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (69, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (70, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (71, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (72, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (73, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (74, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (75, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (78, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (79, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (80, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (81, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (82, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (83, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (84, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (85, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (86, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (87, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (92, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (93, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (94, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 40000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (99, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (100, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (101, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (102, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 40040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (103, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 50000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (104, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 60000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (105, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 60010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (106, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 60010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (127, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (130, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (131, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (132, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (133, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (134, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (135, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (136, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (137, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (138, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (141, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (142, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (143, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (144, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (145, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (146, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (147, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (148, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (149, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (150, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (155, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (156, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (157, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 40000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (162, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (163, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (164, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (165, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 40040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (167, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 60000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (168, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 60010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (169, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 60010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (190, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (193, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (194, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (195, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (196, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (197, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (198, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (199, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (200, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (201, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (204, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (205, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (206, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (207, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (208, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (209, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (210, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (211, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (212, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (213, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (218, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (219, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (220, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 40000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (225, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (226, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (227, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (228, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 40040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (229, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 50000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (230, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 60000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (231, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 60010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (232, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 60010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (235, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '0', 60010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (236, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '0', 60010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (237, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '0', 60010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (238, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '0', 60010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (239, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 10030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (240, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 10030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (241, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 20010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (242, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 30020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (243, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 30020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (244, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 40040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (258, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 90000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (259, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 90010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (260, '2018-09-20 09:48:29', NULL, NULL, NULL, '0101', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (270, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 10030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (271, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 10030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (272, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 20010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (273, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 30020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (274, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 30020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (275, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 40040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (276, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 50010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (277, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 50010001, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (278, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 50010002, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (279, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 50010003, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (280, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 50010004, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (289, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 90000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (290, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 90010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (291, '2018-09-20 09:49:04', NULL, NULL, NULL, '0102', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (301, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 10030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (302, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 10030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (303, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 20010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (304, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 30020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (305, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 30020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (306, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 40040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (315, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 80020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (316, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 80020001, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (317, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 80020002, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (318, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 80020003, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (319, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 80020004, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (320, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 90000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (321, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 90010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (322, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (332, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 10030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (333, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 10030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (334, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 20010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (335, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 30020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (336, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 30020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (337, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 40040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (338, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 50010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (339, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 50010001, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (340, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 50010002, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (341, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 50010003, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (342, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 50010004, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (351, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 90000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (352, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 90010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (353, '2018-09-20 09:49:31', NULL, NULL, NULL, '0104', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (354, '2018-09-20 09:49:17', NULL, NULL, NULL, '0103', '0', 50000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (369, '2018-09-29 15:49:32', NULL, NULL, NULL, '0103', '0', 80030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (370, '2018-09-29 15:49:32', NULL, NULL, NULL, '0103', '0', 80030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (371, '2018-09-29 15:49:32', NULL, NULL, NULL, '0103', '0', 80030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (372, '2018-09-29 15:49:32', NULL, NULL, NULL, '0103', '0', 80030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (373, '2018-09-29 15:49:32', NULL, NULL, NULL, '0103', '0', 80030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (374, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (375, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (376, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (377, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (378, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (379, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (382, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (383, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (385, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (386, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (387, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (388, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (389, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (390, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (394, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (395, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (397, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (398, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (399, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (419, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (420, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (421, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (422, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (423, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (424, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (425, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (428, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (429, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (431, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (432, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (433, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (434, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (435, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (436, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (440, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (441, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (443, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (444, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (445, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (465, '2019-01-02 15:49:27', NULL, NULL, NULL, '0202', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (466, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (467, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (468, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (469, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (470, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (471, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (474, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (475, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (477, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (478, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (479, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (480, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (481, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (482, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (486, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (487, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (489, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (490, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (491, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (511, '2019-01-02 15:49:32', NULL, NULL, NULL, '0203', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (512, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 100000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (513, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 100010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (514, '2019-01-02 15:35:09', NULL, NULL, NULL, '0202', '0', 100000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (515, '2019-01-02 15:35:09', NULL, NULL, NULL, '0202', '0', 100010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (516, '2019-01-02 15:35:09', NULL, NULL, NULL, '0203', '0', 100000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (517, '2019-01-02 15:35:09', NULL, NULL, NULL, '0203', '0', 100010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (518, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (519, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (520, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (521, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (522, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (523, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (525, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (526, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (527, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (528, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (529, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (530, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (531, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (532, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (533, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (534, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (536, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (537, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (538, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (539, '2019-01-02 15:49:27', NULL, NULL, NULL, '0204', '0', 90010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (540, '2019-01-16 16:22:27', NULL, NULL, NULL, '0103', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (541, '2019-01-16 16:22:27', NULL, NULL, NULL, '0103', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (542, '2019-01-16 16:22:27', NULL, NULL, NULL, '0103', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (543, '2019-01-16 16:22:27', NULL, NULL, NULL, '0103', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (544, '2019-01-16 16:22:27', NULL, NULL, NULL, '0101', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (545, '2019-01-16 16:22:27', NULL, NULL, NULL, '0101', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (546, '2019-01-16 16:22:27', NULL, NULL, NULL, '0101', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (547, '2019-01-16 16:22:27', NULL, NULL, NULL, '0101', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (548, '2019-01-16 16:22:27', NULL, NULL, NULL, '0102', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (549, '2019-01-16 16:22:27', NULL, NULL, NULL, '0102', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (550, '2019-01-16 16:22:27', NULL, NULL, NULL, '0102', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (551, '2019-01-16 16:22:27', NULL, NULL, NULL, '0102', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (552, '2019-01-16 16:22:27', NULL, NULL, NULL, '0104', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (553, '2019-01-16 16:22:27', NULL, NULL, NULL, '0104', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (554, '2019-01-16 16:22:27', NULL, NULL, NULL, '0104', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (555, '2019-01-16 16:22:27', NULL, NULL, NULL, '0104', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (556, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (557, '2019-01-02 15:35:09', NULL, NULL, NULL, '0201', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (558, '2019-01-02 15:35:09', NULL, NULL, NULL, '0202', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (559, '2019-01-02 15:35:09', NULL, NULL, NULL, '0202', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (560, '2019-01-02 15:35:09', NULL, NULL, NULL, '0203', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (561, '2019-01-02 15:35:09', NULL, NULL, NULL, '0203', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (562, '2019-01-02 15:35:09', NULL, NULL, NULL, '0204', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (563, '2019-01-02 15:35:09', NULL, NULL, NULL, '0204', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (564, '2019-01-02 15:35:09', NULL, NULL, NULL, '0101', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (565, '2019-01-02 15:35:09', NULL, NULL, NULL, '0102', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (566, '2019-01-02 15:35:09', NULL, NULL, NULL, '0103', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (567, '2019-01-02 15:35:09', NULL, NULL, NULL, '0104', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (568, '2019-01-02 15:35:09', NULL, NULL, NULL, '0101', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (569, '2019-01-02 15:35:09', NULL, NULL, NULL, '0102', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (570, '2019-01-02 15:35:09', NULL, NULL, NULL, '0103', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (571, '2019-01-02 15:35:09', NULL, NULL, NULL, '0104', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (573, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (574, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (575, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (576, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (577, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (578, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (579, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (580, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (581, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (582, '2019-03-09 13:41:08', NULL, NULL, NULL, '0101', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (583, '2019-03-09 13:41:08', NULL, NULL, NULL, '0102', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (584, '2019-03-09 13:41:08', NULL, NULL, NULL, '0103', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (585, '2019-03-09 13:41:08', NULL, NULL, NULL, '0104', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (586, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (587, '2019-03-09 13:41:08', NULL, NULL, NULL, '0101', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (588, '2019-03-09 13:41:08', NULL, NULL, NULL, '0102', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (589, '2019-03-09 13:41:08', NULL, NULL, NULL, '0103', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (590, '2019-03-09 13:41:08', NULL, NULL, NULL, '0104', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (591, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (592, '2019-03-09 13:41:08', NULL, NULL, NULL, '0101', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (593, '2019-03-09 13:41:08', NULL, NULL, NULL, '0102', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (594, '2019-03-09 13:41:08', NULL, NULL, NULL, '0103', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (595, '2019-03-09 13:41:08', NULL, NULL, NULL, '0104', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (596, '2019-03-09 13:41:08', NULL, NULL, NULL, '0105', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (598, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (599, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (600, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (601, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 20030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (602, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (603, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (604, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (605, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 20030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (606, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (607, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (608, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (609, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 20030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (610, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (611, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (612, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (613, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 20030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (614, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (615, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (616, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (617, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 30040000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (618, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (619, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (620, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (621, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 30040100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (622, '2019-03-09 13:43:07', NULL, NULL, NULL, '0201', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (623, '2019-03-09 13:43:07', NULL, NULL, NULL, '0202', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (624, '2019-03-09 13:43:07', NULL, NULL, NULL, '0203', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (625, '2019-03-09 13:43:07', NULL, NULL, NULL, '0204', '0', 30040200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (626, '2019-03-13 11:24:48', NULL, NULL, NULL, '0101', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (627, '2019-03-13 11:24:48', NULL, NULL, NULL, '0101', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (628, '2019-03-13 11:24:48', NULL, NULL, NULL, '0102', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (629, '2019-03-13 11:24:48', NULL, NULL, NULL, '0102', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (630, '2019-03-13 11:24:48', NULL, NULL, NULL, '0103', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (631, '2019-03-13 11:24:48', NULL, NULL, NULL, '0103', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (632, '2019-03-13 11:24:48', NULL, NULL, NULL, '0104', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (633, '2019-03-13 11:24:48', NULL, NULL, NULL, '0104', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (634, '2019-03-13 11:24:48', NULL, NULL, NULL, '0105', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (635, '2019-03-13 11:24:48', NULL, NULL, NULL, '0105', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (636, '2019-03-13 11:24:48', NULL, NULL, NULL, '0201', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (637, '2019-03-13 11:24:48', NULL, NULL, NULL, '0201', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (638, '2019-03-13 11:24:48', NULL, NULL, NULL, '0202', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (639, '2019-03-13 11:24:48', NULL, NULL, NULL, '0202', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (640, '2019-03-13 11:24:48', NULL, NULL, NULL, '0203', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (641, '2019-03-13 11:24:48', NULL, NULL, NULL, '0203', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (642, '2019-03-13 11:24:48', NULL, NULL, NULL, '0204', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (643, '2019-03-13 11:24:48', NULL, NULL, NULL, '0204', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (644, '2019-04-15 18:05:20', NULL, NULL, NULL, '0103', '0', 80040000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (645, '2019-04-15 18:05:20', NULL, NULL, NULL, '0103', '0', 80040100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (646, '2019-05-16 15:21:25', NULL, NULL, NULL, '0201', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (647, '2019-05-16 15:21:25', NULL, NULL, NULL, '0202', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (648, '2019-05-16 15:21:25', NULL, NULL, NULL, '0203', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (649, '2019-05-16 15:21:25', NULL, NULL, NULL, '0204', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (650, '2019-05-16 15:21:25', NULL, NULL, NULL, '0105', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (651, '2019-05-17 18:07:04', NULL, NULL, NULL, '0101', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (652, '2019-05-17 18:07:04', NULL, NULL, NULL, '0102', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (653, '2019-05-17 18:07:04', NULL, NULL, NULL, '0103', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (654, '2019-05-17 18:07:04', NULL, NULL, NULL, '0104', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (655, '2019-05-17 18:07:04', NULL, NULL, NULL, '0105', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (656, '2019-05-17 18:07:04', NULL, NULL, NULL, '0201', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (657, '2019-05-17 18:07:04', NULL, NULL, NULL, '0202', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (658, '2019-05-17 18:07:04', NULL, NULL, NULL, '0203', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (659, '2019-05-17 18:07:04', NULL, NULL, NULL, '0204', '0', 60010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (661, '2019-05-31 17:52:10', NULL, NULL, NULL, '0101', '0', 20010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (662, '2019-05-31 17:52:10', NULL, NULL, NULL, '0101', '0', 60010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (663, '2019-05-31 17:52:10', NULL, NULL, NULL, '0101', '0', 60010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (664, '2019-05-31 17:52:10', NULL, NULL, NULL, '0102', '0', 20010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (665, '2019-05-31 17:52:10', NULL, NULL, NULL, '0102', '0', 60010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (666, '2019-05-31 17:52:10', NULL, NULL, NULL, '0102', '0', 60010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (667, '2019-05-31 17:52:10', NULL, NULL, NULL, '0103', '0', 20010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (668, '2019-05-31 17:52:10', NULL, NULL, NULL, '0103', '0', 60010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (669, '2019-05-31 17:52:10', NULL, NULL, NULL, '0103', '0', 60010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (670, '2019-05-31 17:52:10', NULL, NULL, NULL, '0104', '0', 20010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (671, '2019-05-31 17:52:10', NULL, NULL, NULL, '0104', '0', 60010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (672, '2019-05-31 17:52:10', NULL, NULL, NULL, '0104', '0', 60010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (673, '2019-05-31 17:52:10', NULL, NULL, NULL, '0105', '0', 20010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (674, '2019-05-31 17:52:10', NULL, NULL, NULL, '0105', '0', 60010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (675, '2019-05-31 17:52:10', NULL, NULL, NULL, '0105', '0', 60010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (676, '2019-07-19 17:41:58', NULL, NULL, NULL, '0101', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (677, '2019-07-19 17:41:58', NULL, NULL, NULL, '0102', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (678, '2019-07-19 17:41:58', NULL, NULL, NULL, '0103', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (679, '2019-07-19 17:41:58', NULL, NULL, NULL, '0104', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (680, '2019-07-19 17:41:58', NULL, NULL, NULL, '0105', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (681, '2019-07-19 17:41:58', NULL, NULL, NULL, '0201', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (682, '2019-07-19 17:41:58', NULL, NULL, NULL, '0202', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (683, '2019-07-19 17:41:58', NULL, NULL, NULL, '0203', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (684, '2019-07-19 17:41:58', NULL, NULL, NULL, '0204', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (685, '2019-06-20 16:06:59', NULL, NULL, NULL, '0101', '0', 120000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (686, '2019-06-20 16:06:59', NULL, NULL, NULL, '0101', '0', 120010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (687, '2019-06-20 16:06:59', NULL, NULL, NULL, '0102', '0', 120000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (688, '2019-06-20 16:06:59', NULL, NULL, NULL, '0102', '0', 120010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (689, '2019-06-20 16:06:59', NULL, NULL, NULL, '0103', '0', 120000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (690, '2019-06-20 16:06:59', NULL, NULL, NULL, '0103', '0', 120010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (691, '2019-06-20 16:06:59', NULL, NULL, NULL, '0104', '0', 120000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (692, '2019-06-20 16:06:59', NULL, NULL, NULL, '0104', '0', 120010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (693, '2019-06-20 16:06:59', NULL, NULL, NULL, '0105', '0', 120000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (694, '2019-06-20 16:06:59', NULL, NULL, NULL, '0105', '0', 120010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (750, '2019-08-30 10:21:47', NULL, NULL, NULL, '0101', '0', 40040200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (751, '2019-08-30 10:21:47', NULL, NULL, NULL, '0102', '0', 40040200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (753, '2019-08-30 10:21:47', NULL, NULL, NULL, '0104', '0', 40040200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (754, '2019-08-30 10:21:47', NULL, NULL, NULL, '0105', '0', 40040200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (755, '2019-09-05 13:32:56', NULL, NULL, NULL, '0101', '0', 10030600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (756, '2019-09-05 13:32:56', NULL, NULL, NULL, '0102', '0', 10030600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (757, '2019-09-05 13:32:56', NULL, NULL, NULL, '0103', '0', 10030600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (758, '2019-09-05 13:32:56', NULL, NULL, NULL, '0104', '0', 10030600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (759, '2019-09-05 13:32:56', NULL, NULL, NULL, '0105', '0', 10030600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (760, '2019-10-15 17:19:48', NULL, NULL, NULL, '0103', '0', 50020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (761, '2019-10-15 17:19:48', NULL, NULL, NULL, '0103', '0', 50020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (762, '2019-10-15 17:19:48', NULL, NULL, NULL, '0103', '0', 50020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (763, '2019-11-05 16:49:15', NULL, NULL, NULL, '0103', '0', 80040200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (764, '2019-11-05 16:49:15', NULL, NULL, NULL, '0103', '0', 80040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (765, '2019-11-05 16:49:57', NULL, NULL, NULL, '0103', '0', 80040200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (766, '2019-11-05 16:49:57', NULL, NULL, NULL, '0103', '0', 80040300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (768, '2019-11-12 09:29:29', NULL, NULL, NULL, '0101', '0', 60020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (769, '2019-11-12 09:29:29', NULL, NULL, NULL, '0102', '0', 60020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (770, '2019-11-12 09:29:29', NULL, NULL, NULL, '0103', '0', 60020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (771, '2019-11-12 09:29:29', NULL, NULL, NULL, '0104', '0', 60020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (772, '2019-11-12 09:29:29', NULL, NULL, NULL, '0105', '0', 60020000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (773, '2019-11-12 09:29:29', NULL, NULL, NULL, '0101', '0', 60020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (774, '2019-11-12 09:29:29', NULL, NULL, NULL, '0102', '0', 60020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (775, '2019-11-12 09:29:29', NULL, NULL, NULL, '0103', '0', 60020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (776, '2019-11-12 09:29:29', NULL, NULL, NULL, '0104', '0', 60020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (777, '2019-11-12 09:29:29', NULL, NULL, NULL, '0105', '0', 60020001, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (778, '2019-11-12 09:29:29', NULL, NULL, NULL, '0101', '0', 60020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (779, '2019-11-12 09:29:29', NULL, NULL, NULL, '0102', '0', 60020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (780, '2019-11-12 09:29:29', NULL, NULL, NULL, '0103', '0', 60020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (781, '2019-11-12 09:29:29', NULL, NULL, NULL, '0104', '0', 60020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (782, '2019-11-12 09:29:29', NULL, NULL, NULL, '0105', '0', 60020002, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (783, '2019-11-12 09:29:57', NULL, NULL, NULL, '0101', '0', 60020000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (784, '2019-11-12 09:29:57', NULL, NULL, NULL, '0102', '0', 60020000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (785, '2019-11-12 09:29:57', NULL, NULL, NULL, '0103', '0', 60020000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (786, '2019-11-12 09:29:57', NULL, NULL, NULL, '0104', '0', 60020000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (787, '2019-11-12 09:29:57', NULL, NULL, NULL, '0105', '0', 60020000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (788, '2019-11-12 09:29:57', NULL, NULL, NULL, '0101', '0', 60020001, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (789, '2019-11-12 09:29:57', NULL, NULL, NULL, '0102', '0', 60020001, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (790, '2019-11-12 09:29:57', NULL, NULL, NULL, '0103', '0', 60020001, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (791, '2019-11-12 09:29:57', NULL, NULL, NULL, '0104', '0', 60020001, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (792, '2019-11-12 09:29:57', NULL, NULL, NULL, '0105', '0', 60020001, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (793, '2019-11-12 09:29:57', NULL, NULL, NULL, '0101', '0', 60020002, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (794, '2019-11-12 09:29:57', NULL, NULL, NULL, '0102', '0', 60020002, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (795, '2019-11-12 09:29:57', NULL, NULL, NULL, '0103', '0', 60020002, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (796, '2019-11-12 09:29:57', NULL, NULL, NULL, '0104', '0', 60020002, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (797, '2019-11-12 09:29:57', NULL, NULL, NULL, '0105', '0', 60020002, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (798, '2019-12-18 16:15:00', NULL, NULL, NULL, '0101', '0', 40040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (799, '2019-12-18 16:15:00', NULL, NULL, NULL, '0102', '0', 40040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (800, '2019-12-18 16:15:00', NULL, NULL, NULL, '0103', '0', 40040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (801, '2019-12-18 16:15:00', NULL, NULL, NULL, '0104', '0', 40040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (802, '2019-12-18 16:15:00', NULL, NULL, NULL, '0105', '0', 40040300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (803, '2020-02-09 17:49:45', NULL, NULL, NULL, '0102', '0', 40040400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (804, '2020-02-09 17:49:45', NULL, NULL, NULL, '0104', '0', 40040400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (805, '2020-02-09 17:49:57', NULL, NULL, NULL, '0102', '0', 40040400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (806, '2020-02-09 17:49:57', NULL, NULL, NULL, '0104', '0', 40040400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (807, '2020-02-09 17:51:29', NULL, NULL, NULL, '0103', '0', 50020003, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (808, '2020-02-09 17:51:29', NULL, NULL, NULL, '0103', '0', 50020004, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (809, '2020-02-09 17:51:45', NULL, NULL, NULL, '0103', '0', 50020003, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (810, '2020-02-09 17:51:45', NULL, NULL, NULL, '0103', '0', 50020004, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (811, '2020-02-12 09:28:53', NULL, NULL, NULL, '0101', '0', 140010600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (812, '2020-02-12 09:28:53', NULL, NULL, NULL, '0102', '0', 140010600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (813, '2020-02-12 09:28:53', NULL, NULL, NULL, '0103', '0', 140010600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (814, '2020-02-12 09:28:53', NULL, NULL, NULL, '0104', '0', 140010600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (815, '2020-02-12 09:28:53', NULL, NULL, NULL, '0105', '0', 140010600, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (816, '2020-02-12 09:29:11', NULL, NULL, NULL, '0101', '0', 140010600, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (817, '2020-02-12 09:29:11', NULL, NULL, NULL, '0102', '0', 140010600, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (818, '2020-02-12 09:29:11', NULL, NULL, NULL, '0103', '0', 140010600, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (819, '2020-02-12 09:29:11', NULL, NULL, NULL, '0104', '0', 140010600, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (820, '2020-02-12 09:29:11', NULL, NULL, NULL, '0105', '0', 140010600, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (821, '2020-03-10 21:50:59', NULL, NULL, NULL, '0101', '0', 140010700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (822, '2020-03-10 21:50:59', NULL, NULL, NULL, '0102', '0', 140010700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (823, '2020-03-10 21:50:59', NULL, NULL, NULL, '0103', '0', 140010700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (824, '2020-03-10 21:50:59', NULL, NULL, NULL, '0104', '0', 140010700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (825, '2020-03-10 21:50:59', NULL, NULL, NULL, '0105', '0', 140010700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (826, '2020-03-10 21:51:16', NULL, NULL, NULL, '0101', '0', 140010700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (827, '2020-03-10 21:51:16', NULL, NULL, NULL, '0102', '0', 140010700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (828, '2020-03-10 21:51:16', NULL, NULL, NULL, '0103', '0', 140010700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (829, '2020-03-10 21:51:16', NULL, NULL, NULL, '0104', '0', 140010700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (830, '2020-03-10 21:51:16', NULL, NULL, NULL, '0105', '0', 140010700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (831, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (832, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (833, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (834, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (835, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (836, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (837, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (838, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (839, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (840, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (841, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (842, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (843, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (844, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (845, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (846, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (847, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (848, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (849, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (850, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (851, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (852, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (853, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (854, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (855, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (856, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (857, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (858, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (859, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (860, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010400, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (861, '2020-03-13 14:27:17', NULL, NULL, NULL, '0101', '0', 140010500, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (862, '2020-03-13 14:27:17', NULL, NULL, NULL, '0102', '0', 140010500, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (863, '2020-03-13 14:27:17', NULL, NULL, NULL, '0103', '0', 140010500, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (864, '2020-03-13 14:27:17', NULL, NULL, NULL, '0104', '0', 140010500, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (865, '2020-03-13 14:27:17', NULL, NULL, NULL, '0105', '0', 140010500, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (866, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140000000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (867, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140000000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (868, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140000000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (869, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140000000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (870, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140000000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (871, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (872, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (873, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (874, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (875, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (876, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (877, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (878, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (879, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (880, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (881, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (882, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (883, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (884, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (885, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010200, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (886, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (887, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (888, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (889, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (890, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010300, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (891, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (892, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (893, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (894, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (895, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010400, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (896, '2020-03-13 14:27:52', NULL, NULL, NULL, '0101', '0', 140010500, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (897, '2020-03-13 14:27:52', NULL, NULL, NULL, '0102', '0', 140010500, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (898, '2020-03-13 14:27:52', NULL, NULL, NULL, '0103', '0', 140010500, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (899, '2020-03-13 14:27:52', NULL, NULL, NULL, '0104', '0', 140010500, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (900, '2020-03-13 14:27:52', NULL, NULL, NULL, '0105', '0', 140010500, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (901, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (902, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (903, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (904, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (905, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (906, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (907, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (908, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (909, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 10030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (910, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (911, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (912, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (913, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (914, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20020100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (915, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20020200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (916, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20020300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (917, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 20020400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (918, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (919, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (920, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (921, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (922, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30050000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (923, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 30050100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (924, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (925, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (926, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (927, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (928, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (929, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 40030500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (930, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 60000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (931, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 120000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (932, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 120010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (933, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 120020000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (934, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 120030000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (935, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 130000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (936, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (937, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (938, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010100, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (939, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010200, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (940, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010300, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (941, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010400, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (942, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010500, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (943, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010600, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (944, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 140010700, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (945, '2020-06-23 15:29:06', NULL, NULL, NULL, '0901', '0', 200000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (946, '2020-07-02 16:04:31', NULL, NULL, NULL, '0801', '0', 150000000, NULL);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (947, '2020-09-21 16:41:37', NULL, NULL, NULL, '0103', '0', 80040700, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (948, '2020-09-21 16:41:37', NULL, '2020-12-25 13:37:53', NULL, '0103', '0', 80040700, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (949, '2020-11-27 15:31:33', NULL, NULL, NULL, '0102', '0', 40050000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (950, '2020-11-27 15:31:33', NULL, NULL, NULL, '0102', '0', 40050100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (951, '2020-11-27 15:31:43', NULL, NULL, NULL, '0102', '0', 40050000, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (952, '2020-11-27 15:31:43', NULL, NULL, NULL, '0102', '0', 40050100, 650000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (953, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160000000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (954, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160010000, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (955, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160010100, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (956, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160010200, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (957, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160010300, 110000);
INSERT INTO `config_init_menu` (`menuConfigId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `isAuth`, `menuId`, `regionId`) VALUES (958, '2020-12-25 13:38:42', NULL, NULL, NULL, '0101', '0', 160010400, 110000);
COMMIT;

-- ----------------------------
-- Table structure for config_init_process
-- ----------------------------
DROP TABLE IF EXISTS `config_init_process`;
CREATE TABLE `config_init_process` (
  `institutionType` varchar(6) NOT NULL COMMENT '机构类型',
  `initProcessType` varchar(6) NOT NULL COMMENT '初始化流程类型',
  `description` varchar(100) DEFAULT NULL COMMENT '描述',
  `seq` int(4) DEFAULT NULL COMMENT '顺序',
  `menuId` bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`institutionType`,`initProcessType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='初始化流程配置';

-- ----------------------------
-- Records of config_init_process
-- ----------------------------
BEGIN;
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0101', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0101', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0101', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0101', '7', '完善保险信息', 4, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0102', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0102', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0102', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0102', '7', '完善保险信息', 4, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0103', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0103', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0103', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0103', '7', '完善保险信息', 4, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0104', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0104', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0104', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0104', '7', '完善保险信息', 4, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0201', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0201', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0201', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0202', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0202', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0202', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0203', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0203', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0203', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0204', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0204', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0204', '3', '完善认证信息', 3, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0901', '1', '初始密码修改', 1, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0901', '2', '完善企业基础信息', 2, 0);
INSERT INTO `config_init_process` (`institutionType`, `initProcessType`, `description`, `seq`, `menuId`) VALUES ('0901', '3', '完善认证信息', 3, 0);
COMMIT;

-- ----------------------------
-- Table structure for config_ins_guaproject
-- ----------------------------
DROP TABLE IF EXISTS `config_ins_guaproject`;
CREATE TABLE `config_ins_guaproject` (
  `insGuaProjectType` varchar(6) NOT NULL COMMENT '保障项目类型',
  `name` varchar(20) DEFAULT NULL COMMENT '消息类型名称',
  `insType` varchar(6) NOT NULL COMMENT '保险种类',
  PRIMARY KEY (`insGuaProjectType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='保障项目配置';

-- ----------------------------
-- Records of config_ins_guaproject
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for config_institutiontype
-- ----------------------------
DROP TABLE IF EXISTS `config_institutiontype`;
CREATE TABLE `config_institutiontype` (
  `institutionTypeId` bigint(20) NOT NULL COMMENT '机构类型ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `institutionType` varchar(6) NOT NULL COMMENT '机构类型',
  `name` varchar(20) DEFAULT NULL COMMENT '机构类型名称',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `industryType` varchar(6) NOT NULL COMMENT '行业类型',
  PRIMARY KEY (`institutionTypeId`),
  UNIQUE KEY `institutionType` (`institutionType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='机构类型配置';

-- ----------------------------
-- Records of config_institutiontype
-- ----------------------------
BEGIN;
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (1, '2018-03-13 15:21:25', NULL, NULL, NULL, '0101', '保安协会', 1, '', '01');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (2, '2018-03-13 15:21:25', NULL, NULL, NULL, '0102', '保安服务公司', 2, NULL, '01');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (3, '2018-03-13 15:21:25', NULL, NULL, NULL, '0103', '保安培训单位', 3, '1212', '01');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (4, '2018-03-13 15:21:25', NULL, NULL, NULL, '0104', '自行招用保安单位', 4, '25414', '01');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (5, '2018-03-13 15:21:25', NULL, NULL, NULL, '0105', '保安服务公司及培训单位', 5, NULL, '01');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (6, '2018-12-25 19:10:19', NULL, NULL, NULL, '0201', '风评机构', 1, NULL, '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (7, '2018-12-25 19:10:30', NULL, NULL, NULL, '0202', '承办单位', 2, NULL, '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (8, '2018-12-25 19:10:42', NULL, NULL, NULL, '0203', '政府单位', 3, NULL, '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (9, '2018-12-25 19:10:42', NULL, '2019-01-07 13:46:44', NULL, '0204', '服务机构', 4, '', '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (10, '2019-08-09 16:33:02', NULL, NULL, NULL, '0205', '搭建服务商', 5, NULL, '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (11, '2020-03-25 14:17:30', NULL, '2020-03-25 14:17:30', NULL, '0210', '公安机构', 6, '', '02');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (81, '2020-07-02 14:38:27', NULL, '2020-07-02 14:38:29', NULL, '0801', '治安机关', 1, NULL, '08');
INSERT INTO `config_institutiontype` (`institutionTypeId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `institutionType`, `name`, `seq`, `remark`, `industryType`) VALUES (91, '2020-06-23 14:17:30', NULL, '2020-06-23 14:17:30', NULL, '0901', '保洁公司', 1, '', '09');
COMMIT;

-- ----------------------------
-- Table structure for config_interface
-- ----------------------------
DROP TABLE IF EXISTS `config_interface`;
CREATE TABLE `config_interface` (
  `interfaceType` varchar(6) NOT NULL COMMENT '接口类型',
  `name` varchar(50) DEFAULT NULL COMMENT '接口名称',
  `url` varchar(500) DEFAULT NULL COMMENT '方法url',
  `providePlatId` bigint(20) NOT NULL COMMENT '接口提供平台ID',
  `callPlatId` bigint(20) NOT NULL COMMENT '接口调用平台ID',
  PRIMARY KEY (`interfaceType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接口配置表';

-- ----------------------------
-- Records of config_interface
-- ----------------------------
BEGIN;
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1101', '新增部门', 'xxxxxxxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1102', '删除部门', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1103', '删创建或更新安保公司信息合同', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1104', '创建或更新管理层信息', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1105', '删除管理层信息', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1106', '逻辑删除企业合同', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1107', '新增或更新任务', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1108', '删除任务', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1109', '新增或更新公司班次信息', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1110', '删除公司班次信息', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1130', '消息已读', 'xxxx', 11, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('1401', '推送百课堂账号', 'xxxx', 14, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('2101', 'PSS企业注册', 'xxxx', 12, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('2102', '推送企业认证信息', 'xxxx', 12, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('2103', '推送风评机构子账号', 'xxxx', 12, 10);
INSERT INTO `config_interface` (`interfaceType`, `name`, `url`, `providePlatId`, `callPlatId`) VALUES ('2104', '修改风评机构子账号', 'xxxx', 12, 10);
COMMIT;

-- ----------------------------
-- Table structure for config_leave_type
-- ----------------------------
DROP TABLE IF EXISTS `config_leave_type`;
CREATE TABLE `config_leave_type` (
  `leaveType` varchar(6) NOT NULL COMMENT '请假类型',
  `isActive` varchar(1) DEFAULT '1' COMMENT '是否启用',
  `name` varchar(20) DEFAULT NULL COMMENT '请假名称',
  `description` varchar(100) DEFAULT NULL COMMENT '描述',
  `seq` int(4) DEFAULT NULL COMMENT '顺序',
  PRIMARY KEY (`leaveType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='请假类型配置';

-- ----------------------------
-- Records of config_leave_type
-- ----------------------------
BEGIN;
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('1', '1', '事假', '事假', 1);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('2', '1', '病假', '病假', 2);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('3', '1', '年假', '年假', 3);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('4', '1', '婚假', '婚假', 4);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('5', '1', '调休', '调休', 5);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('6', '1', '产假', '产假', 6);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('7', '1', '公假', '公假', 7);
INSERT INTO `config_leave_type` (`leaveType`, `isActive`, `name`, `description`, `seq`) VALUES ('8', '1', '主管假', '主管假', 8);
COMMIT;

-- ----------------------------
-- Table structure for config_message_category
-- ----------------------------
DROP TABLE IF EXISTS `config_message_category`;
CREATE TABLE `config_message_category` (
  `messageCategoryType` varchar(6) NOT NULL COMMENT '消息范畴类型',
  `name` varchar(20) DEFAULT NULL COMMENT '消息范畴名称',
  PRIMARY KEY (`messageCategoryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息范畴配置';

-- ----------------------------
-- Records of config_message_category
-- ----------------------------
BEGIN;
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0101', '系统通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0102', '保险通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0201', '任务通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0202', '任务定时通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0300', '企业系统触发通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0302', '会议通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0303', '考勤通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0304', '劳务薪酬通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0305', '人事招聘通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0306', '重要通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0307', '常规通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0401', '考试通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0501', '问题人员');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0502', '许可备案通知');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0503', '公安通知公告');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0601', '平台公告');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0602', '新版介绍');
INSERT INTO `config_message_category` (`messageCategoryType`, `name`) VALUES ('0701', '审批通知');
COMMIT;

-- ----------------------------
-- Table structure for config_messagetype
-- ----------------------------
DROP TABLE IF EXISTS `config_messagetype`;
CREATE TABLE `config_messagetype` (
  `messageType` varchar(6) NOT NULL COMMENT '消息类型',
  `name` varchar(20) DEFAULT NULL COMMENT '消息类型名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否启用',
  `isTempConfig` varchar(1) DEFAULT NULL COMMENT '是否模板配置',
  `messageTrigType` varchar(6) DEFAULT NULL COMMENT '消息触发类型',
  `businessType` varchar(6) DEFAULT NULL COMMENT '业务类型（当触发类型为业务触发）',
  `tableName` varchar(30) DEFAULT NULL COMMENT '涉及表名',
  `messageCategoryType` varchar(6) NOT NULL COMMENT '消息范畴类型',
  PRIMARY KEY (`messageType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息类型配置';

-- ----------------------------
-- Records of config_messagetype
-- ----------------------------
BEGIN;
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010101', '下线抢登通知', '1', '0', '程序写死', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010102', 'token失效通知', '1', '0', '程序写死', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010103', '账户异常通知', '1', '0', '程序写死', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010104', '初始化未完成通知', '1', '0', '定时器', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010105', '试用期到期通知', '1', '0', '定时器', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010106', '企业认证通知', '1', '0', '业务触发', '', NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010107', '身份认证通知', '1', '0', '业务触发', '', '', '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010108', '系统常规通知', '1', '0', '业务触发', NULL, NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010109', '企业完成企业管理层人员信息录入通知', '1', '0', '定时器', NULL, NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010110', '钱包信息变更审批通知', '1', '0', '业务触发', NULL, NULL, '0101');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010201', '投保成功通知', '1', '0', '业务触发', '', NULL, '0102');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010202', '保险即将到期提醒', '1', '0', '定时器', '', NULL, '0102');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010203', '引导购买保险消息通知', '1', '0', '平台发布', NULL, NULL, '0102');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010204', '保险方案书消息通知', '1', '0', '平台发布', NULL, NULL, '0102');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010205', '保险人员入职、离职情况提醒', '1', '0', '定时器', '', NULL, '0102');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('010301', '金融服务通知', '1', '0', '业务触发', NULL, NULL, '0103');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020101', '任务发布通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020102', '任务接受通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020103', '任务拒绝通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020104', '任务删除通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020105', '任务修改通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020106', '任务结束通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020107', '任务指派通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020108', '任务调班通知（任务人员班次调整）', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020109', '任务代班通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020110', '任务增员通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020111', '班次即将开始提醒', '0', '0', '定时器', '', NULL, '0202');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020112', '班次补签提醒', '1', '0', '定时器', '', NULL, '0202');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020113', '任务出勤统计报表提醒', '1', '0', '定时器', '', NULL, '0202');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020114', '任务减员通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020115', '任务迟到通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020116', '任务早退通知', '1', '0', '业务触发', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020117', '任务签到提醒', '1', '0', '定时器', '', NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020118', '任务延长通知', '1', '0', '业务触发', NULL, NULL, '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('020119', '任务到期通知', '1', '0', '定时器', '', '', '0201');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030001', '企业系统触发通知', '1', '0', '平台触发', NULL, NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030002', '会议即将开始通知', '1', '0', '定时器', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030003', '内勤打卡提醒', '1', '0', '定时器', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030004', '内勤补卡提醒', '1', '0', '定时器', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030005', '内勤统计报表通知', '1', '0', '定时器', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030006', '合同即将到期提醒', '1', '0', '定时器', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030007', '收到新简历通知', '1', '0', '业务触发', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030008', '申请加入公司通知', '1', '0', '业务触发', '', NULL, '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030009', '超龄人员通知', '1', '0', '定时器', '', '', '0300');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030201', '会议邀请通知', '1', '0', '业务触发', '', NULL, '0302');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030202', '会议取消通知', '1', '0', '业务触发', '', NULL, '0302');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030204', '会议修改通知', '1', '0', '业务触发', '', NULL, '0302');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030303', '加入考勤组通知', '1', '0', '业务触发', '', NULL, '0303');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030304', '修改考勤组通知', '1', '0', '业务触发', '', NULL, '0303');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030305', '考勤排班通知', '1', '0', '业务触发', '', NULL, '0303');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030306', '考勤班次调整通知', '1', '0', '业务触发', '', NULL, '0303');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030307', '考勤组被解散通知', '1', '0', '业务触发', '', NULL, '0303');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030401', '工资条发放通知', '1', '0', '业务触发', '', NULL, '0304');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030402', '工资条确认提醒', '1', '0', '业务触发', '', NULL, '0304');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030601', '员工奖惩公告', '1', '0', '企业发布', '', NULL, '0306');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030602', '岗位调整公告', '1', '0', '企业发布', '', NULL, '0306');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030603', '规章制度调整', '1', '0', '企业发布', '', NULL, '0306');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030701', '新人公告', '1', '0', '企业发布', '', NULL, '0307');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030702', '临时通知', '1', '0', '企业发布', '', NULL, '0307');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('030703', '常规通知', '1', '0', '企业发布', NULL, NULL, '0307');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('040101', '考试安排通知', '1', '0', '业务触发', '', NULL, '0401');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('040102', '考试取消通知', '1', '0', '业务触发', '', NULL, '0401');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('040103', '考试修改通知', '1', '0', '业务触发', '', NULL, '0401');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('040104', '考试成绩通知', '1', '0', '业务触发', '', NULL, '0401');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050101', '背景筛查问题通知', '1', '0', '业务触发', '', NULL, '0501');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050201', '指纹录入通知', '1', '0', '业务触发', '', NULL, '0502');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050202', '缴费通知', '1', '0', '业务触发', '', NULL, '0502');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050203', '审批结果通知', '1', '0', '业务触发', '', NULL, '0502');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050204', '领证通知', '1', '0', '业务触发', '', NULL, '0502');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050205', '许可备案申报提醒', '1', '0', '业务触发', NULL, NULL, '0502');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050301', '公安通知公告', '1', '0', '公安发布', '', NULL, '0503');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050302', '问题人员通知', '1', '0', '公安发布', '', NULL, '0503');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('050303', '管理层完善提醒', '1', '0', '公安发布', NULL, NULL, '0503');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('060101', '升级公告', '1', '0', '平台发布', '', NULL, '0601');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('060102', '平台维护公告', '1', '0', '平台发布', '', NULL, '0601');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('060201', '企业端功能介绍', '1', '0', '平台发布', '', NULL, '0602');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('060202', '公安端功能介绍', '1', '0', '平台发布', '', NULL, '0602');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('060203', 'app功能介绍', '1', '0', '平台发布', '', NULL, '0602');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('070101', '审批结果通知', '1', '0', '业务触发', '', NULL, '0701');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('070102', '待审批通知', '1', '0', '业务触发', '', NULL, '0701');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('070103', '审批抄送通知', '1', '0', '业务触发', '', NULL, '0701');
INSERT INTO `config_messagetype` (`messageType`, `name`, `isActive`, `isTempConfig`, `messageTrigType`, `businessType`, `tableName`, `messageCategoryType`) VALUES ('070104', '审批撤销通知', '1', '0', '业务触发', '', NULL, '0701');
COMMIT;

-- ----------------------------
-- Table structure for config_pay_report_field
-- ----------------------------
DROP TABLE IF EXISTS `config_pay_report_field`;
CREATE TABLE `config_pay_report_field` (
  `filedCode` varchar(20) NOT NULL COMMENT '字段code',
  `fieldName` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `seq` int(3) DEFAULT NULL COMMENT '排序',
  `isRequired` varchar(1) DEFAULT NULL COMMENT '是否必录',
  `preview` varchar(100) DEFAULT NULL COMMENT '预览值',
  `isEdit` varchar(20) DEFAULT NULL COMMENT '是否可编辑',
  `fieldType` varchar(1) DEFAULT NULL COMMENT '字段类型',
  `category` varchar(20) DEFAULT NULL COMMENT '所属范畴',
  PRIMARY KEY (`filedCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业薪酬自定义报表字段';

-- ----------------------------
-- Records of config_pay_report_field
-- ----------------------------
BEGIN;
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('absenceCharge', '缺勤扣款', 240, '0', '200', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('actualWage', '实发工资', 300, '1', '5000', '1', '2', '工资结算项目');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('bank', '开户银行', 35, '0', '建设银行', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('bankNo', '银行卡号', 40, '0', '622848040256489', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('baseSalary', '基本工资', 65, '1', '4000', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('birthIns', '生育保险', 225, '0', '200', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('businessIns', '商业保险', 235, '0', '100', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('careerIns', '事业保险', 215, '0', '100', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('communicateWelfare', '通讯补贴', 135, '0', '200', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('compensateWelfare', '补偿', 140, '0', '500', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('departName', '部门', 15, '0', '保安部', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('diningWelfare', '餐饮补贴', 120, '0', '200', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('extraSalary', '额外津贴', 90, '0', '500', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('houseIns', '住房公积金', 230, '0', '400', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('idCardNo', '身份证号', 25, '1', '33038119920504XXXX', '0', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('idCardType', '证件类型', 23, '1', '身份证', '0', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('injuryIns', '工伤保险', 220, '0', '100', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('jobNo', '工号', 10, '0', 'A001', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('laterCharge', '迟到扣款', 245, '0', '200', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('medicalIns', '医疗保险', 210, '0', '200', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('monthWage', '月度工资', 310, '0', '5000', '1', '2', '工资结算项目');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('monthWelfare', '月度绩效', 100, '0', '1000', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('otherCharge', '其他扣款', 270, '0', '500', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('otherSalary', '其他工资', 95, '0', '600', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('otherWelfare', '其他补贴', 145, '0', '100', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('overtimeDay', '加班时间', 60, '0', '2', '1', '2', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('overtimeSalary', '加班工资', 75, '0', '400', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('overtimeWelfare', '加班补贴', 115, '0', '100', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('pensionIns', '养老保险', 205, '0', '100', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('performanceSalary', '绩效工资', 70, '0', '400', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('perName', '姓名', 1, '1', '张三', '0', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('personalCharge', '事假扣款', 255, '0', '240', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('personalDay', '事假天数', 55, '0', '2', '1', '2', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('personalTax', '个人所得税', 260, '1', '136', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('positionName', '职位', 30, '0', '保安员', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('pretaxWage', '税前工资', 320, '0', '5600', '1', '2', '工资结算项目');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('pushSalary', '提成工资', 85, '0', '1000', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('quarterWelfare', '季度绩效', 105, '0', '500', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('secondDepartName', '二级部门', 20, '0', '保安二部', '1', '1', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('sickCharge', '病假扣款', 250, '0', '100', '1', '2', '个人扣减信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('sickDay', '病假天数', 50, '0', '1', '1', '2', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('taxWage', '计税工资', 330, '0', '1200', '1', '2', '工资结算项目');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('timeSalary', '计时工资', 80, '0', '4800', '1', '2', '工资增量信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('trafficWelfare', '交通补贴', 125, '0', '500', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('travelWelfare', '差旅补贴', 130, '0', '100', '1', '2', '福利补贴信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('workDay', '出勤天数', 45, '0', '28', '1', '2', '人员基本信息');
INSERT INTO `config_pay_report_field` (`filedCode`, `fieldName`, `seq`, `isRequired`, `preview`, `isEdit`, `fieldType`, `category`) VALUES ('yearWelfare', '年终奖', 110, '0', '5000', '1', '2', '福利补贴信息');
COMMIT;

-- ----------------------------
-- Table structure for config_per_app_menu
-- ----------------------------
DROP TABLE IF EXISTS `config_per_app_menu`;
CREATE TABLE `config_per_app_menu` (
  `configPerAppMenuId` varchar(6) NOT NULL COMMENT '人员APP菜单ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime NOT NULL COMMENT '更新时间',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `appServiceType` varchar(6) DEFAULT NULL COMMENT 'app服务类型',
  `menuName` varchar(50) DEFAULT NULL COMMENT '菜单名称',
  `linkUrl` varchar(500) DEFAULT NULL COMMENT '跳转地址',
  `applyInstitutionType` varchar(200) DEFAULT NULL COMMENT '机构类型(如果通用则为$$$$)',
  `applyProvince` varchar(200) DEFAULT NULL COMMENT '适用省份(如果通用则为$$$$)',
  `isCheckLeaveJob` varchar(1) DEFAULT NULL COMMENT '是否校验离职(为1需要校验)',
  `seq` int(6) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`configPerAppMenuId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='人员APP菜单配置';

-- ----------------------------
-- Records of config_per_app_menu
-- ----------------------------
BEGIN;
INSERT INTO `config_per_app_menu` (`configPerAppMenuId`, `createTime`, `updateTime`, `isActive`, `appServiceType`, `menuName`, `linkUrl`, `applyInstitutionType`, `applyProvince`, `isCheckLeaveJob`, `seq`) VALUES ('10', '2020-07-29 14:29:49', '2020-07-29 14:29:49', '1', '2', '我的钱包', '/wallet/my-wallet', '$$$$', '$$$$', NULL, 1);
INSERT INTO `config_per_app_menu` (`configPerAppMenuId`, `createTime`, `updateTime`, `isActive`, `appServiceType`, `menuName`, `linkUrl`, `applyInstitutionType`, `applyProvince`, `isCheckLeaveJob`, `seq`) VALUES ('11', '2020-07-29 14:30:59', '2020-07-29 14:30:59', '1', '2', '保安员证联名卡', '/smart-card', '0101,0102,0103,0104,0105', '$$$$', '1', 2);
INSERT INTO `config_per_app_menu` (`configPerAppMenuId`, `createTime`, `updateTime`, `isActive`, `appServiceType`, `menuName`, `linkUrl`, `applyInstitutionType`, `applyProvince`, `isCheckLeaveJob`, `seq`) VALUES ('12', '2020-07-29 14:31:26', '2020-07-29 14:31:26', '1', '4', '健康保障', 'http://114.116.90.77:8006/h5/#/indemnity/entrance', '$$$$', '$$$$', NULL, 3);
COMMIT;

-- ----------------------------
-- Table structure for config_per_cer
-- ----------------------------
DROP TABLE IF EXISTS `config_per_cer`;
CREATE TABLE `config_per_cer` (
  `perCerType` varchar(6) NOT NULL COMMENT '人员证书类别',
  `fieldCode` varchar(20) NOT NULL COMMENT '字段编码',
  `fieldName` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `isRequired` varchar(1) DEFAULT NULL COMMENT '是否必录',
  `isHidden` varchar(1) DEFAULT NULL COMMENT '是否隐藏',
  `seq` int(4) DEFAULT NULL COMMENT '顺序',
  `fieldType` varchar(2) DEFAULT NULL COMMENT '字段类型',
  `tips` varchar(100) DEFAULT NULL COMMENT '提示',
  `maxLength` varchar(4) DEFAULT NULL COMMENT '最大长度',
  `scriptEvent` varchar(200) DEFAULT NULL COMMENT '脚本事件',
  `scriptFunction` varchar(4000) DEFAULT NULL COMMENT '脚本方法',
  PRIMARY KEY (`perCerType`,`fieldCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员证书类别信息配置';

-- ----------------------------
-- Records of config_per_cer
-- ----------------------------
BEGIN;
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010001', 'perCerLevel', '证书等级', '1', '1', 1, '4', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010001', 'trainEndDate', '培训结束日期', '0', '1', 4, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010001', 'trainOrganName', '培训单位名称', '0', '0', 2, '1', '请输入', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010001', 'trainStartDate', '培训开始日期', '0', '1', 3, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010002', 'trainEndDate', '培训结束日期', '0', '1', 3, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010002', 'trainOrganName', '培训单位名称', '0', '0', 1, '1', '请输入', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010002', 'trainStartDate', '培训开始日期', '0', '1', 2, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010003', 'cerEffectDate', '有效期开始日期', '0', '1', 3, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010003', 'cerExpireDate', '有效期结束日期', '0', '1', 4, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010003', 'gunProofCode', '持枪证枪型代码', '0', '1', 5, '1', '请输入', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010003', 'pressIndoCardNumber', '十指指纹按印卡号', '0', '0', 2, '1', '请选择', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010003', 'trainOrganName', '培训单位名称', '0', '0', 1, '1', '请输入', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010004', 'trainEndDate', '培训结束日期', '0', '1', 3, '9', '请选择', '0', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010004', 'trainOrganName', '培训单位名称', '0', '0', 1, '1', '请输入', '20', '', '');
INSERT INTO `config_per_cer` (`perCerType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('010004', 'trainStartDate', '培训开始日期', '0', '1', 2, '9', '请选择', '0', '', '');
COMMIT;

-- ----------------------------
-- Table structure for config_per_industry
-- ----------------------------
DROP TABLE IF EXISTS `config_per_industry`;
CREATE TABLE `config_per_industry` (
  `industryType` varchar(6) NOT NULL COMMENT '行业类别',
  `institutionType` varchar(6) NOT NULL COMMENT '机构类型',
  `fieldCode` varchar(20) NOT NULL COMMENT '字段编码',
  `fieldName` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `isRequired` varchar(1) DEFAULT NULL COMMENT '是否必录',
  `isHidden` varchar(1) DEFAULT NULL COMMENT '是否隐藏',
  `seq` int(4) DEFAULT NULL COMMENT '顺序',
  `fieldType` varchar(2) DEFAULT NULL COMMENT '字段类型',
  `tips` varchar(100) DEFAULT NULL COMMENT '提示',
  `maxLength` varchar(4) DEFAULT NULL COMMENT '最大长度',
  `scriptEvent` varchar(200) DEFAULT NULL COMMENT '脚本事件',
  `scriptFunction` varchar(4000) DEFAULT NULL COMMENT '脚本方法',
  PRIMARY KEY (`institutionType`,`fieldCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员行业信息配置';

-- ----------------------------
-- Records of config_per_industry
-- ----------------------------
BEGIN;
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'diseaseHistory', '疾病史', '1', '0', 4, '1', '限制文字500个汉字', '500', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'isVeteran', '是否退伍军人', '1', '0', 1, '4', '退伍军人', '1', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'workMonths', '从业年限-月', '1', '0', 3, '4', '请填写从事保安年限-月', '2', NULL, NULL);
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0101', 'workYears', '从业年限-年', '1', '0', 2, '4', '请填写从事保安年限-年', '5', NULL, NULL);
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'diseaseHistory', '疾病史', '1', '0', 4, '1', '限制文字500个汉字', '500', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'isVeteran', '是否退伍军人', '1', '0', 1, '4', '退伍军人', '1', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'workMonths', '从业年限-月', '1', '0', 3, '4', '请填写从事保安年限-月', '2', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0102', 'workYears', '从业年限-年', '1', '0', 2, '4', '请填写从事保安年限-年', '5', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'diseaseHistory', '疾病史', '1', '0', 4, '1', '限制文字500个汉字', '500', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'isVeteran', '是否退伍军人', '1', '0', 1, '4', '退伍军人', '1', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'workMonths', '从业年限-月', '1', '0', 3, '4', '请填写从事保安年限-月', '2', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0103', 'workYears', '从业年限-年', '1', '0', 2, '4', '请填写从事保安年限-年', '5', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'diseaseHistory', '疾病史', '1', '0', 4, '1', '限制文字500个汉字', '500', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'isVeteran', '是否退伍军人', '1', '0', 1, '4', '退伍军人', '1', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'workMonths', '从业年限-月', '1', '0', 3, '4', '请填写从事保安年限-月', '2', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0104', 'workYears', '从业年限-年', '1', '0', 2, '4', '请填写从事保安年限-年', '5', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0105', 'diseaseHistory', '疾病史', '1', '0', 4, '1', '限制文字500个汉字', '500', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0105', 'isVeteran', '是否退伍军人', '1', '0', 1, '4', '退伍军人', '1', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0105', 'workMonths', '从业年限-月', '1', '0', 3, '4', '请填写从事保安年限-月', '2', '', '');
INSERT INTO `config_per_industry` (`industryType`, `institutionType`, `fieldCode`, `fieldName`, `isRequired`, `isHidden`, `seq`, `fieldType`, `tips`, `maxLength`, `scriptEvent`, `scriptFunction`) VALUES ('01', '0105', 'workYears', '从业年限-年', '1', '0', 2, '4', '请填写从事保安年限-年', '5', '', '');
COMMIT;

-- ----------------------------
-- Table structure for config_positiontype
-- ----------------------------
DROP TABLE IF EXISTS `config_positiontype`;
CREATE TABLE `config_positiontype` (
  `positionType` varchar(6) NOT NULL COMMENT '职位类型',
  `name` varchar(50) DEFAULT NULL COMMENT '职位类型名称',
  `parentPositionType` varchar(6) DEFAULT NULL COMMENT '上级职位类型',
  PRIMARY KEY (`positionType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='职位类型配置';

-- ----------------------------
-- Records of config_positiontype
-- ----------------------------
BEGIN;
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('01', '经营管理类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0101', '总裁/总经理/CEO', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0102', '行政总监', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0103', '技术总监CTO/总工', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0104', '人力资源总监', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0105', '财务总监CFO/总会计师', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0106', '首席信息官CIO', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0107', '首席运营官/COO', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0108', '市场/营销总监', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0109', '联盟经理', '01');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('02', '公关/市场营销类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0201', '公关经理', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0202', '公关专员', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0211', '市场经理/营销经理', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0212', '渠道经理', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0213', '产品/品牌经理', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0214', '市场助理/专员', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0215', '市场营销/推广/合作', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0216', '客户代表/营销代表', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0217', '市场策划', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0218', '市场分析/调研', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0221', 'CI设计与策划', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0222', '广告文案/媒体策划/设计', '02');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('03', '贸易/销售/业务类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0301', '国内贸易', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0302', '国外贸易/涉外业务', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0303', '跟单员', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0304', '报关员', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0311', '销售经理/区域经理/商务经理', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0312', '销售工程师/销售代表', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0313', '销售助理/业务员', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0314', '商务代表/商务助理/业务助理', '03');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('04', '财务类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0401', '财务经理/主任', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0402', '会计主管', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0411', '注册会计师', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0412', '会计', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0413', '出纳', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0421', '审计经理/主管/专员', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0422', '注册审计师', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0431', '统计', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0432', '计划', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0433', '稽核', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0434', '财务分析', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0435', '成本分析/核算', '04');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('05', '行政/人力资源管理类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0501', '行政经理/主管', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0502', '行政专员/行政秘书/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0503', '办公室主任', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0511', '人力资源经理/专员/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0512', '培训经理/专员/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0513', '招聘经理/专员/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0514', '薪酬福利经理/专员/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0515', '绩效考核经理/专员/助理', '05');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('06', '文职类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0601', '图书情报/资料/文档管理', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0602', '文秘/高级文员', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0603', '资料/文档撰写/编辑', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0611', '计算机操作员/打字员/文员/校对', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0612', '前台/接待员/礼仪', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0613', '收发员/话务员/后勤', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0621', '英语翻译', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0622', '日语翻译', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0623', '法语翻译', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0624', '德语翻译', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0625', '韩语翻译', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0626', '其它语种', '06');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('07', '客户服务类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0701', '客户服务经理', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0702', '技术支持/客户培训', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0703', '售前/售后服务', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0704', '热线咨询', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0705', '客户关系处理', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0706', '客户分析', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0707', '投诉处理', '07');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('08', '工厂类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0801', '厂长/副厂长', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0802', '厂务管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0803', '车间主任/拉长', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0811', '产品开发', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0812', '品质管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0813', '采购管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0814', '仓储管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0815', '物料管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0816', '设备管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0817', '安全管理', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0821', '配色美工', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0822', '计划/调度/协调员', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0823', 'PMC/SMT技术员', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0824', '生产控制文员', '08');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('09', '计算机/互联网类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0901', '技术主管/项目经理', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0902', '信息经理/内容主管/栏目主持', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0911', '程序员/软件工程师', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0912', '系统集成/支持', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0913', '系统分析员', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0914', '硬件开发工程师/硬件工程师', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0921', '软件测试工程师', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0922', '硬件测试工程师', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0931', '网站/电子商务开发', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0932', '网络工程师', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0933', '网站策划', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0934', '网页设计与制作', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0935', '网站美工/电脑美工', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0936', '网站编辑', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0941', '数据库开发与管理', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0942', '系统/网络管理及维护', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0943', '系统/网络/信息安全', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0951', '多媒体设计与开发', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('0952', '计算机辅助设计与绘图', '09');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('10', '电子/通讯类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1001', '技术主管/项目经理', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1011', '电子工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1012', '无线电工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1013', '电子元器件工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1014', '电路设计/电子测试/半导体技术', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1015', '单片机/DSL/DSP/底层软件开发', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1016', '广播视听设备工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1017', '电子/电器维修工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1018', '电子测试工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1019', '电子技术员', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1020', '工艺工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1021', '仪器/仪表/测量工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1022', '绘图工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1031', '通讯/通信工程师', '10');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('11', '机械类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1101', '机械工程师/模具设计', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1102', '机械制图工程师', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1103', '机械制造工程师', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1104', '机电工程师', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1105', '结构工程师', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1106', '注塑/电镀工程师', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1111', '机电技术员', '11');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('12', '规划/建筑/建材类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1201', '城镇规划设计', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1202', '风景园林规划设计', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1203', '园艺工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1211', '建筑设计', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1212', '土木建筑/工民建', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1213', '绘图/建筑制图', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1214', '结构工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1215', '测绘工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1221', '施工管理', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1222', '工程监理', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1223', '工程预决算', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1231', '装饰/安装工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1232', '道桥设计与施工', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1233', '港口与航道设计与施工', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1234', '水电/管道工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1235', '给排水工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1236', '制冷暖通工程师', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1237', '智能楼宇设计与施工', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1238', '岩土工程师/地下工程', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1241', '安全注册主任', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1242', '安全员', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1251', '建材', '12');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('13', '房地产/物业管理类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1301', '房地产开发/策划', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1302', '房地产经纪', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1303', '房地产评估/交易', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1304', '房地产销售', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1311', '物业管理经理/主管/主任', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1312', '物业管理员/助理', '13');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('14', '金融/经济', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1401', '银行会计', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1402', '储蓄员', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1403', '信贷/信贷风险控制', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1404', '银行国际业务', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1405', '投资银行', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1406', '外汇', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1407', '建筑审计', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1411', '证券经纪人', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1412', '证券投资顾问', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1413', '操盘手/交易员', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1414', '行业分析', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1415', '股评', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1416', '期货/股票经纪', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1421', '投资管理/顾问', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1422', '资产评估', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1423', '融资', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1431', '保险经纪人/保险业务员', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1441', '拍卖师', '14');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('15', '设计类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1501', '平面设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1502', '动画设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1511', '产品外观设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1512', '装璜美术设计/室内外设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1513', '服装设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1514', '广告设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1515', '珠宝设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1516', '展览设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1517', '家具设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1518', '工艺品设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1521', '形象设计', '15');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('16', '法律类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1601', '律师', '16');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1602', '法律顾问', '16');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1603', '法律助理', '16');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('17', '酒店/餐饮类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1701', '酒店经理/餐馆经理', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1702', '大堂副理/楼面经理', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1711', '领班', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1712', '厨师', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1721', '服务员', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1722', '咨客', '17');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('18', '物流/交通运输类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1801', '物流经理/主管', '18');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1802', '货运仓储经理/主管', '18');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1811', '船务', '18');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1821', '运输管理/调度', '18');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('19', '商场类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1901', '商场经理/主管', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1902', '业务经理/主任', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1911', '店面设计/陈列', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1912', '店长', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1913', '营业员/导购员/店员', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1914', '收银员', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1915', '促销员', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('1921', '物价员', '19');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('20', '电气/电力类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2001', '电力拖动与自动控制', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2002', '电机与电器', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2003', '电力工程师/电气', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2011', '电路布线设计', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2012', '智能大厦/综合布线/弱电', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2013', '灯饰研发工程师', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2014', '光源/照明', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2015', '变压器/磁电工程师', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2021', '家用电器研发', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2022', '家用电器维修', '20');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('21', '咨询/顾问类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2101', '企业管理咨询', '21');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2102', '企业管理顾问', '21');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2103', '信息咨询/中介', '21');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2104', '培训师', '21');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('22', '化工/生物类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2201', '化工生产工程师', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2202', '精细化工工程师', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2203', '高分子材料工程师', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2204', '化工制药', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2211', '化验员/检验员', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2212', '化工生产技术员', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2221', '生物工程', '22');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('23', '文化/教育/体育类/艺术类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2301', '图书情报/资料/文档管理', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2311', '高等教育', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2312', '中等教育', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2313', '小学教育/幼儿教育/保育员', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2314', '职业教育/培训/家教', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2321', '体育教练/健美教练', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2331', '模特', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2332', '舞蹈', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2333', '声乐', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2334', '器乐', '23');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('24', '医疗卫生/护理/保健类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2401', '西医', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2402', '中医', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2403', '心理医生', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2404', '兽医/宠物医生', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2405', '医疗技术/医学检验师', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2406', '药剂师', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2407', '麻醉师', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2411', '护理人员/护士', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2421', '卫生防疫', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2422', '妇幼保健', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2423', '针灸推拿', '24');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('25', '新闻/出版/传媒类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2501', '总编/主编', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2502', '文字编辑', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2503', '美术编辑/美工', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2511', '记者/新闻采编', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2512', '摄影录制', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2521', '节目主持/DJ/播音', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2522', '演员', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2523', '影视策划/制作', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2524', '音效师', '25');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('26', '公众服务类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2601', '保安/消防员', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2602', '快递员', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2611', '旅游/导游', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2612', '声讯', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2621', '按摩师/美容/美发', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2622', '家政', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2623', '裁缝', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2624', '环卫工', '26');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('27', '印刷/染织类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2701', '印刷主管', '27');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2702', '印刷技工', '27');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2703', '版房制版师傅', '27');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2704', '晒版师', '27');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2711', '染织类', '27');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('28', '技工类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2801', '机器冷加工/车、铣、刨、磨、镗、锯等', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2802', '机器热加工/铸、锻、冲压、焊、金属热处理、注塑等', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2803', '装配工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2804', '叉车工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2805', '汽车修理工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2811', '司机', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2821', '水/木/漆工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2822', '电工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2823', '空调工/电梯工/锅炉工', '28');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('29', '其他专业类', NULL);
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2901', '食品类', '29');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2902', '造纸类', '29');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2903', '家具制造类', '29');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2904', '农林牧渔/水利类', '29');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2905', '地质/矿产类', '29');
INSERT INTO `config_positiontype` (`positionType`, `name`, `parentPositionType`) VALUES ('2906', '环境保护/监测/治理类', '29');
COMMIT;

-- ----------------------------
-- Table structure for config_product_buy_mode
-- ----------------------------
DROP TABLE IF EXISTS `config_product_buy_mode`;
CREATE TABLE `config_product_buy_mode` (
  `productBuyModeId` varchar(8) NOT NULL COMMENT '产品购买方式ID',
  `productId` varchar(6) NOT NULL COMMENT '产品ID',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `productBuyMode` varchar(6) NOT NULL COMMENT '购买方式',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '费用',
  `unit` varchar(20) DEFAULT NULL COMMENT '单位',
  PRIMARY KEY (`productBuyModeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品购买方式';

-- ----------------------------
-- Records of config_product_buy_mode
-- ----------------------------
BEGIN;
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11010101', '110101', '0', '1', 150.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11010102', '110101', '1', '2', 1200.00, '元/个/年（原价1500元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020101', '110201', '0', '1', 250.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020102', '110201', '1', '2', 2000.00, '元/个/年（原价2500元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020201', '110202', '0', '1', 750.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020202', '110202', '0', '2', 4200.00, '元/个/年（原价7500元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020301', '110203', '0', '1', 750.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020302', '110203', '1', '2', 6000.00, '元/个/年（原价7500元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020401', '110204', '0', '1', 1500.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020402', '110204', '1', '2', 12000.00, '元/个/年（原价15000元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020501', '110205', '0', '1', 3000.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020502', '110205', '1', '2', 24000.00, '元/个/年（原价30000元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020601', '110206', '0', '1', 4500.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020602', '110206', '1', '2', 36000.00, '元/个/年（原价45000元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020701', '110207', '0', '1', 6000.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020702', '110207', '1', '2', 48000.00, '元/个/年（原价60000元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020801', '110208', '0', '1', 7500.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11020802', '110208', '1', '2', 60000.00, '元/个/年（原价75000元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030103', '110301', '1', '3', 25999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030203', '110302', '1', '3', 54999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030303', '110303', '1', '3', 2999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030403', '110304', '1', '3', 299.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030503', '110305', '1', '3', 999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030603', '110306', '1', '3', 64999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030703', '110307', '1', '3', 2999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11030803', '110308', '1', '3', 2999.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11040103', '110401', '1', '3', 23751.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11050103', '110501', '1', '3', 7425.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060101', '110601', '1', '1', 258.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060102', '110601', '0', '2', 1008.00, '元/个/年（原价1440元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060201', '110602', '0', '1', 144.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060202', '110602', '1', '2', 1008.00, '元/个/年（原价1440元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060301', '110603', '0', '1', 228.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060302', '110603', '1', '2', 1596.00, '元/个/年（原价2280元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060401', '110604', '0', '1', 228.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11060402', '110604', '1', '2', 1596.00, '元/个/年（原价2280元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11070102', '110701', '1', '2', 20.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11070202', '110702', '1', '2', 90.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11070302', '110703', '1', '2', 180.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11070402', '110704', '1', '2', 850.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11080101', '110801', '0', '1', 1370.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11080102', '110801', '1', '2', 13700.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090101', '110901', '0', '1', 333.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090102', '110901', '1', '2', 2664.00, '元/个/年（原价3330元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090201', '110902', '0', '1', 391.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090202', '110902', '1', '2', 3128.00, '元/个/年（原价3910元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090301', '110903', '0', '1', 1175.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090302', '110903', '1', '2', 9400.00, '元/个/年（原价11750元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090401', '110904', '0', '1', 2048.00, '元/个/月');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('11090402', '110904', '1', '2', 16384.00, '元/个/年（原价20480元）');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('12010102', '120101', '1', '2', 1000.00, '元/个/年');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('12020103', '120201', '1', '3', 50.00, '元/个');
INSERT INTO `config_product_buy_mode` (`productBuyModeId`, `productId`, `isActive`, `productBuyMode`, `amount`, `unit`) VALUES ('12020203', '120202', '1', '3', 100.00, '元/个');
COMMIT;

-- ----------------------------
-- Table structure for config_product_category
-- ----------------------------
DROP TABLE IF EXISTS `config_product_category`;
CREATE TABLE `config_product_category` (
  `productCategoryType` varchar(6) NOT NULL COMMENT '产品范畴类型',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `name` varchar(50) DEFAULT NULL COMMENT '产品范畴名称',
  `remark` varchar(100) DEFAULT NULL COMMENT '描述',
  `productCategoryUrl` varchar(200) DEFAULT NULL COMMENT '图片URL',
  PRIMARY KEY (`productCategoryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品范畴';

-- ----------------------------
-- Records of config_product_category
-- ----------------------------
BEGIN;
INSERT INTO `config_product_category` (`productCategoryType`, `isActive`, `name`, `remark`, `productCategoryUrl`) VALUES ('11', '1', '云会议', '警企、企企、企内云会议服务，支持软硬件开会。快速一键入会，一体化会控功能', NULL);
INSERT INTO `config_product_category` (`productCategoryType`, `isActive`, `name`, `remark`, `productCategoryUrl`) VALUES ('12', '1', '防控指挥', '开通服务后，即可对企业内正在执勤的保安员进行文字、语音、视频实时调度进行防控指挥', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_product_info
-- ----------------------------
DROP TABLE IF EXISTS `config_product_info`;
CREATE TABLE `config_product_info` (
  `productId` varchar(6) NOT NULL COMMENT '产品ID',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `name` varchar(50) DEFAULT NULL COMMENT '产品名称',
  `remark` varchar(100) DEFAULT NULL COMMENT '描述',
  `productStatus` varchar(6) DEFAULT NULL COMMENT '产品状态',
  `productUrl` varchar(200) DEFAULT NULL COMMENT '产品图片URL',
  `productType` varchar(6) NOT NULL COMMENT '产品类型',
  PRIMARY KEY (`productId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品信息';

-- ----------------------------
-- Records of config_product_info
-- ----------------------------
BEGIN;
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110101', '1', '账号数', '', '1', '', '1101');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110201', '1', '10方云会议室', '会议室最多能容纳10方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110202', '0', '25方云会议室', '会议室最多能容纳25方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110203', '1', '50方云会议室', '会议室最多能容纳50方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110204', '1', '100方云会议室', '会议室最多能容纳100方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110205', '1', '200方云会议室', '会议室最多能容纳200方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110206', '1', '300方云会议室', '会议室最多能容纳300方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110207', '1', '400方云会议室', '会议室最多能容纳400方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110208', '1', '500方云会议室', '会议室最多能容纳500方加入会议，一个会议成员或一个硬件设备接入占用1方。', '1', '', '1102');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110301', '1', '会议宝 IdeaHub S 65', '包含：1个IdeaHub 接入账号（1年）；10方会议资源（1年）。加赠：50方云会议室（1年）。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763272832689917.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110302', '1', '会议宝 IdeaHub S 86', '包含：1个IdeaHub 接入账号（1年）；10方会议资源（1年）。加赠：100方云会议室（1年）。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763272832689917.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110303', '1', '会议宝 IdeaHub 落地支架（65英寸）', '仅支持65英寸会议宝使用。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763328457093290.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110304', '1', '会议宝 IdeaHub 挂架', '挂架安装须为实体承重墙，需在垂直承重且厚度大于20cm的实心砖墙或混凝土墙上安装，请在购买前确认安装环境。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763362343842320.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110305', '1', '投屏器 IdeaShare Key', '不受”线“制，一键投屏。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763386981202348.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110306', '1', '会议宝 IdeaHub  86  PRO', '包含：1个IdeaHub 接入账号（1年）；10方会议资源（1年）。加赠：100方云会议室（1年）。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763272832689917.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110307', '1', '会议宝 IdeaHub 落地支架（86英寸 白色）', '仅支持86英寸会议宝使用。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763328457093290.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110308', '0', '会议宝 IdeaHub 落地支架（86英寸 灰色）', '仅支持86英寸会议宝使用。', '1', 'http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-22%2F1600763328457093290.png', '1103');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110401', '0', 'TE30 Cloud', '一体化设计，适用于企业中小型会议室；内置12倍光学变焦摄像机、高清编解码器、麦克风、Wi-Fi', '1', 'https://bcxin-saas-test.obs.cn-north-1.myhuaweicloud.com/upload%2F2020-01-16%2F1579178531948829527.png', '1104');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110501', '0', 'Camera 200', '', '1', 'https://bcxin-saas-test.obs.cn-north-1.myhuaweicloud.com/upload%2F2020-01-16%2F1579178545475248373.png', '1105');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110601', '1', 'IdeaHub 接入账号', '适用于IdeaHub，支持1080P视频分辨率。', '1', '', '1106');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110602', '0', '华为小型会议终端接入账号', '适用于华为TE10小型会议终端设备，支持720P视频分辨率', '0', '', '1106');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110603', '0', '华为中型会议终端接入账号', '适用于华为TE20、TE30、TE40、TE50、TE60、Camera200、CloudLink协作智真系列等会议设备，支持1080P视频分辨率。', '1', '', '1106');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110604', '0', '第三方会议终端接入账号', '适用于思科、宝利通等第三方会议设备，支持1080P视频分辨率', '1', '', '1106');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110701', '0', '100分钟外呼包', '每分钟低至0.2元', '0', '', '1107');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110702', '0', '200分钟外呼包', '每分钟低至0.18元', '0', '', '1107');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110703', '0', '1000分钟外呼包', '每分钟低至0.18元；送100分钟', '0', '', '1107');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110704', '0', '5000分钟外呼包', '每分钟低至0.17元，送550分钟', '0', '', '1107');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110801', '0', '直播端口', '订购后开启会议直播端口，使用直播服务还需订购直播间观看人数（需在直播间进行会议直播），请前往购买', '0', '', '1108');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110901', '1', '50G录播空间', '50G空间最低可录制23小时的会议', '1', '', '1109');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110902', '1', '100G录播空间', '100G空间最低可录制40小时的会议。', '1', '', '1109');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110903', '1', '500G录播空间', '500G空间最低可录制200小时的会议。', '1', '', '1109');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('110904', '1', '1T录播空间', '1T空间最低可录制400小时的会议。', '1', '', '1109');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('120101', '0', '服务年费', '有效期为1年，到期后系统自动关闭服务', '0', '', '1201');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('120201', '0', '视频调度100分钟包', '', '0', '', '1202');
INSERT INTO `config_product_info` (`productId`, `isActive`, `name`, `remark`, `productStatus`, `productUrl`, `productType`) VALUES ('120202', '0', '视频调度1000分钟包', '', '0', '', '1202');
COMMIT;

-- ----------------------------
-- Table structure for config_product_type
-- ----------------------------
DROP TABLE IF EXISTS `config_product_type`;
CREATE TABLE `config_product_type` (
  `productType` varchar(6) NOT NULL COMMENT '产品类型',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否可用',
  `name` varchar(50) DEFAULT NULL COMMENT '产品类型名称',
  `remark` varchar(100) DEFAULT NULL COMMENT '描述',
  `productTypeUrl` varchar(200) DEFAULT NULL COMMENT '图片URL',
  `productServiceType` varchar(6) NOT NULL COMMENT '产品服务类型',
  `productCategoryType` varchar(6) NOT NULL COMMENT '产品范畴类型',
  PRIMARY KEY (`productType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品类型';

-- ----------------------------
-- Records of config_product_type
-- ----------------------------
BEGIN;
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1101', '1', '会议账号数', '购买会议账号数后，可添加同等数量的会议用户数，会议用户即可参与其他组织发起的会议，如公安会议、协会会议、其他企业会议。', '', '1', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1102', '1', '云会议室', '购买云会议室后，即可进行企业开会。同一云会议室只能同时召开一个会议；每个云会议室拥有一名会议管理员，只有会议管理员可以开会；可添加会议用户数量=会议室方数*25，购买多个云会议室可累加。', '', '1', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1103', '1', '云会议宝', '65寸/86英寸4K超清显示屏；内置摄像头、无线传屏、智能书写、视频会议。需购买硬件接入账号配合使用。', '', '2', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1104', '1', '华为会议终端', '', '', '2', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1105', '0', '设置配件', '', '', '2', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1106', '1', '硬件接入账号', '', '', '2', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1107', '0', 'PSTN外呼', '购买后启用电话外呼服务，会议中可呼叫手机参与会议；外呼报分钟使用超出部分将按照0.22元/分钟收费', '', '3', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1108', '0', '直播端口', '', '', '3', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1109', '1', '录播空间', '购买后，发起会议时可以选择是否开启会议录制，录制生成的文件会占用录播空间', '', '3', '11');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1201', '0', '服务年费', '购买后，立即开启，即可使用', '', '3', '12');
INSERT INTO `config_product_type` (`productType`, `isActive`, `name`, `remark`, `productTypeUrl`, `productServiceType`, `productCategoryType`) VALUES ('1202', '0', '视频调度时长包', '', '', '3', '12');
COMMIT;

-- ----------------------------
-- Table structure for config_product_yhy_resource_item
-- ----------------------------
DROP TABLE IF EXISTS `config_product_yhy_resource_item`;
CREATE TABLE `config_product_yhy_resource_item` (
  `productId` varchar(6) NOT NULL COMMENT '产品ID',
  `service_type` varchar(50) DEFAULT NULL COMMENT '云服务类型',
  `res_type` varchar(100) DEFAULT NULL COMMENT '资源类型',
  `res_spec_code` varchar(100) DEFAULT NULL COMMENT '资源规格',
  `type` varchar(20) DEFAULT NULL COMMENT '资源类型',
  `typeId` varchar(50) DEFAULT NULL COMMENT '类型标识',
  PRIMARY KEY (`productId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='云会议产品资源';

-- ----------------------------
-- Records of config_product_yhy_resource_item
-- ----------------------------
BEGIN;
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110101', 'hws.service.type.cloudvc', 'hws.resource.type.vc.writeboardaccount', 'vc.writeboardaccount', 'SOFT', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110201', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-10', 'VMR', 'ff808081699b56d40169c410d5080179');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110202', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-25', 'VMR', 'ff808081699b56d40169c4111fe5017a');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110203', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-50', 'VMR', 'ff808081699b56cb0169c411a0980152');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110204', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-100', 'VMR', 'ff808081699b56cb0169c41167850151');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110205', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-200', 'VMR', 'ff808081699b56d40169c410913d0178');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110206', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-300', 'VMR', 'ff8080816b9ec3ab016bdff237962e83');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110207', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-400', 'VMR', 'ff8080816b9ec475016bdff37efc279f');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110208', 'hws.service.type.cloudvc', 'hws.resource.type.vc.vmr', 'vc-vmr-500', 'VMR', 'ff8080816b9ec3ab016bdff338542e84');
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110305', 'hws.service.type.partnerdevices', 'hws.resource.type.partnerdevices.maxhub', 'maxhub.maxhub-Bracket', NULL, NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110401', 'hws.service.type.ecendpoint', 'hws.resource.type.ecendpoint.te30', 'TE30', NULL, NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110601', 'hws.service.type.cloudvc', 'hws.resource.type.vc.writeboardaccount', 'vc.writeboardaccount', 'ROOM', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110602', 'hws.service.type.cloudvc', 'hws.resource.type.vc.720hardaccount30', 'vc.720hardaccount30', 'HARD_720P', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110603', 'hws.service.type.cloudvc', 'hws.resource.type.vc.1080hardaccount30', 'vc.1080hardaccount30', 'HARD_1080P', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110604', 'hws.service.type.cloudvc', 'hws.resource.type.vc.thirdhardaccount', 'thirdhardaccount', 'HARD_THIRD_PARTY', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110801', 'hws.service.type.cloudvc', 'hws.resource.type.vc.liveport', 'vc-liveport', 'LIVE', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110901', 'hws.service.type.cloudvc', 'hws.resource.type.vc.record', 'vc-record-50g', 'RECORD', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110902', 'hws.service.type.cloudvc', 'hws.resource.type.vc.record', 'vc-record-100g', 'RECORD', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110903', 'hws.service.type.cloudvc', 'hws.resource.type.vc.record', 'vc-record-500g', 'RECORD', NULL);
INSERT INTO `config_product_yhy_resource_item` (`productId`, `service_type`, `res_type`, `res_spec_code`, `type`, `typeId`) VALUES ('110904', 'hws.service.type.cloudvc', 'hws.resource.type.vc.record', 'vc-record-1t', 'RECORD', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_provine_age_limit
-- ----------------------------
DROP TABLE IF EXISTS `config_provine_age_limit`;
CREATE TABLE `config_provine_age_limit` (
  `provinceId` int(6) NOT NULL COMMENT '省份ID',
  `provinceName` varchar(20) DEFAULT NULL COMMENT '省份名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否启用',
  `seq` int(3) DEFAULT NULL COMMENT '排序',
  `maxAge` int(3) DEFAULT NULL COMMENT '最大年龄',
  `minAge` int(3) DEFAULT NULL COMMENT '最小年龄',
  PRIMARY KEY (`provinceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='各省保安员年龄限制配置';

-- ----------------------------
-- Records of config_provine_age_limit
-- ----------------------------
BEGIN;
INSERT INTO `config_provine_age_limit` (`provinceId`, `provinceName`, `isActive`, `seq`, `maxAge`, `minAge`) VALUES (110000, '北京市', '1', 1, 60, 18);
INSERT INTO `config_provine_age_limit` (`provinceId`, `provinceName`, `isActive`, `seq`, `maxAge`, `minAge`) VALUES (450000, '广西壮族自治区', '1', 2, 65, 18);
INSERT INTO `config_provine_age_limit` (`provinceId`, `provinceName`, `isActive`, `seq`, `maxAge`, `minAge`) VALUES (610000, '陕西省', '1', 3, 60, 18);
INSERT INTO `config_provine_age_limit` (`provinceId`, `provinceName`, `isActive`, `seq`, `maxAge`, `minAge`) VALUES (640000, '宁夏回族自治区', '1', 4, 60, 18);
INSERT INTO `config_provine_age_limit` (`provinceId`, `provinceName`, `isActive`, `seq`, `maxAge`, `minAge`) VALUES (650000, '新疆', '1', 5, 60, 18);
COMMIT;

-- ----------------------------
-- Table structure for config_region_train_give
-- ----------------------------
DROP TABLE IF EXISTS `config_region_train_give`;
CREATE TABLE `config_region_train_give` (
  `regionId` int(20) NOT NULL COMMENT '区域ID',
  `isGive` varchar(1) DEFAULT NULL COMMENT '是否赠送',
  PRIMARY KEY (`regionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域培训赠送配置';

-- ----------------------------
-- Records of config_region_train_give
-- ----------------------------
BEGIN;
INSERT INTO `config_region_train_give` (`regionId`, `isGive`) VALUES (110000, '1');
INSERT INTO `config_region_train_give` (`regionId`, `isGive`) VALUES (450000, '1');
INSERT INTO `config_region_train_give` (`regionId`, `isGive`) VALUES (610000, '1');
COMMIT;

-- ----------------------------
-- Table structure for config_salary_category
-- ----------------------------
DROP TABLE IF EXISTS `config_salary_category`;
CREATE TABLE `config_salary_category` (
  `salaryCategory` varchar(6) NOT NULL COMMENT '薪资范畴',
  `categoryName` varchar(50) DEFAULT NULL COMMENT '薪资范畴名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否启用',
  `seq` int(3) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`salaryCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='薪资项目范畴配置';

-- ----------------------------
-- Records of config_salary_category
-- ----------------------------
BEGIN;
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('11', '员工工资：', '1', 1);
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('12', '福利补贴：', '1', 2);
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('13', '内勤计薪：', '1', 3);
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('14', '外勤计薪：', '1', 4);
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('30', '社保公积金：（五险一金缴纳金额请到【五险一金设置】中设置，若未设置，则金额为0）', '1', 5);
INSERT INTO `config_salary_category` (`salaryCategory`, `categoryName`, `isActive`, `seq`) VALUES ('31', '个人所得税：', '1', 6);
COMMIT;

-- ----------------------------
-- Table structure for config_salary_type
-- ----------------------------
DROP TABLE IF EXISTS `config_salary_type`;
CREATE TABLE `config_salary_type` (
  `salaryType` varchar(6) NOT NULL COMMENT '薪资类型',
  `salaryName` varchar(20) DEFAULT NULL COMMENT '薪资名称',
  `isActive` varchar(1) DEFAULT NULL COMMENT '是否启用',
  `seq` int(3) DEFAULT NULL COMMENT '排序',
  `isRequired` varchar(1) DEFAULT NULL COMMENT '是否必录',
  `isSelect` varchar(1) DEFAULT NULL COMMENT '是否默认选中',
  `isEdit` varchar(1) DEFAULT NULL COMMENT '是否可编辑',
  `calUnit` varchar(20) DEFAULT NULL COMMENT '计算单位',
  `calRule` varchar(6) NOT NULL COMMENT '计算规则',
  `tips` varchar(50) DEFAULT NULL COMMENT '提示',
  `salaryCategory` varchar(6) DEFAULT NULL COMMENT '薪资范畴',
  PRIMARY KEY (`salaryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='薪资项目类型配置';

-- ----------------------------
-- Records of config_salary_type
-- ----------------------------
BEGIN;
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1101', '基本工资', '1', 1, '1', '1', '1', '元/月', '+', NULL, '11');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1102', '绩效工资', '1', 2, '0', '0', '1', '元/月', '+', NULL, '11');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1201', '岗位津贴', '1', 1, '0', '0', '1', '元/月', '+', NULL, '12');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1202', '差旅补贴', '1', 2, '0', '0', '1', '元/月', '+', NULL, '12');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1203', '通讯补贴', '1', 3, '0', '0', '1', '元/月', '+', NULL, '12');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1204', '餐饮补贴', '1', 4, '0', '0', '1', '元/月', '+', NULL, '12');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1209', '其他补贴', '1', 5, '0', '0', '1', '元/月', '+', NULL, '12');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1301', '迟到扣款（内勤）', '1', 1, '0', '1', '1', '元/次', '-', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1302', '早退扣款（内勤）', '1', 2, '0', '1', '1', '元/次', '-', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1303', '旷工扣款（内勤）', '1', 3, '0', '1', '1', '元/天', '-', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1304', '事假扣款（内勤）', '1', 4, '0', '1', '1', '元/时', '-', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1305', '病假扣款（内勤）', '1', 5, '0', '1', '1', '元/时', '-', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1306', '工作日加班补贴', '1', 7, '0', '1', '1', '元/时', '+', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1307', '休息日加班补贴', '1', 8, '0', '1', '1', '元/时', '+', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1308', '节假日加班补贴', '1', 9, '0', '1', '1', '元/时', '+', NULL, '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1309', '漏卡扣款（内勤）', '1', 6, '0', '1', '1', '元/次', '-', '注：若全天漏卡，则按旷工扣款', '13');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1401', '迟到扣款（外勤）', '1', 1, '0', '1', '1', '元/次', '-', NULL, '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1402', '早退扣款（外勤）', '1', 2, '0', '1', '1', '元/次', '-', NULL, '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1403', '旷工扣款（外勤）', '1', 3, '0', '1', '1', '元/天', '-', NULL, '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1404', '事假扣款（外勤）', '1', 4, '0', '1', '1', '元/时', '-', NULL, '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1405', '病假扣款（外勤）', '1', 5, '0', '1', '1', '元/时', '-', NULL, '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('1406', '漏卡扣款（外勤）', '1', 6, '0', '1', '1', '元/次', '-', '注：若全天漏卡，则按旷工扣款', '14');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('3001', '代扣养老金', '1', 1, '1', '1', '0', NULL, '-', NULL, '30');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('3002', '代扣失业金', '1', 2, '1', '1', '0', NULL, '-', NULL, '30');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('3003', '代扣医保', '1', 3, '1', '1', '0', NULL, '-', NULL, '30');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('3008', '代扣公积金', '1', 4, '1', '1', '0', NULL, '-', NULL, '30');
INSERT INTO `config_salary_type` (`salaryType`, `salaryName`, `isActive`, `seq`, `isRequired`, `isSelect`, `isEdit`, `calUnit`, `calRule`, `tips`, `salaryCategory`) VALUES ('3101', '个人所得税', '1', 1, '1', '1', '0', NULL, '-', NULL, '31');
COMMIT;

-- ----------------------------
-- Table structure for config_task_traject
-- ----------------------------
DROP TABLE IF EXISTS `config_task_traject`;
CREATE TABLE `config_task_traject` (
  `configTaskTrajectId` bigint(20) NOT NULL COMMENT '业务日志明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `provinceId` int(20) NOT NULL COMMENT '省份ID',
  `interfaceAddress` varchar(50) DEFAULT NULL COMMENT '接口地址',
  `interfaceOperType` varchar(6) DEFAULT NULL COMMENT '接口操作类型',
  `description` varchar(100) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`configTaskTrajectId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务轨迹接口配置表';

-- ----------------------------
-- Records of config_task_traject
-- ----------------------------
BEGIN;
INSERT INTO `config_task_traject` (`configTaskTrajectId`, `createTime`, `createBy`, `provinceId`, `interfaceAddress`, `interfaceOperType`, `description`) VALUES (1, '2018-03-13 15:21:25', NULL, 350000, 'http://120.76.218.179:9085/ars-rest', 'read', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_taskbigtype
-- ----------------------------
DROP TABLE IF EXISTS `config_taskbigtype`;
CREATE TABLE `config_taskbigtype` (
  `institutionType` varchar(6) NOT NULL COMMENT '机构类型',
  `taskBigType` varchar(6) NOT NULL COMMENT '任务大类',
  `name` varchar(20) DEFAULT NULL COMMENT '任务大类名称',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`institutionType`,`taskBigType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务大类配置';

-- ----------------------------
-- Records of config_taskbigtype
-- ----------------------------
BEGIN;
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0101', '010001', '大型活动', 1);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0101', '010005', '其他任务', 2);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0101', '010009', '自定义任务', 3);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010001', '大型活动', 1);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010002', '安保服务', 2);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010003', '事故救援', 3);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010004', '应急处置', 4);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010005', '其他任务', 5);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0102', '010009', '自定义任务', 6);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0103', '010003', '事故救援', 1);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0103', '010005', '其他任务', 2);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0103', '010009', '自定义任务', 3);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010001', '大型活动', 1);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010002', '安保服务', 2);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010003', '事故救援', 3);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010004', '应急处置', 4);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010005', '其他任务', 5);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0104', '010009', '自定义任务', 6);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010001', '大型活动', 1);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010002', '安保服务', 2);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010003', '事故救援', 3);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010004', '应急处置', 4);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010005', '其他任务', 5);
INSERT INTO `config_taskbigtype` (`institutionType`, `taskBigType`, `name`, `seq`) VALUES ('0105', '010009', '自定义任务', 6);
COMMIT;

-- ----------------------------
-- Table structure for config_tasktype
-- ----------------------------
DROP TABLE IF EXISTS `config_tasktype`;
CREATE TABLE `config_tasktype` (
  `taskTypeId` varchar(6) NOT NULL COMMENT '任务类型',
  `taskType` varchar(8) NOT NULL COMMENT '任务类型',
  `name` varchar(20) DEFAULT NULL COMMENT '任务类型名称',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `taskBigType` varchar(6) NOT NULL COMMENT '任务大类',
  `isComDefined` varchar(1) DEFAULT NULL COMMENT '是否企业自定义',
  `comId` bigint(20) DEFAULT NULL COMMENT '企业ID',
  PRIMARY KEY (`taskTypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务类型配置';

-- ----------------------------
-- Records of config_tasktype
-- ----------------------------
BEGIN;
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('1', '01000101', '体育赛事', 1, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('10', '01000204', '安全检查', 4, '010002', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('11', '01000205', '押运', 5, '010002', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('12', '01000206', '技术防范', 6, '010002', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('13', '01000301', '自然灾害救援', 1, '010003', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('14', '01000302', '事故灾难救援', 2, '010003', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('15', '01000401', '公共卫生应急处置', 1, '010004', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('16', '01000402', '社会安全应急处理', 2, '010004', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('17', '01000501', '其他任务', 1, '010005', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('2', '01000102', '文艺演出', 2, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('3', '01000103', '展览展销', 3, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('4', '01000104', '游园灯会', 4, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('5', '01000105', '招聘会', 5, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('6', '01000106', '公益慈善', 6, '010001', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('7', '01000201', '巡逻', 1, '010002', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('8', '01000202', '守卫', 2, '010002', '0', NULL);
INSERT INTO `config_tasktype` (`taskTypeId`, `taskType`, `name`, `seq`, `taskBigType`, `isComDefined`, `comId`) VALUES ('9', '01000203', '随身护卫', 3, '010002', '0', NULL);
COMMIT;

-- ----------------------------
-- Table structure for config_tax
-- ----------------------------
DROP TABLE IF EXISTS `config_tax`;
CREATE TABLE `config_tax` (
  `taxLevel` int(5) NOT NULL COMMENT '税率等级',
  `taxAboveMin` int(10) NOT NULL COMMENT '超过起征点的税额最小值',
  `taxAboveMax` int(10) NOT NULL COMMENT '超过起征点的税额最大值',
  `taxRate` varchar(10) DEFAULT NULL COMMENT '税率',
  `deduction` varchar(10) DEFAULT NULL COMMENT '速算扣除数',
  PRIMARY KEY (`taxLevel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='税率计算配置';

-- ----------------------------
-- Records of config_tax
-- ----------------------------
BEGIN;
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (1, 0, 3000, '3', '0');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (2, 3000, 12000, '10', '210');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (3, 12000, 25000, '20', '1410');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (4, 25000, 35000, '25', '2660');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (5, 35000, 55000, '30', '4410');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (6, 55000, 80000, '35', '7160');
INSERT INTO `config_tax` (`taxLevel`, `taxAboveMin`, `taxAboveMax`, `taxRate`, `deduction`) VALUES (7, 80000, 99999999, '45', '15160');
COMMIT;

-- ----------------------------
-- Table structure for count_per_attend_approve_date
-- ----------------------------
DROP TABLE IF EXISTS `count_per_attend_approve_date`;
CREATE TABLE `count_per_attend_approve_date` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `attendDate` date NOT NULL COMMENT '考勤日期',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `workDayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '工作日加班(时)',
  `restDayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '休息日加班(时)',
  `HolidayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '节假日加班(时)',
  `absenceLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '事假时长(时)',
  `sickLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '病假时长(时)',
  `yearLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '年假时长(时)',
  `marriageLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '婚假时长(时)',
  `breakOffTime` decimal(4,2) DEFAULT '0.00' COMMENT '调休时长(时)',
  `maternityLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '产假时长(时)',
  `publicLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '公假时长(时)',
  `chargeLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '主管假时长(时)',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`perId`,`attendDate`),
  KEY `index_per_attend_approve_date_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员考勤审批日统计表';

-- ----------------------------
-- Records of count_per_attend_approve_date
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for count_per_attend_date
-- ----------------------------
DROP TABLE IF EXISTS `count_per_attend_date`;
CREATE TABLE `count_per_attend_date` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `attendDate` date NOT NULL COMMENT '考勤日期',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `normalAttendTimes` int(3) DEFAULT NULL COMMENT '正常考勤次数',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `isAbsenteeism` varchar(1) DEFAULT '0' COMMENT '是否缺勤',
  `absenceTime` decimal(4,2) DEFAULT '0.00' COMMENT '缺勤时长(时)',
  `lateTimes` int(3) DEFAULT '0' COMMENT '迟到次数',
  `totalLateTime` int(6) DEFAULT '0' COMMENT '总迟到时间(分钟)',
  `leaveEarlyTimes` int(3) DEFAULT '0' COMMENT '早退次数',
  `totalLeaveEarlyTime` int(6) DEFAULT '0' COMMENT '总早退时间(分钟)',
  `missCardTimes` int(3) DEFAULT '0' COMMENT '缺卡次数',
  `workHours` decimal(4,2) DEFAULT NULL COMMENT '总工时(时)',
  `firstRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第一轮上班打卡结果',
  `firstRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第一轮下班打卡结果',
  `secondRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第二轮上班打卡结果',
  `secondRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第二轮下班打卡结果',
  `thirdRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第三轮上班打卡结果',
  `thirdRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第三轮下班打卡结果',
  `fourthRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第四轮上班打卡结果',
  `fourthRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第四轮下班打卡结果',
  `fifthRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第五轮上班打卡结果',
  `fifthRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第五轮下班打卡结果',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `departId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `attendGroupId` bigint(20) NOT NULL COMMENT '考勤组ID',
  PRIMARY KEY (`perId`,`attendDate`),
  KEY `index_per_attend_date_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员考勤日统计表';

-- ----------------------------
-- Records of count_per_attend_date
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for count_per_task_approve_date
-- ----------------------------
DROP TABLE IF EXISTS `count_per_task_approve_date`;
CREATE TABLE `count_per_task_approve_date` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `attendDate` date NOT NULL COMMENT '考勤日期',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `workDayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '工作日加班(时)',
  `restDayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '休息日加班(时)',
  `HolidayOverTime` decimal(4,2) DEFAULT '0.00' COMMENT '节假日加班(时)',
  `absenceLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '事假时长(时)',
  `sickLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '病假时长(时)',
  `yearLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '年假时长(时)',
  `marriageLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '婚假时长(时)',
  `breakOffTime` decimal(4,2) DEFAULT '0.00' COMMENT '调休时长(时)',
  `maternityLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '产假时长(时)',
  `publicLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '公假时长(时)',
  `chargeLeaveTime` decimal(4,2) DEFAULT '0.00' COMMENT '主管假时长(时)',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`perId`,`attendDate`,`comTaskId`),
  KEY `index_per_task_approve_date_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员外勤审批日统计表';

-- ----------------------------
-- Records of count_per_task_approve_date
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for count_per_task_date
-- ----------------------------
DROP TABLE IF EXISTS `count_per_task_date`;
CREATE TABLE `count_per_task_date` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `attendDate` date NOT NULL COMMENT '考勤日期',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `normalAttendTimes` int(3) DEFAULT NULL COMMENT '正常考勤次数',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `isAbsenteeism` varchar(1) DEFAULT '0' COMMENT '是否缺勤',
  `absenceTime` decimal(4,2) DEFAULT '0.00' COMMENT '缺勤时长(时)',
  `lateTimes` int(3) DEFAULT '0' COMMENT '迟到次数',
  `totalLateTime` int(6) DEFAULT '0' COMMENT '总迟到时间(分钟)',
  `leaveEarlyTimes` int(3) DEFAULT '0' COMMENT '早退次数',
  `totalLeaveEarlyTime` int(6) DEFAULT '0' COMMENT '总早退时间(分钟)',
  `missCardTimes` int(3) DEFAULT '0' COMMENT '缺卡次数',
  `workHours` decimal(4,2) DEFAULT NULL COMMENT '总工时(时)',
  `firstRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第一轮上班打卡结果',
  `firstRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第一轮下班打卡结果',
  `secondRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第二轮上班打卡结果',
  `secondRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第二轮下班打卡结果',
  `thirdRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第三轮上班打卡结果',
  `thirdRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第三轮下班打卡结果',
  `fourthRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第四轮上班打卡结果',
  `fourthRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第四轮下班打卡结果',
  `fifthRoundOnWork` varchar(80) DEFAULT NULL COMMENT '第五轮上班打卡结果',
  `fifthRoundOffWork` varchar(80) DEFAULT NULL COMMENT '第五轮下班打卡结果',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `departId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`perId`,`attendDate`,`comTaskId`),
  KEY `index_per_task_date_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员外勤日统计表';

-- ----------------------------
-- Records of count_per_task_date
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mid_attend_group
-- ----------------------------
DROP TABLE IF EXISTS `mid_attend_group`;
CREATE TABLE `mid_attend_group` (
  `midAttendGroupId` bigint(20) NOT NULL COMMENT '考勤组中间表ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
  `attendGroupId` bigint(20) DEFAULT NULL COMMENT '正式考勤组ID',
  PRIMARY KEY (`midAttendGroupId`),
  KEY `index_mid_attend_group_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤组设置中间表';

-- ----------------------------
-- Records of mid_attend_group
-- ----------------------------
BEGIN;
INSERT INTO `mid_attend_group` (`midAttendGroupId`, `createTime`, `createBy`, `updateTime`, `updateBy`, `comId`, `perId`, `attendGroupId`) VALUES (1196444720053604352, '2024-01-15 13:24:10', NULL, NULL, NULL, 3420, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for mid_attend_group_detail
-- ----------------------------
DROP TABLE IF EXISTS `mid_attend_group_detail`;
CREATE TABLE `mid_attend_group_detail` (
  `midAttendDetailId` bigint(20) NOT NULL COMMENT '考勤组中间表阶段明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `stage` int(2) NOT NULL COMMENT '第几阶段',
  `content` json DEFAULT NULL COMMENT '阶段内容',
  `midAttendGroupId` bigint(20) NOT NULL COMMENT '考勤组中间表ID',
  `attendGroupName` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`content`,'$.attendGroupName'))) VIRTUAL,
  PRIMARY KEY (`midAttendDetailId`),
  UNIQUE KEY `uni_mid_attend_group_detail` (`midAttendGroupId`,`stage`),
  KEY `index_mid_attend_group_detail_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤组设置阶段明细中间表';

-- ----------------------------
-- Records of mid_attend_group_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mid_task
-- ----------------------------
DROP TABLE IF EXISTS `mid_task`;
CREATE TABLE `mid_task` (
  `midTaskId` bigint(20) NOT NULL COMMENT '任务中间表ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`midTaskId`),
  KEY `index_mid_task_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务中间表';

-- ----------------------------
-- Records of mid_task
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mid_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `mid_task_detail`;
CREATE TABLE `mid_task_detail` (
  `midTaskDetailId` bigint(20) NOT NULL COMMENT '任务中间表阶段明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `stage` int(20) DEFAULT NULL COMMENT '第几阶段',
  `content` json DEFAULT NULL COMMENT '阶段内容',
  `midTaskId` bigint(20) NOT NULL COMMENT '任务中间表ID',
  `taskName` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`content`,'$.taskName'))) VIRTUAL,
  PRIMARY KEY (`midTaskDetailId`),
  KEY `index_mid_task_detail_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务设置阶段明细中间表';

-- ----------------------------
-- Records of mid_task_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_attend_card_record
-- ----------------------------
DROP TABLE IF EXISTS `per_attend_card_record`;
CREATE TABLE `per_attend_card_record` (
  `attendCardRecordId` bigint(20) NOT NULL COMMENT '考勤打卡记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `setClockInTime` datetime DEFAULT NULL COMMENT '设置的打卡时间',
  `clockInDate` date NOT NULL COMMENT '打卡日期',
  `clockInTime` datetime DEFAULT NULL COMMENT '打卡时间',
  `clockInType` varchar(6) DEFAULT NULL COMMENT '打卡类别(上班打卡、下班打卡)',
  `clockInRound` int(3) DEFAULT NULL COMMENT '第几轮打卡',
  `placeLongitude` varchar(50) DEFAULT NULL COMMENT '打卡地点经度',
  `palceLatitude` varchar(50) DEFAULT NULL COMMENT '打卡地点纬度',
  `clockInWay` varchar(6) DEFAULT NULL COMMENT '打卡方式(wifi打卡、地点打卡)',
  `attendAddress` varchar(100) DEFAULT NULL COMMENT '打卡地点',
  `attendStatus` varchar(6) DEFAULT NULL COMMENT '考勤状态',
  `comId` bigint(20) NOT NULL COMMENT '所在企业ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  `attendWifiId` bigint(20) DEFAULT NULL COMMENT '考勤WIFIID',
  `perId` bigint(20) NOT NULL COMMENT '打卡人员ID',
  `approveApplyId` bigint(20) DEFAULT NULL COMMENT '审批申请ID',
  `remark` varchar(50) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`attendCardRecordId`,`clockInDate`),
  KEY `index_per_attend_card_record_comId` (`comId`),
  KEY `index_per_attend_card` (`perId`,`clockInDate`,`clockInType`,`shiftId`,`shiftRuleId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡记录'
/*!50100 PARTITION BY RANGE (TO_DAYS(clockInDate))
(PARTITION p_201808 VALUES LESS THAN (737302) ENGINE = InnoDB,
 PARTITION p_201809 VALUES LESS THAN (737332) ENGINE = InnoDB,
 PARTITION p_201810 VALUES LESS THAN (737363) ENGINE = InnoDB,
 PARTITION p_201811 VALUES LESS THAN (737393) ENGINE = InnoDB,
 PARTITION p_201812 VALUES LESS THAN (737424) ENGINE = InnoDB,
 PARTITION p_201901 VALUES LESS THAN (737455) ENGINE = InnoDB,
 PARTITION p_201902 VALUES LESS THAN (737483) ENGINE = InnoDB,
 PARTITION p_201903 VALUES LESS THAN (737514) ENGINE = InnoDB,
 PARTITION p_max VALUES LESS THAN MAXVALUE ENGINE = InnoDB) */;

-- ----------------------------
-- Records of per_attend_card_record
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_base_info
-- ----------------------------
DROP TABLE IF EXISTS `per_base_info`;
CREATE TABLE `per_base_info` (
  `perId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '人员ID',
  `tlkId` varchar(200) NOT NULL COMMENT 'V5的ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `industryType` varchar(6) DEFAULT NULL COMMENT '行业类型',
  `institutionType` varchar(6) DEFAULT NULL COMMENT '机构类型',
  `authStatus` varchar(6) DEFAULT '0' COMMENT '认证状态 0：未认证；1.认证通过；2.认证中；3.认证不通过',
  `idCardType` varchar(6) DEFAULT NULL COMMENT '身份证件类型',
  `idCardNo` varchar(20) DEFAULT NULL COMMENT '证件号码',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `isIncumbency` varchar(1) DEFAULT '1' COMMENT '是否在职',
  `photoUrl` varchar(500) DEFAULT NULL COMMENT '头像存放url',
  `colourPhotoUrl` varchar(200) DEFAULT NULL COMMENT '一寸免冠彩照url',
  `oneInchColourPhotoUrl` varchar(200) DEFAULT NULL COMMENT '一寸免冠彩照url(企业上传)',
  `twoInchColourPhotoUrl` varchar(200) DEFAULT NULL COMMENT '两寸免冠彩照url',
  `idCardFrontUrl` varchar(200) DEFAULT NULL COMMENT '身份证正面url',
  `idCardReverseUrl` varchar(200) DEFAULT NULL COMMENT '身份证反面url',
  `sex` varchar(6) DEFAULT NULL COMMENT '性别',
  `nation` varchar(6) DEFAULT NULL COMMENT '民族',
  `birthday` date DEFAULT NULL COMMENT '出生日期',
  `firstWorkDay` date DEFAULT NULL COMMENT '参加工作日期',
  `perType` varchar(6) DEFAULT NULL COMMENT '人员类型',
  `nationality` varchar(6) DEFAULT NULL COMMENT '国籍',
  `originPlace` varchar(50) DEFAULT NULL COMMENT '籍贯',
  `education` varchar(6) DEFAULT NULL COMMENT '学历',
  `mobilePhone` varchar(20) DEFAULT NULL COMMENT '手机号',
  `email` varchar(50) DEFAULT NULL COMMENT '电子邮箱',
  `height` decimal(8,3) DEFAULT NULL COMMENT '身高',
  `bloodType` varchar(6) DEFAULT NULL COMMENT '血型',
  `politicalStatus` varchar(6) DEFAULT NULL COMMENT '政治面貌',
  `maritalStatus` varchar(6) DEFAULT NULL COMMENT '婚姻状况',
  `drivingLicenseLevel` varchar(6) DEFAULT NULL COMMENT '驾照等级',
  `residentType` varchar(6) DEFAULT NULL COMMENT '户籍类型',
  `residentProvince` int(6) DEFAULT NULL COMMENT '户口所在省',
  `residentCity` int(6) DEFAULT NULL COMMENT '户口所在城市',
  `residentArea` int(6) DEFAULT NULL COMMENT '户口所在区/县',
  `residenceAddress` varchar(100) DEFAULT NULL COMMENT '户口具体地址',
  `domicileProvince` int(6) DEFAULT NULL COMMENT '居住地所在省',
  `domicileCity` int(6) DEFAULT NULL COMMENT '居住地所在城市',
  `domicileArea` int(6) DEFAULT NULL COMMENT '居住地所在区/县',
  `domicileAddress` varchar(100) DEFAULT NULL COMMENT '居住具体地址',
  `contactper` varchar(50) DEFAULT NULL COMMENT '紧急联系人',
  `contactPhone` varchar(20) DEFAULT NULL COMMENT '联系人手机号码',
  `perSource` varchar(6) DEFAULT NULL COMMENT '数据来源',
  `sysPlatId` bigint(20) DEFAULT NULL COMMENT '系统平台ID',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `perRegEventId` bigint(20) DEFAULT NULL COMMENT '人员注册事件ID',
  `perAddEventId` bigint(20) DEFAULT NULL COMMENT '人员新增事件ID',
  `tlkUserId` varchar(200) DEFAULT NULL COMMENT '天翎人员id',
  PRIMARY KEY (`perId`),
  UNIQUE KEY `index_per_base_info_tlkId` (`tlkId`) USING BTREE,
  KEY `index_per_base_info_idCardNo` (`idCardNo`),
  KEY `index_per_base_info_mobilePhone` (`mobilePhone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员基础信息';

-- ----------------------------
-- Records of per_base_info
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_current_location
-- ----------------------------
DROP TABLE IF EXISTS `per_current_location`;
CREATE TABLE `per_current_location` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `updateTime` datetime NOT NULL COMMENT '更新时间',
  `longitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员当前位置';

-- ----------------------------
-- Records of per_current_location
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_org_relation
-- ----------------------------
DROP TABLE IF EXISTS `per_org_relation`;
CREATE TABLE `per_org_relation` (
  `perOrgRelationId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '人员组织关系ID',
  `tlkId` varchar(200) NOT NULL COMMENT 'V5的ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `position` varchar(6) DEFAULT NULL COMMENT '职位',
  `jobNo` varchar(6) DEFAULT NULL COMMENT '工号',
  `entryDate` date DEFAULT NULL COMMENT '入职日期',
  `leaveDate` date DEFAULT NULL COMMENT '离职日期',
  `leaveReason` varchar(100) DEFAULT NULL COMMENT '离职原因',
  `orgType` varchar(1) DEFAULT NULL COMMENT '所在组织类型',
  `orgId` bigint(20) NOT NULL COMMENT '所在组织ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`perOrgRelationId`),
  UNIQUE KEY `index_per_org_relation_tlkId` (`tlkId`) USING BTREE,
  KEY `index_per_org_relation_comId` (`comId`),
  KEY `index_per_org_relation_orgId` (`orgId`),
  KEY `index_per_org_relation_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员组织关系';

-- ----------------------------
-- Records of per_org_relation
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_salary_grant
-- ----------------------------
DROP TABLE IF EXISTS `per_salary_grant`;
CREATE TABLE `per_salary_grant` (
  `perSalaryGrantId` bigint(20) NOT NULL COMMENT '人员薪资发放ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `grantYears` varchar(7) NOT NULL COMMENT '发放年月',
  `sumAmount` decimal(10,2) NOT NULL COMMENT '工资总额(不含代扣五险、公积金、个税)',
  `taxableAmount` decimal(10,2) NOT NULL COMMENT '应税工资(工资总额-五险-公积金)',
  `payableAmount` decimal(10,2) NOT NULL COMMENT '应发金额=工资总额-代扣(五险、公积金、个税)',
  `actualAmount` decimal(10,2) NOT NULL COMMENT '实发金额(领导确认或者银行回单)',
  `accountStatus` varchar(6) NOT NULL COMMENT '核算状态',
  `accountTime` datetime DEFAULT NULL COMMENT '核算时间',
  `salaryTempName` varchar(50) DEFAULT NULL COMMENT '薪酬模板名称',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `isConfirm` varchar(1) NOT NULL DEFAULT '0' COMMENT '是否确认',
  `confirmTime` datetime DEFAULT NULL COMMENT '确认时间',
  `comId` bigint(20) DEFAULT NULL COMMENT '企业ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  PRIMARY KEY (`perSalaryGrantId`),
  KEY `index_per_salary_grant_comId` (`comId`),
  KEY `index_per_salary_grant` (`perId`,`grantYears`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员薪资发放';

-- ----------------------------
-- Records of per_salary_grant
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_salary_grant_detail
-- ----------------------------
DROP TABLE IF EXISTS `per_salary_grant_detail`;
CREATE TABLE `per_salary_grant_detail` (
  `perSalaryGrantId` bigint(20) NOT NULL COMMENT '人员薪资发放ID',
  `salaryType` varchar(6) NOT NULL COMMENT '薪资类型',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `amount` decimal(10,2) NOT NULL COMMENT '金额',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注(工资条提醒项目)',
  PRIMARY KEY (`perSalaryGrantId`,`salaryType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员薪资发放明细';

-- ----------------------------
-- Records of per_salary_grant_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_social_ins_pay_detail
-- ----------------------------
DROP TABLE IF EXISTS `per_social_ins_pay_detail`;
CREATE TABLE `per_social_ins_pay_detail` (
  `insPayDetailId` bigint(20) NOT NULL COMMENT '社保缴费明细ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `socialInsType` varchar(6) DEFAULT NULL COMMENT '社保险种',
  `socialInsBase` decimal(10,2) DEFAULT NULL COMMENT '缴费基数',
  `payPeriod` varchar(7) DEFAULT NULL COMMENT '费款所属期',
  `comPayProp` decimal(4,3) DEFAULT NULL COMMENT '公司缴纳比例',
  `perPayProp` decimal(4,3) DEFAULT NULL COMMENT '人员缴纳比例',
  `comPayAmount` decimal(8,2) DEFAULT NULL COMMENT '公司缴纳金额',
  `perPayAmount` decimal(8,2) DEFAULT NULL COMMENT '人员缴纳金额',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`insPayDetailId`),
  KEY `index_per_social_ins_pay_detail_comId` (`comId`),
  KEY `index_per_social_ins_pay_detail_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员社保缴费明细';

-- ----------------------------
-- Records of per_social_ins_pay_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_social_ins_scheme_rela
-- ----------------------------
DROP TABLE IF EXISTS `per_social_ins_scheme_rela`;
CREATE TABLE `per_social_ins_scheme_rela` (
  `paySchemeId` bigint(20) NOT NULL COMMENT '缴费方案ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  PRIMARY KEY (`paySchemeId`,`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员医社保缴费方案关联';

-- ----------------------------
-- Records of per_social_ins_scheme_rela
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for per_task_card_record
-- ----------------------------
DROP TABLE IF EXISTS `per_task_card_record`;
CREATE TABLE `per_task_card_record` (
  `taskCardRecordId` bigint(20) NOT NULL COMMENT '任务打卡记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `setClockInTime` datetime DEFAULT NULL COMMENT '设置的打卡时间',
  `clockInDate` date DEFAULT NULL COMMENT '打卡日期',
  `clockInTime` datetime DEFAULT NULL COMMENT '打卡时间',
  `clockInType` varchar(6) DEFAULT NULL COMMENT '打卡类别(上班打卡、下班打卡)',
  `clockInRound` int(3) DEFAULT NULL COMMENT '第几轮打卡',
  `placeLongitude` varchar(50) DEFAULT NULL COMMENT '打卡地点经度',
  `palceLatitude` varchar(50) DEFAULT NULL COMMENT '打卡地点纬度',
  `clockInWay` varchar(6) DEFAULT NULL COMMENT '打卡方式(wifi打卡、地点打卡)',
  `attendAddress` varchar(100) DEFAULT NULL COMMENT '打卡地点',
  `attendStatus` varchar(6) DEFAULT NULL COMMENT '考勤状态',
  `comId` bigint(20) NOT NULL COMMENT '所在企业ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  `attendWifiId` bigint(20) DEFAULT NULL COMMENT '考勤WIFIID',
  `perId` bigint(20) NOT NULL COMMENT '打卡人员ID',
  `approveApplyId` bigint(20) DEFAULT NULL COMMENT '审批申请ID',
  `remark` varchar(50) DEFAULT NULL COMMENT '备注',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskCardRecordId`),
  KEY `index_per_task_card_record_comId` (`comId`),
  KEY `index_per_task_card` (`comTaskId`,`perId`,`clockInDate`,`clockInType`,`shiftId`,`shiftRuleId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务打卡记录';

-- ----------------------------
-- Records of per_task_card_record
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `sysConfigId` bigint(20) NOT NULL COMMENT '主键ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '创建时间',
  `sysKey` varchar(255) DEFAULT NULL COMMENT '键',
  `sysValue` varchar(255) DEFAULT NULL COMMENT '值',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`sysConfigId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
BEGIN;
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (0, '2018-01-16 10:31:35', NULL, 'SYS_PIC_PATH', '/data/upload/saas/', '系统全局图片操作系统保存的路径');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (1, '2018-01-03 10:08:52', NULL, 'BCXIN_JWT_KEY', 'sdoDFyzfieqMrisd4H5o5t9weOl6GmSr', 'jwt加密密钥');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (2, '2018-01-03 14:01:24', NULL, 'BLB_URL', 'https://blb.test.bcxin.com.cn/', '百联保购买页面url');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (3, '2018-01-03 14:08:50', NULL, 'PLATFORM_SIGN', 'SAAS-NC', 'SAAS开发环境');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (4, '2018-01-04 10:26:16', NULL, 'BLB_DETAIL_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposDetail', '百联保详情页面url');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (5, '2018-01-04 14:54:23', NULL, 'YWRZ_URL', 'http://183.250.166.207:8762/public/businessLog/create-business-log', '业务日志接口URL');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (6, '2018-01-16 10:21:21', NULL, 'COMLOGO_URL', NULL, '企业logoURL');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (8, '2018-01-16 10:33:06', NULL, 'SYS_PIC_HTTP_ADDR', 'http://49.4.51.65:9009/', '系统全局HTTP访问地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (10, '2018-02-01 10:17:37', NULL, 'bbdH5Url', 'http://saasapp.test.baibaodun.cn/saasapp/#', 'Saas系统H5前端UI地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (11, '2018-02-01 10:18:41', NULL, 'trainURL', 'http://test.bktang.cn/pxxtfront/train#/', '百课堂前端服务器地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (12, '2018-02-02 16:27:11', NULL, 'MATERIAL_COMINFO_URL', 'http://bcxin-risk-extranet-test.oss-cn-shanghai.aliyuncs.com/static/doc/%E5%A4%A7%E5%9E%8B%E7%BE%A4%E4%BC%97%E6%80%A7%E6%B4%BB%E5%8A%A8%E5%AE%89%E5%85%A8%E8%AE%B8%E5%8F%AF%E7%94%B3%E8%AF%B7%E8%A1%A8.doc', '批量导入机构信息模板url');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (13, '2018-02-08 15:38:55', NULL, 'MATERIAL_POLICEORGINFO_URL', 'http://bcxin-risk-extranet-test.oss-cn-shanghai.aliyuncs.com/static/doc/%E5%A4%A7%E5%9E%8B%E7%BE%A4%E4%BC%97%E6%80%A7%E6%B4%BB%E5%8A%A8%E5%AE%89%E5%85%A8%E8%AE%B8%E5%8F%AF%E7%94%B3%E8%AF%B7%E8%A1%A8.doc', '批量导入公安机构模板');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (14, '2018-02-22 15:22:24', NULL, 'PUBLIC_URL', 'http://59.110.22.100:9173/', '公安一所身份证认证地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (15, '2018-03-14 09:54:12', NULL, 'TRACK_610000', 'http://outsnbbd.test.baibaodun.cn/ars-rest', '陕西子站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (16, '2018-03-28 15:04:04', NULL, 'BLB_PRESERVATION_URL', 'https://blb.test.bcxin.com.cn/api/preservation/resultSet/sassPreservationView', '百联保保全新增和减少页面，带人员信息');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (17, '2018-03-29 15:30:01', NULL, 'PREVIEW_FILE_URL', 'http://preview.abcxin.com', '文件预览服务地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (18, '2018-03-14 09:54:12', '2018-03-30 15:42:22', 'OPEN_SUBSTATION', '0', '是否开启陕西子站地址默认站点(0：未开启,1：开启)');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (19, '2018-03-14 09:54:12', '2018-03-30 16:16:02', 'TRACK_DEFAULT', 'http://outsnbbd.test.baibaodun.cn/ars-rest', '默认子站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (20, '2018-04-03 09:52:44', NULL, 'BLB_PRODUCT_LIST_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposProductAndRes', '百联保产品列表信息');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (21, '2018-04-03 10:07:08', NULL, 'BLB_PRESERVATION_LIST_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposPreservation', '百联保保全页列表页');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (22, '2018-04-04 11:24:06', NULL, 'BCXIN_GX_TYX-TK-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (23, '2018-04-04 11:26:39', NULL, 'BCXIN_GX_TYX-TK-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (24, '2018-04-04 11:27:04', NULL, 'BCXIN_GX_TYX-TK-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (25, '2018-04-04 11:27:23', NULL, 'BCXIN_GX_TYX-TK-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (26, '2018-04-04 11:27:41', NULL, 'BCXIN_GX_TYX-TK-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (27, '2018-04-04 11:28:16', NULL, 'BCXIN_GX_TYX-TK-6', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西泰康团意险6');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (28, '2018-04-04 11:28:56', NULL, 'BCXIN_GX_TYX-PA-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西平安团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (29, '2018-04-04 11:31:21', NULL, 'BCXIN_GX_TYX-PA-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西平安团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (30, '2018-04-04 11:31:39', NULL, 'BCXIN_GX_TYX-PA-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西平安团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (31, '2018-04-04 11:31:57', NULL, 'BCXIN_GX_TYX-PA-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西平安团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (32, '2018-04-04 11:32:15', NULL, 'BCXIN_GX_TYX-PA-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '广西平安团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (33, '2018-04-04 11:24:06', NULL, 'BCXIN_SX_TYX-TK-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (34, '2018-04-04 11:26:39', NULL, 'BCXIN_SX_TYX-TK-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (35, '2018-04-04 11:27:04', NULL, 'BCXIN_SX_TYX-TK-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (36, '2018-04-04 11:27:23', NULL, 'BCXIN_SX_TYX-TK-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (37, '2018-04-04 11:27:41', NULL, 'BCXIN_SX_TYX-TK-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (38, '2018-04-04 11:28:16', NULL, 'BCXIN_SX_TYX-TK-6', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西泰康团意险6');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (39, '2018-04-04 11:28:56', NULL, 'BCXIN_SX_TYX-PA-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西平安团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (40, '2018-04-04 11:31:21', NULL, 'BCXIN_SX_TYX-PA-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西平安团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (41, '2018-04-04 11:31:39', NULL, 'BCXIN_SX_TYX-PA-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西平安团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (42, '2018-04-04 11:31:57', NULL, 'BCXIN_SX_TYX-PA-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西平安团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (43, '2018-04-04 11:32:15', NULL, 'BCXIN_SX_TYX-PA-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '陕西平安团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (44, '2018-04-04 11:24:06', NULL, 'BCXIN_SC_TYX-TK-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (45, '2018-04-04 11:26:39', NULL, 'BCXIN_SC_TYX-TK-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (46, '2018-04-04 11:27:04', NULL, 'BCXIN_SC_TYX-TK-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (47, '2018-04-04 11:27:23', NULL, 'BCXIN_SC_TYX-TK-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (48, '2018-04-04 11:27:41', NULL, 'BCXIN_SC_TYX-TK-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (49, '2018-04-04 11:28:16', NULL, 'BCXIN_SC_TYX-TK-6', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场泰康团意险6');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (50, '2018-04-04 11:28:56', NULL, 'BCXIN_SC_TYX-PA-1', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场平安团意险1');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (51, '2018-04-04 11:31:21', NULL, 'BCXIN_SC_TYX-PA-2', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场平安团意险2');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (52, '2018-04-04 11:31:39', NULL, 'BCXIN_SC_TYX-PA-3', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场平安团意险3');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (53, '2018-04-04 11:31:57', NULL, 'BCXIN_SC_TYX-PA-4', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场平安团意险4');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (54, '2018-04-04 11:32:15', NULL, 'BCXIN_SC_TYX-PA-5', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '市场平安团意险5');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (55, '2018-04-04 16:23:06', NULL, 'BCXIN_PROMPT_PIC', 'https://www.baidu.com/img/baidu_jgylogo3.gif', '温馨提示的图片地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (56, '2018-04-13 09:59:38', NULL, 'MSS_URL', 'http://192.168.0.249:9000/api/gate/notify', '消息服务url');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (57, '2018-04-18 16:59:21', NULL, 'TRAIN_BG_URL', 'http://test.bktang.cn:90/train-sys', '百课堂后台管理服务地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (58, '2018-04-18 16:59:21', '2018-09-19 19:50:31', 'MSG_OPEN_STATE', '0', '短信发送状态(0:不打开,1:打开)');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (59, '2018-09-20 17:48:26', '2018-09-20 17:48:29', 'TABLE_SCHEMA', 'saas_test', '数据库schema');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (60, '2018-09-21 17:10:19', NULL, 'BLB_INS_NUM', '500', '给百联保投保人数');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (61, '2018-03-14 09:54:12', '2018-09-26 09:07:13', 'TRACK_450000', 'http://outgxbbd.test.baibaodun.cn/ars-rest', '广西子站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (62, '2018-11-05 22:27:13', '2018-11-05 22:27:15', 'POS_TIME_OUT', '20000', 'POST超时时间');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (64, '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_SDKAPPID', '1400383558', '腾讯云SDKAPPID');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (65, '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_LIBPATH', '/data/upload/saas/tls/tls_sig_api/src/jnisigcheck_mt_x64.so', '腾讯云动态库的地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (66, '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_EC_KEY', 'f5a350194321f137886aa00c6696d264b25de7a1e45d552827db2893251417ff', '腾讯云私钥地址-- 旧：/data/upload/saas/tls/tls_sig_api/src/ec_key.pem');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (67, '2019-01-02 11:06:17', '2019-01-02 11:06:18', 'TENCENT_PUBLIC_KEY', '/data/upload/saas/tls/tls_sig_api/src/public.pem', '腾讯云公钥地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (68, '2019-01-02 13:32:41', '2019-01-02 13:32:38', 'PSS_BG_URL', 'http://main.test.pss360.cn/', 'PSS接口对接地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (69, '2019-01-02 13:32:41', '2019-01-02 13:32:38', 'TENCENT_IM_URL', 'https://console.tim.qq.com', '腾讯云服务器地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (70, '2019-01-02 13:32:41', '2019-01-02 13:32:38', 'TENCENT_ADMIN', 'administrator', '腾讯云管理员账号');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (71, '2019-03-26 11:01:24', NULL, 'BLB_CACHE_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposCheckoutAddCache', '百联保购买页面url带缓存id');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (72, '2019-03-26 14:01:24', NULL, 'BLB_ADD_PRESERVATION_URL', 'https://blb.test.bcxin.com.cn/api/preservation/resultSet/sassAddPreservationService', '百联保保全带人员信息新增业务');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (73, '2019-04-03 14:30:50', NULL, 'MATERIAL_SALARY_TEMPLATE_URL', 'https://bcxin-saas-prod.oss-cn-beijing.aliyuncs.com/template/per_salary_import_template.xls', '人员薪酬信息导入模板');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (74, '2019-04-22 17:54:12', NULL, 'TRACK_110000', 'http://outbjbbd.test.baibaodun.cn/ars-rest', '北京子站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (75, '2019-04-30 10:43:26', NULL, 'TRACK_640000', 'http://inbjbbd.test.baibaodun.cn/ars-rest/', '宁夏子站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (76, '2019-05-08 15:32:36', NULL, 'BLB_MINUS_PRESERVATION_URL', 'https://blb.test.bcxin.com.cn/api/preservation/resultSet/sassMinusPreservationService', '百联保保全带人员信息百联保保全带人员信息新增业务减员业务');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (77, '2019-05-22 15:32:36', NULL, 'BLB_ORDER_LIST_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposCheckoutToOrder', '百联保订单列表页');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (78, '2019-06-21 13:36:25', NULL, 'PAYMENT_PLATFORM_URL', 'http://pay.test.bcxin.com.cn', '支付平台地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (79, '2019-06-26 09:54:12', '2018-06-26 09:17:13', 'AUTHENTICATION_450000', 'http://outbjbbd.test.baibaodun.cn/authentication', '广西子站认证地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (80, '2019-06-26 09:54:12', '2018-06-26 09:17:13', 'AUTHENTICATION_640000', 'http://outbjbbd.test.baibaodun.cn/authentication', '宁夏子站认证地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (81, '2019-06-26 09:54:12', '2018-06-26 09:17:13', 'AUTHENTICATION_610000', 'http://outbjbbd.test.baibaodun.cn/authentication', '陕西子站认证地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (82, '2019-06-26 09:54:12', '2018-06-26 09:17:13', 'AUTHENTICATION_110000', 'http://outbjbbd.test.baibaodun.cn/authentication', '北京子站认证地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (83, '2019-07-05 09:54:12', '2019-07-05 09:17:13', 'PUBLIC_AUTH_PRO', 'DEFAULT', '公安一所认证标识省份');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (84, '2019-09-19 11:06:17', '2019-09-19 11:06:18', 'TENCENT_SECRETID', 'AKIDlNvOisseBSUKyNWSAetsd9QREm593jAT', '腾讯云secretId');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (85, '2019-09-19 11:06:17', '2019-09-19 11:06:18', 'TENCENT_SECRETKEY', 'FJDucMzRghT0IPK0Vowx34tTl050iTAm', '腾讯云secretKey');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (86, '2019-11-05 16:54:38', NULL, 'EINVOICE_URL', 'http://einvoice.test.bcxin.com.cn', '电子发票服务地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (87, '2019-12-12 15:27:20', NULL, 'SYS_TEMP_PATH', '/data/upload/saas/temp/', '系统临时文件保存的路径');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (88, '2019-12-12 15:32:36', NULL, 'BLB_REPORT_LIST_URL', 'https://blb.test.bcxin.com.cn/api/thr/tposCheckoutToReport', '百联保理赔列表页');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (89, '2019-12-26 11:32:36', NULL, 'BLB_SPECIAL_MINUS_PRESERVATION_URL', 'https://blb.test.bcxin.com.cn/api/preservation/resultSet/sassSpecialMinusPreservationService', 'saas在保未录入人员减员接口');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (90, '2019-12-30 11:06:17', '2019-12-30 11:06:18', 'KEFU_EMAIL', '384023074@qq.com,327929617@qq.com', '客服邮箱地址，多个逗号隔开');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (91, '2019-12-26 11:32:36', NULL, 'BLB_INS_RESULT_NAME_URL', 'https://blb.test.bcxin.com.cn/api/preservation/resultSet/sassFindPerNameByIdCard', 'saas身份证查询对应在保人员信息接口');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (92, '2020-01-10 09:54:16', NULL, 'THIRD_SALARY_URL', 'http://114.116.34.137:1112', '第三方薪酬系统URL');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (93, '2020-01-16 14:14:57', NULL, 'PLAT_COMID', '491667483476885504', '平台企业ID');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (94, '2019-12-30 11:06:17', '2019-12-30 11:06:18', 'MEETING_EMAIL', '', '云会议邮箱地址，多个逗号隔开');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (95, '2020-02-02 14:14:57', '2020-02-07 17:07:54', 'MEET_INCOME_COMID', '491667483476885504', '会议收入企业ID');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (96, '2020-05-21 17:32:44', '2020-05-21 17:33:02', 'APP_INIT_STEP', '5', 'APP初始化步骤');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (97, '2020-05-28 15:27:04', '2020-05-28 15:27:07', 'ORDER_YW_EMAIL', '384023074@qq.com', '订单处理人邮箱，多个逗号隔开');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (98, '2020-05-29 16:21:56', '2020-05-29 16:21:59', 'MEET_LOGIN_USER', 'hw28814466', '华为IAM登录账号');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (99, '2020-05-29 16:23:03', '2020-05-29 16:23:06', 'MEET_LOGIN_PWD', '01@qq.com', '华为IAM登录密码');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (100, '2020-05-29 16:24:00', '2020-05-29 16:24:03', 'MEET_LOGIN_USER_ID', '075975dc7a800fd70f16c01f1e83e660', '华为IAM登录账号ID（我的凭证详情里可以找到）');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (101, '2020-05-29 16:26:07', '2020-05-29 16:26:09', 'MEET_MANAGE_SP_USER', 'tianjiazhanghao', '华为SP管理员账号');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (102, '2020-05-29 16:27:33', '2020-05-29 16:27:35', 'MEET_MANAGE_SP_PWD', '05@qq.com', '华为SP管理员密码');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (103, '2020-05-29 16:29:47', '2020-05-29 16:29:50', 'MEET_ACTUATING_RANGE_4', 'cn-north-4', '华为会议作用范围项目（当前为华北-北京四）');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (104, '2020-05-29 16:41:47', '2020-05-29 16:41:50', 'MEET_BUILD_SP_EMAIL', 'fuguannan@baichuanxin.com', '华为管理员创建企业账号默认的邮箱');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (105, '2020-06-04 17:32:29', '2020-06-04 17:32:29', 'MSG_ONEDAY_MAXCOUNT', '8', '同一手机号当天发送次数上限');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (108, '2020-07-14 17:45:42', '2020-07-14 17:45:45', 'CDN_URL', 'http://bcxinsaasprod.baibaodun.cn', '生产CDN域名');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (109, '2020-08-19 11:03:11', '2020-08-19 11:03:16', 'PSS_MAIN_URL', 'http://main.test.pss360.cn/', 'PSS主站地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (110, '2020-09-04 11:03:11', '2020-09-04 11:03:16', 'BOHAI_JOINTLYCARD_APPLY_URL', 'https://e.cbhb.com.cn/UAT2-pmobile/static/index.html?Transid=CBHBOrderCardBatch&Signature=', '联名卡申请地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (111, '2020-09-04 11:03:11', '2020-09-04 11:03:16', 'BOHAI_JOINTLYCARD_QUERY_URL', 'https://e.cbhb.com.cn/UAT2-pmobile/static/index.html?Transid=CBHBOrderCardBatchQry', '联名卡查询地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (112, '2020-09-04 11:03:11', '2020-09-04 11:03:16', 'BOHAI_JOINTLYCARD_APPLY_AESKEY', 'cbhb&trans@%$000', '联名卡加密秘钥');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (113, '2020-10-20 11:03:11', '2020-10-20 11:03:16', 'BAIDU_FACE_THAN_VPT', '80', '百度人脸比对阈值');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (114, '2020-10-21 11:03:11', '2020-10-21 11:03:16', 'BAIDU_FACE_MATCH_URL', 'http://117.78.36.99:17777/rest/face/match', '百度人像比对地址');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (115, '2020-12-03 20:39:38', '2020-12-03 20:39:40', 'BAIDU_FACE_ACCOUNT', '85DdDN1vZ3LOmcB5i30cLFaI,jSL2BSZbj5g1lDrSD9GZT6GagHLGwbAc;aMHCMSx9OWnTbTjjzeAxk6Tm,xF7AySBlI0cOgQLN44oLWClmHxCDnEVP', '百度人像比对账号');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (116, '2021-01-05 14:14:47', NULL, 'BAIDU_FACE_THAN_LOCAL_DOWNLOAD', '1', '是否开启百度人脸认证前进行文件下载尝试（0不开启，1开启）');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (117, '2021-01-06 20:39:38', '2021-01-06 20:39:40', 'BAIDU_ORC_ACCOUNT', 'ytjZgnIlDwUW8VhPxD3MrFjj,FcwWpiPsB5capVZSFtBH5ATd3UKaO906', '百度身份证识别应用KEY');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (118, '2021-01-30 14:16:10', '2021-01-30 14:16:12', 'TLK_URL', 'http://117.78.35.63:8080/obpm/runtime/users/myprofile', '解析天翎Token');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (119, '2021-03-13 11:41:58', '2021-03-13 11:42:00', 'BDP_URL', 'http://49.4.26.74:8060/messages/public', '百川信数据分发中心URL');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (120, '2021-03-13 11:47:44', '2021-03-13 11:47:46', 'BDP_PROVINCES', '430000', '百川信数据分发中心推送省份（以逗号分隔）');
INSERT INTO `sys_config` (`sysConfigId`, `createTime`, `updateTime`, `sysKey`, `sysValue`, `description`) VALUES (121, '2021-07-15 11:47:44', '2021-07-15 11:47:46', 'JOINTLY_MAX_DAY', '180', '发证未取最大天数');
COMMIT;

-- ----------------------------
-- Table structure for sys_interface_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_interface_log`;
CREATE TABLE `sys_interface_log` (
  `interfaceLogId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '接口日志ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `interfaceType` varchar(6) DEFAULT NULL COMMENT '接口类型',
  `interfaceExecStatus` varchar(6) DEFAULT NULL COMMENT '接口执行状态',
  `startTime` datetime DEFAULT NULL COMMENT '执行开始时间',
  `endTime` datetime DEFAULT NULL COMMENT '执行结束时间',
  `parameters` longtext COMMENT '接口请求数据',
  `result` longtext COMMENT '接口返回结果',
  `providePlatId` bigint(20) NOT NULL COMMENT '接口提供平台ID',
  `callPlatId` bigint(20) NOT NULL COMMENT '接口调用平台ID',
  `url` varchar(500) DEFAULT NULL COMMENT '方法url',
  `reExecCount` int(6) DEFAULT '0' COMMENT '重复调用次数',
  PRIMARY KEY (`interfaceLogId`)
) ENGINE=InnoDB AUTO_INCREMENT=1587 DEFAULT CHARSET=utf8 COMMENT='系统接口日志';

-- ----------------------------
-- Records of sys_interface_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for sys_police
-- ----------------------------
DROP TABLE IF EXISTS `sys_police`;
CREATE TABLE `sys_police` (
  `policeId` bigint(6) NOT NULL COMMENT '公安机构ID',
  `policeName` varchar(50) DEFAULT NULL COMMENT '公安机构',
  `policeFullName` varchar(300) DEFAULT NULL COMMENT '公安机构全称(带路径)',
  `policeLevel` varchar(6) DEFAULT NULL COMMENT '公安级别',
  `seq` int(4) DEFAULT NULL COMMENT '排序',
  `parentPoliceId` bigint(20) DEFAULT NULL COMMENT '上级公安机构ID',
  `regionId` int(6) DEFAULT NULL COMMENT '区域ID',
  `provinceId` int(6) DEFAULT NULL COMMENT '省份ID',
  `bbdId` bigint(20) NOT NULL COMMENT '百保盾ID',
  PRIMARY KEY (`policeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='公安机构';

-- ----------------------------
-- Records of sys_police
-- ----------------------------
BEGIN;
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110100, '北京公安局', '北京公安局', '2', NULL, NULL, 110100, 110000, 1);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110101, '北京市公安局东城区分局', '北京公安局//北京市公安局东城区分局', '3', 1, 110100, 110101, 110000, 3);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110102, '北京市公安局西城区分局', '北京公安局//北京市公安局西城区分局', '3', 2, 110100, 110102, 110000, 4);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110105, '北京市公安局朝阳区分局', '北京公安局//北京市公安局朝阳区分局', '3', 3, 110100, 110105, 110000, 5);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110106, '北京市公安局丰台区分局', '北京公安局//北京市公安局丰台区分局', '3', 4, 110100, 110106, 110000, 6);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110107, '北京市公安局石景山区分局', '北京公安局//北京市公安局石景山区分局', '3', 6, 110100, 110107, 110000, 8);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110108, '北京市公安局海淀区分局', '北京公安局//北京市公安局海淀区分局', '3', 7, 110100, 110108, 110000, 9);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110109, '北京市公安局门头沟区分局', '北京公安局//北京市公安局门头沟区分局', '3', 9, 110100, 110109, 110000, 11);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110111, '北京市公安局房山区分局', '北京公安局//北京市公安局房山区分局', '3', 10, 110100, 110111, 110000, 12);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110112, '北京市公安局通州区分局', '北京公安局//北京市公安局通州区分局', '3', 13, 110100, 110112, 110000, 15);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110113, '北京市公安局顺义区分局', '北京公安局//北京市公安局顺义区分局', '3', 12, 110100, 110113, 110000, 14);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110114, '北京市公安局昌平区分局', '北京公安局//北京市公安局昌平区分局', '3', 11, 110100, 110114, 110000, 13);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110115, '北京市公安局大兴区分局', '北京公安局//北京市公安局大兴区分局', '3', 14, 110100, 110115, 110000, 16);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110116, '北京市公安局怀柔区分局', '北京公安局//北京市公安局怀柔区分局', '3', 16, 110100, 110116, 110000, 18);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110117, '北京市公安局平谷区分局', '北京公安局//北京市公安局平谷区分局', '3', 15, 110100, 110117, 110000, 17);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110118, '北京市公安局密云区分局', '北京公安局//北京市公安局密云区分局', '3', 8, 110100, 110118, 110000, 10);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110119, '北京市公安局延庆区分局', '北京公安局//北京市公安局延庆区分局', '3', 5, 110100, 110119, 110000, 7);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110120, '北京市公安局机场分局', '北京公安局//北京市公安局机场分局', '3', 19, 110100, NULL, 110000, 29);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110121, '北京市公安局西站分局', '北京公安局//北京市公安局西站分局', '3', 18, 110100, NULL, 110000, 27);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (110122, '北京市公安局天安门分局', '北京公安局//北京市公安局天安门分局', '3', 17, 110100, NULL, 110000, 25);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (330000, '浙江省公安厅', '浙江省公安厅', '2', 1, NULL, 330000, 330000, 1);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (330100, '杭州市公安局', '浙江省公安厅//杭州市公安局', '3', 1, 330000, 330100, 330000, 2);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (330102, '上城区公安分局', '浙江省公安厅//杭州市公安局//上城区公安分局', '4', 1, 330100, 330102, 330000, 3);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (430100, '长沙公安局', '长沙公安局', '2', NULL, NULL, 430100, 430000, 1);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (430101, '长沙公安局XX分局', '长沙公安局//长沙公安局XX分局', '3', 1, 430100, 430101, 430000, 3);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450000, '广西公安厅', NULL, '1', NULL, NULL, 450000, 450000, 1);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450100, '广西南宁市公安局', '广西南宁市公安局', '2', 1, 450000, 450100, 450000, 2);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450102, '广西南宁市公安局兴宁分局', '广西南宁市公安局//广西南宁市公安局兴宁分局', '3', 1, 450100, 450102, 450000, 3);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450103, '广西南宁市公安局青秀分局', '广西南宁市公安局//广西南宁市公安局青秀分局', '3', 2, 450100, 450103, 450000, 14);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450105, '广西南宁市公安局江南分局', '广西南宁市公安局//广西南宁市公安局江南分局', '3', 3, 450100, 450105, 450000, 31);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450107, '广西南宁市公安局西乡塘分局', '广西南宁市公安局//广西南宁市公安局西乡塘分局', '3', 4, 450100, 450107, 450000, 46);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450108, '广西南宁市公安局良庆分局', '广西南宁市公安局//广西南宁市公安局良庆分局', '3', 5, 450100, 450108, 450000, 65);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450109, '广西南宁市公安局邕宁分局', '广西南宁市公安局//广西南宁市公安局邕宁分局', '3', 6, 450100, 450109, 450000, 76);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450115, '广西南宁市公安局南湖分局', '广西南宁市公安局//广西南宁市公安局南湖分局', '3', 7, 450100, 450115, 450000, 86);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450116, '广西南宁市公安局高新分局', '广西南宁市公安局//广西南宁市公安局高新分局', '3', 8, 450100, 450116, 450000, 90);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450117, '广西南宁市公安局青秀山风景名胜旅游区分局', '广西南宁市公安局//广西南宁市公安局青秀山风景名胜旅游区分局', '3', 9, 450100, 450117, 450000, 95);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450119, '广西南宁市公安局地铁公交分局', '广西南宁市公安局//广西南宁市公安局地铁公交分局', '3', 11, 450100, 450115, 450000, 100);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450122, '广西南宁市公安局武鸣分局', '广西南宁市公安局//广西南宁市公安局武鸣分局', '3', 12, 450100, 450110, 450000, 104);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450123, '广西隆安县公安局', '广西南宁市公安局//广西隆安县公安局', '3', 13, 450100, 450123, 450000, 125);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450124, '广西马山县公安局', '广西南宁市公安局//广西马山县公安局', '3', 14, 450100, 450124, 450000, 140);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450125, '广西上林县公安局', '广西南宁市公安局//广西上林县公安局', '3', 15, 450100, 450125, 450000, 156);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450126, '广西宾阳县公安局', '广西南宁市公安局//广西宾阳县公安局', '3', 16, 450100, 450126, 450000, 170);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450127, '广西横县公安局', '广西南宁市公安局//广西横县公安局', '3', 17, 450100, 450127, 450000, 195);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450130, '广西南宁市公安局广西-东盟经济技术开发区（南宁华侨投资区）分局', '广西南宁市公安局//广西南宁市公安局广西-东盟经济技术开发区（南宁华侨投资区）分局', '3', 10, 450100, 450130, 450000, 98);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450200, '广西柳州市公安局', '广西柳州市公安局', '2', 2, 450000, 450200, 450000, 221);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450202, '广西柳州市公安局城中分局', '广西柳州市公安局//广西柳州市公安局城中分局', '3', 1, 450200, 450202, 450000, 222);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450203, '广西柳州市公安局鱼峰分局', '广西柳州市公安局//广西柳州市公安局鱼峰分局', '3', 2, 450200, 450203, 450000, 230);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450204, '广西柳州市公安局柳南分局', '广西柳州市公安局//广西柳州市公安局柳南分局', '3', 3, 450200, 450204, 450000, 237);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450205, '广西柳州市公安局柳北分局', '广西柳州市公安局//广西柳州市公安局柳北分局', '3', 4, 450200, 450205, 450000, 249);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450206, '广西柳州市公安局柳江分局', '广西柳州市公安局//广西柳州市公安局柳江分局', '3', 5, 450200, 450206, 450000, 259);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450222, '广西柳城县公安局', '广西柳州市公安局//广西柳城县公安局', '3', 6, 450200, 450222, 450000, 274);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450223, '广西鹿寨县公安局', '广西柳州市公安局//广西鹿寨县公安局', '3', 7, 450200, 450223, 450000, 291);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450224, '广西融安县公安局', '广西柳州市公安局//广西融安县公安局', '3', 8, 450200, 450224, 450000, 302);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450225, '广西融水苗族自治县公安局', '广西柳州市公安局//广西融水苗族自治县公安局', '3', 9, 450200, 450225, 450000, 318);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450226, '广西三江侗族自治县公安局', '广西柳州市公安局//广西三江侗族自治县公安局', '3', 10, 450200, 450226, 450000, 341);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450299, '广西柳州市公安局柳东分局', '广西柳州市公安局//广西柳州市公安局柳东分局', '3', 11, 450200, 450299, 450000, 358);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450300, '广西桂林市公安局', '广西桂林市公安局', '2', 3, 450000, 450300, 450000, 364);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450302, '广西壮族自治区桂林市公安局秀峰分局', '广西桂林市公安局//广西壮族自治区桂林市公安局秀峰分局', '3', 1, 450300, 450302, 450000, 365);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450303, '广西桂林市公安局叠彩分局', '广西桂林市公安局//广西桂林市公安局叠彩分局', '3', 2, 450300, 450303, 450000, 371);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450304, '广西桂林市公安局象山分局', '广西桂林市公安局//广西桂林市公安局象山分局', '3', 3, 450300, 450304, 450000, 378);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450305, '广西桂林市公安局七星分局', '广西桂林市公安局//广西桂林市公安局七星分局', '3', 4, 450300, 450305, 450000, 386);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450311, '广西桂林市公安局雁山分局', '广西桂林市公安局//广西桂林市公安局雁山分局', '3', 5, 450300, 450311, 450000, 394);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450312, '广西桂林市公安局漓江分局（旅游警察支队）', '广西桂林市公安局//广西桂林市公安局漓江分局（旅游警察支队）', '3', 6, 450300, 450312, 450000, 400);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450321, '广西阳朔县公安局', '广西桂林市公安局//广西阳朔县公安局', '3', 7, 450300, 450321, 450000, 403);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450322, '广西临桂县公安局', '广西桂林市公安局//广西临桂县公安局', '3', 8, 450300, 450312, 450000, 414);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450323, '广西灵川县公安局', '广西桂林市公安局//广西灵川县公安局', '3', 9, 450300, 450323, 450000, 430);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450324, '广西全州县公安局', '广西桂林市公安局//广西全州县公安局', '3', 10, 450300, 450324, 450000, 447);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450325, '广西壮族自治区兴安县公安局', '广西桂林市公安局//广西壮族自治区兴安县公安局', '3', 11, 450300, 450325, 450000, 469);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450326, '广西永福县公安局', '广西桂林市公安局//广西永福县公安局', '3', 12, 450300, 450326, 450000, 483);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450327, '广西灌阳县公安局', '广西桂林市公安局//广西灌阳县公安局', '3', 13, 450300, 450327, 450000, 494);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450328, '广西龙胜各族自治县公安局', '广西桂林市公安局//广西龙胜各族自治县公安局', '3', 14, 450300, 450328, 450000, 504);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450329, '广西资源县公安局', '广西桂林市公安局//广西资源县公安局', '3', 15, 450300, 450329, 450000, 515);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450330, '广西平乐县公安局', '广西桂林市公安局//广西平乐县公安局', '3', 16, 450300, 450330, 450000, 524);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450331, '广西桂林市荔浦县公安局', '广西桂林市公安局//广西桂林市荔浦县公安局', '3', 17, 450300, 450331, 450000, 538);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450332, '广西恭城瑶族自治县公安局', '广西桂林市公安局//广西恭城瑶族自治县公安局', '3', 18, 450300, 450332, 450000, 554);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450400, '广西梧州市公安局', '广西梧州市公安局', '2', 4, 450000, 450400, 450000, 565);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450403, '广西梧州市公安局万秀区分局', '广西梧州市公安局//广西梧州市公安局万秀区分局', '3', 1, 450400, 450403, 450000, 566);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450405, '广西梧州市公安局长洲区分局', '广西梧州市公安局//广西梧州市公安局长洲区分局', '3', 2, 450400, 450405, 450000, 586);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450406, '广西梧州市公安局龙圩区分局', '广西梧州市公安局//广西梧州市公安局龙圩区分局', '3', 3, 450400, 450406, 450000, 593);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450421, '广西苍梧县公安局', '广西梧州市公安局//广西苍梧县公安局', '3', 4, 450400, 450421, 450000, 602);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450422, '广西藤县公安局', '广西梧州市公安局//广西藤县公安局', '3', 5, 450400, 450422, 450000, 614);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450423, '广西蒙山县公安局', '广西梧州市公安局//广西蒙山县公安局', '3', 6, 450400, 450423, 450000, 638);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450481, '广西岑溪市公安局', '广西梧州市公安局//广西岑溪市公安局', '3', 7, 450400, 450481, 450000, 649);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450500, '广西北海市公安局', '广西北海市公安局', '2', 5, 450000, 450500, 450000, 671);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450501, '广西北海市公安局涠洲岛旅游区办事处', '广西北海市公安局//广西北海市公安局涠洲岛旅游区办事处', '3', 1, 450500, 450501, 450000, 672);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450502, '广西北海市公安局海城分局', '广西北海市公安局//广西北海市公安局海城分局', '3', 2, 450500, 450502, 450000, 673);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450503, '广西北海市公安局银海分局', '广西北海市公安局//广西北海市公安局银海分局', '3', 3, 450500, 450503, 450000, 682);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450512, '广西北海市公安局铁山港分局', '广西北海市公安局//广西北海市公安局铁山港分局', '3', 4, 450500, 450512, 450000, 688);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450521, '广西合浦县公安局', '广西北海市公安局//广西合浦县公安局', '3', 5, 450500, 450521, 450000, 690);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450600, '广西防城港市公安局', '广西防城港市公安局', '2', 6, 450000, 450600, 450000, 706);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450602, '广西防城港市公安局港口分局', '广西防城港市公安局//广西防城港市公安局港口分局', '3', 1, 450600, 450602, 450000, 707);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450603, '广西防城港市公安局防城分局', '广西防城港市公安局//广西防城港市公安局防城分局', '3', 2, 450600, 450603, 450000, 713);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450604, '广西防城港市公安局企沙工业区分局', '广西防城港市公安局//广西防城港市公安局企沙工业区分局', '3', 3, 450600, 450604, 450000, 723);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450605, '广西防城港市公安局海港分局', '广西防城港市公安局//广西防城港市公安局海港分局', '3', 4, 450600, 450602, 450000, 727);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450621, '广西上思县公安局', '广西防城港市公安局//广西上思县公安局', '3', 5, 450600, 450621, 450000, 728);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450681, '广西东兴市公安局', '广西防城港市公安局//广西东兴市公安局', '3', 6, 450600, 450681, 450000, 738);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450700, '广西钦州市公安局', '广西钦州市公安局', '2', 7, 450000, 450700, 450000, 745);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450702, '广西钦州市公安局钦南分局', '广西钦州市公安局//广西钦州市公安局钦南分局', '3', 1, 450700, 450702, 450000, 746);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450703, '广西钦州市公安局钦北分局', '广西钦州市公安局//广西钦州市公安局钦北分局', '3', 2, 450700, 450703, 450000, 767);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450704, '广西钦州市公安局港区分局', '广西钦州市公安局//广西钦州市公安局港区分局', '3', 3, 450700, 450704, 450000, 783);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450721, '广西灵山县公安局', '广西钦州市公安局//广西灵山县公安局', '3', 4, 450700, 450721, 450000, 790);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450722, '广西浦北县公安局', '广西钦州市公安局//广西浦北县公安局', '3', 5, 450700, 450722, 450000, 810);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450800, '广西贵港市公安局', '广西贵港市公安局', '2', 8, 450000, 450800, 450000, 829);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450802, '广西贵港市公安局港北分局', '广西贵港市公安局//广西贵港市公安局港北分局', '3', 1, 450800, 450802, 450000, 830);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450803, '广西贵港市公安局港南分局', '广西贵港市公安局//广西贵港市公安局港南分局', '3', 2, 450800, 450803, 450000, 846);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450804, '广西贵港市公安局覃塘分局', '广西贵港市公安局//广西贵港市公安局覃塘分局', '3', 3, 450800, 450804, 450000, 857);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450821, '广西平南县公安局', '广西贵港市公安局//广西平南县公安局', '3', 4, 450800, 450821, 450000, 869);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450881, '广西桂平市公安局', '广西贵港市公安局//广西桂平市公安局', '3', 5, 450800, 450881, 450000, 898);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450900, '广西玉林市公安局', '广西玉林市公安局', '2', 9, 450000, 450900, 450000, 932);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450902, '广西玉林市公安局玉州分局', '广西玉林市公安局//广西玉林市公安局玉州分局', '3', 1, 450900, 450902, 450000, 933);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450903, '广西玉林市公安局福绵分局', '广西玉林市公安局//广西玉林市公安局福绵分局', '3', 2, 450900, 450903, 450000, 952);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450904, '广西玉林市公安局玉东分局', '广西玉林市公安局//广西玉林市公安局玉东分局', '3', 3, 450900, 450904, 450000, 959);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450921, '广西容县公安局', '广西玉林市公安局//广西容县公安局', '3', 4, 450900, 450921, 450000, 960);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450922, '广西陆川县公安局', '广西玉林市公安局//广西陆川县公安局', '3', 5, 450900, 450922, 450000, 978);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450923, '广西博白县公安局', '广西玉林市公安局//广西博白县公安局', '3', 6, 450900, 450923, 450000, 997);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450924, '广西兴业县公安局', '广西玉林市公安局//广西兴业县公安局', '3', 7, 450900, 450924, 450000, 1034);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (450981, '广西北流市公安局', '广西玉林市公安局//广西北流市公安局', '3', 8, 450900, 450981, 450000, 1050);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451000, '广西百色市公安局', '广西百色市公安局', '2', 10, 450000, 451000, 450000, 1079);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451002, '广西百色市公安局右江分局', '广西百色市公安局//广西百色市公安局右江分局', '3', 1, 451000, 451002, 450000, 1080);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451003, '广西百色市公安局铝城分局', '广西百色市公安局//广西百色市公安局铝城分局', '3', 2, 451000, 451003, 450000, 1101);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451021, '广西田阳县公安局', '广西百色市公安局//广西田阳县公安局', '3', 3, 451000, 451021, 450000, 1105);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451022, '广西田东县公安局', '广西百色市公安局//广西田东县公安局', '3', 4, 451000, 451022, 450000, 1122);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451023, '广西平果县公安局', '广西百色市公安局//广西平果县公安局', '3', 5, 451000, 451023, 450000, 1139);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451024, '广西德保县公安局', '广西百色市公安局//广西德保县公安局', '3', 6, 451000, 451024, 450000, 1157);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451026, '广西那坡县公安局', '广西百色市公安局//广西那坡县公安局', '3', 7, 451000, 451026, 450000, 1177);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451027, '广西凌云县公安局', '广西百色市公安局//广西凌云县公安局', '3', 8, 451000, 451027, 450000, 1186);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451028, '广西乐业县公安局', '广西百色市公安局//广西乐业县公安局', '3', 9, 451000, 451028, 450000, 1198);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451029, '广西田林县公安局', '广西百色市公安局//广西田林县公安局', '3', 10, 451000, 451029, 450000, 1209);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451030, '广西西林县公安局', '广西百色市公安局//广西西林县公安局', '3', 11, 451000, 451030, 450000, 1230);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451031, '广西隆林各族自治县公安局', '广西百色市公安局//广西隆林各族自治县公安局', '3', 12, 451000, 451031, 450000, 1242);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451081, '广西靖西市公安局', '广西百色市公安局//广西靖西市公安局', '3', 13, 451000, 451081, 450000, 1259);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451100, '广西贺州市公安局', '广西贺州市公安局', '2', 11, 450000, 451100, 450000, 1280);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451102, '广西贺州市公安局八步分局', '广西贺州市公安局//广西贺州市公安局八步分局', '3', 1, 451100, 451102, 450000, 1281);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451103, '广西贺州市公安局平桂分局', '广西贺州市公安局//广西贺州市公安局平桂分局', '3', 2, 451100, 451103, 450000, 1300);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451121, '广西壮族自治区昭平县公安局', '广西贺州市公安局//广西壮族自治区昭平县公安局', '3', 3, 451100, 451121, 450000, 1315);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451122, '广西钟山县公安局', '广西贺州市公安局//广西钟山县公安局', '3', 4, 451100, 451122, 450000, 1329);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451123, '广西富川瑶族自治县公安局', '广西贺州市公安局//广西富川瑶族自治县公安局', '3', 5, 451100, 451123, 450000, 1344);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451200, '广西河池市公安局', '广西河池市公安局', '2', 12, 450000, 451200, 450000, 1360);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451202, '广西河池市公安局金城江分局', '广西河池市公安局//广西河池市公安局金城江分局', '3', 1, 451200, 451202, 450000, 1361);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451221, '广西南丹县公安局', '广西河池市公安局//广西南丹县公安局', '3', 2, 451200, 451221, 450000, 1380);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451222, '广西天峨县公安局', '广西河池市公安局//广西天峨县公安局', '3', 3, 451200, 451222, 450000, 1399);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451223, '广西凤山县公安局', '广西河池市公安局//广西凤山县公安局', '3', 4, 451200, 451223, 450000, 1414);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451224, '广西壮族自治区河池市东兰县公安局', '广西河池市公安局//广西壮族自治区河池市东兰县公安局', '3', 5, 451200, 451224, 450000, 1424);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451225, '广西罗城仫佬族自治县公安局', '广西河池市公安局//广西罗城仫佬族自治县公安局', '3', 6, 451200, 451225, 450000, 1442);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451226, '广西环江毛南族自治县公安局', '广西河池市公安局//广西环江毛南族自治县公安局', '3', 7, 451200, 451226, 450000, 1457);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451227, '广西巴马瑶族自治县公安局', '广西河池市公安局//广西巴马瑶族自治县公安局', '3', 8, 451200, 451227, 450000, 1474);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451228, '广西都安瑶族自治县公安局', '广西河池市公安局//广西都安瑶族自治县公安局', '3', 9, 451200, 451228, 450000, 1485);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451229, '广西大化瑶族自治县公安局', '广西河池市公安局//广西大化瑶族自治县公安局', '3', 10, 451200, 451229, 450000, 1508);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451281, '广西宜州市公安局', '广西河池市公安局//广西宜州市公安局', '3', 11, 451200, 451281, 450000, 1530);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451300, '广西来宾市公安局', '广西来宾市公安局', '2', 13, 450000, 451300, 450000, 1556);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451302, '广西来宾市公安局兴宾分局', '广西来宾市公安局//广西来宾市公安局兴宾分局', '3', 1, 451300, 451302, 450000, 1557);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451303, '广西来宾市公安局来宾华侨管理区（广西来宾高新技术产业开发区）分局', '广西来宾市公安局//广西来宾市公安局来宾华侨管理区（广西来宾高新技术产业开发区）分局', '3', 2, 451300, 451303, 450000, 1582);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451321, '广西忻城县公安局', '广西来宾市公安局//广西忻城县公安局', '3', 3, 451300, 451321, 450000, 1588);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451322, '广西象州县公安局', '广西来宾市公安局//广西象州县公安局', '3', 4, 451300, 451322, 450000, 1602);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451323, '广西武宣县公安局', '广西来宾市公安局//广西武宣县公安局', '3', 5, 451300, 451323, 450000, 1614);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451324, '广西金秀瑶族自治县公安局', '广西来宾市公安局//广西金秀瑶族自治县公安局', '3', 6, 451300, 451324, 450000, 1628);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451381, '广西合山市公安局', '广西来宾市公安局//广西合山市公安局', '3', 7, 451300, 451381, 450000, 1640);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451400, '广西崇左市公安局', '广西崇左市公安局', '2', 14, 450000, 451400, 450000, 1645);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451402, '广西崇左市公安局江州分局', '广西崇左市公安局//广西崇左市公安局江州分局', '3', 1, 451400, 451402, 450000, 1646);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451421, '广西扶绥县公安局', '广西崇左市公安局//广西扶绥县公安局', '3', 2, 451400, 451421, 450000, 1660);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451422, '广西宁明县公安局', '广西崇左市公安局//广西宁明县公安局', '3', 3, 451400, 451422, 450000, 1674);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451423, '广西龙州县公安局', '广西崇左市公安局//广西龙州县公安局', '3', 4, 451400, 451423, 450000, 1687);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451424, '广西大新县公安局', '广西崇左市公安局//广西大新县公安局', '3', 5, 451400, 451424, 450000, 1696);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451425, '广西天等县公安局', '广西崇左市公安局//广西天等县公安局', '3', 6, 451400, 451425, 450000, 1709);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451481, '广西凭祥市公安局', '广西崇左市公安局//广西凭祥市公安局', '3', 7, 451400, 451481, 450000, 1724);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (451500, '南宁铁路公安局', '南宁铁路公安局', '2', 15, 450000, NULL, 450000, 1765);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610000, '陕西省公安厅', NULL, '1', NULL, NULL, 610000, 610000, 60);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610100, '西安市公安局', '西安市公安局', '2', 1, 610000, 610100, 610000, 154);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610102, '新城分局', '西安市公安局//新城分局', '3', 1, 610100, 610102, 610000, 271);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610103, '碑林分局', '西安市公安局//碑林分局', '3', 6, 610100, 610103, 610000, 277);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610104, '莲湖分局', '西安市公安局//莲湖分局', '3', 7, 610100, 610104, 610000, 278);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610112, '未央分局', '西安市公安局//未央分局', '3', 8, 610100, 610112, 610000, 279);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610113, '雁塔分局', '西安市公安局//雁塔分局', '3', 5, 610100, 610113, 610000, 276);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610114, '阎良分局', '西安市公安局//阎良分局', '3', 12, 610100, 610114, 610000, 283);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610115, '临潼分局', '西安市公安局//临潼分局', '3', 10, 610100, 610115, 610000, 281);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610116, '长安分局', '西安市公安局//长安分局', '3', 2, 610100, 610116, 610000, 273);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610117, '高陵分局', '西安市公安局//高陵分局', '3', 15, 610100, 610117, 610000, 306);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610122, '蓝田县局', '西安市公安局//蓝田县局', '3', 13, 610100, 610122, 610000, 284);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610124, '周至县局', '西安市公安局//周至县局', '3', 14, 610100, 610124, 610000, 305);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610125, '鄠邑分局', '西安市公安局//鄠邑分局', '3', 11, 610100, 610125, 610000, 282);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610126, '灞桥分局', '西安市公安局//灞桥分局', '3', 17, 610100, 610111, 610000, 1126);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610189, '治安大队', NULL, '3', NULL, NULL, NULL, 610000, 410);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610190, '站前分局', '西安市公安局//站前分局', '3', 4, 610100, 150102, 610000, 275);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610191, '治安管理大队', NULL, '3', NULL, NULL, 610103, 610000, 393);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610192, '地铁分局', '西安市公安局//地铁分局', '3', 3, 610100, 610112, 610000, 274);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610193, '航天分局', '西安市公安局//航天分局', '3', 9, 610100, 130102, 610000, 280);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610194, '鄠邑分局党委委员、治安大队大队长', NULL, '3', NULL, NULL, NULL, 610000, 409);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610195, '西安市公安局高陵分局园区分局', NULL, '3', NULL, NULL, 610111, 610000, 10054);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610196, '洪庆分局', '西安市公安局//洪庆分局', '3', 16, 610100, 610111, 610000, 844);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610198, '西安市公安局站前分局', '西安市公安局//西安市公安局站前分局', '3', 18, 610100, NULL, 610000, 10065);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610200, '铜川市公安局', '铜川市公安局', '2', 4, 610000, 610200, 610000, 158);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610202, '王益公安分局', '铜川市公安局//王益公安分局', '3', 1, 610200, 610202, 610000, 195);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610203, '印台公安分局', '铜川市公安局//印台公安分局', '3', 2, 610200, 610203, 610000, 196);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610204, '耀州公安分局', '铜川市公安局//耀州公安分局', '3', 3, 610200, 610204, 610000, 197);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610222, '宜君县公安局', '铜川市公安局//宜君县公安局', '3', 5, 610200, 610222, 610000, 199);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610291, '虹桥公安分局', '铜川市公安局//虹桥公安分局', '3', 6, 610200, 610202, 610000, 200);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610292, '建乐公安分局', '铜川市公安局//建乐公安分局', '3', 7, 610200, 610202, 610000, 201);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610293, '新区公安分局', '铜川市公安局//新区公安分局', '3', 4, 610200, 610204, 610000, 198);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610300, '宝鸡市公安局', '宝鸡市公安局', '2', 2, 610000, 610300, 610000, 156);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610302, '渭滨公安分局', '宝鸡市公安局//渭滨公安分局', '3', 2, 610300, 610302, 610000, 207);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610303, '金台公安分局', '宝鸡市公安局//金台公安分局', '3', 1, 610300, 610303, 610000, 206);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610304, '陈仓公安分局', '宝鸡市公安局//陈仓公安分局', '3', 13, 610300, 610304, 610000, 218);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610322, '凤翔县公安局', '宝鸡市公安局//凤翔县公安局', '3', 7, 610300, 610322, 610000, 212);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610323, '岐山县公安局', '宝鸡市公安局//岐山县公安局', '3', 6, 610300, 610323, 610000, 211);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610324, '扶风县公安局', '宝鸡市公安局//扶风县公安局', '3', 4, 610300, 610324, 610000, 209);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610326, '眉县公安分局', '宝鸡市公安局//眉县公安分局', '3', 5, 610300, 610326, 610000, 210);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610327, '陇县公安分局', '宝鸡市公安局//陇县公安分局', '3', 8, 610300, 610327, 610000, 213);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610328, '千阳县公安局', '宝鸡市公安局//千阳县公安局', '3', 10, 610300, 610328, 610000, 215);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610329, '麟游县公安局', '宝鸡市公安局//麟游县公安局', '3', 11, 610300, 610329, 610000, 216);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610330, '凤县公安局', '宝鸡市公安局//凤县公安局', '3', 15, 610300, 610330, 610000, 220);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610331, '太白县公安局', '宝鸡市公安局//太白县公安局', '3', 14, 610300, 610331, 610000, 219);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610332, '高新公安分局', '宝鸡市公安局//高新公安分局', '3', 3, 610300, NULL, 610000, 208);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610333, '钛城公安分局', '宝鸡市公安局//钛城公安分局', '3', 9, 610300, NULL, 610000, 214);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610335, '法门寺分局', '宝鸡市公安局//法门寺分局', '3', 12, 610300, NULL, 610000, 217);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610399, '陕西省宝鸡市公安局高新技术产业开发区分局', '宝鸡市公安局//陕西省宝鸡市公安局高新技术产业开发区分局', '3', 16, 610300, NULL, 610000, 10167);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610400, '咸阳市公安局', '咸阳市公安局', '2', 3, 610000, 610400, 610000, 157);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610402, '秦都公安分局', '咸阳市公安局//秦都公安分局', '3', 1, 610400, 610402, 610000, 259);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610404, '渭城公安分局', '咸阳市公安局//渭城公安分局', '3', 2, 610400, 610404, 610000, 260);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610422, '三原县公安局', '咸阳市公安局//三原县公安局', '3', 11, 610400, 610422, 610000, 1081);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610423, '泾阳县公安局', '咸阳市公安局//泾阳县公安局', '3', 5, 610400, 610423, 610000, 1075);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610424, '乾县公安局', '咸阳市公安局//乾县公安局', '3', 7, 610400, 610424, 610000, 1077);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610425, '礼泉县公安局', '咸阳市公安局//礼泉县公安局', '3', 6, 610400, 610425, 610000, 1076);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610426, '永寿县公安局', '咸阳市公安局//永寿县公安局', '3', 8, 610400, 610426, 610000, 1078);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610427, '彬州市公安局', '咸阳市公安局//彬州市公安局', '3', 9, 610400, 610427, 610000, 1079);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610428, '长武县公安局', '咸阳市公安局//长武县公安局', '3', 10, 610400, 610428, 610000, 1080);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610429, '旬邑县公安局', '咸阳市公安局//旬邑县公安局', '3', 12, 610400, 610429, 610000, 1082);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610430, '淳化县公安局', '咸阳市公安局//淳化县公安局', '3', 13, 610400, 610430, 610000, 1083);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610431, '武功县公安局', '咸阳市公安局//武功县公安局', '3', 4, 610400, 610431, 610000, 549);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610481, '兴平市公安局', '咸阳市公安局//兴平市公安局', '3', 3, 610400, 610481, 610000, 548);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610490, '陕西省彬县公安局', NULL, '3', NULL, NULL, 610427, 610000, 10254);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610497, '秦岭公安分局', '咸阳市公安局//秦岭公安分局', '3', 16, 610400, NULL, 610000, 1091);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610498, '铁路工程公安分局', '咸阳市公安局//铁路工程公安分局', '3', 15, 610400, NULL, 610000, 1090);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610499, '彩虹公安分局', '咸阳市公安局//彩虹公安分局', '3', 14, 610400, NULL, 610000, 1089);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610500, '渭南市公安局', '渭南市公安局', '2', 5, 610000, 610500, 610000, 159);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610502, '临渭分局', '渭南市公安局//临渭分局', '3', 1, 610500, 610502, 610000, 169);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610503, '华州区公安局', '渭南市公安局//华州区公安局', '3', 4, 610500, 610503, 610000, 180);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610522, '潼关县公安局', '渭南市公安局//潼关县公安局', '3', 12, 610500, 610522, 610000, 188);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610523, '大荔县公安局', '渭南市公安局//大荔县公安局', '3', 10, 610500, 610523, 610000, 186);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610524, '合阳县公安局', '渭南市公安局//合阳县公安局', '3', 13, 610500, 610524, 610000, 189);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610525, '澄城县公安局', '渭南市公安局//澄城县公安局', '3', 11, 610500, 610525, 610000, 187);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610526, '蒲城县公安局', '渭南市公安局//蒲城县公安局', '3', 7, 610500, 610526, 610000, 183);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610527, '白水县公安局', '渭南市公安局//白水县公安局', '3', 8, 610500, 610527, 610000, 184);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610528, '富平县公安局', '渭南市公安局//富平县公安局', '3', 9, 610500, 610528, 610000, 185);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610581, '韩城市公安局', '渭南市公安局//韩城市公安局', '3', 6, 610500, 610581, 610000, 182);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610582, '华阴市公安局', '渭南市公安局//华阴市公安局', '3', 5, 610500, 610582, 610000, 181);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610583, '高新分局', '渭南市公安局//高新分局', '3', 2, 610500, NULL, 610000, 170);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610584, '经开分局', '渭南市公安局//经开分局', '3', 3, 610500, NULL, 610000, 179);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610590, '陕西省潼关县公安局矿区分局', NULL, '3', NULL, NULL, 610522, 610000, 10331);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610591, '陕西省渭南市公安局象山分局', '渭南市公安局//陕西省渭南市公安局象山分局', '3', 14, 610500, NULL, 610000, 10341);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610592, '陕西省渭南市公安局罕井分局', '渭南市公安局//陕西省渭南市公安局罕井分局', '3', 15, 610500, NULL, 610000, 10342);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610594, '陕西省渭南市公安局钼城分局', '渭南市公安局//陕西省渭南市公安局钼城分局', '3', 16, 610500, NULL, 610000, 10346);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610595, '陕西省渭南市公安局大华分局', '渭南市公安局//陕西省渭南市公安局大华分局', '3', 17, 610500, NULL, 610000, 10347);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610596, '陕西省渭南市公安局城南分局', '渭南市公安局//陕西省渭南市公安局城南分局', '3', 18, 610500, NULL, 610000, 10349);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610597, '陕西省渭南市公安局秦华分局', '渭南市公安局//陕西省渭南市公安局秦华分局', '3', 19, 610500, NULL, 610000, 10351);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610598, '陕西省渭南市公安局东雷分局', '渭南市公安局//陕西省渭南市公安局东雷分局', '3', 20, 610500, NULL, 610000, 10353);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610599, '陕西省华阴市公安局华山分局', NULL, '3', NULL, NULL, 610582, 610000, 10340);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610600, '延安市公安局', '延安市公安局', '2', 6, 610000, 610600, 610000, 160);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610602, '宝塔分局', '延安市公安局//宝塔分局', '3', 1, 610600, 610602, 610000, 690);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610603, '陕西省延安市公安局安塞分局', '延安市公安局//陕西省延安市公安局安塞分局', '3', 2, 610600, 610603, 610000, 10374);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610621, '陕西省延长县公安局', '延安市公安局//陕西省延长县公安局', '3', 3, 610600, 610621, 610000, 10386);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610622, '陕西省延川县公安局', '延安市公安局//陕西省延川县公安局', '3', 4, 610600, 610622, 610000, 10395);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610623, '陕西省子长县公安局', '延安市公安局//陕西省子长县公安局', '3', 5, 610600, 610623, 610000, 10406);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610625, '陕西省志丹县公安局', '延安市公安局//陕西省志丹县公安局', '3', 6, 610600, 610625, 610000, 10430);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610626, '陕西省吴起县公安局', '延安市公安局//陕西省吴起县公安局', '3', 7, 610600, 610626, 610000, 10440);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610627, '陕西省甘泉县公安局', '延安市公安局//陕西省甘泉县公安局', '3', 8, 610600, 610627, 610000, 10453);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610628, '陕西省富县公安局', '延安市公安局//陕西省富县公安局', '3', 9, 610600, 610628, 610000, 10462);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610629, '陕西省洛川县公安局', '延安市公安局//陕西省洛川县公安局', '3', 10, 610600, 610629, 610000, 10472);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610630, '陕西省宜川县公安局', '延安市公安局//陕西省宜川县公安局', '3', 11, 610600, 610630, 610000, 10484);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610631, '陕西省黄龙县公安局', '延安市公安局//陕西省黄龙县公安局', '3', 12, 610600, 610631, 610000, 10491);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610632, '陕西省黄陵县公安局', '延安市公安局//陕西省黄陵县公安局', '3', 13, 610600, 610632, 610000, 10499);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610696, '陕西省延安市公安局经济技术开发区分局', '延安市公安局//陕西省延安市公安局经济技术开发区分局', '3', 14, 610600, 450129, 610000, 10508);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610697, '陕西省延安市公安局永坪分局', '延安市公安局//陕西省延安市公安局永坪分局', '3', 15, 610600, NULL, 610000, 10511);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610698, '陕西省延安市公安局延河分局', '延安市公安局//陕西省延安市公安局延河分局', '3', 16, 610600, NULL, 610000, 10524);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610699, '陕西省延安市公安局交口分局', '延安市公安局//陕西省延安市公安局交口分局', '3', 17, 610600, 141130, 610000, 10531);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610700, '汉中市公安局', '汉中市公安局', '2', 8, 610000, 610700, 610000, 162);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610702, '汉台分局', '汉中市公安局//汉台分局', '3', 1, 610700, 610702, 610000, 171);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610721, '南郑分局', '汉中市公安局//南郑分局', '3', 2, 610700, 610721, 610000, 172);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610722, '城固县公安局', '汉中市公安局//城固县公安局', '3', 4, 610700, 610722, 610000, 174);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610723, '洋县公安局', '汉中市公安局//洋县公安局', '3', 6, 610700, 610723, 610000, 176);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610724, '西乡县公安局', '汉中市公安局//西乡县公安局', '3', 7, 610700, 610724, 610000, 177);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610725, '勉县公安局', '汉中市公安局//勉县公安局', '3', 5, 610700, 610725, 610000, 175);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610726, '宁强县公安局', '汉中市公安局//宁强县公安局', '3', 8, 610700, 610726, 610000, 178);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610727, '略阳县公安局', '汉中市公安局//略阳县公安局', '3', 9, 610700, 610727, 610000, 191);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610728, '镇巴县公安局', '汉中市公安局//镇巴县公安局', '3', 10, 610700, 610728, 610000, 192);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610729, '留坝县公安局', '汉中市公安局//留坝县公安局', '3', 11, 610700, 610729, 610000, 193);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610730, '佛坪县公安局', '汉中市公安局//佛坪县公安局', '3', 12, 610700, 610730, 610000, 194);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610731, '经济开发区分局', '汉中市公安局//经济开发区分局', '3', 3, 610700, 450129, 610000, 173);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610790, '汉台分局治安大队', NULL, '3', NULL, NULL, 610702, 610000, 190);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610791, '陕西省城固县公安局森林公安分局', NULL, '3', NULL, NULL, 610722, 610000, 10576);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610792, '陕西省略阳县公安局森林公安分局', NULL, '3', NULL, NULL, 610727, 610000, 10643);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610796, '陕西省汉中市公安局南山公安分局', '汉中市公安局//陕西省汉中市公安局南山公安分局', '3', 13, 610700, NULL, 610000, 10684);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610797, '陕西省汉中市公安局玉河公安分局', '汉中市公安局//陕西省汉中市公安局玉河公安分局', '3', 14, 610700, NULL, 610000, 10686);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610798, '陕西省汉中市公安局文柳公安分局', '汉中市公安局//陕西省汉中市公安局文柳公安分局', '3', 15, 610700, NULL, 610000, 10690);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610800, '榆林市公安局', '榆林市公安局', '2', 7, 610000, 610800, 610000, 161);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610801, '榆林市公安局榆庆分局', '榆林市公安局//榆林市公安局榆庆分局', '3', 15, 610800, 610801, 610000, 10694);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610802, '榆阳区公安局', '榆林市公安局//榆阳区公安局', '3', 2, 610800, 610802, 610000, 571);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610803, '横山分局', '榆林市公安局//横山分局', '3', 5, 610800, 610803, 610000, 601);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610821, '神木市公安局', '榆林市公安局//神木市公安局', '3', 13, 610800, 610821, 610000, 736);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610822, '府谷县公安局', '榆林市公安局//府谷县公安局', '3', 8, 610800, 610822, 610000, 650);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610824, '靖边县公安局', '榆林市公安局//靖边县公安局', '3', 4, 610800, 610824, 610000, 574);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610825, '定边县公安局', '榆林市公安局//定边县公安局', '3', 1, 610800, 610825, 610000, 569);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610826, '绥德县公安局', '榆林市公安局//绥德县公安局', '3', 11, 610800, 610826, 610000, 708);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610827, '米脂县公安局', '榆林市公安局//米脂县公安局', '3', 3, 610800, 610827, 610000, 572);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610828, '佳县公安局', '榆林市公安局//佳县公安局', '3', 7, 610800, 610828, 610000, 648);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610829, '吴堡县公安局', '榆林市公安局//吴堡县公安局', '3', 12, 610800, 610829, 610000, 731);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610830, '清涧县公安局', '榆林市公安局//清涧县公安局', '3', 14, 610800, 610830, 610000, 742);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610831, '子洲县公安局', '榆林市公安局//子洲县公安局', '3', 6, 610800, 610831, 610000, 634);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610832, '榆林市公安局榆横分局', '榆林市公安局//榆林市公安局榆横分局', '3', 16, 610800, NULL, 610000, 10732);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610833, '榆神公安分局', '榆林市公安局//榆神公安分局', '3', 10, 610800, NULL, 610000, 694);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610890, '高新区榆横工业园区分局	', '榆林市公安局//高新区榆横工业园区分局	', '3', 9, 610800, 610930, 610000, 682);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610900, '安康市公安局', '安康市公安局', '2', 9, 610000, 610900, 610000, 163);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610901, '安康市公安局恒口分局', '安康市公安局//安康市公安局恒口分局', '3', 8, 610900, 610901, 610000, 319);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610902, '安康市公安局汉滨分局', '安康市公安局//安康市公安局汉滨分局', '3', 10, 610900, 610902, 610000, 693);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610921, '安康市汉阴县公安局', '安康市公安局//安康市汉阴县公安局', '3', 11, 610900, 610921, 610000, 837);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610922, '安康市石泉县公安局', '安康市公安局//安康市石泉县公安局', '3', 4, 610900, 610922, 610000, 312);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610923, '安康市宁陕县公安局', '安康市公安局//安康市宁陕县公安局', '3', 2, 610900, 610923, 610000, 309);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610924, '安康市紫阳县公安局', '安康市公安局//安康市紫阳县公安局', '3', 7, 610900, 610924, 610000, 316);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610925, '安康市岚皋县公安局', '安康市公安局//安康市岚皋县公安局', '3', 9, 610900, 610925, 610000, 525);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610926, '安康市平利县公安局', '安康市公安局//安康市平利县公安局', '3', 1, 610900, 610926, 610000, 308);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610927, '安康市镇坪县公安局', '安康市公安局//安康市镇坪县公安局', '3', 5, 610900, 610927, 610000, 313);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610928, '安康市旬阳县公安局', '安康市公安局//安康市旬阳县公安局', '3', 6, 610900, 610928, 610000, 315);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610929, '安康市白河县公安局', '安康市公安局//安康市白河县公安局', '3', 3, 610900, 610929, 610000, 311);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (610930, '安康市公安局高新分局', '安康市公安局//安康市公安局高新分局', '3', 12, 610900, 610930, 610000, 842);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611000, '商洛市公安局', '商洛市公安局', '2', 10, 610000, 611000, 610000, 164);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611002, '商州分局', '商洛市公安局//商州分局', '3', 1, 611000, 611002, 610000, 261);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611021, '洛南县公安局', '商洛市公安局//洛南县公安局', '3', 2, 611000, 611021, 610000, 262);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611022, '丹凤县公安局', '商洛市公安局//丹凤县公安局', '3', 3, 611000, 611022, 610000, 263);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611023, '商南县公安局', '商洛市公安局//商南县公安局', '3', 4, 611000, 611023, 610000, 264);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611024, '山阳县公安局', '商洛市公安局//山阳县公安局', '3', 5, 611000, 611024, 610000, 265);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611025, '镇安县公安局', '商洛市公安局//镇安县公安局', '3', 6, 611000, 611025, 610000, 266);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611026, '柞水县公安局', '商洛市公安局//柞水县公安局', '3', 7, 611000, 611026, 610000, 267);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611027, '商洛市高新分局', '商洛市公安局//商洛市高新分局', '3', 8, 611000, 610930, 610000, 268);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611100, '杨凌农业高新技术产业示范区公安局', '杨凌农业高新技术产业示范区公安局', '2', 11, 610000, 611100, 610000, 165);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611200, '西咸新区公安局', '西咸新区公安局', '2', 12, 610000, 611200, 610000, 166);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611201, ' 沣东新城分局', '西咸新区公安局// 沣东新城分局', '3', 1, 611200, NULL, 610000, 846);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611202, '秦汉新城分局', '西咸新区公安局//秦汉新城分局', '3', 2, 611200, NULL, 610000, 847);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611203, '空港新城分局', '西咸新区公安局//空港新城分局', '3', 3, 611200, NULL, 610000, 849);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611204, '沣西新城分局', '西咸新区公安局//沣西新城分局', '3', 4, 611200, NULL, 610000, 850);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611205, '泾河新城分局', '西咸新区公安局//泾河新城分局', '3', 5, 611200, NULL, 610000, 851);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611300, '西安国际商务区片区公安局', '西安国际商务区片区公安局', '2', 13, 610000, 611300, 610000, 167);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611400, '中心片区公安局', '中心片区公安局', '2', 14, 610000, 611400, 610000, 168);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611500, '西安市公安局高新分局', '西安市公安局高新分局', '2', 17, 610000, 611500, 610000, 995);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611600, '西安市公安局浐灞生态区分局', '西安市公安局浐灞生态区分局', '2', 16, 610000, 611600, 610000, 994);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611601, '浐灞分局治安大队', '西安市公安局浐灞生态区分局//浐灞分局治安大队', '3', 1, 611600, 611600, 610000, 1056);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611700, '西安市公安局经济技术开发区分局', '西安市公安局经济技术开发区分局', '2', 15, 610000, 611700, 610000, 993);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611800, '西安市公安局灞桥分局国际港务区', '西安市公安局灞桥分局国际港务区', '2', 18, 610000, 611800, 610000, 1055);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611900, '咸阳高新公安分局', '咸阳高新公安分局', '2', 19, 610000, NULL, 610000, 1084);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (611901, '陕西省咸阳市公安局高新技术产业开发区分局', '咸阳高新公安分局//陕西省咸阳市公安局高新技术产业开发区分局', '3', 1, 611900, NULL, 610000, 10320);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640000, '宁夏回族自治区公安厅', NULL, '1', NULL, NULL, 640000, 640000, 1);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640100, '宁夏银川市公安局', '宁夏银川市公安局', '2', 1, 640000, 640100, 640000, 2);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640101, '宁夏银川市公安局滨河新区分局', '宁夏银川市公安局//宁夏银川市公安局滨河新区分局', '3', 9, 640100, 640101, 640000, 81);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640104, '宁夏银川市公安局兴庆区分局', '宁夏银川市公安局//宁夏银川市公安局兴庆区分局', '3', 1, 640100, 640104, 640000, 3);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640105, '宁夏银川市公安局西夏区分局', '宁夏银川市公安局//宁夏银川市公安局西夏区分局', '3', 3, 640100, 640105, 640000, 34);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640106, '宁夏银川市公安局金凤区分局', '宁夏银川市公安局//宁夏银川市公安局金凤区分局', '3', 2, 640100, 640106, 640000, 24);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640121, '宁夏银川市公安局永宁县公安局', '宁夏银川市公安局//宁夏银川市公安局永宁县公安局', '3', 6, 640100, 640121, 640000, 53);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640122, '宁夏银川市公安局贺兰县公安局', '宁夏银川市公安局//宁夏银川市公安局贺兰县公安局', '3', 7, 640100, 640122, 640000, 64);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640181, '宁夏银川市公安局灵武市公安局', '宁夏银川市公安局//宁夏银川市公安局灵武市公安局', '3', 8, 640100, 640181, 640000, 71);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640198, '宁夏银川市公安局经济技术开发区分局', '宁夏银川市公安局//宁夏银川市公安局经济技术开发区分局', '3', 4, 640100, 450129, 640000, 48);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640199, '宁夏银川市公安局宁东公安分局', '宁夏银川市公安局//宁夏银川市公安局宁东公安分局', '3', 5, 640100, NULL, 640000, 50);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640200, '宁夏石嘴山市公安局', '宁夏石嘴山市公安局', '2', 2, 640000, 640200, 640000, 86);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640201, '宁夏石嘴山市公安局石炭井公安分局', '宁夏石嘴山市公安局//宁夏石嘴山市公安局石炭井公安分局', '3', 3, 640200, 640201, 640000, 112);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640202, '宁夏石嘴山市公安局大武口区公安分局', '宁夏石嘴山市公安局//宁夏石嘴山市公安局大武口区公安分局', '3', 1, 640200, 640202, 640000, 87);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640205, '宁夏石嘴山市公安局惠农区公安分局', '宁夏石嘴山市公安局//宁夏石嘴山市公安局惠农区公安分局', '3', 2, 640200, 640205, 640000, 97);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640221, '宁夏石嘴山市公安局太西公安分局平罗县公安局', NULL, '3', NULL, NULL, 640221, 640000, 118);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640299, '宁夏石嘴山市公安局太西公安分局', '宁夏石嘴山市公安局//宁夏石嘴山市公安局太西公安分局', '3', 4, 640200, 640202, 640000, 115);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640300, '宁夏吴忠市公安局', '宁夏吴忠市公安局', '2', 5, 640000, 640300, 640000, 251);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640302, '宁夏吴忠市公安局利通区分局', '宁夏吴忠市公安局//宁夏吴忠市公安局利通区分局', '3', 1, 640300, 640302, 640000, 252);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640303, '宁夏吴忠市公安局红寺堡区公安分局', '宁夏吴忠市公安局//宁夏吴忠市公安局红寺堡区公安分局', '3', 2, 640300, 640303, 640000, 264);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640323, '宁夏吴忠市公安局盐池县公安局', '宁夏吴忠市公安局//宁夏吴忠市公安局盐池县公安局', '3', 6, 640300, 640323, 640000, 295);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640324, '宁夏吴忠市公安局同心县公安局', '宁夏吴忠市公安局//宁夏吴忠市公安局同心县公安局', '3', 5, 640300, 640324, 640000, 285);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640381, '宁夏吴忠市公安局青铜峡市公安局', '宁夏吴忠市公安局//宁夏吴忠市公安局青铜峡市公安局', '3', 4, 640300, 640381, 640000, 272);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640398, '宁夏吴忠市公安局太阳山移民开发区公安分局', '宁夏吴忠市公安局//宁夏吴忠市公安局太阳山移民开发区公安分局', '3', 3, 640300, 640303, 640000, 270);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640399, '宁夏吴忠市公安局孙家滩分局', '宁夏吴忠市公安局//宁夏吴忠市公安局孙家滩分局', '3', 7, 640300, NULL, 640000, 304);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640400, '宁夏固原市公安局', '宁夏固原市公安局', '2', 4, 640000, 640400, 640000, 175);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640402, '宁夏固原市公安局原州区分局', '宁夏固原市公安局//宁夏固原市公安局原州区分局', '3', 1, 640400, 640402, 640000, 176);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640422, '宁夏固原市公安局西吉县公安局', '宁夏固原市公安局//宁夏固原市公安局西吉县公安局', '3', 5, 640400, 640422, 640000, 228);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640423, '宁夏固原市公安局隆德县公安局', '宁夏固原市公安局//宁夏固原市公安局隆德县公安局', '3', 4, 640400, 640423, 640000, 214);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640424, '宁夏固原市公安局泾源县公安局', '宁夏固原市公安局//宁夏固原市公安局泾源县公安局', '3', 3, 640400, 640424, 640000, 206);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640425, '宁夏固原市公安局彭阳县公安局', '宁夏固原市公安局//宁夏固原市公安局彭阳县公安局', '3', 2, 640400, 640425, 640000, 192);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640499, '宁夏固原市公安局开发区分局', '宁夏固原市公安局//宁夏固原市公安局开发区分局', '3', 6, 640400, NULL, 640000, 248);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640500, '宁夏中卫市公安局', '宁夏中卫市公安局', '2', 3, 640000, 640500, 640000, 129);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640502, '宁夏中卫市公安局沙坡头区公安分局', '宁夏中卫市公安局//宁夏中卫市公安局沙坡头区公安分局', '3', 5, 640500, 640502, 640000, 164);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640521, '宁夏中卫市公安局中宁县公安局', '宁夏中卫市公安局//宁夏中卫市公安局中宁县公安局', '3', 4, 640500, 640521, 640000, 150);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640522, '宁夏中卫市公安局海原县公安局', '宁夏中卫市公安局//宁夏中卫市公安局海原县公安局', '3', 1, 640500, 640522, 640000, 130);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640598, '宁夏中卫市公安局工业园区分局', '宁夏中卫市公安局//宁夏中卫市公安局工业园区分局', '3', 3, 640500, 640521, 640000, 148);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (640599, '宁夏中卫市公安局工业物流园分局', '宁夏中卫市公安局//宁夏中卫市公安局工业物流园分局', '3', 2, 640500, 640502, 640000, 146);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010101, '北京市公安局东城区分局建国门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局建国门派出所', '4', 1, 110101, 110101, 110000, 20);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010102, '北京市公安局东城区分局朝阳门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局朝阳门派出所', '4', 2, 110101, 110101, 110000, 21);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010103, '北京市公安局东城区分局东四派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东四派出所', '4', 3, 110101, 110101, 110000, 22);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010104, '北京市公安局东城区分局景山派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局景山派出所', '4', 4, 110101, 110101, 110000, 23);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010105, '北京市公安局东城区分局北新桥派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局北新桥派出所', '4', 5, 110101, 110101, 110000, 24);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010106, '北京市公安局东城区分局东直门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东直门派出所', '4', 6, 110101, 110101, 110000, 26);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010107, '北京市公安局东城区分局和平里派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局和平里派出所', '4', 7, 110101, 110101, 110000, 28);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010108, '北京市公安局东城区分局交道口派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局交道口派出所', '4', 8, 110101, 110101, 110000, 30);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010109, '北京市公安局东城区分局安定门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局安定门派出所', '4', 9, 110101, 110101, 110000, 31);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010110, '北京市公安局东城区分局东华门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东华门派出所', '4', 10, 110101, 110101, 110000, 33);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010111, '北京市公安局东城区分局东交民巷派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东交民巷派出所', '4', 11, 110101, 110101, 110000, 36);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010112, '北京市公安局东城区分局北京站派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局北京站派出所', '4', 12, 110101, 110101, 110000, 41);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010113, '北京市公安局东城区分局安外大街派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局安外大街派出所', '4', 13, 110101, 110101, 110000, 75);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010114, '北京市公安局东城区分局王府井大街派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局王府井大街派出所', '4', 14, 110101, 110101, 110000, 77);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010115, '北京市公安局东城区分局东方广场派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东方广场派出所', '4', 15, 110101, 110101, 110000, 80);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010116, '北京市公安局东城区分局永外派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局永外派出所', '4', 16, 110101, 110101, 110000, 83);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010117, '北京市公安局东城区分局天坛派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局天坛派出所', '4', 17, 110101, 110101, 110000, 85);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010118, '北京市公安局东城区分局前门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局前门派出所', '4', 18, 110101, 110101, 110000, 87);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010119, '北京市公安局东城区分局崇文门派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局崇文门派出所', '4', 19, 110101, 110101, 110000, 89);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010120, '北京市公安局东城区分局东花市派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局东花市派出所', '4', 20, 110101, 110101, 110000, 91);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010121, '北京市公安局东城区分局体育馆路派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局体育馆路派出所', '4', 21, 110101, 110101, 110000, 93);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010122, '北京市公安局东城区分局龙潭派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局龙潭派出所', '4', 22, 110101, 110101, 110000, 95);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010123, '北京市公安局东城区分局前门大街派出所', '北京公安局//北京市公安局东城区分局//北京市公安局东城区分局前门大街派出所', '4', 23, 110101, 110101, 110000, 97);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010201, '北京市公安局西城区分局西长安街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局西长安街派出所', '4', 1, 110102, 110102, 110000, 163);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010202, '北京市公安局西城区分局二龙路派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局二龙路派出所', '4', 2, 110102, 110102, 110000, 165);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010203, '北京市公安局西城区分局丰盛派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局丰盛派出所', '4', 3, 110102, 110102, 110000, 167);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010204, '北京市公安局西城区分局厂桥派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局厂桥派出所', '4', 4, 110102, 110102, 110000, 169);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010205, '北京市公安局西城区分局福绥境派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局福绥境派出所', '4', 5, 110102, 110102, 110000, 171);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010206, '北京市公安局西城区分局月坛派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局月坛派出所', '4', 6, 110102, 110102, 110000, 172);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010207, '北京市公安局西城区分局新街口派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局新街口派出所', '4', 7, 110102, 110102, 110000, 174);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010208, '北京市公安局西城区分局展览路派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局展览路派出所', '4', 8, 110102, 110102, 110000, 175);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010209, '北京市公安局西城区分局阜外大街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局阜外大街派出所', '4', 9, 110102, 110102, 110000, 176);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010210, '北京市公安局西城区分局德外派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局德外派出所', '4', 10, 110102, 110102, 110000, 178);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010211, '北京市公安局西城区分局西单大街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局西单大街派出所', '4', 11, 110102, 110102, 110000, 180);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010212, '北京市公安局西城区分局北海公园派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局北海公园派出所', '4', 12, 110102, 110102, 110000, 181);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010213, '北京市公安局西城区分局动物园派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局动物园派出所', '4', 13, 110102, 110102, 110000, 183);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010214, '北京市公安局西城区分局府右街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局府右街派出所', '4', 14, 110102, 110102, 110000, 185);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010215, '北京市公安局西城区分局西直门外大街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局西直门外大街派出所', '4', 15, 110102, 110102, 110000, 187);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010216, '北京市公安局西城区分局地安门派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局地安门派出所', '4', 16, 110102, 110102, 110000, 190);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010217, '北京市公安局西城区分局国家大剧院派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局国家大剧院派出所', '4', 17, 110102, 110102, 110000, 192);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010218, '北京市公安局西城区分局广内派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局广内派出所', '4', 18, 110102, 110102, 110000, 194);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010219, '北京市公安局西城区分局广外派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局广外派出所', '4', 19, 110102, 110102, 110000, 195);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010220, '北京市公安局西城区分局牛街派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局牛街派出所', '4', 20, 110102, 110102, 110000, 196);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010221, '北京市公安局西城区分局白纸坊派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局白纸坊派出所', '4', 21, 110102, 110102, 110000, 197);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010222, '北京市公安局西城区分局陶然亭派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局陶然亭派出所', '4', 22, 110102, 110102, 110000, 198);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010223, '北京市公安局西城区分局天桥派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局天桥派出所', '4', 23, 110102, 110102, 110000, 199);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010224, '北京市公安局西城区分局椿树派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局椿树派出所', '4', 24, 110102, 110102, 110000, 201);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010225, '北京市公安局西城区分局大栅栏派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局大栅栏派出所', '4', 25, 110102, 110102, 110000, 203);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010226, '北京市公安局西城区分局天宁寺派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局天宁寺派出所', '4', 26, 110102, 110102, 110000, 205);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010227, '北京市公安局西城区分局陶然亭公园派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局陶然亭公园派出所', '4', 27, 110102, 110102, 110000, 207);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010228, '北京市公安局西城区分局先农坛派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局先农坛派出所', '4', 28, 110102, 110102, 110000, 209);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010229, '北京市公安局西城区分局官园派出所', '北京公安局//北京市公安局西城区分局//北京市公安局西城区分局官园派出所', '4', 29, 110102, 110102, 110000, 211);
INSERT INTO `sys_police` (`policeId`, `policeName`, `policeFullName`, `policeLevel`, `seq`, `parentPoliceId`, `regionId`, `provinceId`, `bbdId`) VALUES (11010501, '北京市公安局朝阳区分局朝外大街派出