import { defineStore } from 'pinia';
// import Cookies from 'js-cookie';
import { Session, Local } from '/@/utils/storage';
import { ConfigApi } from '/@/api/api'
/**
 * 用户信息
 * @methods setUserInfos 设置用户信息
 */
export const useUserInfo = defineStore('userInfo', {
  state: (): UserInfosState => ({
    userInfos: {
      userName: '',
      photo: '',
      time: 0,
      roles: ['admin', 'common'],
      authBtnList: []
    },
  }),
  actions: {
    async setUserInfos() {
      if (Session.get('userInfolist')) {
        this.userInfos = Session.get('userInfolist')
      } else {
        const userInfos: any = await this.getApiUserInfo()// 模拟接口数据
        this.userInfos = userInfos;//返回模拟出来json数据对象
      }
    },
    async getApiUserInfo() {// 模拟接口数据
      return new Promise((resolve) => {
        // ConfigApi().dispatchidentityLoginApi().then(async res=>{
        //     console.log('res',res)
        //     if(res.status==200){
        //       console.log('res.data.dispatchToken',res.data.dispatchToken)
        //       let dispatchToken=res.data.dispatchToken;
        //       localStorage.setItem('dispatchToken',dispatchToken)//dispatchToken代表该用户可以调度应用的token
        //     }
        // })
        setTimeout(() => {
          const userName = Session.get('userName') || 'admin';// 模拟数据，请求接口时，记得删除多余代码及对应依赖的引入
          // 模拟数据
          let defaultRoles: Array<string> = []
          let defaultAuthBtnList: Array<string> = []

          let adminRoles = ['admin']// admin 页面权限标识，对应路由 meta.roles，用于控制路由的显示/隐藏
          let adminAuthBtnList: Array<string> = ['btn.add', 'btn.del', 'btn.edit', 'btn.link']// admin 按钮权限标识

          let testRoles: Array<string> = ['common']// test 页面权限标识，对应路由 meta.roles，用于控制路由的显示/隐藏
          let testAuthBtnList: Array<string> = ['btn.add', 'btn.link']// test 按钮权限标识

          // 不同用户模拟不同的用户权限
          if (userName === 'admin') {
            defaultRoles = adminRoles
            defaultAuthBtnList = adminAuthBtnList
          } else {
            defaultRoles = testRoles
            defaultAuthBtnList = testAuthBtnList
          }

          // 用户信息模拟数据
          const userInfos = {
            userName: userName,//用户名称
            photo: userName === 'admin' ? 'https://img2.baidu.com/it/u=1978192862,2048448374&fm=253&fmt=auto&app=138&f=JPEG?w=504&h=500' : 'https://img2.baidu.com/it/u=2370931438,70387529&fm=253&fmt=auto&app=138&f=JPEG?w=500&h=500',//用户头像
            time: new Date().getTime(),//时间戳
            roles: defaultRoles,//角色全选
            authBtnList: defaultAuthBtnList,//按钮权限
          }
          resolve(userInfos)//返回对象出去
        }, 100);
      })
    }
  },
  getters: {

  }

})
