import { RouteRecordRaw } from 'vue-router'

/**
 * 路由meta对象参数说明
 * meta: {
 *      title:          菜单栏及 tagsView 栏、菜单搜索名称（国际化）
 *      isLink：        是否超链接菜单，开启外链条件，`1、isLink: 链接地址不为空 2、isIframe:false`
 *      isHide：        是否隐藏此路由
 *      isKeepAlive：   是否缓存组件状态
 *      isAffix：       是否固定在 tagsView 栏上
 *      isIframe：      是否内嵌窗口，开启条件，`1、isIframe:true 2、isLink：链接地址不为空`
 *      roles：         当前路由权限标识，取角色管理。控制路由显示、隐藏。超级管理员：admin 普通角色：common
 *      icon：          菜单、tagsView 图标，阿里：加 `iconfont xxx`，fontawesome：加 `fa xxx`
 * }
 */

// 扩展 RouteMeta 接口
declare module 'vue-router' {
  interface RouteMeta {
    title?: string;
    isLink?: string;
    isHide?: boolean;
    isKeepAlive?: boolean;
    isAffix?: boolean;
    isIframe?: boolean;
    roles?: string[];
    icon?: string;
  }
}

/**
 * 定义静态路由（默认路由）
 */
export const staticRoutes: Array<RouteRecordRaw> = [
  {
    path: '/login',
    name: 'login',
    component: () => import('/@/views/login/index.vue'),
    meta: {
      title: '登录',
    }
  },
  {
    path: '/test',
    name: 'test',
    component: () => import('/@/views/test/index.vue'),
    meta: {
      title: '测试',
    }
  },
  {
    path: '/payWallet/success',
    name: 'success',
    component: () => import('/@/views/payWallet/success/index.vue'),
    meta: {
      title: '成功',
    }
  },
  {
    path: '/tobeInvoiced',
    name: 'tobeInvoiced',
    component: () => import('/@/views/tobeInvoiced/index.vue'),
    meta: {
      title: '我要开票',
    }
  },
  {
    path: '/applyRecord',
    name: 'applyRecord',
    component: () => import('/@/views/applyRecord/index.vue'),
    meta: {
      title: '申请记录',
    }
  },
]
/**
 * 定义动态路由 
 */
export const dynamicRoutes: Array<RouteRecordRaw> = [
  {
    path: '/',
    name: '/',
    component: () => import('/@/layout/index.vue'),
    redirect: '/payWallet',
    meta: {
      isKeepAlive: true,
      // title:'',
      // isLink:'',
      // isHide:false,
      // isKeepAlive:true,
      // isAffix:true,
      // isIframe:false,
      // roles:['admin','common'],
      // icon:'iconfont icon-shouye'
    },
    children: [
      {
        path: '/payWallet',
        name: 'payWallet',
        component: () => import('/@/views/payWallet/index.vue'),
        meta: {
          title: '企业钱包',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/payWallet/payAccount',
        name: 'payAccount',
        component: () => import('/@/views/payWallet/payAccount/index.vue'),
        meta: {
          title: '企业钱包',
          isLink: '',
          isHide: true,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/payWallet/payAccount2',
        name: 'payAccount2',
        component: () => import('/@/views/payWallet/payAccount2/index.vue'),
        meta: {
          title: '企业钱包',
          isLink: '',
          isHide: true,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/payWallet/tradeDetailTask',
        name: 'tradeDetailTask',
        component: () => import('/@/views/payWallet/tradeDetailTask/index.vue'),
        meta: {
          title: '收支明细查询',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/payWallet/reconciliation',
        name: 'reconciliation',
        component: () => import('/@/views/payWallet/reconciliation/index.vue'),
        meta: {
          title: '对账数据查询',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/payWallet/withdrawalRecords',
        name: 'withdrawalRecords',
        component: () => import('/@/views/payWallet/withdrawalRecords/index.vue'),
        meta: {
          title: '充值提现记录',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        },
      },
      {
        path: '/lookup',
        name: 'lookup',
        component: () => import('/@/views/payWallet/lookup/index.vue'),
        meta: {
          title: '抬头管理',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        },
      },
	  {
	    path: '/invoiceInfo',
	    name: 'invoiceInfo',
	    component: () => import('/@/views/payWallet/invoiceManage/index.vue'),
	    meta: {
	      title: '发票开具',
	      isLink: '',
	      isHide: false,
	      isKeepAlive: true,
	      isAffix: true,
	      isIframe: false,
	      roles: ['admin', 'common'],
	      icon: 'iconfont icon-shouye'
	    }
	  },
      // {
      //   path: 'payWallet',
      //   name: 'invoiceManage',
      //   redirect: '/payWallet/invoiceInfo',
      //   component: () => import('/@/views/payWallet/invoiceManage/index.vue'),
      //   meta: {
      //     title: '用户订单',
      //     isLink: '',
      //     isHide: false,
      //     isKeepAlive: true,
      //     isAffix: true,
      //     isIframe: false,
      //     roles: ['admin', 'common'],
      //     icon: 'iconfont icon-shouye'
      //   },
      //   children: [
      //     {
      //       path: 'invoiceInfo',
      //       name: 'invoiceInfo',
      //       component: () => import('/@/views/payWallet/invoiceManage/invoiceInfo.vue'),
      //       meta: {
      //         title: '订单管理',
      //         isLink: '',
      //         isHide: false,
      //         isKeepAlive: true,
      //         isAffix: true,
      //         isIframe: false,
      //         roles: ['admin', 'common'],
      //       },
      //     }
      //   ]
      // },
      // {
      //   path: '/dispatchView/warnManage',
      //   name: 'warnManage',
      //   component: () => import('/@/views/dispatchView/warnManage/index.vue'),
      //   meta: {
      //     title: '警情管理',
      //     isLink: '',
      //     isHide: false,
      //     isKeepAlive: true,
      //     isAffix: true,
      //     isIframe: false,
      //     roles: ['admin', 'common'],
      //     icon: 'iconfont icon-shouye'
      //   }
      // },
      // {
      //   path: '/dispatchView/signedManage',
      //   name: 'signedManage',
      //   component: () => import('/@/views/dispatchView/signedManage/index.vue'),
      //   meta: {
      //     title: '签到管理',
      //     isLink: '',
      //     isHide: false,
      //     isKeepAlive: true,
      //     isAffix: true,
      //     isIframe: false,
      //     roles: ['admin', 'common'],
      //     icon: 'iconfont icon-shouye'
      //   }
      // },
      // {
      //   path: '/dispatchView/sosRecords',
      //   name: 'sosRecords',
      //   component: () => import('/@/views/dispatchView/sosRecords/index.vue'),
      //   meta: {
      //     title: 'sos记录',
      //     isLink: '',
      //     isHide: false,
      //     isKeepAlive: true,
      //     isAffix: true,
      //     isIframe: false,
      //     roles: ['admin', 'common'],
      //     icon: 'iconfont icon-shouye'
      //   }
      // },
      // {
      //   path: '/dispatchView/railAlarm',
      //   name: 'railAlarm',
      //   component: () => import('/@/views/dispatchView/railAlarm/index.vue'),
      //   meta: {
      //     title: '围栏告警',
      //     isLink: '',
      //     isHide: false,
      //     isKeepAlive: true,
      //     isAffix: true,
      //     isIframe: false,
      //     roles: ['admin', 'common'],
      //     icon: 'iconfont icon-shouye'
      //   }
      // },
      
    ]
  },

]

/**
 * 定义404、401界面
 * @link 参考：https://next.router.vuejs.org/zh/guide/essentials/history-mode.html#netlify
 */
export const notFoundAndNoPower = [
  {
    path: '/:path(.*)*',
    name: 'notFound',
    component: () => import('/@/views/error/404.vue'),
    meta: {
      title: 'message.staticRoutes.notFound',
      isHide: true
    }
  },
  {
    path: '/401',
    name: 'noPower',
    component: () => import('/@/views/error/401.vue'),
    meta: {
      title: 'message.staticRoutes.noPower',
      isHide: true
    }
  }
]