import axios, { AxiosInstance, AxiosRequestConfig } from 'axios';

// 创建 Axios 实例并配置默认值
const apiClient: AxiosInstance = axios.create({
    baseURL: import.meta.env.VITE_API_UPLOAD_URL,
    timeout: 10000, // 设置请求超时时间为 10 秒
    headers: {
        'Content-Type': 'multipart/form-data',
    },
});

/**
 * 上传 ID 卡片数据
 * @param data - 包含要上传的数据的 FormData 对象
 * @returns 返回一个 Promise，成功时返回响应数据，失败时抛出错误
 */
export async function uploadIdCardApi(data: FormData): Promise<any> {
    try {
        const response = await apiClient.post('/identify/api/common/upload-file', data);
        return response.data;
    } catch (error) {
        handleAxiosError(error);
        throw error;
    }
}

/**
 * 处理 Axios 错误
 * @param error - 捕获的 Axios 错误对象
 */
function handleAxiosError(error: any): void {
    if (error.response) {
        // 服务器返回了错误状态码
        console.error('服务器错误:', error.response.data);
        console.error('状态码:', error.response.status);
        console.error('响应头:', error.response.headers);
    } else if (error.request) {
        // 请求已发出，但没有收到响应
        console.error('请求未响应:', error.request);
    } else {
        // 其他错误
        console.error('请求失败:', error.message);
    }
}
