import axios, { AxiosInstance, AxiosRequestConfig } from 'axios';
import { ElMessage, ElMessageBox } from 'element-plus';
import { Session, Local } from '/@/utils/storage';
import qs from 'qs';

// 配置新建一个 axios 实例
const service: AxiosInstance = axios.create({
	baseURL: import.meta.env.VITE_API_URL,
	timeout: 60000,
	headers: {
		'Content-Type': 'application/json;charset=utf-8',
		"content-language": "zh_cn"
	},
	paramsSerializer: {
		serialize(params) {
			// debugger
			return qs.stringify(params, { allowDots: true });
		},
	},
});

// 添加请求拦截器
service.interceptors.request.use(
	(config: AxiosRequestConfig) => {
		// 在发送请求之前做些什么 token	
		let bcxToken = localStorage.getItem('bcxToken') || ''//317783b16db7470e9c4b7edad43daa3d
		if (Session.get('token')) {
			config.headers!['Authori-zation'] = bcxToken;			
		}
		return config;
	},
	(error) => {
		// 对请求错误做些什么
		return Promise.reject(error);
	}
);

// 添加响应拦截器
service.interceptors.response.use(
	(response) => {
		// 对响应数据做点什么
		console.log('response', response)
		const res = response.data;
		if (res.code && res.code !== 200) {			
			ElMessage({message:res.message,type:'error'})					
			return Promise.reject(service.interceptors.response);
		} else {
			if (response.data instanceof Blob) {
			    return response;
			}
			return response.data;
		}
	},
	(error) => {
		console.log('error', error)
		if (error && (error.response) && (error.response.status)) {//405表示 not allowed
			ElMessage.error(error.response.data.msg)
			return Promise.resolve(error.response.data)
		}
		// 对响应错误做点什么
		if (error.message.indexOf('timeout') != -1) {
			ElMessage.error('网络超时');
		} else if (error.message == 'Network Error') {
			ElMessage.error('网络连接错误');
		} else {
			if (error.response && error.response.data) ElMessage.error(error.response.statusText);
			else ElMessage.error('接口路径找不到');
		}
		return Promise.reject(error);
	}
);

// 导出 axios 实例
export default service;
