import { NextLoading } from '/@/utils/loading'
import { Session } from '/@/utils/storage';
import { useUserInfo } from '/@/stores/userInfo';
import { RouteRecordRaw } from 'vue-router';
import { dynamicRoutes, notFoundAndNoPower } from '/@/router/route'//dynamicRoutes导出动态路由菜单
import { router, formatFlatteningRoutes, formatTwoStageRoutes } from '/@/router/index'
import pinia from '/@/stores';
import { storeToRefs } from 'pinia';

import { useRoutesList } from '/@/stores/routesList'
import { useTagsViewRoutes } from '/@/stores/tagsViewRoutes'
// 前端控制路由
/**
 * 前端控制路由：初始化方法，防止刷新时路由丢失
 * @method  NextLoading 界面 loading 动画开始执行
 * @method useUserInfo(pinia).setUserInfos() 触发初始化用户信息 pinia
 * @method setAddRoute 添加动态路由---主要55
 * @method setFilterMenuAndCacheTagsViewRoutes 设置递归过滤有权限的路由到 vuex routesList 中（已处理成多级嵌套路由）及缓存多级嵌套数组处理后的一维数组
 */
export async function initFrontEndControlRoutes() {
   // debugger
   //  console.time('计时器')
   //  console.time('计时器2')
   //  console.time('计时器3')
   // 界面 loading 动画开始执行
   if (window.nextLoading === undefined) NextLoading.start()//加载自定义的loading 
   // 无 token 停止执行下一步
   if (!Session.get('token')) return false;

   // 触发初始化用户信息 pinia
   await useUserInfo().setUserInfos()//返回userInfos对象数据(userInfos:{userName:'',photo:'',time:'',roles:[],authBtnList:[]})--1.动态添加到缓存中--数据存储在状态管理内存中
   // 无登录权限时，添加判断
   // https://gitee.com/lyt-top/vue-next-admin/issues/I64HVO
   if (useUserInfo().userInfos.roles?.length <= 0) return Promise.resolve(true);
   //  console.timeEnd('计时器')
   // 添加动态路由--多维数组转一维数组--》keepAlive思路：将路由配置表的所有路由拆成两个操作，一是保持原样用于菜单的展示，二是对路由配置表进行扁平化处理，将所有的路由处理成二级路由，这样keep-alive就能默认支持缓存了
   await setAddRoute();//2.动态添加路由到router对象里面--核心--研究55（所有的二级三级路由都生成二级，为了keepAlive缓存使用）
   //  console.timeEnd('计时器2')
   // 设置递归过滤有权限的路由到 vuex routesList 中（已处理成多级嵌套路由）及缓存多级嵌套数组处理后的一维数组
   await setFilterMenuAndCacheTagsViewRoutes()//返回menu
   //  console.timeEnd('计时器3')
   NextLoading.done()//结束loading

}

/**
 * 添加动态路由
 * @method router.addRoute
 * @description 此处循环为 dynamicRoutes（//@/router/route）第一个顶级 children 的路由一维数组，非多级嵌套
 * @link 参考：https://next.router.vuejs.org/zh/api/#addroute
 */
export async function setAddRoute() {
   await setFilterRouteEnd().forEach((route: RouteRecordRaw) => {//route 把返回符合相同角色的路由---加入到当前的路由里面-->// 将路由扁平化为二级路由
      router.addRoute(route)//在路由配置项中使用扁平化处理后的路由
      console.log(router)
   })
}

/**
 * 获取有当前用户权限标识的路由数组，进行对原路由的替换
 * @description 替换 dynamicRoutes（//@/router/route）第一个顶级 children 的路由
 * @returns 返回替换后的路由数组
 */
export function setFilterRouteEnd() {
   // debugger
   console.log(dynamicRoutes)
   //formatTwoStageRoutes(formatFlatteningRoutes(dynamicRoutes)) 这边是格式路由
   let filterRouteEnd = formatTwoStageRoutes(formatFlatteningRoutes(dynamicRoutes))//第一步把所有children（children下面的children）下面的路由抽离出来一级，再把生成的一级都加入第一个children里面，只能保存二级；三级路由不支持keepalive
   console.log(filterRouteEnd)//把所有路由，包括children下面的children的返回到一级菜单的children下面-》数组里面只有一个对象{path:'/',name:'/',children:[{},{},{}],}
   filterRouteEnd[0].children = [...setFilterRoute(filterRouteEnd[0].children), ...notFoundAndNoPower]
   console.log(filterRouteEnd)
   return filterRouteEnd;//最终返回相同的角色的路由
}

/**
 * 获取当前用户权限标识去比对路由表（未处理成多级嵌套路由）
 * @description 这里主要用于动态路由的添加，router.addRoute
 * @link 参考：https://next.router.vuejs.org/zh/api/#addroute
 * @param chil dynamicRoutes（//@/router/route）第一个顶级 children 的下路由集合
 * @returns 返回有当前用户权限标识的路由数组
 */
export function setFilterRoute(chil: any) {
   const stores = useUserInfo(pinia);
   const { userInfos } = storeToRefs(stores)
   let filterRoute: any = []
   // debugger
   console.log('chil', chil)
   if (chil && chil.length) {
      console.log('chil---', chil)
      chil && chil.length && chil.forEach((route: any) => {
         if (route.meta.roles && route.meta.roles.length) {
            route.meta.roles && route.meta.roles.forEach((metaRoles: any) => {
               userInfos.value && userInfos.value.roles && userInfos.value.roles.length && userInfos.value.roles.forEach((roles: any) => {
                  if (metaRoles === roles) filterRoute.push({ ...route })
               })
            })
         }
      })
   }
   return filterRoute;//返回当前角色相同的---路由
}

/**
 * 设置递归过滤有权限的路由到 vuex routesList 中（已处理成多级嵌套路由）及缓存多级嵌套数组处理后的一维数组
 * @description 用于左侧菜单、横向菜单的显示
 * @description 用于 tagsView、菜单搜索中：未过滤隐藏的(isHide)
 */
export function setFilterMenuAndCacheTagsViewRoutes() {
   const stores = useUserInfo(pinia)
   const storesRoutesList = useRoutesList(pinia)
   const { userInfos } = storeToRefs(stores)
   storesRoutesList.setRoutesList(setFilterHasRolesMenu(dynamicRoutes[0].children, userInfos.value.roles))//dynamicRoutes[0].children第一个children的二级菜单
   setCacheTagsViewRoutes()
}

/**
 * 获取当前用户权限标识去比对路由表，设置递归过滤有权限的路由
 * @param routes 当前路由 children
 * @param roles 用户权限标识，在 userInfos（用户信息）的 roles（登录页登录时缓存到浏览器）数组
 * @returns 返回有权限的路由数组 `meta.roles` 中控制
 */
export function setFilterHasRolesMenu(routes: any, roles: any) {
   // debugger
   const menu: any = []
   routes && routes.length && routes.forEach((route: any) => {
      const item = { ...route }
      if (hasRoles(roles, item)) {
         if (item.children) item.children = setFilterHasRolesMenu(item.children, roles);
         menu.push(item)
      }
   })
   return menu;
}

/**
 * 判断路由 `meta.roles` 中是否包含当前登录用户权限字段
 * @param roles 用户权限标识，在 userInfos（用户信息）的 roles（登录页登录时缓存到浏览器）数组
 * @param route 当前循环时的路由项
 * @returns 返回对比后有权限的路由项
 */
export function hasRoles(roles: any, route: any) {
   if (route.meta && route.meta.roles) return roles && roles.length && roles.some((role: any) => route.meta.roles.includes(role));//一对多,pinia缓存roles==userInfos.roles=['admin']
   else return true
}

/**
 * 缓存多级嵌套数组处理后的一维数组
 * @description 用于 tagsView、菜单搜索中：未过滤隐藏的(isHide)
 */
export function setCacheTagsViewRoutes() {
   // 获取有权限的路由，否则 tagsView、菜单搜索中无权限的路由也将显示
   const stores = useUserInfo(pinia)
   const storesTagsView = useTagsViewRoutes(pinia)
   const { userInfos } = storeToRefs(stores)
   let rolesRoutes = setFilterHasRolesMenu(dynamicRoutes, userInfos.value.roles)
   // 添加到 pinia setTagsViewRoutes 中
   // debugger
   storesTagsView.setTagsViewRoutes(formatTwoStageRoutes(formatFlatteningRoutes(rolesRoutes)) && formatTwoStageRoutes(formatFlatteningRoutes(rolesRoutes)).length && formatTwoStageRoutes(formatFlatteningRoutes(rolesRoutes))[0].children)//children的路由设置到tagsview标签vuex的路由里面
}
