import { defineAsyncComponent, reactive, onMounted, ref } from 'vue';
import { Session } from '/@/utils/storage';
// import { useRoute, useRouter, onBeforeRouteUpdate } from 'vue-router';
import { useKeepALiveNames } from '/@/stores/keepAliveNames';
import mittBus from '/@/utils/mitt';
// const route = useRoute();
const storesKeepALiveNames = useKeepALiveNames();
const state = reactive({
	tagsViewList: []
});
//刷新当前列表
const refreshBtnView = (route: { fullPath: string; }) => {
	if (Session.get('tagsViewList')) {
		state.tagsViewList = Session.get('tagsViewList');
	}
	console.log(storesKeepALiveNames)
	console.log(route)

	refreshCurrentTagsView(route.fullPath)
}
// 2、刷新当前 tagsView：
const refreshCurrentTagsView = async (fullPath: string) => {
	const decodeURIPath = decodeURI(fullPath);
	let item: RouteToFrom = {};
	state.tagsViewList && state.tagsViewList.length && state.tagsViewList.forEach((v: RouteItem) => {
		v.transUrl = transUrlParams(v);
		if (v.transUrl) {
			if (v.transUrl === transUrlParams(v)) item = v;
		} else {
			if (v.path === decodeURIPath) item = v;
		}
	});
	if (!item) return false;
	await storesKeepALiveNames.delCachedView(item);
	mittBus.emit('onTagsViewRefreshRouterView', fullPath);
	if (item.meta?.isKeepAlive) storesKeepALiveNames.addCachedView(item);
};
const transUrlParams = (v: RouteItem) => {
	let params = v.query && Object.keys(v.query).length > 0 ? v.query : v.params;
	if (!params) return '';
	let path = '';
	for (let [key, value] of Object.entries(params)) {
		if (v.meta?.isDynamic) path += `/${value}`;
		else path += `&${key}=${value}`;
	}
	// 判断是否是动态路由（xxx/:id/:name"）isDynamic
	if (v.meta?.isDynamic) {
		/**
		 *
		 * isFnClick 用于判断是通过方法调用，还是直接右键菜单点击（此处只针对动态路由）
		 * 原因：
		 * 1、右键菜单点击时，路由的 path 还是原始定义的路由格式，如：/params/dynamic/details/:t/:id/:tagsViewName
		 * 2、通过事件调用时，路由的 path 不是原始定义的路由格式，如：/params/dynamic/details/vue-next-admin/111/我是动态路由测试tagsViewName(非国际化)
		 *
		 * 所以右侧菜单点击时，需要处理路径拼接 v.path.split(':')[0]，得到路径 + 参数的完整路径
		 */
		return v.isFnClick ? decodeURI(v.path) : `${v.path.split(':')[0]}${path.replace(/^\//, '')}`;
	} else {
		return `${v.path}${path.replace(/^&/, '?')}`;
	}
};
export { refreshBtnView };
