import request from '/@/utils/request'

/**
 * 后端控制菜单模拟json，路径在 https://gitee.com/lyt-top/vue-next-admin-images/tree/master/menu
 * 后端控制路由，isRequestRoutes 为 true，则开启后端控制路由
 * @method getMenuAdmin 获取后端动态路由菜单(admin)
 * @method getMenuTest 获取后端动态路由菜单(test)
 */
export function ConfigApi() {
  return {
    walletServiceOpeninfoApi: (data?: object) => {// 1.获取企业钱包服务开通情况
      return request({
        url: `/api/front/wallet/get-huifu-wallet-service-open-info`,
        method: 'get',
        data,
      })
    },
    getComWalletCurrentProcessApi: (data?: object) => {// 2.获取企业钱包服务当前开通步骤
      return request({
        url: `/api/front/wallet/get-huifu-wallet-current-process`,
        method: 'get',
        data,
      })
    },
    
    getCityListApi: (data?: object) => {// 获取区域列表树
      return request({
        url: `/api/front/city/list/tree-3`,
        method: 'get',
        data,
      })
    },
    saveAccountInfoApi: (data?: object) => {// 保存开户资料
      return request({
        url: `/api/front/wallet/save-account-info`,
        method: 'post',
        data,
      })
    },
    saveAccountBusiApi: (data?: object) => {// 开户业务入驻-绑定银行卡--保存
      return request({
        url: `/api/front/wallet/save-account-info-step-two`,
        method: 'post',
        data,
      })
    },
    findBanksApi: (data?: object) => {// 获取银行列表
      return request({
        url: `/api/front/wallet/find-banks`,
        method: 'post',
        data,
      })
    },
    getWalletAccountaApi: (data?: object) => {//获取企业钱包账户信息
      return request({
        url: `/api/front/wallet/get-huifu-wallet-account`,
        method: 'get',
        data,
      })
    },
    getwalletAccountAmountApi: (data?: object) => {//获取企业钱包账户金额
      return request({
        url: `/api/front/wallet/get-huifu-wallet-account-amount`,
        method: 'get',
        data,
      })
    },
    rechargeTokenApi: (data?: object) => {// 企业钱包充值-- 获取企业钱包充值收银台地址
      return request({
        url: `/api/front/wallet/get-wallet-recharge-token`,
        method: 'post',
        data,
      })
    },
    accountExtractApi: (data?: object) => {// 企业钱包账户提现
      return request({
        url: `/api/front/wallet/huifu-wallet-account-extract`,
        method: 'post',
        data,
      })
    },
    sendAcodeApi: (data?: object) => {// 发送验证码
      return request({
        url: `/api/front/pay/send/code`,
        method: 'post',
        data,
      })
    },
    
    tradedetailtaskApi: (data?: object) => {// 收支明细
      return request({
        url: `/api/front/wallet/get-huifu-wallet-account-trade-detail`,
        method: 'post',
        data,
      })
    },

    reconciliationApi: (data?: object) => {// 对账数据查询
      return request({
        url: `/api/front/wallet/get-huifu-wallet-reconciliation`,
        method: 'post',
        data,
      })
    },
    exportReconciliationApi: (data?: object) => {// 对账数据查询--导出
      return request({
        url: `/api/front/wallet/export-huifu-wallet-reconciliation`,
        method: 'post',
        // params:data,//get请求url携带参数写法params
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },
    tradevoucherDownApi: (data?: object) => {// 电子回单下载
      return request({
        url: `/api/front/wallet/huifu-account-trade-voucher`,
        method: 'post',
        data,
      })
    },
    withdrawalRecordsApi: (data?: object) => {// 提现记录查询
      return request({
        url: `/api/front/wallet/get-huifu-wallet-translog`,
        method: 'post',
        data,
      })
    },
    

    

    






    
    dispatchidentityLoginApi: (data?: object) => {//单点登入调度系统
      return request({
        url: `/dispatch/identity/Desk/auto-login`,//"accountType":"APP",//防控指挥账号类型：百保盾APP，第三方设备Device，调度台客户端Desk
        method: 'post',
        data,
      })
    },
    searchDepartsApi: (data?: object) => {//查询监管机构
      return request({
        url: `/dispatch/departs/searchDeparts`,
        method: 'post',
        data,
      })
    },

    policeIncidentsSearchApi: (data?: object) => {//警情上报查询
      return request({
        url: `/dispatch/policeIncidents/search`,
        method: 'post',
        data,
      })
    },
    policeIncidentsEditApi: (data?: object) => {//警情上报处理
      return request({
        url: `/dispatch/policeIncidents`,
        method: 'put',
        data,
      })
    },
    attendanceSearchApi: (data?: object) => {//签到查询
      return request({
        url: `/dispatch/attendance/search`,
        method: 'post',
        data,
      })
    },
    attendancesearchDayApi: (data?: object) => {//签到签退详情
      return request({
        url: `/dispatch/attendance/searchDay`,
        method: 'post',
        data,
      })
    },
    dispatchlogsApi: (data?: object) => {//调度记录
      return request({
        url: `/dispatch/dispatch-logs`,
        method: 'post',
        data,
      })
    },
    dispatchlogsyDetailApi: (data?: object) => {//调度详情
      return request({
        url: `/dispatch/dispatch-logs/${data.id}/detail-logs/${data.calledOrganizationId}`,
        method: 'post',
        data,
      })
    },

    railAlarmSearchApi: (data?: object) => {//围栏告警查询
      return request({
        url: `/dispatch/security-station-rail-messages/search`,
        method: 'post',
        data,
      })
    },
    



    // sourcesinkjdbcApi: (params?: object) => {//查询jdbc可用项
    //   return request({
    //     url: `/job-web/source-sink/jdbc`,
    //     method: 'get',
    //     params,
    //   })
    // },
    // jobmetasApi: (data?: object) => {//新增数据归集项配置
    //   return request({
    //     url: `/job-web/job-metas/simple`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // topiclistApi: (data?: object) => {//查询订阅主题
    //   return request({
    //     url: `/job-web/source-sink/kafka`,
    //     method: 'get',
    //     data,
    //   })
    // },
    // jobmetassearchApi: (data?: object) => {//查询所有数据归集项配置
    //   return request({
    //     url: `/job-web/job-metas/search`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // jobmetasdetailApi: (data?: dataCollectionType) => {//查询所有数据归集项详情
    //   return request({
    //     url: `/job-web/job-metas/${data?.id}`,
    //     method: 'get',
    //     data,
    //   })
    // },
    // jobmetasdeleteApi: (data?: dataCollectionType) => {//数据归集项配置删除
    //   console.log('data66', data)
    //   return request({
    //     url: `/job-web/job-metas/simple/${data?.id}`,
    //     method: 'delete',
    //     data,
    //   })
    // },
    // jobmetasPublishApi: (data?: dataCollectionType) => {//数据归集项配置删除
    //   console.log('data77', data)
    //   return request({
    //     url: `/job-web/jobs/jar-run/${data?.id}`,
    //     method: 'post',
    //   })
    // },
    // sourcesinkjdbcAddApi: (data?: object) => {//目标数据库配置新增
    //   return request({
    //     url: `/job-web/source-sink/jdbc`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // sourcesinkjdbcEditApi: (data?: targetDataType) => {//目标数据库配置修改
    //   console.log('data55', data)
    //   return request({
    //     url: `/job-web/source-sink/jdbc/${data?.id}`,
    //     method: 'put',
    //     data,
    //   })
    // },


    /**
     * @description
     * 获取发票列表
     */
    getInvoiceListApi: (params: Record<any, any>):Promise<any> => {
      return request({
        url: `api/front/order/fapiao/list`,
        method: 'GET',
        params
      });
    },

    /**
     * @description
     * 获取发票抬头列表
     */
    getInvoiceHeaderListApi: (params: Record<any, any>):Promise<any> => {
      return request({
        url: `api/front/fapiao/title/list`,
        method: 'GET',
        params
      });
    },

    /**
     * @description
     * 新增和编辑发票抬头
     */
    addInvoiceHeaderApi: (data: Record<any, any>, type: string):Promise<any> => {
      let url = type === 'edit' ? `api/front/fapiao/title/update` : `api/front/fapiao/title/create`;

      return request({
        url,
        method: 'POST',
        data,
      });
    },

    /**
     * @description
     * 删除发票抬头
     */
    delInvoiceHeaderApi: (data: Record<any, any>):Promise<any> => {
      return request({
        url: `api/front/fapiao/title/delete/${data.id}`,
        method: 'POST',
        data,
      });
    },

    /**
     * @description
     * 新增订单发票
     */
    createInvoiceApi: (data: Record<any, any>):Promise<any> => {
      return request({
        url: `api/front/order/fapiao/create`,
        method: 'POST',
        data,
      });
    },

    /**
     * @description
     * 查询发票订单详情
     */
    getInvoiceDetailApi: (data: Record<any, any>):Promise<any> => {
      return request({
        url: `api/front/order/fapiao/info/${ data.id }`,
        method: 'GET',
        data,
      });
    }
  }
}